import React, { useState, useEffect } from "react";
import AuthRouter from "./authRouter";
import AdminRouter from "./adminRouter";
import AdminApi from "../api/admin";
import { Cookies } from "react-cookie";
import { useNavigate, useLocation } from "react-router-dom";
import CoupleRouter from "./coupleRouter";

const IndexRouter = () => {
  const cookies = new Cookies();
  const [userRole, setUserRole] = useState("");
  const navigate = useNavigate();
  const location = useLocation();
  let adminApi = new AdminApi();

  useEffect(() => {}, [userRole]);

  const checkFunciton = () => {
    if (cookies.get("LoveStrongUser")) {
      let data = cookies.get("LoveStrongUser");
      let token = cookies.get("LoveStrongToken");
      if (data.userRole && token) {
        return data.userRole;
      } else {
        return "";
      }
    } else {
      return false;
    }
  };

  const updateuser = (data) => {
    setUserRole(data); // change role of user Admin or User
  };

  const logoutUser = async () => {
    let userData = cookies.get("LoveStrongUser");
    let report = {
      byWhom:
        `${userData && userData.userName ? userData.userName : null} ` +
        ` (${userData && userData.userRole ? userData.userRole : null})`,
      pagelink: window.location.href,
      description: `Logout`,
      action: "Click",
    };
    await adminApi
      .addLogReport(report)
      .then((response) => {
        if (response.success) {
          console.log("Created new log report.");
        }
      })
      .catch((error) => {
        console.log(error);
      });
    setUserRole("");
    cookies.remove("LoveStrongToken", { path: "/" });
    cookies.remove("LoveStrongUser", { path: "/" });
    navigate("/");
  };
  useEffect(() => {
    const currentPath = location.pathname;
    const isLoggedIn = cookies.get("LoveStrongUser");
    if (
      !isLoggedIn &&
      (currentPath.startsWith("/retreat-registrations") ||
        currentPath === "/retreat-registrations")
    ) {
      const redirectUrl = encodeURIComponent(currentPath);
      navigate(`/login?redirect=${redirectUrl}`);
    }
  }, [location.pathname]);

  return (
    <>
      {checkFunciton() === "ADMIN" || checkFunciton() === "SUBADMIN" ? (
        <AdminRouter logoutUser={logoutUser} />
      ) : checkFunciton() === "COUPLE" ? (
        <CoupleRouter logoutUser={logoutUser} />
      ) : (
        <AuthRouter updatedUser={updateuser} />
      )}
    </>
  );
};

export default IndexRouter;
