import React, { useState, useEffect } from "react";
import { useParams, useNavigate } from "react-router-dom";
import { Row, Col } from "react-bootstrap";
import { toast } from "react-toastify";
import moment from "moment";
import Profile from "../../assets/images/couple-default.png";
import ImagePlaceHolder from "../../assets/images/image-placeholder.png";
import AuthApi from "../../api/authApi";
import Helpers from "../../components/Helpers";
import lovestrongLogo from "../../assets/images/Lovestrong-logo.jpg";

const Directory = () => {
  let authApi = new AuthApi();
  const { id } = useParams();
  const [directory, setDirectory] = useState([]);
  const [data, setData] = useState([]);
  const [allRetreatRoasters, setAllRetreatRoasters] = useState([]);

  useEffect(() => {
    getDirectoryDetail(id);
    getRetreatDetail(id);
    getAllRoastersOfRetreat(id);
  }, [id]);

  const getRetreatDetail = async (id) => {
    await authApi
      .getRetreatDetail({ id: id })
      .then((res) => {
        if (res.success) {
          const { schedule, ...rest } = res.data[0];
          const parsedSchedule = schedule ? JSON.parse(schedule) : [];
          const parsedData = {
            ...rest,
            schedule: parsedSchedule.map((entry) => ({
              date: new Date(entry.date),
              from: entry.from,
              to: entry.to,
            })),
            parish: res.data[0].parishId,
          };
          setData(parsedData);
        } else {
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const getDirectoryDetail = async (id) => {
    try {
      const response = await authApi.getDirectoryDetail({ rereatId: id });
      let directory = response.data[0];

      // Parse socialLinks if it's a string
      if (directory?.socialLinks) {
        directory.socialLinks =
          typeof directory.socialLinks === "string"
            ? JSON.parse(directory.socialLinks)
            : directory.socialLinks;
      } else {
        directory.socialLinks = {};
      }

      setDirectory(directory);
    } catch (error) {
      toast.error(error.toString());
    }
  };

  const getAllRoastersOfRetreat = async (id) => {
    await authApi
      .getAllRoastersOfRetreat({ rereatId: id })
      .then((response) => {
        setAllRetreatRoasters(response.data);
      })
      .catch((error) => {
        toast.error(error.toString());
      });
  };

  return (
    <div className="container-scroller mainpannel">
      <div className="container-fluid page-body-wrapper full-page-wrapper">
        <div className="content-wrapper  align-items-center auth px-0">
          <div className="row w-100 mx-0">
            <div className="col-lg-10 mx-auto">
              <div className="auth-form-light text-center main-register py-5 px-4 px-sm-5">
                <Row className="text-center">
                  <Col>
                    {" "}
                    <img
                      src={lovestrongLogo}
                      alt=""
                      srcset=""
                      style={{
                        height: "140px",
                        marginTop: "15px",
                      }}
                    />
                  </Col>
                  {data && data.heading ? (
                    <Col
                      lg={12}
                      md={12}
                      sm={12}
                      xs={12}
                      className="directoryHeader howerOption"
                    >
                      <div>
                        <h1>
                          <em>
                            <span
                              dangerouslySetInnerHTML={{
                                __html: data && data.heading,
                              }}
                            />{" "}
                          </em>
                        </h1>
                      </div>
                    </Col>
                  ) : null}

                  {data && data.image1 ? (
                    <Col
                      className="directoryImgMain howerOption p-0"
                      lg={12}
                      md={12}
                      sm={12}
                      xs={12}
                    >
                      <div className="text-center">
                        <img
                          src={data && data.image1}
                          className="imageHeader"
                        />
                      </div>
                    </Col>
                  ) : null}
                  <Col
                    lg={12}
                    md={12}
                    sm={12}
                    xs={12}
                    className="directoryHeaderInMain"
                  >
                    <div>
                      <p>Retreat Directory</p>{" "}
                      <h2> {data?.myparish?.parish}</h2>
                      <h1 className="mt-4">
                        {data.dateFrom && data.dateTo ? (
                          <span>
                            {moment(data.dateFrom).isSame(data.dateTo, "day")
                              ? // Same day
                                `${moment(data.dateFrom)
                                  .tz("America/New_York")
                                  .format("MMM D, YYYY")}`
                              : moment(data.dateFrom).isSame(
                                  data.dateTo,
                                  "month"
                                )
                              ? // Same month, show month only once
                                `${moment(data.dateFrom)
                                  .tz("America/New_York")
                                  .format("MMM D")} - ${moment(data.dateTo)
                                  .tz("America/New_York")
                                  .format("D")}, ${moment(data.dateFrom)
                                  .tz("America/New_York")
                                  .format("YYYY")}`
                              : // Different months
                                `${moment(data.dateFrom)
                                  .tz("America/New_York")
                                  .format("MMM D")} - ${moment(data.dateTo)
                                  .tz("America/New_York")
                                  .format("MMM D")}, ${moment(data.dateFrom)
                                  .tz("America/New_York")
                                  .format("YYYY")}`}
                          </span>
                        ) : null}
                      </h1>
                    </div>
                  </Col>
                  {(allRetreatRoasters &&
                    allRetreatRoasters[0] &&
                    allRetreatRoasters[0].lead &&
                    allRetreatRoasters[0].lead.length) ||
                  (allRetreatRoasters &&
                    allRetreatRoasters[1] &&
                    allRetreatRoasters[1].coLead &&
                    allRetreatRoasters[1].coLead.length) ||
                  (allRetreatRoasters &&
                    allRetreatRoasters[2] &&
                    allRetreatRoasters[2].mentor &&
                    allRetreatRoasters[2].mentor.length) ||
                  (allRetreatRoasters &&
                    allRetreatRoasters[4] &&
                    allRetreatRoasters[4].sprDirector &&
                    allRetreatRoasters[4].sprDirector.length) ||
                  (allRetreatRoasters &&
                    allRetreatRoasters[3] &&
                    allRetreatRoasters[3].sprAdvisor &&
                    allRetreatRoasters[3].sprAdvisor.length) ? (
                    <Col
                      lg={12}
                      md={12}
                      sm={12}
                      xs={12}
                      className="colorTalks mt-3 p-5 leaderShip"
                    >
                      <h2 className="LeadHeading">Leadership</h2>

                      {allRetreatRoasters &&
                        allRetreatRoasters[0] &&
                        allRetreatRoasters[0].lead &&
                        allRetreatRoasters[0].lead.map((item, i) => {
                          return (
                            <Row key={i} className="mt-5">
                              <Col
                                md={5}
                                className="coupleImages coupleImageHower"
                              >
                                {(item && item.imageUrl == "") ||
                                item.imageUrl == undefined ? (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <img
                                      src={Profile}
                                      className="shadowImage"
                                    />
                                  </div>
                                ) : (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <>
                                      <img
                                        className="shadowImage profileImage"
                                        src={item && item.imageUrl}
                                      />
                                    </>{" "}
                                  </div>
                                )}{" "}
                              </Col>
                              <Col md={7} className="coupl_detail">
                                {i === 0 ? <h4>Lead Couple</h4> : null}
                                <h2 className="mt-3 mb-3">
                                  {`${
                                    item && item.hisFirstName
                                      ? item.hisFirstName
                                      : ""
                                  } ${item && item.hisFirstName ? "&" : ""} ${
                                    item && item.herFirstName
                                      ? item.herFirstName
                                      : ""
                                  } ${
                                    item && item.hisLastName
                                      ? item.hisLastName
                                      : ""
                                  }`}
                                </h2>
                                <h4>
                                  {" "}
                                  {"His : " +
                                    `${
                                      item && item.hisMobile
                                        ? item.hisMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.hisEmail ? item.hisEmail : ""
                                }`}</h4>
                                <h4>
                                  {" "}
                                  {"Her : " +
                                    `${
                                      item && item.herMobile
                                        ? item.herMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.herEmail ? item.herEmail : ""
                                }`}</h4>{" "}
                                {item && item.anniversary_date ? (
                                  <h4>
                                    {"Anniversary Date : " +
                                      `${
                                        item && item.anniversary_date
                                          ? Helpers.convertUtcToTimezone(
                                              item.anniversary_date,
                                              "MM/DD"
                                            )
                                          : ""
                                      }`}
                                  </h4>
                                ) : (
                                  ""
                                )}
                              </Col>
                            </Row>
                          );
                        })}

                      {allRetreatRoasters &&
                        allRetreatRoasters[1] &&
                        allRetreatRoasters[1].coLead &&
                        allRetreatRoasters[1].coLead.map((item, i) => {
                          return (
                            <Row key={i} className="mt-5">
                              <Col
                                md={5}
                                className="coupleImages coupleImageHower"
                              >
                                {(item && item.imageUrl == "") ||
                                item.imageUrl == undefined ? (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <img
                                      src={Profile}
                                      className="shadowImage"
                                    />
                                  </div>
                                ) : (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <>
                                      <img
                                        src={item && item.imageUrl}
                                        className="shadowImage profileImage"
                                      />
                                    </>{" "}
                                  </div>
                                )}{" "}
                              </Col>
                              <Col md={7} className="coupl_detail">
                                {i === 0 ? <h4>Co-Lead Couple</h4> : null}
                                <h2 className="mt-3 mb-3">
                                  {`${
                                    item && item.hisFirstName
                                      ? item.hisFirstName
                                      : ""
                                  } ${item && item.hisFirstName ? "&" : ""} ${
                                    item && item.herFirstName
                                      ? item.herFirstName
                                      : ""
                                  } ${
                                    item && item.hisLastName
                                      ? item.hisLastName
                                      : ""
                                  }`}
                                </h2>
                                <h4>
                                  {" "}
                                  {"His : " +
                                    `${
                                      item && item.hisMobile
                                        ? item.hisMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.hisEmail ? item.hisEmail : ""
                                }`}</h4>
                                <h4>
                                  {" "}
                                  {"Her : " +
                                    `${
                                      item && item.herMobile
                                        ? item.herMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.herEmail ? item.herEmail : ""
                                }`}</h4>{" "}
                                {item && item.anniversary_date ? (
                                  <h4>
                                    {"Anniversary Date : " +
                                      `${
                                        item && item.anniversary_date
                                          ? Helpers.convertUtcToTimezone(
                                              item.anniversary_date,
                                              "MM/DD"
                                            )
                                          : ""
                                      }`}
                                  </h4>
                                ) : (
                                  ""
                                )}
                              </Col>
                            </Row>
                          );
                        })}

                      {allRetreatRoasters &&
                        allRetreatRoasters[2] &&
                        allRetreatRoasters[2].mentor &&
                        allRetreatRoasters[2].mentor.map((item, i) => {
                          return (
                            <Row key={i} className="my-5">
                              <Col
                                md={5}
                                className="coupleImages coupleImageHower"
                              >
                                {(item && item.imageUrl == "") ||
                                item.imageUrl == undefined ? (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <img
                                      src={Profile}
                                      className="shadowImage"
                                    />
                                  </div>
                                ) : (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <>
                                      <img
                                        src={item && item.imageUrl}
                                        className="shadowImage profileImage"
                                      />
                                    </>{" "}
                                  </div>
                                )}{" "}
                              </Col>
                              <Col md={7} className="coupl_detail">
                                {i === 0 ? <h4>Mentor Couple</h4> : null}
                                <h2 className="mt-3 mb-3">
                                  {`${
                                    item && item.hisFirstName
                                      ? item.hisFirstName
                                      : ""
                                  } ${item && item.hisFirstName ? "&" : ""} ${
                                    item && item.herFirstName
                                      ? item.herFirstName
                                      : ""
                                  } ${
                                    item && item.hisLastName
                                      ? item.hisLastName
                                      : ""
                                  }`}
                                </h2>
                                <h4>
                                  {" "}
                                  {"His : " +
                                    `${
                                      item && item.hisMobile
                                        ? item.hisMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.hisEmail ? item.hisEmail : ""
                                }`}</h4>
                                <h4>
                                  {" "}
                                  {"Her : " +
                                    `${
                                      item && item.herMobile
                                        ? item.herMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.herEmail ? item.herEmail : ""
                                }`}</h4>{" "}
                                {item && item.anniversary_date ? (
                                  <h4>
                                    {"Anniversary Date : " +
                                      `${
                                        item && item.anniversary_date
                                          ? Helpers.convertUtcToTimezone(
                                              item.anniversary_date,
                                              "MM/DD"
                                            )
                                          : ""
                                      }`}
                                  </h4>
                                ) : (
                                  ""
                                )}
                              </Col>
                            </Row>
                          );
                        })}
                      {allRetreatRoasters &&
                        allRetreatRoasters[3] &&
                        allRetreatRoasters[3].sprAdvisor &&
                        allRetreatRoasters[3].sprAdvisor.map((item, i) => {
                          return (
                            <Row key={i} className="my-5">
                              <Col
                                md={5}
                                className="coupleImages coupleImageHower"
                              >
                                {(item && item.imageUrl == "") ||
                                item.imageUrl == undefined ? (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <img
                                      src={Profile}
                                      className="shadowImage"
                                    />
                                  </div>
                                ) : (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <>
                                      <img
                                        src={item && item.imageUrl}
                                        className="shadowImage profileImage"
                                      />
                                    </>{" "}
                                  </div>
                                )}{" "}
                              </Col>
                              <Col md={7} className="coupl_detail">
                                {i === 0 ? <h4>Spiritual Mentor</h4> : null}
                                <h2 className="mt-3 mb-3">
                                  {`${
                                    item && item.hisFirstName
                                      ? item.hisFirstName
                                      : ""
                                  } ${item && item.hisFirstName ? "&" : ""} ${
                                    item && item.herFirstName
                                      ? item.herFirstName
                                      : ""
                                  } ${
                                    item && item.hisLastName
                                      ? item.hisLastName
                                      : ""
                                  }`}
                                </h2>
                                <h4>
                                  {" "}
                                  {"His : " +
                                    `${
                                      item && item.hisMobile
                                        ? item.hisMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.hisEmail ? item.hisEmail : ""
                                }`}</h4>
                                <h4>
                                  {" "}
                                  {"Her : " +
                                    `${
                                      item && item.herMobile
                                        ? item.herMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.herEmail ? item.herEmail : ""
                                }`}</h4>{" "}
                                {item && item.anniversary_date ? (
                                  <h4>
                                    {"Anniversary Date : " +
                                      `${
                                        item && item.anniversary_date
                                          ? Helpers.convertUtcToTimezone(
                                              item.anniversary_date,
                                              "MM/DD"
                                            )
                                          : ""
                                      }`}
                                  </h4>
                                ) : (
                                  ""
                                )}
                              </Col>
                            </Row>
                          );
                        })}
                      {allRetreatRoasters &&
                        allRetreatRoasters[4] &&
                        allRetreatRoasters[4].sprDirector &&
                        allRetreatRoasters[4].sprDirector.map((item, i) => {
                          return (
                            <Row key={i} className="my-5">
                              <Col
                                md={5}
                                className="coupleImages coupleImageHower"
                              >
                                {(item && item.imageUrl == "") ||
                                item.imageUrl == undefined ? (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <img
                                      src={Profile}
                                      className="shadowImage"
                                    />
                                  </div>
                                ) : (
                                  <div className="edit-profile-img mb-2  imageHeader">
                                    <>
                                      <img
                                        src={item && item.imageUrl}
                                        className="shadowImage profileImage"
                                      />
                                    </>{" "}
                                  </div>
                                )}{" "}
                              </Col>
                              <Col md={7} className="coupl_detail">
                                {i === 0 ? <h4>Spiritual Director</h4> : null}
                                <h2 className="mt-3 mb-3">
                                  {`${
                                    item && item.hisFirstName
                                      ? item.hisFirstName
                                      : ""
                                  } ${item && item.hisFirstName ? "&" : ""} ${
                                    item && item.herFirstName
                                      ? item.herFirstName
                                      : ""
                                  } ${
                                    item && item.hisLastName
                                      ? item.hisLastName
                                      : ""
                                  }`}
                                </h2>
                                <h4>
                                  {" "}
                                  {"His : " +
                                    `${
                                      item && item.hisMobile
                                        ? item.hisMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.hisEmail ? item.hisEmail : ""
                                }`}</h4>
                                <h4>
                                  {" "}
                                  {"Her : " +
                                    `${
                                      item && item.herMobile
                                        ? item.herMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.herEmail ? item.herEmail : ""
                                }`}</h4>{" "}
                                {item && item.anniversary_date ? (
                                  <h4>
                                    {"Anniversary Date : " +
                                      `${
                                        item && item.anniversary_date
                                          ? Helpers.convertUtcToTimezone(
                                              item.anniversary_date,
                                              "MM/DD"
                                            )
                                          : ""
                                      }`}
                                  </h4>
                                ) : (
                                  ""
                                )}
                              </Col>
                            </Row>
                          );
                        })}
                    </Col>
                  ) : null}
                  {allRetreatRoasters &&
                  allRetreatRoasters[6] &&
                  allRetreatRoasters[6].retreatant.length &&
                  allRetreatRoasters[6].retreatant ? (
                    <Col
                      lg={12}
                      md={12}
                      sm={12}
                      xs={12}
                      className="colorTalks mt-2 p-5 leaderShip"
                    >
                      <img
                        src="https://lovestrong.koolderbyacademy.com/logo.png"
                        alt=""
                        srcset=""
                        style={{
                          height: "90px",
                        }}
                      />
                      <h2 className="LeadHeading mt-4">Retreatants</h2>
                      {allRetreatRoasters &&
                        allRetreatRoasters[6] &&
                        allRetreatRoasters[6].retreatant &&
                        allRetreatRoasters[6].retreatant.map((item, i) => {
                          return (
                            <Row className="mt-5" key={i}>
                              <Col
                                md={5}
                                className="coupleImages coupleImageHower"
                              >
                                {(item && item.imageUrl == "") ||
                                item.imageUrl == undefined ? (
                                  <div className="edit-profile-img mb-2 imageHeader ">
                                    <img
                                      src={Profile}
                                      className="shadowImage"
                                    />
                                  </div>
                                ) : (
                                  <div className="edit-profile-img mb-2  imageHeader ">
                                    <>
                                      <img
                                        src={item && item.imageUrl}
                                        className="shadowImage profileImage"
                                      />
                                    </>{" "}
                                  </div>
                                )}{" "}
                              </Col>
                              <Col md={7} className="coupl_detail">
                                {" "}
                                <h2 className="mt-3 mb-3">
                                  {`${
                                    item && item.hisFirstName
                                      ? item.hisFirstName
                                      : ""
                                  } ${item && item.hisFirstName ? "&" : ""} ${
                                    item && item.herFirstName
                                      ? item.herFirstName
                                      : ""
                                  } ${
                                    item && item.hisLastName
                                      ? item.hisLastName
                                      : ""
                                  }`}
                                </h2>
                                <h4>
                                  {" "}
                                  {"His : " +
                                    `${
                                      item && item.hisMobile
                                        ? item.hisMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.hisEmail ? item.hisEmail : ""
                                }`}</h4>
                                <h4>
                                  {" "}
                                  {"Her : " +
                                    `${
                                      item && item.herMobile
                                        ? item.herMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.herEmail ? item.herEmail : ""
                                }`}</h4>{" "}
                                {item && item.anniversary_date ? (
                                  <h4>
                                    {"Anniversary Date : " +
                                      `${
                                        item && item.anniversary_date
                                          ? Helpers.convertUtcToTimezone(
                                              item.anniversary_date,
                                              "MM/DD"
                                            )
                                          : ""
                                      }`}
                                  </h4>
                                ) : (
                                  ""
                                )}
                              </Col>
                            </Row>
                          );
                        })}
                    </Col>
                  ) : null}
                  {allRetreatRoasters &&
                  allRetreatRoasters[5] &&
                  allRetreatRoasters[5].team &&
                  allRetreatRoasters[5].team.length ? (
                    <Col
                      lg={12}
                      md={12}
                      sm={12}
                      xs={12}
                      className="colorTalks mt-3 p-5 leaderShip"
                    >
                      {" "}
                      <img
                        src="https://lovestrong.koolderbyacademy.com/logo.png"
                        alt=""
                        srcset=""
                        style={{
                          height: "90px",
                        }}
                      />
                      <h2 className="LeadHeading mt-4">Team</h2>
                      {allRetreatRoasters &&
                        allRetreatRoasters[5] &&
                        allRetreatRoasters[5].team &&
                        allRetreatRoasters[5].team.map((item, i) => {
                          return (
                            <Row className="mt-5">
                              <Col
                                md={5}
                                className="coupleImages coupleImageHower"
                              >
                                {(item && item.imageUrl == "") ||
                                item.imageUrl == undefined ? (
                                  <div className="edit-profile-img mb-2 imageHeader">
                                    <img
                                      src={Profile}
                                      className="shadowImage"
                                    />
                                  </div>
                                ) : (
                                  <div className="edit-profile-img mb-2 imageHeader">
                                    <>
                                      <img
                                        src={item && item.imageUrl}
                                        className="shadowImage profileImage"
                                      />
                                    </>{" "}
                                  </div>
                                )}{" "}
                              </Col>
                              <Col md={7} className="coupl_detail">
                                {" "}
                                <h2 className="mt-3 mb-3">
                                  {`${
                                    item && item.hisFirstName
                                      ? item.hisFirstName
                                      : ""
                                  } ${item && item.hisFirstName ? "&" : ""} ${
                                    item && item.herFirstName
                                      ? item.herFirstName
                                      : ""
                                  } ${
                                    item && item.hisLastName
                                      ? item.hisLastName
                                      : ""
                                  }`}
                                </h2>
                                <h4>
                                  {" "}
                                  {"His : " +
                                    `${
                                      item && item.hisMobile
                                        ? item.hisMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.hisEmail ? item.hisEmail : ""
                                }`}</h4>
                                <h4>
                                  {" "}
                                  {"Her : " +
                                    `${
                                      item && item.herMobile
                                        ? item.herMobile
                                        : ""
                                    }`}
                                </h4>
                                <h4>{`${
                                  item && item.herEmail ? item.herEmail : ""
                                }`}</h4>{" "}
                                {item && item.anniversary_date ? (
                                  <h4>
                                    {"Anniversary Date : " +
                                      `${
                                        item && item.anniversary_date
                                          ? Helpers.convertUtcToTimezone(
                                              item.anniversary_date,
                                              "MM/DD"
                                            )
                                          : ""
                                      }`}
                                  </h4>
                                ) : (
                                  ""
                                )}
                              </Col>
                            </Row>
                          );
                        })}
                    </Col>
                  ) : null}
                  <Col
                    lg={12}
                    md={12}
                    sm={12}
                    xs={12}
                    className="colorTalks mt-3 leaderShip  "
                  >
                    {directory && directory.footerImage ? (
                      <div>
                        {directory.footerImage && (
                          <div className="text-center footer_images">
                            <img
                              src={directory.footerImage}
                              className="imageHeader"
                              alt="Footer Image 1"
                            />
                          </div>
                        )}
                        <div className="retdet1">
                          <div>
                            {" "}
                            <h2>{data?.myparish?.parish} Lovestrong Team</h2>
                            <h1>
                              {data.dateFrom && data.dateTo ? (
                                <span>
                                  {moment(data.dateFrom).isSame(
                                    data.dateTo,
                                    "day"
                                  )
                                    ? // Same day
                                      `${moment(data.dateFrom)
                                        .tz("America/New_York")
                                        .format("MMM D, YYYY")}`
                                    : moment(data.dateFrom).isSame(
                                        data.dateTo,
                                        "month"
                                      )
                                    ? // Same month, show month only once
                                      `${moment(data.dateFrom)
                                        .tz("America/New_York")
                                        .format("MMM D")} - ${moment(
                                        data.dateTo
                                      )
                                        .tz("America/New_York")
                                        .format("D")}, ${moment(data.dateFrom)
                                        .tz("America/New_York")
                                        .format("YYYY")}`
                                    : // Different months
                                      `${moment(data.dateFrom)
                                        .tz("America/New_York")
                                        .format("MMM D")} - ${moment(
                                        data.dateTo
                                      )
                                        .tz("America/New_York")
                                        .format("MMM D")}, ${moment(
                                        data.dateFrom
                                      )
                                        .tz("America/New_York")
                                        .format("YYYY")}`}
                                </span>
                              ) : null}
                            </h1>
                          </div>
                        </div>
                      </div>
                    ) : null}
                    <dir className="howerOption mt-5">
                      <h2 className="mb-4">
                        {directory && directory.footerText ? (
                          <div
                            dangerouslySetInnerHTML={{
                              __html: directory && directory.footerText,
                            }}
                          />
                        ) : (
                          ""
                        )}
                      </h2>
                    </dir>
                    {directory?.socialLinks ? (
                      <div className="social-icons">
                        {directory?.socialLinks?.facebook ? (
                          <a
                            href={directory?.socialLinks?.facebook}
                            target="_blank"
                          >
                            <i className="mdi mdi-facebook"></i>
                          </a>
                        ) : null}
                        {directory?.socialLinks?.twitter ? (
                          <a
                            href={directory?.socialLinks?.twitter}
                            target="_blank"
                          >
                            <i className="mdi mdi-twitter"></i>
                          </a>
                        ) : null}
                        {directory?.socialLinks?.pinterest ? (
                          <a
                            href={directory?.socialLinks?.pinterest}
                            target="_blank"
                          >
                            <i className="mdi mdi-pinterest"></i>
                          </a>
                        ) : null}
                        {directory?.socialLinks?.instagram ? (
                          <a
                            href={directory?.socialLinks?.instagram}
                            target="_blank"
                          >
                            <i className="mdi mdi-instagram"></i>
                          </a>
                        ) : null}
                      </div>
                    ) : null}
                    <img
                      src={lovestrongLogo}
                      alt=""
                      srcset=""
                      className="logo_image"
                    />
                  </Col>
                </Row>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Directory;
