import React, { useState, useEffect } from "react";
import { useNavigate, useLocation, Link } from "react-router-dom";
import ExcelJS from "exceljs";
import {
  Tab,
  Tabs,
  Form,
  Button,
  Modal,
  OverlayTrigger,
  Tooltip,
  Row,
  Col,
  Container,
  ListGroup,
} from "react-bootstrap";
import AdminApi from "../../../api/admin";
import AuthApi from "../../../api/authApi";
import { toast } from "react-toastify";
import CustomDataTable from "../../../components/CustomDataTable";
import Helpers from "../../../components/Helpers";
import DeleteModel from "../../../components/DeleteModel";
import { Cookies } from "react-cookie";
import DatePicker from "react-datepicker";
import "react-datepicker/dist/react-datepicker.css";
import RetreatApi from "../../../api/retreatApi";
import uploadRetreat from "../../../assets/images/uploadRetreat.png";
import RetreatRoastApi from "../../../api/retreatRoasterApi";
import TimePicker from "react-time-picker";
import "react-time-picker/dist/TimePicker.css";
import "react-clock/dist/Clock.css";
import ImagePlaceHolder from "../../../assets/images/image-placeholder.png";
import DirectoryApi from "../../../api/directoryApi";
import ProgramApi from "../../../api/programApi";
import Profile from "../../../assets/images/couple-default.png";
import fbIcon from "../../../assets/images/facebook-logo.webp";
import QrDummy from "../../../assets/images/qrScanner.jpg";
import AlertDelete from "../../../components/AlertDelete";
import moment from "moment-timezone";
import DirectoryModel from "./DirectoryModel";
import ProgramModel from "./ProgramModel";
import FileUploadModal from "../../../components/FileUploadModal";
import AlertModal from "../../../components/AlertModel";

const ManageRetreat = () => {
  const locationData = useLocation();
  const [showRegModal, setShowREgModal] = useState(false);
  const [total, setTotal] = useState(20);
  const [searchKey, setSearchKey] = useState(""); //for searching
  const [show, setShow] = useState(false);
  const [icon_id, setIcon_id] = useState("");
  let cookies = new Cookies();
  let userData = cookies.get("LoveStrongUser") || null;
  const [perishDataList, setPerishDataList] = useState([]);
  const [allRetreatData, setAllRetreatData] = useState([]);
  const [LoadData, setLoadData] = useState(false);
  const [directory, setDirectory] = useState([]);
  const [program, setProgram] = useState([]);
  const [retreatDetail, setRetreatDetail] = useState([]);
  const [deleteList, setDeleteList] = useState(null);
  const [contactData, setContactData] = useState(false);
  const [confirmedData, setConfirmedData] = useState(false);
  const [showStatus, setShowStatus] = useState(false);
  const [allSelected, setAllSelected] = useState(false);
  const [editBox, setEditBox] = useState(false);

  const [showUploadModal, setShowUploadModal] = useState(false); // Controls modal visibility
  const [selectedRowId, setSelectedRowId] = useState(null); // Stores the ID of the selected row
  const [selectedRetreats, setSelectedRetreats] = useState([]);
  const [showingRetreats, setShowingRetreats] = useState(false);
  const [fileType, setFileType] = useState("");
  const [existingFileUrl, setExistingFileUrl] = useState("");
  const [uploadModalTitle, setUploadModalTitle] = useState("");
  const [parishValue, setParishValue] = useState("");
  const [alertData, setAlertData] = useState([]);
  const [clearSelectionTrigger, setClearSelectionTrigger] = useState(false);

  const [showFreeze, setShowFreeze] = useState(false);
  let adminApi = new AdminApi();
  let retreatApi = new RetreatApi();
  let authApi = new AuthApi();
  let directoryApi = new DirectoryApi();
  let programApi = new ProgramApi();
  let navigate = useNavigate();

  const [data, setData] = useState({
    id: "",
    retreatment: "",
    title: "",
    parish: "",
    language: "",
    location: "",
    schedule: [],
    image1: "",
    image2: "",
    heading: "",
    mission_statement:
      "The mission of the LOVESTRONG Marriage Ministry is to support, strengthen, and nurture the Christ-centered bond between married couples in our parish and community.",
    description: "",
  });
  const [timeDate, setTimeDate] = useState({
    date: "",
    from: "00:00",
    to: "00:00",
  });
  const [newTitle, setNewTitle] = useState({
    parish: "",
    language: "",
    location: "",
  });

  useEffect(() => {
    if (locationData?.state?.parishValue) {
      getAllRetreats(
        1,
        20,
        null,
        {},
        false,
        "",
        null,
        locationData?.state?.parishValue
      );
    } else {
      getAllRetreats();
    }

    getPerishList();
    let report = {
      byWhom:
        `${userData && userData.userName ? userData.userName : null} ` +
        ` (${userData && userData.userRole ? userData.userRole : null})`,
      pagelink: window.location.href,
      description: "Visited on Manage Retreats page.",
      action: "View",
    };
    adminApi
      .addLogReport(report)
      .then((response) => {
        if (response.success) {
          console.log("Created new log report.");
        }
      })
      .catch((error) => {
        console.log(error);
      });
  }, []);

  useEffect(() => {
    if (locationData?.state?.parishValue) {
      getAllRetreats(
        1,
        20,
        null,
        {},
        false,
        "",
        null,
        locationData?.state?.parishValue
      );
    }
  }, [locationData]);

  const handleUploadProgram = (retreat) => {
    setSelectedRowId(retreat.id);
    setUploadModalTitle(retreat.title);
    setFileType("programFile");
    setShowUploadModal(true);
    setExistingFileUrl(retreat.programFile);
  };

  const handleUploadDirectory = (retreat) => {
    setSelectedRowId(retreat.id);
    setUploadModalTitle(retreat.title);
    setFileType("directoryFile");
    setShowUploadModal(true); // Show the upload modal
    setExistingFileUrl(retreat.directoryFile);
  };

  // Handle closing the modal
  const handleUploadModalClose = () => {
    setShowUploadModal(false);
    setSelectedRowId(null); // Reset the row ID(Retreat Id)
    setFileType("");
    setExistingFileUrl("");
    setUploadModalTitle("");
  };

  // Callback to trigger after successful upload
  const handleUploadSuccess = () => {
    if (showingRetreats === true) {
      getAllRetreats(1, 20, null, {}, false, "", userData?.id);
    } else {
      getAllRetreats();
    }
  };

  const handleDeleteFile = () => {
    setExistingFileUrl(null); // Update the UI after deletion
    if (showingRetreats === true) {
      getAllRetreats(1, 20, null, {}, false, "", userData?.id);
    } else {
      getAllRetreats();
    }
  };

  const getAllRetreats = async (
    pageNo = 1,
    size = 20,
    searchKeyword = null,
    sortBy = {},
    loadCount = false,
    coupleId,
    committeeId = "",
    parishValue = null
  ) => {
    setAllRetreatData([]);
    setLoadData(true);
    let d = {};
    if (pageNo && size) {
      d.pageNo = pageNo;
      d.size = size;
    }
    if (searchKeyword !== null) {
      d.searchKeyword = searchKeyword;
    } else {
      d.searchKeyword = searchKey;
    }
    if (sortBy.sortColumn) {
      d.sortBy = sortBy;
    }
    d.export = false;
    d.coupleId = coupleId;
    d.committeeId = committeeId;
    d.parishValue = parishValue || null;
    if (userData?.committeeMember === true && userData?.userRole !== "ADMIN") {
      d.committeeId = userData.id;
    }

    await retreatApi
      .getAllRetreats(d)
      .then((res) => {
        if (res.success) {
          let totalRecords = res.totalRecords ? res.totalRecords : 0;
          setTotal(totalRecords);
          const parsedData = res.data.map((item) => {
            const { confirmation, schedule, ...rest } = item;
            const parsedSchedule = schedule ? JSON.parse(schedule) : [];
            const parsedConfirmation = confirmation
              ? JSON.parse(confirmation)
              : [];
            return {
              ...rest,
              confirmation: parsedConfirmation,
              schedule: parsedSchedule.map((entry) => ({
                date: new Date(entry.date),
                from: entry.from,
                to: entry.to,
              })),
            };
          });
          setLoadData(false);
          if (parishValue && parishValue !== null) {
            const retreatIds = parsedData.map((retreat) => retreat.id);
            setSelectedRetreats(retreatIds);
          }
          setAllRetreatData(parsedData);
        } else {
          setLoadData(false);
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        setLoadData(false);
        toast.error(error);
      });
  };

  const getPerishList = async () => {
    await authApi
      .getPerishList()
      .then((response) => {
        const sortedList = response.data.sort((a, b) =>
          a.parish.localeCompare(b.parish)
        );
        setPerishDataList(sortedList);
      })
      .catch((error) => {
        toast.error(error.toString());
      });
  };

  const tempDeleteDataList = async () => {
    await retreatApi
      .tempDeleteDataList()
      .then((response) => {
        setDeleteList(response.data);
      })
      .catch((error) => {
        toast.error(error.toString());
      });
  };

  const deleteRetreat = async () => {
    await retreatApi
      .tempDeleteRetreat({ id: icon_id })
      .then(async (res) => {
        if (res.success) {
          setShow(false);
          setIcon_id("");
          toast.success(res.msg);
          if (showingRetreats === true) {
            getAllRetreats(1, 20, null, {}, false, "", userData?.id);
          } else {
            getAllRetreats();
          }
          let report = {
            byWhom:
              `${userData && userData.userName ? userData.userName : null} ` +
              ` (${userData && userData.userRole ? userData.userRole : null})`,
            pagelink: window.location.href,
            description: `Retreat deleted temporarily ( ${icon_id} - ${
              data?.parishName || ""
            }${
              data.language
                ? ` (${data.language[0].toUpperCase()}${data.language.slice(
                    1
                  )})`
                : ""
            } ${
              data.location
                ? `${data.location[0].toUpperCase()}${data.location.slice(1)}`
                : ""
            } )`,
            action: "Delete",
          };
          await adminApi
            .addLogReport(report)
            .then((response) => {
              if (response.success) {
                console.log("Added new log report");
              }
            })
            .catch((error) => {
              console.log(error);
            });
        } else {
          toast.error(res.msg);
          if (showingRetreats === true) {
            getAllRetreats(1, 20, null, {}, false, "", userData?.id);
          } else {
            getAllRetreats();
          }
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const restoreRetreat = async (id) => {
    await retreatApi
      .restoreRetreat({ id: id })
      .then(async (res) => {
        if (res.success) {
          toast.success(res.msg);
          tempDeleteDataList();
        } else {
          toast.error(res.msg);
          tempDeleteDataList();
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const permanentDeleteRetreat = async (id) => {
    await retreatApi
      .permanentDeleteRetreat({ id: id })
      .then(async (res) => {
        if (res.success) {
          toast.success(res.msg);
          tempDeleteDataList();
        } else {
          toast.error(res.msg);
          tempDeleteDataList();
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const SearchData = (event) => {
    const key = event.target.value;
    if (key !== "") {
      setSearchKey(event.target.value);
      if (showingRetreats === true) {
        getAllRetreats(
          1,
          20,
          event.target.value,
          {},
          false,
          "",
          userData?.id,
          locationData?.state?.parishValue
        );
      } else {
        getAllRetreats(
          1,
          20,
          event.target.value,
          {},
          false,
          "",
          null,
          locationData?.state?.parishValue
        );
      }
    } else {
      setSearchKey("");
      if (showingRetreats === true) {
        getAllRetreats(
          1,
          20,
          event.target.value,
          {},
          false,
          "",
          userData?.id,
          locationData?.state?.parishValue
        );
      } else {
        getAllRetreats(
          1,
          20,
          event.target.value,
          {},
          false,
          "",
          null,
          locationData?.state?.parishValue
        );
      }
    }
  };

  const clearfield = () => {
    setData({
      id: "",
      retreatment: "",
      title: "",
      parish: "",
      language: "",
      location: "",
      schedule: [],
      image1: "",
      image2: "",
      heading: "",
      mission_statement:
        "The mission of the LOVESTRONG Marriage Ministry is to support, strengthen, and nurture the Christ-centered bond between married couples in our parish and community.",
      description: "",
    });
    setNewTitle({
      parish: "",
      language: "",
      location: "",
    });
  };

  const renderTooltip = (props) => (
    <Tooltip id="button-tooltip">{props}</Tooltip>
  );

  const customTooltip = (props) => (
    <Tooltip id="button-tooltip" className="custom-tooltip">
      {props}
    </Tooltip>
  );

  const handleShow1 = (row) => {
    setShowFreeze(true);
    let d = { ...alertData };
    d.value = row.freeze;
    d.retreatId = row.id;
    d.title = row.title;
    d.language = row.language;
    d.location = row.location;
    d.parishName = row.parishName;
    setAlertData(d);
  };

  const handleClose2 = () => {
    setShowFreeze(false);
    setAlertData([]);
  };

  const retreatFreeze = () => {
    retreatApi
      .retreatFreeze(alertData)
      .then((res) => {
        handleClose2();
        if (showingRetreats === true) {
          getAllRetreats(1, 20, null, {}, false, "", userData?.id);
        } else {
          getAllRetreats();
        }
        let report = {
          byWhom:
            `${userData && userData.userName ? userData.userName : null} ` +
            ` (${userData && userData.userRole ? userData.userRole : null})`,
          pagelink: window.location.href,
          description: `${alertData?.parishName || ""}${
            alertData.language
              ? ` (${alertData.language[0].toUpperCase()}${alertData.language.slice(
                  1
                )})`
              : ""
          } ${
            alertData.location
              ? `${alertData.location[0].toUpperCase()}${alertData.location.slice(
                  1
                )}`
              : ""
          } Retreat - ${alertData.value === "FREEZE" ? "UNFREEZE" : "FREEZE"}`,
        };
        adminApi
          .addLogReport(report)
          .then((response) => {
            if (response.success) {
              console.log("Added new log report");
            }
          })
          .catch((error) => {
            console.log(error);
          });
        toast.success(res.msg);
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const handleShowStatus = (row) => {
    setShowStatus(true);
    setAlertData(row);
  };

  const handleCloseStatus = () => {
    setShowStatus(false);
    setAlertData([]);
    setEditBox(false);
  };

  const retreatChangeStatus = (reason = "") => {
    const payload = {
      alertData: {
        ...alertData,
        inactiveReason: reason,
      },
      userData: userData,
      editBox,
    };
    retreatApi
      .retreatChangeStatus(payload)
      .then((res) => {
        handleCloseStatus();

        if (showingRetreats === true) {
          getAllRetreats(1, 20, null, {}, false, "", userData?.id);
        } else {
          getAllRetreats();
        }

        let report = {
          byWhom: `${userData?.userName || ""} (${userData?.userRole || ""})`,
          pagelink: window.location.href,
          description: `${alertData?.parishName || ""}${
            alertData.language
              ? ` (${alertData.language[0].toUpperCase()}${alertData.language.slice(
                  1
                )})`
              : ""
          } ${
            alertData.location
              ? `${alertData.location[0].toUpperCase()}${alertData.location.slice(
                  1
                )}`
              : ""
          } Retreat - ${alertData.status}`,
        };

        adminApi.addLogReport(report);
        toast.success(res.message);
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const columns = [
    ...(userData && userData.userRole === "ADMIN"
      ? [
          {
            id: "Active/Deactivate",
            name: (
              <OverlayTrigger
                placement="bottom"
                overlay={customTooltip(
                  "Retreat Registration stops if Deactivate"
                )}
              >
                <span>Active/Deactivate</span>
              </OverlayTrigger>
            ),
            cell: (row) => {
              return (
                <>
                  <OverlayTrigger
                    placement="bottom"
                    delay={{ show: 250, hide: 400 }}
                    overlay={renderTooltip(
                      row.status === "ACTIVE" ? "ACTIVE" : "INACTIVE"
                    )}
                  >
                    <Form.Check
                      className={`switchSize  ${
                        row.status === "ACTIVE"
                          ? "toggle-on-status"
                          : "toggle-off-status"
                      }`}
                      type="checkBox"
                      name="status"
                      value={row.status}
                      checked={row.status === "ACTIVE"}
                      onChange={(e) => {
                        handleShowStatus(row);
                      }}
                      id="status"
                    />
                  </OverlayTrigger>

                  {row.status === "INACTIVE" ? (
                    <i
                      onClick={() => {
                        setEditBox(true);
                        handleShowStatus(row);
                      }}
                      className={`mdi mdi-pencil text-lg mt-2 font-size`}
                      title="Edit Deactivate Reason"
                      style={{ marginLeft: "15px" }}
                    ></i>
                  ) : null}
                </>
              );
            },
            reorder: true,
            width: "150px",
            conditionalCellStyles: [
              {
                when: (row) => {
                  const today = new Date();
                  today.setHours(0, 0, 0, 0);
                  const dateFrom = new Date(row.dateFrom);
                  dateFrom.setHours(0, 0, 0, 0);
                  const dateTo = new Date(row.dateTo);
                  dateTo.setHours(0, 0, 0, 0);
                  return dateFrom >= today || dateTo >= today;
                },
                style: {
                  backgroundColor: "rgb(196 240 196)",
                },
              },
            ],
          },

          // {
          //   id: "Export",
          //   name: "Export",
          //   cell: (row) => {
          //     const isChecked =
          //       selectedRetreats && selectedRetreats.includes(row.id);

          //     return (
          //       <Form.Check
          //         className="switchSize"
          //         type="checkbox"
          //         name="SelectRetreat"
          //         value="SelectRetreat"
          //         checked={isChecked}
          //         onChange={(e) => handleSelectRetreat(e, row)}
          //         id={`SelectRetreat-${row.id}`}
          //       />
          //     );
          //   },
          //   reorder: true,
          //   width: "90px",
          //   conditionalCellStyles: [
          //     {
          //       when: (row) => {
          //         const today = new Date();
          //         today.setHours(0, 0, 0, 0);
          //         const dateFrom = new Date(row.dateFrom);
          //         dateFrom.setHours(0, 0, 0, 0);
          //         const dateTo = new Date(row.dateTo);
          //         dateTo.setHours(0, 0, 0, 0);
          //         return dateFrom >= today || dateTo >= today;
          //       },
          //       style: {
          //         backgroundColor: "rgb(196 240 196)",
          //       },
          //     },
          //   ],
          // },

          {
            id: "action",
            name: "Action",
            button: true,
            cell: (row) => (
              <>
                {" "}
                {row && row.freeze === "FREEZE" ? (
                  <span className="font-size action-icons">
                    <i
                      className={`mdi mdi-pencil-box text-lg ${
                        row && row.freeze === "FREEZE"
                          ? "editRetreatDisabled"
                          : "editRetreatButton"
                      } font-size`}
                      title="Edit"
                    ></i>
                  </span>
                ) : (
                  <Link
                    to={`/create-retreat/${row.id}`}
                    className="font-size action-icons"
                  >
                    <i
                      className={`mdi mdi-pencil-box text-lg ${
                        row && row.freeze === "FREEZE"
                          ? "editRetreatDisabled"
                          : "editRetreatButton"
                      } font-size`}
                      title="Edit"
                    ></i>
                  </Link>
                )}
                <button
                  disabled={row && row.freeze === "FREEZE" ? true : false}
                  className="font-size action-icons"
                  onClick={() => handleShow(row)}
                >
                  <i
                    className={`mdi mdi-delete-forever text-md ${
                      row && row.freeze === "FREEZE"
                        ? "deleteRetreatDisabled"
                        : "deleteRetreatButton"
                    }  mx-2 font-size`}
                    title="Delete"
                  ></i>
                </button>
                <a
                  href={`/registration-retreat/${row.id}`}
                  className="font-size action-icons"
                  target="_blank"
                >
                  <i className="mdi mdi-eye" title="View"></i>
                </a>
              </>
            ),
            reorder: true,
            width: "150px",
            conditionalCellStyles: [
              {
                when: (row) => {
                  const today = new Date();
                  today.setHours(0, 0, 0, 0);
                  const dateFrom = new Date(row.dateFrom);
                  dateFrom.setHours(0, 0, 0, 0);
                  const dateTo = new Date(row.dateTo);
                  dateTo.setHours(0, 0, 0, 0);
                  return dateFrom >= today || dateTo >= today;
                },
                style: {
                  backgroundColor: "rgb(196 240 196)",
                },
              },
            ],
          },
          {
            id: "Freeze",
            name: (
              <OverlayTrigger
                placement="bottom"
                overlay={customTooltip("Edit/Delete not allowed")}
              >
                <span>Freeze</span>
              </OverlayTrigger>
            ),
            selector: (row) => {
              return (
                <Form.Check
                  className={`switchSize ${
                    row.freeze === "FREEZE" ? "toggle-on" : "toggle-off"
                  }`}
                  type="switch"
                  name="freeze"
                  value={row.freeze}
                  checked={row.freeze === "FREEZE" ? true : false}
                  onChange={(e) => {
                    handleShow1(row);
                  }}
                  id="freeze"
                />
              );
            },
            reorder: true,
            width: "100px",
            conditionalCellStyles: [
              {
                when: (row) => {
                  const today = new Date();
                  today.setHours(0, 0, 0, 0);
                  const dateFrom = new Date(row.dateFrom);
                  dateFrom.setHours(0, 0, 0, 0);
                  const dateTo = new Date(row.dateTo);
                  dateTo.setHours(0, 0, 0, 0);
                  return dateFrom >= today || dateTo >= today;
                },
                style: {
                  backgroundColor: "rgb(196 240 196)",
                },
              },
            ],
          },
          {
            id: "Post Retreat Closure",
            name: "Post Retreat Closure",
            cell: (row) => (
              <div className="retreat_closure">
                {" "}
                <div>
                  <div>
                    {row &&
                    row.confirmation &&
                    row.confirmation[0] &&
                    row.confirmation[0].roasterData === true ? (
                      <>
                        {" "}
                        <div class="green-dot"></div>{" "}
                        <span>Retreat Roster data</span>
                      </>
                    ) : (
                      <>
                        <div class="red-dot"></div>{" "}
                        <span>Retreat Roster data</span>
                      </>
                    )}
                  </div>

                  {row &&
                  row.confirmation &&
                  row.confirmation[1] &&
                  row.confirmation[1].Directory === true ? (
                    <>
                      {" "}
                      <div class="green-dot"></div> <span>Directory</span>
                    </>
                  ) : (
                    <>
                      <div class="red-dot"></div> <span>Directory</span>
                    </>
                  )}
                </div>
                <div>
                  {row &&
                  row.confirmation &&
                  row.confirmation[2] &&
                  row.confirmation[2].Program === true ? (
                    <>
                      {" "}
                      <div class="green-dot"></div> <span>Program</span>
                    </>
                  ) : (
                    <>
                      <div class="red-dot"></div> <span>Program</span>
                    </>
                  )}
                </div>
              </div>
            ),

            sortable: true,
            reorder: true,
            width: "140px",
            style: {
              cursor: "text",
            },
            conditionalCellStyles: [
              {
                when: (row) => {
                  const today = new Date();
                  today.setHours(0, 0, 0, 0);
                  const dateFrom = new Date(row.dateFrom);
                  dateFrom.setHours(0, 0, 0, 0);
                  const dateTo = new Date(row.dateTo);
                  dateTo.setHours(0, 0, 0, 0);
                  return dateFrom >= today || dateTo >= today;
                },
                style: {
                  backgroundColor: "rgb(196 240 196)",
                },
              },
            ],
          },
        ]
      : []),
    ...(userData &&
    userData.userRole !== "ADMIN" &&
    userData.committeeMember === true
      ? [
          {
            id: "action",
            name: "Action",
            button: true,
            cell: (row) => (
              <>
                {" "}
                {row && row.freeze === "FREEZE" ? (
                  <span className="font-size action-icons">
                    <i
                      className={`mdi mdi-pencil-box text-lg ${
                        row && row.freeze === "FREEZE"
                          ? "editRetreatDisabled"
                          : "editRetreatButton"
                      } font-size`}
                      title="Edit"
                    ></i>
                  </span>
                ) : (
                  <Link
                    to={`/create-retreat/${row.id}`}
                    className="font-size action-icons"
                  >
                    <i
                      className={`mdi mdi-pencil-box text-lg ${
                        row && row.freeze === "FREEZE"
                          ? "editRetreatDisabled"
                          : "editRetreatButton"
                      } font-size`}
                      title="Edit"
                    ></i>
                  </Link>
                )}
                <a
                  href={`/registration-retreat/${row.id}`}
                  className="font-size action-icons mx-2"
                  target="_blank"
                >
                  <i className="mdi mdi-eye" title="View"></i>
                </a>
              </>
            ),
            reorder: true,
            width: "150px",
            conditionalCellStyles: [
              {
                when: (row) => {
                  const today = new Date();
                  today.setHours(0, 0, 0, 0);
                  const dateFrom = new Date(row.dateFrom);
                  dateFrom.setHours(0, 0, 0, 0);
                  const dateTo = new Date(row.dateTo);
                  dateTo.setHours(0, 0, 0, 0);
                  return dateFrom >= today || dateTo >= today;
                },
                style: {
                  backgroundColor: "rgb(196 240 196)",
                },
              },
            ],
          },

          {
            id: "Post Retreat Closure",
            name: "Post Retreat Closure",
            cell: (row) => (
              <div className="retreat_closure">
                {" "}
                <div>
                  {row &&
                  row.confirmation &&
                  row.confirmation[0] &&
                  row.confirmation[0].Directory === true ? (
                    <>
                      {" "}
                      <div class="green-dot"></div> <span>Directory</span>
                    </>
                  ) : (
                    <>
                      <div class="red-dot"></div> <span>Directory</span>
                    </>
                  )}
                </div>
                <div>
                  {row &&
                  row.confirmation &&
                  row.confirmation[1] &&
                  row.confirmation[1].Program === true ? (
                    <>
                      {" "}
                      <div class="green-dot"></div> <span>Program</span>
                    </>
                  ) : (
                    <>
                      <div class="red-dot"></div> <span>Program</span>
                    </>
                  )}
                </div>
                <div>
                  {row &&
                  row.confirmation &&
                  row.confirmation[2] &&
                  row.confirmation[2].roasterData === true ? (
                    <>
                      {" "}
                      <div class="green-dot"></div>{" "}
                      <span>Retreat Roster data</span>
                    </>
                  ) : (
                    <>
                      <div class="red-dot"></div>{" "}
                      <span>Retreat Roster data</span>
                    </>
                  )}
                </div>
              </div>
            ),
            conditionalCellStyles: [
              {
                when: (row) => {
                  const today = new Date();
                  today.setHours(0, 0, 0, 0);
                  const dateFrom = new Date(row.dateFrom);
                  dateFrom.setHours(0, 0, 0, 0);
                  const dateTo = new Date(row.dateTo);
                  dateTo.setHours(0, 0, 0, 0);
                  return dateFrom >= today || dateTo >= today;
                },
                style: {
                  backgroundColor: "rgb(196 240 196)",
                },
              },
            ],
            sortable: true,
            reorder: true,
            width: "140px",
            style: {
              cursor: "text",
            },
          },
        ]
      : []),
    {
      id: "title",
      name: "Retreat Title",
      selector: (row) => {
        const formatDateRange = (from, to) => {
          if (moment(from).isSame(to, "day")) {
            // Same day
            return `${moment(from)
              .tz("America/New_York")
              .format("MMM D, YYYY")}`;
          } else if (moment(from).isSame(to, "month")) {
            // Same month
            return `${moment(from)
              .tz("America/New_York")
              .format("MMM D")} - ${moment(to)
              .tz("America/New_York")
              .format("D")}, ${moment(from)
              .tz("America/New_York")
              .format("YYYY")}`;
          } else {
            // Different months
            return `${moment(from)
              .tz("America/New_York")
              .format("MMM D")} - ${moment(to)
              .tz("America/New_York")
              .format("MMM D")}, ${moment(from)
              .tz("America/New_York")
              .format("YYYY")}`;
          }
        };

        const displayDate =
          row.dateFrom && row.dateTo
            ? formatDateRange(row.dateFrom, row.dateTo)
            : null;

        return (
          <>
            <a
              href=""
              onClick={(e) => {
                e.preventDefault();
                navigate(`/retreatRoster?retreatId=${row.id}`);
              }}
            >
              <div>
                {row?.parishName}
                {row.language
                  ? ` (${row.language[0].toUpperCase()}${row.language.slice(
                      1
                    )}) `
                  : null}{" "}
                {row.location
                  ? `${row.location[0].toUpperCase()}${row.location.slice(1)}`
                  : ""}
              </div>
            </a>

            {displayDate && (
              <OverlayTrigger
                placement="bottom"
                delay={{ show: 250, hide: 400 }}
                overlay={renderTooltip(displayDate)}
              >
                <span>{displayDate}</span>
              </OverlayTrigger>
            )}
          </>
        );
      },
      sortable: true,
      reorder: true,
      width: "300px",
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
    {
      id: "language",
      name: "Language",
      selector: (row) =>
        row.language.charAt(0).toUpperCase() + row.language.slice(1),
      sortable: true,
      reorder: true,
      width: "120px",
      style: {
        cursor: "text",
      },
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
    {
      id: "location",
      name: "Location",
      selector: (row) =>
        row.location.charAt(0).toUpperCase() + row.location.slice(1),
      sortable: true,
      reorder: true,
      width: "130px",
      style: {
        cursor: "text",
      },
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
    {
      id: "fromToDate",
      name: "Retreat Dates",
      cell: (row) => {
        const formatDateRange = (from, to) => {
          if (moment(from).isSame(to, "day")) {
            // Same day
            return `${moment(from)
              .tz("America/New_York")
              .format("MMM D, YYYY")}`;
          } else if (moment(from).isSame(to, "month")) {
            // Same month
            return `${moment(from)
              .tz("America/New_York")
              .format("MMM D")} - ${moment(to)
              .tz("America/New_York")
              .format("D")}, ${moment(from)
              .tz("America/New_York")
              .format("YYYY")}`;
          } else {
            // Different months
            return `${moment(from)
              .tz("America/New_York")
              .format("MMM D")} - ${moment(to)
              .tz("America/New_York")
              .format("MMM D")}, ${moment(from)
              .tz("America/New_York")
              .format("YYYY")}`;
          }
        };

        const displayDate =
          row.dateFrom && row.dateTo
            ? formatDateRange(row.dateFrom, row.dateTo)
            : null;

        return (
          <OverlayTrigger
            placement="bottom"
            delay={{ show: 250, hide: 400 }}
            overlay={renderTooltip(displayDate)}
          >
            <span>{displayDate}</span>
          </OverlayTrigger>
        );
      },
      sortable: true,
      reorder: true,
      width: "140px",
      style: {
        cursor: "text",
      },
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
    {
      id: "team",
      name: "# Team Couples",
      selector: (row) => row && row.countTeam,
      cell: (row) => (
        <div className="tooltip-static-demo">
          <div
            className="bs-tooltip-bottom bs-tooltip-bottom-demo tooltip-info"
            data-bs-toggle="tooltip"
            data-bs-placement="bottom"
            title=""
            data-bs-original-title="Decorations, Facilities, Go Team, Kitchen"
          >
            <div className="arrow"></div>
            <a
              href={`/retreatRoster?retreatId=${row.id}&flag=2`}
              style={{ textDecoration: "none" }}
              target="_blank"
              rel="noopener noreferrer"
            >
              <div className="tooltip-inner">{row && row.countTeam}</div>
            </a>
          </div>
        </div>
      ),
      reorder: true,
      sortable: true,
      width: "200px",
      style: {
        cursor: "text",
      },
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
    {
      id: "Retreatants",
      name: "# Retreatant Couples",
      selector: (row) => row && row.countRetreatant,
      cell: (row) => (
        <div className="tooltip-static-demo">
          <div
            className="bs-tooltip-bottom bs-tooltip-bottom-demo tooltip-info"
            data-bs-toggle="tooltip"
            data-bs-placement="bottom"
            title=""
            data-bs-original-title="Decorations, Facilities, Go Team, Kitchen"
          >
            <div className="arrow"></div>
            <a
              href={`/retreatRoster?retreatId=${row.id}&flag=1`}
              style={{ textDecoration: "none" }}
              target="_blank"
              rel="noopener noreferrer"
            >
              <div className="tooltip-inner">{row && row.countRetreatant}</div>
            </a>
          </div>
        </div>
      ),
      reorder: true,
      sortable: true,
      width: "200px",
      style: {
        cursor: "text",
      },
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
    {
      id: "Directory",
      name: "Directory",
      button: true,
      cell: (row) =>
        row && row.freeze === "FREEZE" ? (
          <div
            className={`font-size ml-3 ${
              row && row.directoryFile ? "file_side" : null
            }  ${
              row && row.freeze === "FREEZE" ? "editRetreatDisabled" : null
            } action-icons`}
          >
            <a>
              <i className="mdi mdi-folder-open" title="Upload Directory"></i>
            </a>
            {row.directoryFile && (
              <a
                className="ml-2"
                title="View Directory"
                href={row.directoryFile}
                target="_blank"
                rel="noopener noreferrer"
                style={{ cursor: "pointer" }}
              >
                <i
                  class="mdi mdi-download"
                  title="View Directory"
                  style={{ color: "#4cd964", marginLeft: "0.5rem" }}
                ></i>
              </a>
            )}
          </div>
        ) : (
          <div
            className={`font-size ml-3 action-icons ${
              row && row.directoryFile ? "file_side" : null
            }`}
          >
            <a
              onClick={(e) => {
                e.preventDefault();
                handleUploadDirectory(row); // Trigger upload modal
              }}
              style={{ cursor: "pointer" }}
              title="Upload Directory"
              className="font-size"
            >
              <i className="mdi mdi-folder-open"></i>
            </a>
            {row.directoryFile && (
              <a
                className="ml-2"
                title="View Directory"
                href={row.directoryFile}
                target="_blank"
                rel="noopener noreferrer"
                style={{ cursor: "pointer" }}
              >
                <i
                  class="mdi mdi-download"
                  title="View Directory"
                  style={{ color: "#4cd964", marginLeft: "0.5rem" }}
                ></i>
              </a>
            )}
          </div>
        ),
      reorder: true,
      width: "110px",
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
    {
      id: "Program",
      name: "Program",
      button: true,
      cell: (row) =>
        row && row.freeze === "FREEZE" ? (
          <div
            className={`font-size ml-3 ${
              row && row.programFile ? "file_side" : null
            } ${
              row && row.freeze === "FREEZE" ? "editRetreatDisabled" : null
            } action-icons`}
            style={{ cursor: "pointer" }}
          >
            <a>
              <i
                className="mdi mdi-calendar-multiselect"
                title="Upload Program"
              ></i>
            </a>
            {row.programFile && (
              <a
                className="ml-2"
                title="View Program"
                href={row.programFile}
                target="_blank"
                rel="noopener noreferrer"
                style={{ cursor: "pointer" }}
              >
                <i
                  class="mdi mdi-download"
                  title="View Program"
                  style={{ color: "#4cd964", marginLeft: "0.5rem" }}
                ></i>
              </a>
            )}
          </div>
        ) : (
          <div
            className={`font-size ml-3 action-icons ${
              row && row.programFile ? "file_side" : null
            }`}
          >
            <a
              onClick={(e) => {
                e.preventDefault();
                handleUploadProgram(row); // Trigger upload modal
              }}
              style={{ cursor: "pointer" }}
              title="Upload program"
              className="font-size"
            >
              <i className="mdi mdi-calendar-multiselect"></i>
            </a>
            {row.programFile && (
              <a
                className="ml-2"
                title="View Program"
                href={row.programFile}
                target="_blank"
                rel="noopener noreferrer"
                style={{ cursor: "pointer" }}
              >
                <i
                  class="mdi mdi-download"
                  title="View Program"
                  style={{ color: "#4cd964", marginLeft: "0.5rem" }}
                ></i>
              </a>
            )}
          </div>
        ),
      reorder: true,
      width: "110px",
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
    {
      id: "created",
      name: "Created",
      selector: (row) =>
        Helpers.convertUtcToTimezone(row.createdAt, "MM-DD-YYYY hh:mm:a"),
      cell: (row) => (
        <OverlayTrigger
          placement="bottom"
          delay={{ show: 250, hide: 400 }}
          overlay={renderTooltip(
            Helpers.convertUtcToTimezone(row.createdAt, "MM-DD-YYYY hh:mm:a")
          )}
        >
          <span>
            {Helpers.convertUtcToTimezone(
              row && row.createdAt,
              "MM-DD-YYYY hh:mm:a"
            )}
          </span>
        </OverlayTrigger>
      ),
      reorder: true,
      sortable: true,
      width: "170px",
      style: {
        cursor: "text",
      },
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
    {
      id: "created_by",
      name: "Created By",
      cell: (row) => (
        <OverlayTrigger
          placement="bottom"
          delay={{ show: 250, hide: 400 }}
          overlay={renderTooltip(
            row.contact_name &&
              row.contact_name !== "" &&
              row.contact_name !== null
              ? row.contact_name
              : "ADMIN"
          )}
        >
          {row.contact_name &&
          row.contact_name !== "" &&
          row.contact_name !== null ? (
            <span
              onClick={() => {
                setContactData(true);
                setRetreatDetail(row);
              }}
              className="sampleData"
            >
              {row.contact_name}
            </span>
          ) : (
            <span>ADMIN</span>
          )}
        </OverlayTrigger>
      ),
      reorder: true,
      sortable: true,
      width: "130px",
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
      style: {
        cursor: "text",
      },
    },
    {
      id: "confirmed_by",
      name: "Confirmed By",
      cell: (row) => (
        <OverlayTrigger
          placement="bottom"
          delay={{ show: 250, hide: 400 }}
          overlay={renderTooltip("Confirmed data List")}
        >
          <span
            onClick={() => {
              setConfirmedData(true);
              setRetreatDetail(row);
            }}
          >
            <i
              className="mdi mdi-view-headline font-size action-icons"
              title="Confirmed List"
            ></i>
          </span>
        </OverlayTrigger>
      ),
      reorder: true,
      sortable: true,
      width: "130px",
      style: {
        cursor: "pointer",
      },
      conditionalCellStyles: [
        {
          when: (row) => {
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const dateFrom = new Date(row.dateFrom);
            dateFrom.setHours(0, 0, 0, 0);
            const dateTo = new Date(row.dateTo);
            dateTo.setHours(0, 0, 0, 0);
            return dateFrom >= today || dateTo >= today;
          },
          style: {
            backgroundColor: "rgb(196 240 196)",
          },
        },
      ],
    },
  ];

  const handleShow = (item) => {
    setRetreatDetail(item);
    setShow(true);
    setIcon_id(item.id);
    let d = { ...data };
    d.id = item.id;
    d.title = item.title;
    d.language = item.language;
    d.location = item.location;
    d.parishName = item.parishName;
    setData(d);
  };

  const handleClose = () => {
    if (showingRetreats === true) {
      getAllRetreats(1, 20, null, {}, false, "", userData?.id);
    } else {
      getAllRetreats();
    }
    setShow(false);
  };

  const renderModel = () => {
    return (
      <Modal
        show={showRegModal}
        onHide={() => {
          setShowREgModal(false);
          setDirectory([]);
          setProgram([]);
          if (showingRetreats === true) {
            getAllRetreats(1, 20, null, {}, false, "", userData?.id);
          } else {
            getAllRetreats();
          }
        }}
        size="lg"
      >
        <Modal.Header closeButton>
          <Modal.Title>Retreat BackUp</Modal.Title>
        </Modal.Header>

        <Modal.Body>
          <ListGroup>
            {deleteList &&
              deleteList.map((item, i) => (
                <ListGroup.Item key={i} className="d-flex restore-delete">
                  <div>
                    <a
                      href=""
                      onClick={(e) => {
                        e.preventDefault();
                        navigate(`/retreatRoster?retreatId=${item.id}`);
                      }}
                    >
                      <div>{item.title}</div>
                    </a>
                    {item.dateFrom === item.dateTo ? (
                      <span>
                        {moment(item && item.dateFrom)
                          .tz("America/New_York")
                          .format("MMM-DD-YYYY")}
                      </span>
                    ) : (
                      <span>
                        {moment(item && item.dateFrom)
                          .tz("America/New_York")
                          .format("MMM-DD") +
                          " - " +
                          moment(item.dateTo)
                            .tz("America/New_York")
                            .format("MMM DD") +
                          ", " +
                          moment(item && item.dateFrom)
                            .tz("America/New_York")
                            .format("YYYY")}
                      </span>
                    )}
                  </div>
                  <div>
                    {" "}
                    <button
                      className="font-size button-33"
                      onClick={() => restoreRetreat(item.id)}
                    >
                      Restore
                    </button>
                    <button
                      className="font-size button-35"
                      onClick={() => permanentDeleteRetreat(item.id)}
                    >
                      Delete
                    </button>
                  </div>
                </ListGroup.Item>
              ))}
          </ListGroup>
        </Modal.Body>
        <Modal.Footer>
          <Button
            variant="secondary"
            onClick={() => {
              setShowREgModal(false);
              if (showingRetreats === true) {
                getAllRetreats(1, 20, null, {}, false, "", userData?.id);
              } else {
                getAllRetreats();
              }
              setDirectory([]);
              setProgram([]);
            }}
          >
            Cancel
          </Button>
        </Modal.Footer>
      </Modal>
    );
  };

  const handleCloseAlert = () => {
    setContactData(false);
    setConfirmedData(false);
  };

  const handleClick = () => {
    setParishValue("");
    if (!showingRetreats) {
      getAllRetreats(1, 20, null, {}, false, "", userData?.id);
    } else {
      getAllRetreats();
    }
    setShowingRetreats(!showingRetreats);
  };

  const getSelectedRetreatData = async () => {
    setLoadData(true);
    try {
      let res;
      const isAllSelectedNoFilters =
        allSelected &&
        (parishValue === "" || parishValue === null) &&
        (searchKey === "" || searchKey === null);

      const isAllSelectedWithFilters =
        allSelected && (parishValue !== "" || searchKey !== "");

      const isSpecificSelection = !allSelected && selectedRetreats.length > 0;

      if (isAllSelectedNoFilters) {
        res = await retreatApi.getAllRetreatData();
      } else if (isAllSelectedWithFilters) {
        res = await retreatApi.getAllRetreats({
          pageNo: 1,
          size: 10000,
          searchKeyword: searchKey,
          parishValue: parishValue,
          allRetreat: true,
        });

        if (res.success) {
          const retreatIds = res.data.map((retreat) => retreat.id);
          res = await retreatApi.getSelectedRetreatData({
            retreats: retreatIds,
          });
        }
      } else if (!allSelected && parishValue) {
        toast.error("Please select at least one retreat to export");
        setLoadData(false);
        return;
      } else if (isSpecificSelection) {
        res = await retreatApi.getSelectedRetreatData({
          retreats: selectedRetreats,
        });
      } else {
        toast.error("Please select at least one retreat to export");
        setLoadData(false);
        return;
      }

      if (!res.success) {
        toast.error(res.msg);
        setLoadData(false);
        return;
      }

      const allRetreatsData = res.data;

      const groupedData = allRetreatsData.reduce((acc, entry) => {
        const id = entry.retreatId;
        if (!acc[id]) acc[id] = [];
        acc[id].push(entry);
        return acc;
      }, {});

      const workbook = new ExcelJS.Workbook();
      const headers = [
        "Retreat Title",
        "Date From",
        "Date To",
        "Couple Id",
        "Type",
        "Image",
        "His Last Name",
        "His First Name",
        "Her Last Name",
        "Her First Name",
        "His Email",
        "Her Email",
        "His Mobile",
        "Her Mobile",
        "Service Role",
        "Service Title",
        "Talk",
        "Address",
        "City",
        "State",
        "Zip",
        "Parish",
        "Anniversary Date",
        "Dietary Restrictions Or Physical Limitations",
        "Under Age 35",
        "Emergency Name1",
        "Emergency Relationship1",
        "Emergency Phone1",
        "Emergency Name2",
        "Emergency Relationship2",
        "Emergency Phone2",
        "Referral from a friend/family member",
        "Notes",
      ];

      const missingText = "⚠ This is Missing";
      Object.entries(groupedData).forEach(([retreatId, couples], index) => {
        let baseTitle = couples[0]?.title || `Retreat-${retreatId}`;
        baseTitle = baseTitle.replace(/[\\/*?:[\]]/g, "");
        let sheetTitle = `${index + 1}_` + baseTitle.slice(0, 25);
        if (sheetTitle.length > 31) sheetTitle = sheetTitle.slice(0, 31);

        const worksheet = workbook.addWorksheet(sheetTitle);
        worksheet.addRow(headers);

        couples.forEach((item) => {
          const rowData = [
            item.title || missingText,
            moment(item?.dateFrom)
              .tz("America/New_York")
              .format("MMM-DD-YYYY") || missingText,
            moment(item?.dateTo).tz("America/New_York").format("MMM-DD-YYYY") ||
              missingText,
            item.primaryKey || missingText,
            item.attendeeType || missingText,
            item.imageUrl || missingText,
            item.hisLastName || missingText,
            item.hisFirstName || missingText,
            item.herLastName || missingText,
            item.herFirstName || missingText,
            item.hisEmail || missingText,
            item.herEmail || missingText,
            item.hisMobile || missingText,
            item.herMobile || missingText,
            item.role || "⚠ No Role",
            item.service || "⚠ No Service",
            item.talk || "⚠ No Talk",
            item.address || missingText,
            item.city || missingText,
            item.state || missingText,
            item.zip || missingText,
            item.coupleParish || missingText,
            item.anniversary_date
              ? Helpers.convertUtcToTimezone(item.anniversary_date, "M/D/YYYY")
              : missingText,
            item.allergies || missingText,
            item.under_age_35 || missingText,
            item.emergency_name1 || missingText,
            item.emergency_relationship1 || missingText,
            item.emergency_phone1 || missingText,
            item.emergency_name2 || missingText,
            item.emergency_relationship2 || missingText,
            item.emergency_phone2 || missingText,
            item.referral_from_a_friend_or_family_member || missingText,
            item.notes || missingText,
          ];

          const row = worksheet.addRow(rowData);

          // Apply yellow only if missing
          for (let i = 1; i <= rowData.length; i++) {
            const cell = row.getCell(i);
            if (cell.value === missingText) {
              cell.fill = {
                type: "pattern",
                pattern: "solid",
                fgColor: { argb: "FFFF00" }, // Yellow
              };
            }
          }
        });

        worksheet.columns.forEach((column) => {
          let maxLength = 0;
          column.eachCell({ includeEmpty: true }, (cell) => {
            const val = cell.value ? cell.value.toString() : "";
            maxLength = Math.max(maxLength, val.length);
          });
          column.width = maxLength + 2;
        });
      });

      const buffer = await workbook.xlsx.writeBuffer();
      const blob = new Blob([buffer], {
        type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
      });
      const url = window.URL.createObjectURL(blob);
      const a = document.createElement("a");
      a.href = url;
      a.download = "Retreats_Export.xlsx";
      a.click();
      window.URL.revokeObjectURL(url);
      setLoadData(false);
    } catch (error) {
      console.error("error--->", error);
      toast.error("Failed to fetch data");
      setLoadData(false);
    }
  };

  const onSelectedParishRetreat = (e) => {
    setParishValue(e.target.value);
    const selectedParishId = parseInt(e.target.value);
    if (showingRetreats === true) {
      getAllRetreats(
        1,
        20,
        null,
        {},
        false,
        "",
        userData?.id,
        selectedParishId
      );
    } else {
      getAllRetreats(1, 20, null, {}, false, "", null, selectedParishId);
    }
  };

  return (
    <div className="row">
      {userData.userRole === "ADMIN" ? (
        <div className="col-lg-12 col-md-12 col-sm-12 col-xs-12 dirPage ">
          {userData?.committeeMember === true ? (
            <div className="mb-3" onClick={handleClick}>
              {showingRetreats ? "Back" : "Update Your Retreats"}
            </div>
          ) : null}
          <div>
            <a href={`/retreat-backup`} className="mb-3 mx-3">
              {" "}
              Back-up of Retreats
            </a>
          </div>
        </div>
      ) : null}

      <div className="col-lg-12 d-flex flex-column mt-1">
        <div className="card  custom-card">
          <div className="card-body">
            <div className="d-sm-flex justify-content-between align-items-start Couple_heading">
              <h4 className="card-title">Retreats</h4>
              {userData && userData.userRole === "ADMIN" ? (
                <div className="d-flex">
                  <select
                    className="selectedCommRetreat retreatViewAll"
                    onChange={(e) => onSelectedParishRetreat(e)}
                    value={parishValue}
                  >
                    <option value="" className="retreatOptions">
                      Select Parish
                    </option>
                    {perishDataList.map((item, i) => {
                      const labelParts = [
                        item.parish,
                        item.city,
                        item.parishCategoryName,
                      ].filter(Boolean);
                      const label = labelParts.join(" | ");

                      return (
                        <option
                          key={item.id}
                          value={item.id}
                          className="retreatOptions"
                        >
                          {label}
                        </option>
                      );
                    })}
                  </select>

                  <a
                    onClick={() => {
                      setSelectedRetreats([]);
                      setAllSelected(false);
                      setParishValue("");
                      setClearSelectionTrigger((prev) => !prev);
                      if (showingRetreats === true) {
                        getAllRetreats(
                          1,
                          20,
                          null,
                          {},
                          false,
                          "",
                          userData?.id
                        );
                      } else {
                        getAllRetreats();
                      }
                    }}
                    className="retreatViewAll"
                  >
                    View All
                  </a>
                  <div className="search">
                    <div className="input-group setSearch">
                      <input
                        onChange={SearchData}
                        type="text"
                        className="form-control searchData"
                        placeholder="Search..."
                        aria-label="Recipient's username"
                        aria-describedby="basic-addon2"
                        // value={searchKey}
                      />
                      <div className="input-group-append">
                        <button
                          className="btn btn-sm btn-primary"
                          type="button"
                        >
                          <i className="icon-search"></i>
                        </button>
                      </div>
                    </div>
                  </div>

                  <Link to="/create-retreat" className="addNewRet">
                    <button
                      onClick={() => {
                        // setShowREgModal(true);
                        clearfield();
                        // setActiveTab("Retreat");
                      }}
                      className="btn btn-primary btn-sm text-white mb-0 me-0 alignbtn"
                      type="button"
                      data-bs-toggle="modal"
                      data-bs-target="#exampleModal"
                    >
                      <i className="mdi mdi-account-multiple"></i> Add New
                      Retreat
                    </button>
                  </Link>
                </div>
              ) : null}
            </div>
            <CustomDataTable
              loading={LoadData}
              data={allRetreatData}
              countPerPage={20}
              isServerSide={true}
              pagination={true}
              sortServer={true}
              total={total}
              columns={columns}
              dataFetchApi={getAllRetreats}
              pointerOnHover={true}
              highlightOnHover={true}
              committeeId={showingRetreats ? userData?.id : null}
              parishValue={locationData?.state?.parishValue}
              selectableRows
              clearSelectedRows={clearSelectionTrigger}
              onSelectedRowsChange={(state) => {
                const { selectedRows, allSelected } = state;
                if (allSelected) {
                  setAllSelected(true);
                } else {
                  setAllSelected(false);
                }
                setSelectedRetreats(selectedRows.map((row) => row.id));
              }}
            />
          </div>
        </div>
        <div>
          <button onClick={getSelectedRetreatData} className="retreatButtons">
            Export Retreat Data
          </button>
          {/* <button onClick={getAllRetreatData} className="retreatButtons">
            Export All Retreats
          </button> */}
        </div>
      </div>

      {showRegModal ? renderModel() : null}
      {show ? (
        <DeleteModel
          show={show}
          handleClose={handleClose}
          DeleteData={deleteRetreat}
          title={retreatDetail.title}
          selectionDelete="temporary"
        ></DeleteModel>
      ) : null}
      {contactData ? (
        <AlertDelete
          show={contactData}
          alertHeader="Contact Information"
          alerMessage={
            <div>
              <div>
                <h5 className="mt-4">
                  <strong>Contact Name :</strong> {retreatDetail.contact_name}
                </h5>
                <h5 className="mt-4">
                  <strong>Contact Email :</strong> {retreatDetail.contact_email}
                </h5>
                <h5 className="mt-4">
                  <strong>Contact Mobile :</strong>{" "}
                  {retreatDetail.contact_mobile}
                </h5>
              </div>
              ​
            </div>
          }
          handleClose={handleCloseAlert}
          buttonText={"Close"}
        />
      ) : null}

      {confirmedData ? (
        <AlertDelete
          show={confirmedData}
          alertHeader="Confirmed By"
          alerMessage={
            retreatDetail.confirmation &&
            retreatDetail.confirmation.length > 0 ? (
              <div>
                <a
                  href=""
                  onClick={(e) => {
                    e.preventDefault();
                    navigate(`/retreatRoster?retreatId=${retreatDetail.id}`);
                  }}
                >
                  <div>{retreatDetail.title}</div>
                </a>
                {retreatDetail.dateFrom === retreatDetail.dateTo ? (
                  <span>
                    {moment(retreatDetail && retreatDetail.dateFrom)
                      .tz("America/New_York")
                      .format("MMM-DD-YYYY")}
                  </span>
                ) : (
                  <span>
                    {moment(retreatDetail && retreatDetail.dateFrom)
                      .tz("America/New_York")
                      .format("MMM-DD") +
                      " - " +
                      moment(retreatDetail.dateTo)
                        .tz("America/New_York")
                        .format("MMM DD") +
                      ", " +
                      moment(retreatDetail && retreatDetail.dateFrom)
                        .tz("America/New_York")
                        .format("YYYY")}
                  </span>
                )}

                <h4 className="mt-3">Roster Data</h4>
                <div>
                  <p className="mt-1">
                    <strong>Confirm Status:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[0] &&
                    retreatDetail.confirmation[0].roasterData
                      ? "Confirmed"
                      : "Not Confirmed"}
                  </p>
                  <p>
                    <strong>Confirmed By:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[0] &&
                    retreatDetail.confirmation[0].confirmedByName
                      ? `${retreatDetail.confirmation[0].confirmedByName} (${
                          retreatDetail.confirmation[0].confirmedByEmail ||
                          "Nil"
                        })`
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Role:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[0] &&
                    retreatDetail.confirmation[0].confirmedByRole
                      ? retreatDetail.confirmation[0].confirmedByRole
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Confirmed Date:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[0] &&
                    retreatDetail.confirmation[0].ConfirmedDate
                      ? Helpers.convertUtcToTimezone(
                          retreatDetail.confirmation[0].ConfirmedDate,
                          "MM-DD-YYYY hh:mm:a"
                        )
                      : "Nil"}
                  </p>
                </div>
                <hr className="mt-3" style={{ border: "1px solid #ccc" }} />
                <h4 className="mt-3">Directory</h4>
                <div>
                  <p className="mt-1">
                    <strong>Confirm Status: </strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[1] &&
                    retreatDetail.confirmation[1].Directory
                      ? "Confirmed"
                      : "Not Confirmed"}
                  </p>
                  <p>
                    <strong>Confirmed By: </strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[1] &&
                    retreatDetail.confirmation[1].confirmedByName
                      ? `${retreatDetail.confirmation[1].confirmedByName} (${
                          retreatDetail.confirmation[1].confirmedByEmail ||
                          "Nil"
                        })`
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Role: </strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[1] &&
                    retreatDetail.confirmation[1].confirmedByRole
                      ? retreatDetail.confirmation[1].confirmedByRole
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Confirmed Date:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[1] &&
                    retreatDetail.confirmation[1].ConfirmedDate
                      ? Helpers.convertUtcToTimezone(
                          retreatDetail.confirmation[1].ConfirmedDate,
                          "MM-DD-YYYY hh:mm:a"
                        )
                      : "Nil"}
                  </p>
                </div>
                <hr className="mt-3" style={{ border: "1px solid #ccc" }} />
                <h4>Program</h4>
                <div>
                  <p className="mt-1">
                    <strong>Confirm Status:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[2] &&
                    retreatDetail.confirmation[2].Program
                      ? "Confirmed"
                      : "Not Confirmed"}
                  </p>
                  <p>
                    <strong>Confirmed By:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[2] &&
                    retreatDetail.confirmation[2].confirmedByName
                      ? `${retreatDetail.confirmation[2].confirmedByName} (${
                          retreatDetail.confirmation[2].confirmedByEmail ||
                          "Nil"
                        })`
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Role:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[2] &&
                    retreatDetail.confirmation[2].confirmedByRole
                      ? retreatDetail.confirmation[2].confirmedByRole
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Confirmed Date:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[2] &&
                    retreatDetail.confirmation[2].ConfirmedDate
                      ? Helpers.convertUtcToTimezone(
                          retreatDetail.confirmation[2].ConfirmedDate,
                          "MM-DD-YYYY hh:mm:a"
                        )
                      : "Nil"}
                  </p>
                </div>
                <hr className="mt-3" style={{ border: "1px solid #ccc" }} />
                <h4>Retreat Status</h4>
                <div>
                  <p className="mt-1">
                    <strong>Status:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[4] &&
                    retreatDetail.confirmation[4].retreatStatus === "ACTIVE"
                      ? "ACTIVE"
                      : "INACTIVE"}
                  </p>
                  <p>
                    <strong>By:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[4] &&
                    retreatDetail.confirmation[4].confirmedByName
                      ? `${retreatDetail.confirmation[4].confirmedByName} (${
                          retreatDetail.confirmation[4].confirmedByEmail ||
                          "Nil"
                        })`
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Role:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[4] &&
                    retreatDetail.confirmation[4].confirmedByRole
                      ? retreatDetail.confirmation[4].confirmedByRole
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Date:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[4] &&
                    retreatDetail.confirmation[4].ConfirmedDate
                      ? Helpers.convertUtcToTimezone(
                          retreatDetail.confirmation[4].ConfirmedDate,
                          "MM-DD-YYYY hh:mm:a"
                        )
                      : "Nil"}
                  </p>
                </div>
                <hr className="mt-3" style={{ border: "1px solid #ccc" }} />

                <h4>Retreat Pictures</h4>
                <div>
                  <p className="mt-1">
                    <strong>Confirm Status:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[3] &&
                    retreatDetail.confirmation[3].pictures
                      ? "Confirmed"
                      : "Not Confirmed"}
                  </p>
                  <p>
                    <strong>Confirmed By:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[3] &&
                    retreatDetail.confirmation[3].confirmedByName
                      ? `${retreatDetail.confirmation[3].confirmedByName} (${
                          retreatDetail.confirmation[3].confirmedByEmail ||
                          "Nil"
                        })`
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Role:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[3] &&
                    retreatDetail.confirmation[3].confirmedByRole
                      ? retreatDetail.confirmation[3].confirmedByRole
                      : "Nil"}
                  </p>
                  <p>
                    <strong>Confirmed Date:</strong>{" "}
                    {retreatDetail &&
                    retreatDetail.confirmation &&
                    retreatDetail.confirmation[3] &&
                    retreatDetail.confirmation[3].ConfirmedDate
                      ? Helpers.convertUtcToTimezone(
                          retreatDetail.confirmation[3].ConfirmedDate,
                          "MM-DD-YYYY hh:mm:a"
                        )
                      : "Nil"}
                  </p>
                </div>
              </div>
            ) : (
              <div>No confirmation data available</div>
            )
          }
          handleClose={handleCloseAlert}
          bu
          ttonText={"Close"}
        />
      ) : null}

      {/* File Upload Modal */}
      <FileUploadModal
        show={showUploadModal}
        handleClose={handleUploadModalClose}
        rowId={selectedRowId}
        handleUploadSuccess={handleUploadSuccess}
        fileType={fileType}
        onDeleteFile={handleDeleteFile}
        existingFileUrl={existingFileUrl}
        modalTitle={uploadModalTitle}
        userData={userData}
      />
      {showFreeze ? (
        <AlertModal
          show={showFreeze}
          handleClose={handleClose2}
          message={`Are you sure you want to ${
            alertData.value === "FREEZE" ? "UNFREEZE" : "FREEZE"
          } this retreat?`}
          actionFunction={retreatFreeze}
          cancel={"Cancel"}
          okay={"Okay"}
          heading={"ALERT!!"}
        />
      ) : null}
      <AlertModal
        show={showStatus}
        handleClose={handleCloseStatus}
        message={` <h4>Are you sure you want to ${
          alertData?.status === "ACTIVE" ? "DEACTIVE" : "ACTIVE"
        } this Retreat?</h4>
  <h5 class="mt-4">
    Retreat Name: <strong>${alertData?.parishName || ""}
    ${
      alertData?.language
        ? ` (${alertData.language[0].toUpperCase()}${alertData.language.slice(
            1
          )})`
        : ""
    }
    ${
      alertData?.location
        ? ` ${alertData.location[0].toUpperCase()}${alertData.location.slice(
            1
          )}`
        : ""
    }</strong>
  </h5>`}
        actionFunction={retreatChangeStatus}
        cancel="Cancel"
        okay="Okay"
        heading="ALERT!!"
        showReasonBox={alertData.status === "ACTIVE"} // show editor only when making INACTIVE
        existingReason={alertData.inactiveReason || ""} // old message if any
        alertData={alertData}
        editBox={editBox}
      />
    </div>
  );
};
export default ManageRetreat;
