import React, { useState, useEffect } from "react";
import { useParams, Link } from "react-router-dom";
import { Row, Col, Container, Button } from "react-bootstrap";
import DirectoryApi from "../../../api/directoryApi";
import ProgramApi from "../../../api/programApi";
import moment from "moment";
import { toast } from "react-toastify";
import ImagePlaceHolder from "../../../assets/images/image-placeholder.png";
import lovestrongLogo from "../../../assets/images/Lovestrong-logo.jpg";
import Profile from "../../../assets/images/couple-default.png";
import Loader from "../../../components/loader";
import DirectoryModel from "./DirectoryModel";
import DeleteModel from "../../../components/DeleteModel";
import RetreatApi from "../../../api/retreatApi";
import Helpers from "../../../components/Helpers";
import { Cookies } from "react-cookie";
import AdminApi from "../../../api/admin";
import SocialLinksModal from "../../../components/SocialLinksModal";

export const CreateDirectory = () => {
  const [directory, setDirectory] = useState([]);
  const [allRetreatRoasters, setAllRetreatRoasters] = useState([]);
  const [modalShow, setModalShow] = useState(false);
  const [showDelete, setShowDelete] = useState(false);
  const [deleteItem, setDeleteItem] = useState(null);
  const [coupleTalkData, setCoupleTalkData] = useState([]);
  const [socialLinksModal, setSocialLinksModal] = useState(false);

  const [data, setData] = useState([]);
  const [loadFooter, setLoadFooter] = useState(false);
  const [loadMain, setLoadMain] = useState(false);
  let cookies = new Cookies();
  let userData = cookies.get("LoveStrongUser") || null;
  const { id } = useParams();
  let directoryApi = new DirectoryApi();
  let programApi = new ProgramApi();
  let retreatApi = new RetreatApi();
  let adminApi = new AdminApi();

  useEffect(() => {
    getDirectoryDetail(id);
    getAllRoastersOfRetreat(id);
    getRetreatDetail(id);
  }, [id]);

  const getRetreatDetail = async (id) => {
    await retreatApi
      .getRetreatDetail({ id: id })
      .then((res) => {
        if (res.success) {
          const { schedule, ...rest } = res.data[0];
          const parsedSchedule = schedule ? JSON.parse(schedule) : [];
          const parsedData = {
            ...rest,
            schedule: parsedSchedule.map((entry) => ({
              date: new Date(entry.date),
              from: entry.from,
              to: entry.to,
            })),
            parish: res.data[0].parishId,
          };
          setData(parsedData);
        } else {
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const getDirectoryDetail = async (id) => {
    await directoryApi
      .getDirectoryDetail({ rereatId: id })
      .then((response) => {
        setDirectory(response.data[0]);
      })
      .catch((error) => {
        toast.error(error.toString());
      });
  };

  const getAllRoastersOfRetreat = async (id) => {
    await directoryApi
      .getAllRoastersOfRetreat({ rereatId: id })
      .then((response) => {
        setAllRetreatRoasters(response.data);
      })
      .catch((error) => {
        toast.error(error.toString());
      });
  };

  const changePublishStatus = (directory, select) => {
    programApi
      .changePublishStatus({ id: directory.id, select: select })
      .then((res) => {
        getDirectoryDetail(directory.retreatId);
        toast.success(res.msg);
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const upload = (i) => {
    document.getElementById(`${i}` + "-" + "CoupleProfileUpload").click();
  };

  const handleClose = () => {
    setShowDelete(false);
    setDeleteItem(null);
  };

  const DeleteData = () => {
    if (deleteItem) {
      remove(deleteItem.directory, deleteItem.selection, deleteItem.checkImage);
      handleClose();
    }
  };

  const remove = (coupleDta, selection, checkImage) => {
    if (selection === "directory") {
      directoryApi
        .removeDirectoryImage({ checkImage: checkImage, id: coupleDta.id })
        .then((res) => {
          toast.success(res.msg);
          getDirectoryDetail(coupleDta.retreatId);
        })
        .catch((error) => {
          console.error(error);
          toast.error("An error occurred while uploading the image.");
        });
    } else if (selection === "") {
      directoryApi
        .removeImage({ id: coupleDta.coupleId })
        .then((res) => {
          toast.success(res.msg);
          getAllRoastersOfRetreat(coupleDta.retreatId);
        })
        .catch((error) => {
          console.error(error);
          toast.error("An error occurred while uploading the image.");
        });
    }
  };

  const hadleDirectoryModel = () => {
    setModalShow(true);
  };

  const handleallImagesChanges = (e, dir, imageSelection) => {
    if (imageSelection === "mainImage") {
      setLoadMain(true);
    } else if (imageSelection === "footerImage") {
      setLoadFooter(true);
    }
    let { name, value } = e.target;
    if (name === "imageUrl" && e.target.files && e.target.files.length > 0) {
      let allData = new FormData();
      allData.append("file", e.target.files[0]);
      allData.append("directoryId", dir && dir.id);
      allData.append("retreatId", id);
      allData.append("imageSelection", imageSelection);
      directoryApi
        .createDirectory(allData)
        .then(async (res) => {
          if (res.mode === "create") {
            let report = {
              byWhom:
                `${userData && userData.userName ? userData.userName : null} ` +
                ` (${
                  userData && userData.userRole ? userData.userRole : null
                })`,
              pagelink: window.location.href,
              description: `Created new retreat directory (Retreat - ${data.title})`,
            };
            await adminApi
              .addLogReport(report)
              .then((response) => {
                if (response.success) {
                  console.log("Added new log report");
                }
              })
              .catch((error) => {
                console.log(error);
              });
          } else {
            if (imageSelection === "mainImage") {
              let report = {
                byWhom:
                  `${
                    userData && userData.userName ? userData.userName : null
                  } ` +
                  ` (${
                    userData && userData.userRole ? userData.userRole : null
                  })`,
                pagelink: window.location.href,
                description: `Header image Changed in retreat directory (Retreat - ${data.title})`,
              };
              await adminApi
                .addLogReport(report)
                .then((response) => {
                  if (response.success) {
                    console.log("Added new log report");
                  }
                })
                .catch((error) => {
                  console.log(error);
                });
            } else if (imageSelection === "footerImage") {
              let report = {
                byWhom:
                  `${
                    userData && userData.userName ? userData.userName : null
                  } ` +
                  ` (${
                    userData && userData.userRole ? userData.userRole : null
                  })`,
                pagelink: window.location.href,
                description: `Footer1 image Changed in retreat directory (Retreat - ${data.title})`,
              };
              await adminApi
                .addLogReport(report)
                .then((response) => {
                  if (response.success) {
                    console.log("Added new log report");
                  }
                })
                .catch((error) => {
                  console.log(error);
                });
            }
          }
          toast.success(res.msg);
          getDirectoryDetail(id);
          setLoadMain(false);
          setLoadFooter(false);
        })
        .catch((error) => {
          console.error(error);
          toast.error("An error occurred while uploading the image.");
        });
    } else {
      toast.error("Please select an image.");
    }
  };

  const handleImageChanges = (e, coupleDta) => {
    console.log("coupleDta------->", coupleDta);

    let { name, value } = e.target;
    if (name === "imageUrl" && e.target.files && e.target.files.length > 0) {
      let allData = new FormData();
      allData.append("file", e.target.files[0]);
      allData.append("coupleId", coupleDta.coupleId);
      directoryApi
        .saveCoupleImage(allData)
        .then((res) => {
          toast.success("Couple image uploaded successfully.");
          getAllRoastersOfRetreat(coupleDta.retreatId);
          // setLoadData(false);
        })
        .catch((error) => {
          console.error(error);
          toast.error("An error occurred while uploading the image.");
        });
    } else {
      toast.error("Please select an image.");
    }
  };

  const closeDirectoryModel = () => {
    setModalShow(false);
    getDirectoryDetail(id);
  };

  const socialLinksOpen = () => {
    setSocialLinksModal(true);
  };
  const socialLinksClose = () => {
    setSocialLinksModal(false);
  };

  return (
    <>
      <Link to="/manageRetreat" className="back-link">
        &lt;Back
      </Link>

      <div className="row ext-space">
        <div className="col-lg-12 d-flex flex-column">
          <div className="row flex-grow">
            <div className="col-12 grid-margin stretch-card">
              <div className="card custom-card">
                <div className="card-body ">
                  <Container fluid className="create-retreat-header ">
                    <div className="row w-100 mx-0">
                      <Col
                        xs={12}
                        sm={8}
                        md={8}
                        lg={8}
                        className="directorydata"
                      >
                        <h1 className="addRetHeading">Directory -</h1>
                        <div className="mt-2 program-upper-title">
                          <h6>
                            {data && data.title
                              ? `${
                                  data &&
                                  data.title &&
                                  data.title.charAt(0).toUpperCase() +
                                    data.title.slice(1)
                                }, `
                              : null}
                            {data.dateFrom && data.dateTo
                              ? moment(data.dateFrom).isSame(data.dateTo, "day")
                                ? // Same day
                                  `${moment(data.dateFrom)
                                    .tz("America/New_York")
                                    .format("MMM D, YYYY")}`
                                : moment(data.dateFrom).isSame(
                                    data.dateTo,
                                    "month"
                                  )
                                ? // Same month, only show month once
                                  `${moment(data.dateFrom)
                                    .tz("America/New_York")
                                    .format("MMM D")} - ${moment(data.dateTo)
                                    .tz("America/New_York")
                                    .format("D")}, ${moment(data.dateFrom)
                                    .tz("America/New_York")
                                    .format("YYYY")}`
                                : // Different months
                                  `${moment(data.dateFrom)
                                    .tz("America/New_York")
                                    .format("MMM D")} - ${moment(data.dateTo)
                                    .tz("America/New_York")
                                    .format("MMM D")}, ${moment(data.dateFrom)
                                    .tz("America/New_York")
                                    .format("YYYY")}`
                              : null}
                          </h6>
                        </div>
                      </Col>

                      <Col xs={12} sm={4} md={4} lg={4}>
                        {directory && directory.id ? (
                          <>
                            {" "}
                            <Button
                              onClick={() =>
                                changePublishStatus(directory, "directory")
                              }
                              className="btn-sm submitRet"
                            >
                              {directory && directory.status === "PUBLISH"
                                ? "Unpublish"
                                : "Publish"}
                            </Button>
                            <a
                              href={`/directory/${id}`}
                              className="font-size"
                              target="_blank"
                            >
                              <Button
                                variant="primary"
                                className="btn-sm submitRet"
                              >
                                Preview
                              </Button>
                            </a>
                          </>
                        ) : null}
                      </Col>
                      <hr />
                    </div>
                    <Row className="text-center">
                      <Col>
                        <img
                          style={{
                            height: "140px",
                            marginTop: "15px",
                          }}
                          src={lovestrongLogo}
                          alt=""
                          srcset=""
                        />
                      </Col>
                      <Col
                        lg={12}
                        md={12}
                        sm={12}
                        xs={12}
                        className="directoryHeader footer-logo-image  howerOption"
                      >
                        <div>
                          {data && data.heading ? (
                            <h1>
                              <em>{data && data.heading}</em>
                            </h1>
                          ) : null}
                        </div>
                      </Col>

                      <Col
                        className="directoryImg howerOption mainHeaderImage p-0"
                        lg={12}
                        md={12}
                        sm={12}
                        xs={12}
                      >
                        {!data ||
                        data.image1 == "" ||
                        data.image1 == undefined ? (
                          <div className="text-center">
                            <img
                              src={ImagePlaceHolder}
                              alt=""
                              srcset=""
                              className="imageHeader"
                            />
                          </div>
                        ) : (
                          <div className="text-center">
                            <>
                              <img
                                src={data && data.image1}
                                className="imageHeader"
                              />
                            </>{" "}
                          </div>
                        )}{" "}
                      </Col>

                      {/* {loadMain ? (
                          <div className="auth-form-light text-center main-register py-5 pt-0 px-4 px-sm-5">
                            <Row className="text-center">
                              <Col
                                lg={12}
                                md={12}
                                sm={12}
                                xs={12}
                                className=" mt-3 p-5"
                              >
                                <Loader />
                              </Col>
                            </Row>
                          </div>
                        ) : (
                          <Col
                            className="directoryImg howerOption mainHeaderImage p-0"
                            lg={12}
                            md={12}
                            sm={12}
                            xs={12}
                          >
                            {!directory ||
                            directory.headerImage == "" ||
                            directory.headerImage == undefined ? (
                              <div className="text-center">
                                <img
                                  src={ImagePlaceHolder}
                                  alt=""
                                  srcset=""
                                  className="imageHeader"
                                />
                              </div>
                            ) : (
                              <div className="text-center">
                                <>
                                  <img
                                    src={directory && directory.headerImage}
                                    className="imageHeader"
                                  />
                                </>{" "}
                              </div>
                            )}{" "}
                            <div className="text-center setUploadField">
                              {!directory ||
                              directory.headerImage == "" ||
                              directory.headerImage == undefined ? (
                                <>
                                  <input
                                    name="imageUrl"
                                    className="pt-1"
                                    type="file"
                                    accept="image/*"
                                    style={{ display: "none" }}
                                    id={
                                      `${directory && directory.id}` +
                                      30 +
                                      "-" +
                                      "CoupleProfileUpload"
                                    }
                                    onChange={(e) =>
                                      handleallImagesChanges(
                                        e,
                                        directory,
                                        "mainImage"
                                      )
                                    }
                                  />
                                  <button
                                    onClick={(e) => {
                                      upload(
                                        `${directory && directory.id}` + 30
                                      );
                                    }}
                                    className="middle_Icon button-18"
                                  >
                                    Upload
                                  </button>
                                </>
                              ) : (
                                <button
                                  className="middle_Icon button-18"
                                  onClick={() => {
                                    setDeleteItem({
                                      directory,
                                      selection: "directory",
                                      checkImage: "mainImage",
                                    });
                                    setShowDelete(true);
                                  }}
                                >
                                  Remove
                                </button>
                              )}
                            </div>
                          </Col>
                        )} */}

                      <Col
                        lg={12}
                        md={12}
                        sm={12}
                        xs={12}
                        className="directoryHeader1 m-0"
                      >
                        <div>
                          <p>Retreat Directory</p>
                          <h2> {data?.myparish?.parish}</h2>
                          <h1 className="mt-2 m-0">
                            {data.dateFrom && data.dateTo ? (
                              <span>
                                {moment(data.dateFrom).isSame(
                                  data.dateTo,
                                  "day"
                                )
                                  ? // Same day
                                    `${moment(data.dateFrom)
                                      .tz("America/New_York")
                                      .format("MMM D, YYYY")}`
                                  : moment(data.dateFrom).isSame(
                                      data.dateTo,
                                      "month"
                                    )
                                  ? // Same month, show month only once
                                    `${moment(data.dateFrom)
                                      .tz("America/New_York")
                                      .format("MMM D")} - ${moment(data.dateTo)
                                      .tz("America/New_York")
                                      .format("D")}, ${moment(data.dateFrom)
                                      .tz("America/New_York")
                                      .format("YYYY")}`
                                  : // Different months
                                    `${moment(data.dateFrom)
                                      .tz("America/New_York")
                                      .format("MMM D")} - ${moment(data.dateTo)
                                      .tz("America/New_York")
                                      .format("MMM D")}, ${moment(data.dateFrom)
                                      .tz("America/New_York")
                                      .format("YYYY")}`}
                              </span>
                            ) : null}
                          </h1>
                        </div>
                      </Col>
                      {(allRetreatRoasters &&
                        allRetreatRoasters[0] &&
                        allRetreatRoasters[0].lead &&
                        allRetreatRoasters[0].lead.length) ||
                      (allRetreatRoasters &&
                        allRetreatRoasters[1] &&
                        allRetreatRoasters[1].coLead &&
                        allRetreatRoasters[1].coLead.length) ||
                      (allRetreatRoasters &&
                        allRetreatRoasters[2] &&
                        allRetreatRoasters[2].mentor &&
                        allRetreatRoasters[2].mentor.length) ||
                      (allRetreatRoasters &&
                        allRetreatRoasters[4] &&
                        allRetreatRoasters[4].sprDirector &&
                        allRetreatRoasters[4].sprDirector.length) ||
                      (allRetreatRoasters &&
                        allRetreatRoasters[3] &&
                        allRetreatRoasters[3].sprAdvisor &&
                        allRetreatRoasters[3].sprAdvisor.length) ? (
                        <Col
                          lg={12}
                          md={12}
                          sm={12}
                          xs={12}
                          className="colorTalks mt-3 p-5 leaderShip"
                        >
                          <h2 className="LeadHeading">Leadership</h2>
                          {allRetreatRoasters &&
                            allRetreatRoasters[0] &&
                            allRetreatRoasters[0].lead &&
                            allRetreatRoasters[0].lead.map((item, i) => {
                              <h3>Lead Couple</h3>;
                              return (
                                <Row key={i} className="mt-4">
                                  <Col
                                    md={5}
                                    className="coupleImages coupleImageHower mainHeaderImage"
                                  >
                                    {(item && item.imageUrl == "") ||
                                    item.imageUrl == undefined ? (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <img
                                          src={Profile}
                                          className="shadowImage"
                                        />
                                      </div>
                                    ) : (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <>
                                          <img
                                            src={item && item.imageUrl}
                                            className="shadowImage profileImage"
                                          />
                                        </>{" "}
                                      </div>
                                    )}{" "}
                                    <div className="text-center setUploadField">
                                      {(item && item.imageUrl == "") ||
                                      item.imageUrl == undefined ? (
                                        <>
                                          <input
                                            name="imageUrl"
                                            className="pt-1"
                                            type="file"
                                            accept="image/*"
                                            style={{
                                              display: "none",
                                            }}
                                            id={
                                              `${i}` +
                                              "-" +
                                              "CoupleProfileUpload"
                                            }
                                            onChange={(e) =>
                                              handleImageChanges(e, item)
                                            }
                                          />
                                          <i
                                            onClick={(e) => {
                                              upload(i);
                                            }}
                                            className="mdi mdi-upload text-lg text-primary font-size middle_Icon1"
                                            title="Image Upload"
                                          ></i>
                                        </>
                                      ) : (
                                        <i
                                          className="mdi mdi-delete-circle text-md text-danger mx-2 font-size middle_Icon1"
                                          onClick={(e) => {
                                            setDeleteItem({
                                              directory: item,
                                              selection: "",
                                              checkImage: "",
                                            });
                                            setShowDelete(true);
                                          }}
                                          title="Remove"
                                        ></i>
                                      )}
                                    </div>
                                  </Col>
                                  <Col md={7} className="coupl_detail">
                                    {i === 0 ? (
                                      <h4 className="mt-3">Lead Couple</h4>
                                    ) : null}
                                    <h2 className="mt-3 mb-3">
                                      {`${
                                        item && item.hisFirstName
                                          ? item.hisFirstName
                                          : ""
                                      } ${
                                        item && item.hisFirstName ? "&" : ""
                                      } ${
                                        item && item.herFirstName
                                          ? item.herFirstName
                                          : ""
                                      } ${
                                        item && item.hisLastName
                                          ? item.hisLastName
                                          : ""
                                      }`}
                                    </h2>
                                    <h4>
                                      {" "}
                                      {"His : " +
                                        `${
                                          item && item.hisMobile
                                            ? item.hisMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>{`${
                                      item && item.hisEmail ? item.hisEmail : ""
                                    }`}</h4>
                                    <h4>
                                      {" "}
                                      {"Her : " +
                                        `${
                                          item && item.herMobile
                                            ? item.herMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>
                                      {`${
                                        item && item.herEmail
                                          ? item.herEmail
                                          : ""
                                      }`}
                                    </h4>
                                    {item && item.anniversary_date ? (
                                      <h4>
                                        {"Anniversary Date : " +
                                          `${
                                            item && item.anniversary_date
                                              ? Helpers.convertUtcToTimezone(
                                                  item.anniversary_date,
                                                  "MM/DD"
                                                )
                                              : ""
                                          }`}
                                      </h4>
                                    ) : (
                                      ""
                                    )}
                                  </Col>
                                </Row>
                              );
                            })}

                          {allRetreatRoasters &&
                            allRetreatRoasters[1] &&
                            allRetreatRoasters[1].coLead &&
                            allRetreatRoasters[1].coLead.map((item, i) => {
                              return (
                                <Row key={i} className="mt-4">
                                  <Col
                                    md={5}
                                    className="coupleImages coupleImageHower mainHeaderImage"
                                  >
                                    {(item && item.imageUrl == "") ||
                                    item.imageUrl == undefined ? (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <img
                                          src={Profile}
                                          className="shadowImage"
                                        />
                                      </div>
                                    ) : (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <>
                                          <img
                                            src={item && item.imageUrl}
                                            className="shadowImage profileImage"
                                          />
                                        </>{" "}
                                      </div>
                                    )}{" "}
                                    <div className="text-center setUploadField">
                                      {(item && item.imageUrl == "") ||
                                      item.imageUrl == undefined ? (
                                        <>
                                          <input
                                            name="imageUrl"
                                            className="pt-1"
                                            type="file"
                                            accept="image/*"
                                            style={{
                                              display: "none",
                                            }}
                                            id={
                                              `${i}` +
                                              "-" +
                                              "CoupleProfileUpload"
                                            }
                                            onChange={(e) =>
                                              handleImageChanges(e, item)
                                            }
                                          />
                                          <i
                                            onClick={(e) => {
                                              upload(i);
                                            }}
                                            className="mdi mdi-upload text-lg text-primary font-size middle_Icon1"
                                            title="Image Upload"
                                          ></i>
                                        </>
                                      ) : (
                                        <i
                                          className="mdi mdi-delete-circle text-md text-danger mx-2 font-size middle_Icon1"
                                          onClick={() => {
                                            setDeleteItem({
                                              directory: item,
                                              selection: "",
                                              checkImage: "",
                                            });
                                            setShowDelete(true);
                                          }}
                                          title="Remove"
                                        ></i>
                                      )}
                                    </div>
                                  </Col>
                                  <Col md={7} className="coupl_detail">
                                    {i === 0 ? (
                                      <h4 className="mt-3">Co-Lead Couple</h4>
                                    ) : null}
                                    <h2 className="mt-3 mb-3">
                                      {`${
                                        item && item.hisFirstName
                                          ? item.hisFirstName
                                          : ""
                                      } ${
                                        item && item.hisFirstName ? "&" : ""
                                      } ${
                                        item && item.herFirstName
                                          ? item.herFirstName
                                          : ""
                                      } ${
                                        item && item.hisLastName
                                          ? item.hisLastName
                                          : ""
                                      }`}
                                    </h2>
                                    <h4>
                                      {" "}
                                      {"His : " +
                                        `${
                                          item && item.hisMobile
                                            ? item.hisMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>{`${
                                      item && item.hisEmail ? item.hisEmail : ""
                                    }`}</h4>
                                    <h4>
                                      {" "}
                                      {"Her : " +
                                        `${
                                          item && item.herMobile
                                            ? item.herMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>
                                      {`${
                                        item && item.herEmail
                                          ? item.herEmail
                                          : ""
                                      }`}
                                    </h4>{" "}
                                    {item && item.anniversary_date ? (
                                      <h4>
                                        {" "}
                                        {"Anniversary Date : " +
                                          `${
                                            item && item.anniversary_date
                                              ? Helpers.convertUtcToTimezone(
                                                  item.anniversary_date,
                                                  "MM/DD"
                                                )
                                              : ""
                                          }`}
                                      </h4>
                                    ) : (
                                      ""
                                    )}
                                  </Col>
                                </Row>
                              );
                            })}

                          {allRetreatRoasters &&
                            allRetreatRoasters[2] &&
                            allRetreatRoasters[2].mentor &&
                            allRetreatRoasters[2].mentor.map((item, i) => {
                              return (
                                <Row key={i} className="my-5">
                                  <Col
                                    md={5}
                                    className="coupleImages coupleImageHower mainHeaderImage"
                                  >
                                    {(item && item.imageUrl == "") ||
                                    item.imageUrl == undefined ? (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <img
                                          src={Profile}
                                          className="shadowImage"
                                        />
                                      </div>
                                    ) : (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <>
                                          <img
                                            src={item && item.imageUrl}
                                            className="shadowImage profileImage"
                                          />
                                        </>{" "}
                                      </div>
                                    )}{" "}
                                    <div className="text-center setUploadField">
                                      {(item && item.imageUrl == "") ||
                                      item.imageUrl == undefined ? (
                                        <>
                                          <input
                                            name="imageUrl"
                                            className="pt-1"
                                            type="file"
                                            accept="image/*"
                                            style={{
                                              display: "none",
                                            }}
                                            id={
                                              `${i}` +
                                              "-" +
                                              "CoupleProfileUpload"
                                            }
                                            onChange={(e) =>
                                              handleImageChanges(e, item)
                                            }
                                          />
                                          <i
                                            onClick={(e) => {
                                              upload(i);
                                            }}
                                            className="mdi mdi-upload text-lg text-primary font-size middle_Icon1"
                                            title="Image Upload"
                                          ></i>
                                        </>
                                      ) : (
                                        <i
                                          className="mdi mdi-delete-circle text-md text-danger mx-2 font-size middle_Icon1"
                                          onClick={() => {
                                            setDeleteItem({
                                              directory: item,
                                              selection: "",
                                              checkImage: "",
                                            });
                                            setShowDelete(true);
                                          }}
                                          title="Remove"
                                        ></i>
                                      )}
                                    </div>
                                  </Col>
                                  <Col md={7} className="coupl_detail">
                                    {i === 0 ? (
                                      <h4 className="mt-3">Mentor Couple</h4>
                                    ) : null}
                                    <h2 className="mt-3 mb-3">
                                      {`${
                                        item && item.hisFirstName
                                          ? item.hisFirstName
                                          : ""
                                      } ${
                                        item && item.hisFirstName ? "&" : ""
                                      } ${
                                        item && item.herFirstName
                                          ? item.herFirstName
                                          : ""
                                      } ${
                                        item && item.hisLastName
                                          ? item.hisLastName
                                          : ""
                                      }`}
                                    </h2>
                                    <h4>
                                      {" "}
                                      {"His : " +
                                        `${
                                          item && item.hisMobile
                                            ? item.hisMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>{`${
                                      item && item.hisEmail ? item.hisEmail : ""
                                    }`}</h4>
                                    <h4>
                                      {" "}
                                      {"Her : " +
                                        `${
                                          item && item.herMobile
                                            ? item.herMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>
                                      {`${
                                        item && item.herEmail
                                          ? item.herEmail
                                          : ""
                                      }`}
                                    </h4>{" "}
                                    {item && item.anniversary_date ? (
                                      <h4>
                                        {" "}
                                        {"Anniversary Date : " +
                                          `${
                                            item && item.anniversary_date
                                              ? Helpers.convertUtcToTimezone(
                                                  item.anniversary_date,
                                                  "MM/DD"
                                                )
                                              : ""
                                          }`}
                                      </h4>
                                    ) : (
                                      ""
                                    )}
                                  </Col>
                                </Row>
                              );
                            })}
                          {allRetreatRoasters &&
                            allRetreatRoasters[3] &&
                            allRetreatRoasters[3].sprAdvisor &&
                            allRetreatRoasters[3].sprAdvisor.map((item, i) => {
                              return (
                                <Row key={i} className="my-5">
                                  <Col
                                    md={5}
                                    className="coupleImages coupleImageHower mainHeaderImage"
                                  >
                                    {(item && item.imageUrl == "") ||
                                    item.imageUrl == undefined ? (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <img
                                          src={Profile}
                                          className="shadowImage"
                                        />
                                      </div>
                                    ) : (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <>
                                          <img
                                            src={item && item.imageUrl}
                                            className="shadowImage profileImage"
                                          />
                                        </>{" "}
                                      </div>
                                    )}{" "}
                                    <div className="text-center setUploadField">
                                      {(item && item.imageUrl == "") ||
                                      item.imageUrl == undefined ? (
                                        <>
                                          <input
                                            name="imageUrl"
                                            className="pt-1"
                                            type="file"
                                            accept="image/*"
                                            style={{
                                              display: "none",
                                            }}
                                            id={
                                              `${i}` +
                                              "-" +
                                              "CoupleProfileUpload"
                                            }
                                            onChange={(e) =>
                                              handleImageChanges(e, item)
                                            }
                                          />
                                          <i
                                            onClick={(e) => {
                                              upload(i);
                                            }}
                                            className="mdi mdi-upload text-lg text-primary font-size middle_Icon1"
                                            title="Image Upload"
                                          ></i>
                                        </>
                                      ) : (
                                        <i
                                          className="mdi mdi-delete-circle text-md text-danger mx-2 font-size middle_Icon1"
                                          onClick={() => {
                                            setDeleteItem({
                                              directory: item,
                                              selection: "",
                                              checkImage: "",
                                            });
                                            setShowDelete(true);
                                          }}
                                          title="Remove"
                                        ></i>
                                      )}
                                    </div>
                                  </Col>
                                  <Col md={7} className="coupl_detail">
                                    {i === 0 ? (
                                      <h4 className="mt-3">Spiritual Mentor</h4>
                                    ) : null}
                                    <h2 className="mt-3 mb-3">
                                      {`${
                                        item && item.hisFirstName
                                          ? item.hisFirstName
                                          : ""
                                      } ${
                                        item && item.hisFirstName ? "&" : ""
                                      } ${
                                        item && item.herFirstName
                                          ? item.herFirstName
                                          : ""
                                      } ${
                                        item && item.hisLastName
                                          ? item.hisLastName
                                          : ""
                                      }`}
                                    </h2>
                                    <h4>
                                      {" "}
                                      {"His : " +
                                        `${
                                          item && item.hisMobile
                                            ? item.hisMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>{`${
                                      item && item.hisEmail ? item.hisEmail : ""
                                    }`}</h4>
                                    <h4>
                                      {" "}
                                      {"Her : " +
                                        `${
                                          item && item.herMobile
                                            ? item.herMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>
                                      {`${
                                        item && item.herEmail
                                          ? item.herEmail
                                          : ""
                                      }`}
                                    </h4>{" "}
                                    {item && item.anniversary_date ? (
                                      <h4>
                                        {" "}
                                        {"Anniversary Date : " +
                                          `${
                                            item && item.anniversary_date
                                              ? Helpers.convertUtcToTimezone(
                                                  item.anniversary_date,
                                                  "MM/DD"
                                                )
                                              : ""
                                          }`}
                                      </h4>
                                    ) : (
                                      ""
                                    )}
                                  </Col>
                                </Row>
                              );
                            })}
                          {allRetreatRoasters &&
                            allRetreatRoasters[4] &&
                            allRetreatRoasters[4].sprDirector &&
                            allRetreatRoasters[4].sprDirector.map((item, i) => {
                              return (
                                <Row key={i} className="my-5">
                                  <Col
                                    md={5}
                                    className="coupleImages coupleImageHower mainHeaderImage"
                                  >
                                    {(item && item.imageUrl == "") ||
                                    item.imageUrl == undefined ? (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <img
                                          src={Profile}
                                          className="shadowImage"
                                        />
                                      </div>
                                    ) : (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <>
                                          <img
                                            src={item && item.imageUrl}
                                            className="shadowImage profileImage"
                                          />
                                        </>{" "}
                                      </div>
                                    )}{" "}
                                    <div className="text-center setUploadField">
                                      {(item && item.imageUrl == "") ||
                                      item.imageUrl == undefined ? (
                                        <>
                                          <input
                                            name="imageUrl"
                                            className="pt-1"
                                            type="file"
                                            accept="image/*"
                                            style={{
                                              display: "none",
                                            }}
                                            id={
                                              `${i}` +
                                              "-" +
                                              "CoupleProfileUpload"
                                            }
                                            onChange={(e) =>
                                              handleImageChanges(e, item)
                                            }
                                          />
                                          <i
                                            onClick={(e) => {
                                              upload(i);
                                            }}
                                            className="mdi mdi-upload text-lg text-primary font-size middle_Icon1"
                                            title="Image Upload"
                                          ></i>
                                        </>
                                      ) : (
                                        <i
                                          className="mdi mdi-delete-circle text-md text-danger mx-2 font-size middle_Icon1"
                                          onClick={() => {
                                            setDeleteItem({
                                              directory: item,
                                              selection: "",
                                              checkImage: "",
                                            });
                                            setShowDelete(true);
                                          }}
                                          title="Remove"
                                        ></i>
                                      )}
                                    </div>
                                  </Col>
                                  <Col md={7} className="coupl_detail">
                                    {i === 0 ? (
                                      <h4 className="mt-3">
                                        Spiritual Director
                                      </h4>
                                    ) : null}
                                    <h2 className="mt-3 mb-3">
                                      {`${
                                        item && item.hisFirstName
                                          ? item.hisFirstName
                                          : ""
                                      } ${
                                        item && item.hisFirstName ? "&" : ""
                                      } ${
                                        item && item.herFirstName
                                          ? item.herFirstName
                                          : ""
                                      } ${
                                        item && item.hisLastName
                                          ? item.hisLastName
                                          : ""
                                      }`}
                                    </h2>
                                    <h4>
                                      {" "}
                                      {"His : " +
                                        `${
                                          item && item.hisMobile
                                            ? item.hisMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>{`${
                                      item && item.hisEmail ? item.hisEmail : ""
                                    }`}</h4>
                                    <h4>
                                      {" "}
                                      {"Her : " +
                                        `${
                                          item && item.herMobile
                                            ? item.herMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>
                                      {`${
                                        item && item.herEmail
                                          ? item.herEmail
                                          : ""
                                      }`}
                                    </h4>{" "}
                                    {item && item.anniversary_date ? (
                                      <h4>
                                        {" "}
                                        {"Anniversary Date : " +
                                          `${
                                            item && item.anniversary_date
                                              ? Helpers.convertUtcToTimezone(
                                                  item.anniversary_date,
                                                  "MM/DD"
                                                )
                                              : ""
                                          }`}
                                      </h4>
                                    ) : (
                                      ""
                                    )}
                                  </Col>
                                </Row>
                              );
                            })}
                        </Col>
                      ) : null}
                      {allRetreatRoasters &&
                      allRetreatRoasters[6] &&
                      allRetreatRoasters[6].retreatant.length &&
                      allRetreatRoasters[6].retreatant ? (
                        <Col
                          lg={12}
                          md={12}
                          sm={12}
                          xs={12}
                          className="colorTalks mt-2 p-5 leaderShip"
                        >
                          <img
                            src="https://lovestrong.koolderbyacademy.com/logo.png"
                            alt=""
                            srcset=""
                            style={{
                              height: "90px",
                            }}
                          />

                          <h2 className="LeadHeading mt-4">Retreatants</h2>
                          {allRetreatRoasters &&
                            allRetreatRoasters[6] &&
                            allRetreatRoasters[6].retreatant &&
                            allRetreatRoasters[6].retreatant.map((item, i) => {
                              return (
                                <Row className="mt-4" key={i}>
                                  <Col
                                    md={5}
                                    className="coupleImages coupleImageHower mainHeaderImage"
                                  >
                                    {(item && item.imageUrl == "") ||
                                    item.imageUrl == undefined ? (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3">
                                        <img
                                          src={Profile}
                                          className="shadowImage"
                                        />
                                      </div>
                                    ) : (
                                      <div className="edit-profile-img mb-2  imageHeader mt-3 ">
                                        <>
                                          <img
                                            src={item && item.imageUrl}
                                            className="shadowImage profileImage"
                                          />
                                        </>{" "}
                                      </div>
                                    )}{" "}
                                    <div className="text-center setUploadField">
                                      {(item && item.imageUrl == "") ||
                                      item.imageUrl == undefined ? (
                                        <>
                                          <input
                                            name="imageUrl"
                                            className="pt-1"
                                            type="file"
                                            accept="image/*"
                                            style={{
                                              display: "none",
                                            }}
                                            id={
                                              `${i}` +
                                              "-" +
                                              "CoupleProfileUpload"
                                            }
                                            onChange={(e) =>
                                              handleImageChanges(e, item)
                                            }
                                          />
                                          <i
                                            onClick={(e) => {
                                              upload(i);
                                            }}
                                            className="mdi mdi-upload text-lg text-primary font-size middle_Icon1"
                                            title="Image Upload"
                                          ></i>
                                        </>
                                      ) : (
                                        <i
                                          className="mdi mdi-delete-circle text-md text-danger mx-2 font-size middle_Icon1"
                                          onClick={() => {
                                            setDeleteItem({
                                              directory: item,
                                              selection: "",
                                              checkImage: "",
                                            });
                                            setShowDelete(true);
                                          }}
                                          title="Remove"
                                        ></i>
                                      )}
                                    </div>
                                  </Col>
                                  <Col md={7} className="coupl_detail">
                                    {" "}
                                    <h2 className="mt-3 mb-3">
                                      {`${
                                        item && item.hisFirstName
                                          ? item.hisFirstName
                                          : ""
                                      } ${
                                        item && item.hisFirstName ? "&" : ""
                                      } ${
                                        item && item.herFirstName
                                          ? item.herFirstName
                                          : ""
                                      } ${
                                        item && item.hisLastName
                                          ? item.hisLastName
                                          : ""
                                      }`}
                                    </h2>
                                    <h4>
                                      {" "}
                                      {"His : " +
                                        `${
                                          item && item.hisMobile
                                            ? item.hisMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>{`${
                                      item && item.hisEmail ? item.hisEmail : ""
                                    }`}</h4>
                                    <h4>
                                      {" "}
                                      {"Her : " +
                                        `${
                                          item && item.herMobile
                                            ? item.herMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>
                                      {`${
                                        item && item.herEmail
                                          ? item.herEmail
                                          : ""
                                      }`}
                                    </h4>{" "}
                                    {item && item.anniversary_date ? (
                                      <h4>
                                        {" "}
                                        {"Anniversary Date : " +
                                          `${
                                            item && item.anniversary_date
                                              ? Helpers.convertUtcToTimezone(
                                                  item.anniversary_date,
                                                  "MM/DD"
                                                )
                                              : ""
                                          }`}
                                      </h4>
                                    ) : (
                                      ""
                                    )}
                                  </Col>
                                </Row>
                              );
                            })}
                        </Col>
                      ) : null}

                      {allRetreatRoasters &&
                      allRetreatRoasters[5] &&
                      allRetreatRoasters[5].team &&
                      allRetreatRoasters[5].team.length ? (
                        <Col
                          lg={12}
                          md={12}
                          sm={12}
                          xs={12}
                          className="colorTalks mt-3 p-5 leaderShip"
                        >
                          {" "}
                          <img
                            src="https://lovestrong.koolderbyacademy.com/logo.png"
                            alt=""
                            srcset=""
                            style={{
                              height: "90px",
                            }}
                          />
                          <h2 className="LeadHeading mt-4">Team</h2>
                          {allRetreatRoasters &&
                            allRetreatRoasters[5] &&
                            allRetreatRoasters[5].team &&
                            allRetreatRoasters[5].team.map((item, i) => {
                              return (
                                <Row className="mt-4">
                                  <Col
                                    md={5}
                                    className="coupleImages coupleImageHower mainHeaderImage"
                                  >
                                    {(item && item.imageUrl == "") ||
                                    item.imageUrl == undefined ? (
                                      <div className="edit-profile-img mb-2 imageHeader">
                                        <img
                                          src={Profile}
                                          className="shadowImage"
                                        />
                                      </div>
                                    ) : (
                                      <div className="edit-profile-img mb-2 imageHeader">
                                        <>
                                          <img
                                            src={item && item.imageUrl}
                                            className="shadowImage profileImage"
                                          />
                                        </>{" "}
                                      </div>
                                    )}{" "}
                                    <div className="text-center setUploadField">
                                      {(item && item.imageUrl == "") ||
                                      item.imageUrl == undefined ? (
                                        <>
                                          <input
                                            name="imageUrl"
                                            className="pt-1"
                                            type="file"
                                            accept="image/*"
                                            style={{
                                              display: "none",
                                            }}
                                            id={
                                              `${i}` +
                                              "-" +
                                              "CoupleProfileUpload"
                                            }
                                            onChange={(e) =>
                                              handleImageChanges(e, item)
                                            }
                                          />
                                          <i
                                            onClick={(e) => {
                                              upload(i);
                                            }}
                                            className="mdi mdi-upload text-lg text-primary font-size middle_Icon1"
                                            title="Image Upload"
                                          ></i>
                                        </>
                                      ) : (
                                        <i
                                          className="mdi mdi-delete-circle text-md text-danger mx-2 font-size middle_Icon1"
                                          onClick={() => {
                                            setDeleteItem({
                                              directory: item,
                                              selection: "",
                                              checkImage: "",
                                            });
                                            setShowDelete(true);
                                          }}
                                          title="Remove"
                                        ></i>
                                      )}
                                    </div>
                                  </Col>
                                  <Col md={7} className="coupl_detail">
                                    {" "}
                                    <h2 className="mt-3 mb-3">
                                      {`${
                                        item && item.hisFirstName
                                          ? item.hisFirstName
                                          : ""
                                      } ${
                                        item && item.hisFirstName ? "&" : ""
                                      } ${
                                        item && item.herFirstName
                                          ? item.herFirstName
                                          : ""
                                      } ${
                                        item && item.hisLastName
                                          ? item.hisLastName
                                          : ""
                                      }`}
                                    </h2>
                                    <h4>
                                      {" "}
                                      {"His : " +
                                        `${
                                          item && item.hisMobile
                                            ? item.hisMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>{`${
                                      item && item.hisEmail ? item.hisEmail : ""
                                    }`}</h4>
                                    <h4>
                                      {" "}
                                      {"Her : " +
                                        `${
                                          item && item.herMobile
                                            ? item.herMobile
                                            : ""
                                        }`}
                                    </h4>
                                    <h4>
                                      {`${
                                        item && item.herEmail
                                          ? item.herEmail
                                          : ""
                                      }`}
                                    </h4>{" "}
                                    {item && item.anniversary_date ? (
                                      <h4>
                                        {" "}
                                        {"Anniversary Date : " +
                                          `${
                                            item && item.anniversary_date
                                              ? Helpers.convertUtcToTimezone(
                                                  item.anniversary_date,
                                                  "MM/DD"
                                                )
                                              : ""
                                          }`}
                                      </h4>
                                    ) : (
                                      ""
                                    )}
                                  </Col>
                                </Row>
                              );
                            })}
                        </Col>
                      ) : null}

                      <Col
                        lg={12}
                        md={12}
                        sm={12}
                        xs={12}
                        className="colorTalks mt-3 leaderShip"
                      >
                        {loadFooter ? (
                          <div className="mainHeaderImage">
                            {" "}
                            <Row className="text-center">
                              <Col
                                lg={12}
                                md={12}
                                sm={12}
                                xs={12}
                                className=" mt-3 p-5"
                              >
                                <Loader />
                              </Col>
                            </Row>
                          </div>
                        ) : (
                          <div className="mainHeaderImage">
                            {!directory ||
                            directory.footerImage == "" ||
                            directory.footerImage == undefined ? (
                              <div className="mb-2 text-center footer_images">
                                <img
                                  src={ImagePlaceHolder}
                                  alt=""
                                  srcset=""
                                  className="imageHeader"
                                />
                              </div>
                            ) : (
                              <div className="mb-2 text-center footer_images">
                                <>
                                  <img
                                    src={directory && directory.footerImage}
                                    className="imageHeader"
                                  />
                                </>{" "}
                              </div>
                            )}{" "}
                            <div className="text-center setUploadField">
                              {!directory ||
                              directory.footerImage == "" ||
                              directory.footerImage == undefined ? (
                                <>
                                  <input
                                    name="imageUrl"
                                    className="pt-1"
                                    type="file"
                                    accept="image/*"
                                    style={{ display: "none" }}
                                    id={
                                      `${directory && directory.id}` +
                                      40 +
                                      "-" +
                                      "CoupleProfileUpload"
                                    }
                                    onChange={(e) =>
                                      handleallImagesChanges(
                                        e,
                                        directory,
                                        "footerImage"
                                      )
                                    }
                                  />
                                  <button
                                    onClick={(e) => {
                                      upload(
                                        `${directory && directory.id}` + 40
                                      );
                                    }}
                                    className="middle_Icon button-18"
                                  >
                                    Upload
                                  </button>
                                </>
                              ) : (
                                <button
                                  className="middle_Icon button-18"
                                  onClick={(e) => {
                                    setDeleteItem({
                                      directory,
                                      selection: "directory",
                                      checkImage: "footerImage",
                                    });
                                    setShowDelete(true);
                                  }}
                                >
                                  Remove
                                </button>
                              )}
                            </div>
                          </div>
                        )}
                        <div className="retdet">
                          <div>
                            {" "}
                            <h2>{data?.myparish?.parish} Lovestrong Team</h2>
                            <h1>
                              {data.dateFrom && data.dateTo ? (
                                <span>
                                  {moment(data.dateFrom).isSame(
                                    data.dateTo,
                                    "day"
                                  )
                                    ? // Same day
                                      `${moment(data.dateFrom)
                                        .tz("America/New_York")
                                        .format("MMM D, YYYY")}`
                                    : moment(data.dateFrom).isSame(
                                        data.dateTo,
                                        "month"
                                      )
                                    ? // Same month, show month only once
                                      `${moment(data.dateFrom)
                                        .tz("America/New_York")
                                        .format("MMM D")} - ${moment(
                                        data.dateTo
                                      )
                                        .tz("America/New_York")
                                        .format("D")}, ${moment(data.dateFrom)
                                        .tz("America/New_York")
                                        .format("YYYY")}`
                                    : // Different months
                                      `${moment(data.dateFrom)
                                        .tz("America/New_York")
                                        .format("MMM D")} - ${moment(
                                        data.dateTo
                                      )
                                        .tz("America/New_York")
                                        .format("MMM D")}, ${moment(
                                        data.dateFrom
                                      )
                                        .tz("America/New_York")
                                        .format("YYYY")}`}
                                </span>
                              ) : null}
                            </h1>
                          </div>
                        </div>{" "}
                        <div className="howerOption mt-3">
                          {" "}
                          <div className="buttonContainer1 text-right">
                            <button
                              className="button-18"
                              onClick={() => hadleDirectoryModel()}
                            >
                              Edit
                            </button>
                          </div>
                          <h2 className="mb-4 footerTitle">
                            {directory && directory.footerText ? (
                              <div
                                dangerouslySetInnerHTML={{
                                  __html: directory && directory.footerText,
                                }}
                              />
                            ) : (
                              "Footer Text..."
                            )}
                          </h2>
                        </div>
                        <div className="social-icons" onClick={socialLinksOpen}>
                          <i className="mdi mdi-facebook"></i>

                          <i className="mdi mdi-twitter"></i>

                          <i className="mdi mdi-pinterest"></i>

                          <i className="mdi mdi-instagram"></i>
                        </div>
                        <img
                          src={lovestrongLogo}
                          alt=""
                          srcset=""
                          className="logo_image footer-logo-image1"
                        />
                      </Col>
                    </Row>
                  </Container>
                </div>
              </div>
            </div>
          </div>
        </div>

        {modalShow ? (
          <DirectoryModel
            show={modalShow}
            directory={directory}
            retreatData={data}
            coupleTalkData={coupleTalkData}
            onHide={() => closeDirectoryModel()}
          />
        ) : null}

        <DeleteModel
          show={showDelete}
          content={
            <>
              {deleteItem?.checkImage === "mainImage" ? (
                <>
                  <h5 className="mt-4 fw-bold">Directory Header image</h5>
                  <div className="p-3 border rounded-3 bg-light shadow-sm">
                    This action will permanently remove the image.
                  </div>
                </>
              ) : deleteItem?.checkImage === "footerImage" ? (
                <>
                  <h5 className="mt-4 fw-bold">Directory Footer image</h5>
                  <div className="p-3 border rounded-3 bg-light shadow-sm">
                    This action will permanently remove the image.
                  </div>
                </>
              ) : (
                <>
                  <h5 className="mt-4 fw-bold">Couple Detail: </h5>
                  <div className="p-3 border rounded-3 bg-light shadow-sm">
                    {/* His Details */}
                    {(deleteItem?.directory?.hisFirstName ||
                      deleteItem?.directory?.hisLastName ||
                      deleteItem?.directory?.hisEmail) && (
                      <div className="mb-2">
                        <span className="fw-bold">His:</span>{" "}
                        {deleteItem?.directory?.hisFirstName}{" "}
                        {deleteItem?.directory?.hisLastName}
                        {deleteItem?.directory?.hisEmail && (
                          <span className="text-muted">
                            {" "}
                            – {deleteItem?.directory?.hisEmail}
                          </span>
                        )}
                      </div>
                    )}

                    {/* Her Details */}
                    {(deleteItem?.directory?.herFirstName ||
                      deleteItem?.directory?.herLastName ||
                      deleteItem?.directory?.herEmail) && (
                      <div>
                        <span className="fw-bold">Her:</span>{" "}
                        {deleteItem?.directory?.herFirstName}{" "}
                        {deleteItem?.directory?.herLastName}
                        {deleteItem?.directory?.herEmail && (
                          <span className="text-muted">
                            {" "}
                            – {deleteItem?.directory?.herEmail}
                          </span>
                        )}
                      </div>
                    )}
                  </div>
                </>
              )}
            </>
          }
          handleClose={handleClose}
          DeleteData={DeleteData}
        />

        {socialLinksModal ? (
          <SocialLinksModal
            show={socialLinksModal}
            onClose={socialLinksClose}
            directory={directory}
            setDirectory={setDirectory}
          ></SocialLinksModal>
        ) : null}
      </div>
    </>
  );
};
