import i18n from "i18next";
import { initReactI18next } from "react-i18next";
import LanguageDetector from "i18next-browser-languagedetector";
const resources = {
  english: {
    translation: {
      registration_form: "REGISTRATION FORM",
      retreat_team: "Are you Retreatant Couple or a Team Couple ?",
      retreatant: "Retreatant",
      team: "Team",
      check_year:
        "If you or your spouse are 35 years of age or younger, click this box:",
      yes: "Yes",
      his_info: "His Info",
      her_info: "Her Info",
      his_first_name: "His First Name",
      her_first_name: "Her First Name",
      his_last_name: "His Last Name",
      her_last_name: "Her Last Name",
      his_email: "His Email",
      her_email: "Her Email",
      email: "Email",
      his_mobile: "His Mobile",
      her_mobile: "Her Mobile",
      mobile: "Mobile",
      address: "Address",
      state: "State",
      city: "City",
      zip: "Zip Code",
      parish: "Parish",
      anniversary_date: "Anniversary Date (Month/Day)",
      notes: "Notes",
      dietary_allergies:
        "Do you or your spouse have any dietary allergies, dietary restrictions or physical limitations?",
      one_emergency_contact: "Please provide at least one emergency contact:",
      name: "Name",
      relationship: "Relationship",
      phone: "Phone",
      hear_us: "How did you hear about us?",
      website: "Website",
      church_bulletin: "Church Bulletin",
      facebook: "Facebook",
      school_marquee: "School Marquee",
      Pulpit_church: "Pulpit Talk/Table in Church",
      referral: "Referral from a friend/Family member",
      release_statement:
        "By checking the boxes of this clause immediately below, we, the LOVESTRONG Retreat participants, hereby release, waive, and forever discharge LOVESTRONG Marriage, the Hosting Parish/Church, and the Archdiocese of San Antonio, and any of their directors, officers, employees, and their agents (collectively “Releasees”) from all liability for any and all loss or damage, and any claim or demands therefore on account of injury, death or property damage or loss, now and forever, arising out of or related to the undersigned retreatants participation in and/or presence at the LOVESTRONG Marriage Retreat, including any of its associated sessions, activities, and operations that may occur, whether caused by the negligence of releasees or otherwise.",
      register: "Register",
      add_one_name: "Please add at least one name.",
      least_email_id: "Please add at least one email ID.",
      couple_register_retreat_msg: "Thank you for Retreat Registration!",
      select_state: "Select State",
      select_parish: "Select Parish...",
      mission_statement: "Our Mission Statement:",
      day: "Day",
      date: "Date",
      start: "Start",
      end: "End",
      lead_couple: "Lead Couple",
      co_lead_couple: "Co-Lead Couple",
      shadow_lead_couple: "Shadow Lead Couple",
      spiritual_director: "Spiritual Director",
      spiritual_mentor: "Spiritual Mentor",
      mentor_couple: "Mentor Couple",
      husband_acknowledgment: "Husband acknowledgment",
      wife_acknowledgment: "Wife acknowledgement",
      acknowledgmentAlertMsg: "Please acknowledge before submitting!",
      release_statement_title: "Release Statement",
      search_mail_field:
        "Enter Your Registered Email Id if you are already a Lovestrong Member:",
      search_mail_placeholder: "Enter Email",
      his_name: "His Name:",
      his_email: "His Email:",
      her_name: "Her Name:",
      her_email: "Her Email:",
      alert_msg: "Is this your information?",
      cancel_button: "No, this is not our information",
      okay_button: "Yes, this is our information",
      register_retreat: "Register Retreat",
      matched_mail:
        "Please check your information, you can edit and register for the Retreat.",
      not_matched_mail:
        "Please enter your information in the below Retreat Registration form.",
      okay_alert_msg: "Okay",
      highlighted_text: "(Fields highlighted in yellow are required.)",
      ret_team_selection: "Please select either a Retreatant or a Team Couple.",
      mobile_used: "This Mobile is already used.",
      already_registered:
        "You are already registered for this Retreat with this Email id.",
      mail_already_exist_in_db:
        "This Email does not exist in the database. Please enter your information in the below form.",
      help: "HELP",
      post_a_ticket: "Post a Ticket",
      first_name: "First Name",
      last_name: "Last Name",
      subject: "Subject",
      message: " Message / Issue",
      enter_captcha: "Enter Captcha",
      enter_your_name: "Enter your first name",
      enter_your_last_name: "Enter your last name",
      enter_your_email: "Enter your email",
      enter_your_mobile: "Enter your mobile number",
      enter_ticket_subject: "Enter ticket subject",
      describe_detail:
        "Please make sure to explain your problem, issue, or question in detail…",
      type_captcha_here: "Type captcha here",
      all_required_fields: "Please fill all required fields",
      failed_to_create_ticket: "Failed to create ticket",
      invalid_captcha: "Invalid captcha",
      ticket_successfully: "Ticket created successfully",
      cancel: "Cancel",
      select_category: "Select Category",
      ticket_category: "Ticket Category",
      retreat_registration: "Retreat Registration",
      retreat_financials: "Retreat Financials",
      retreat_roster: "Retreat Roster",
      retreat_closure: "Retreat Closure",
      database_issues: "Database Issues",
      retreat_reports: "Retreat Reports",
      request_to_feature: "Request to Feature",
      how_do_i: "How do I...",
      other: "Other",
      attachments: "Attachments",
      allowed: "(JPG, MP4, AVI allowed)",
      selected_files: "Selected files",
      invalid_email: "Invalid email",
      files_are_invalid: "These files are invalid",
      category_reqired: "Category is required",
      three_mb_size: "size should be less than 3 MB",
      ten_mb_size: "size should be less than 10 MB",
      invalid_type: "(invalid type)",
    },
  },
  spanish: {
    translation: {
      registration_form: "FORMULARIO DE INSCRIPCIÓN",
      retreat_team: "¿Son una pareja de retiro o una pareja de equipo?",
      retreatant: "Retiro",
      team: "Equipo",
      check_year:
        "Si usted o su cónyuge tienen 35 años o menos, haga clic en esta casilla:",
      yes: "Sí",
      his_info: "Información de el",
      her_info: "Información de ella",
      his_first_name: "Nombre de el",
      her_first_name: "Nombre de Ella",
      his_last_name: "Apellido (El)",
      her_last_name: "Apellido (Ella)",
      his_email: "Correo Electrónico (El)",
      her_email: "Correo Electrónico (Ella)",
      email: "Correo electrónico",
      his_mobile: "Celular (El)",
      her_mobile: "Celular (Ella)",
      mobile: "Móvil",
      address: "Dirección",
      state: "Estado",
      city: "Ciudad",
      zip: "Código postal",
      parish: "Parroquia / Iglesia",
      anniversary_date: "Fecha de aniversario (mes/día)",
      notes: "Notas",
      dietary_allergies:
        "¿Tiene usted o su cónyuge alguna alergia dietética, restricciones dietéticas o problemas físicos o limitaciones? Si es así, por favor explique.",
      one_emergency_contact: "Proporcione al menos un contacto de emergencia:",
      name: "Nombre",
      relationship: "Relación",
      phone: "Teléfono",
      hear_us: "¿Cómo se enteraron de nosotros?",
      website: "Sitio web",
      church_bulletin: "Boletín de la Iglesia",
      facebook: "Facebook",
      school_marquee: "Anuncio escolar",
      Pulpit_church: "Anuncio desde el púlpito en la iglesia",
      referral: "Referencia de un amigo/familiar",
      release_statement:
        "Al marcar las casillas de esta cláusula que inmediatamente a continuación se muestran, nosotros, los participantes del Retiro LOVESTRONG, por la presente, renunciamos y liberamos para siempre a LOVESTRONG Marriage, la Parroquia / Iglesia anfitriona y la Arquidiócesis a la que esta afiliada,  y cualquiera de sus representantes, directores, funcionarios, empleados y sus agentes (colectivamente 'Exonerados') de toda responsabilidad por cualquier pérdida o daño, y cualquier reclamo o demanda por causa de lesiones,  muerte, o daño, o pérdida a la propiedad, ahora y para siempre, que surja o, esté relacionada con la participación y / o presencia de los abajo mencionados en el Retiro Matrimonial LOVESTRONG, incluidas sus sesiones, juntas, actividades y operaciones asociadas que puedan ocurrir, ya sea causadas por la negligencia de los liberados o de otra manera.",
      register: "Registro",
      add_one_name: "Por favor agregue al menos un nombre.",
      least_email_id:
        "Agregue al menos una identificación de correo electrónico.",
      couple_register_retreat_msg: "¡Gracias por registrarse para el retiro!",
      select_state: "Seleccione estado",
      select_parish: "Seleccione Parroquia...",
      mission_statement: "Nuestra Misión:",
      day: "Dia",
      date: "Fecha",
      start: "Empieza",
      end: "Termina",
      lead_couple: "Pareja Líder",
      co_lead_couple: "Pareja Colider",
      shadow_lead_couple: "Pareja líder de la sombra",
      spiritual_director: "Director espiritual",
      spiritual_mentor: "Mentora espiritual",
      mentor_couple: "Pareja Mentora",
      husband_acknowledgment: "Reconocimiento del esposo",
      wife_acknowledgment: "Reconocimiento de la esposa",
      acknowledgmentAlertMsg: "¡Por favor reconozca antes de enviar!",
      release_statement_title: "Declaración de lanzamiento",
      search_mail_field:
        "Ingrese su dirección de correo electrónico registrada si ya es miembro de Lovestrong:",
      search_mail_placeholder: "Introducir correo electrónico",
      his_name: "Su nombre:",
      his_email: "Su correo electrónico:",
      her_name: "Su nombre:",
      her_email: "Su correo electrónico:",
      alert_msg: "¿Es esta tu información?",
      cancel_button: "No, esta no es tu informaciónn",
      okay_button: "Sí, esta es nuestra información.",
      register_retreat: "Registrarse Retiro",
      matched_mail:
        "Por favor revisa tu información, puedes editarla y registrarte para el Retiro.",
      not_matched_mail:
        "Ingrese su información en el formulario de registro de retiro a continuación.",
      okay_alert_msg: "Bueno",
      highlighted_text: "(Los campos resaltados en amarillo son obligatorios.)",
      ret_team_selection:
        "Por favor seleccione un participante en retiro o una pareja del equipo.",
      mobile_used: "Este Móvil ya está usado.",
      already_registered:
        "Ya está registrado para este retiro con esta dirección de correo electrónico.",
      mail_already_exist_in_db:
        "Este correo electrónico no existe en la base de datos. Ingrese su información en el formulario a continuación.",
      help: "AYUDA",
      post_a_ticket: "Publicar un ticket",
      first_name: "Nombre de pila",
      last_name: "Apellido",
      message: "Mensaje/Problema",
      enter_captcha: "Introducir captcha",
      enter_your_name: "Ingrese su nombre",
      enter_your_last_name: "Introduce tu apellido",
      enter_your_email: "Introduce tu correo electrónico",
      enter_your_mobile: "Introduce tu número de móvil",
      enter_ticket_subject: "Ingrese el asunto del ticket",
      describe_detail:
        "Asegúrese de explicar su problema, inconveniente o pregunta en detalle…",
      type_captcha_here: "Escribe captcha aquí",
      all_required_fields: "Por favor, rellene todos los campos obligatorios",
      failed_to_create_ticket: "No se pudo crear el ticket",
      subject: "Sujeta",
      invalid_captcha: "Captcha no válido",
      ticket_successfully: "Ticket creado exitosamente",
      cancel: "Cancelar",

      select_category: "Seleccionar categoría",
      ticket_category: "Categoría del ticket",
      retreat_registration: "Inscripción al retiro",
      retreat_financials: "Finanzas del retiro",
      retreat_roster: "Lista del retiro",
      retreat_closure: "Cierre del retiro",
      database_issues: "Problemas de base de datos",
      retreat_reports: "Informes del retiro",
      request_to_feature: "Solicitud de función",
      how_do_i: "¿Cómo puedo...?",
      other: "Otro",
      attachments: "Archivos adjuntos",
      allowed: "(Se permiten JPG, MP4, AVI)",
      selected_files: "Archivos seleccionados",
      invalid_email: "Correo electrónico no válido",
      files_are_invalid: "Estos archivos no son válidos",
      category_reqired: "La categoría es obligatoria",
      three_mb_size: "El tamaño debe ser inferior a 3 MB",
      ten_mb_size: "El tamaño debe ser inferior a 10 MB",
      invalid_type: "(tipo inválido)",
    },
  },
};

i18n
  .use(LanguageDetector)
  .use(initReactI18next)
  .init({
    resources,
    lng: "english",
    fallbackLng: "spanish",
    interpolation: {
      escapeValue: false,
    },
  });

export default i18n;
