module.exports = (sequelize, Sequelize) => {
  const TicketMessageSchema = sequelize.define(
    "ticketMessage",
    {
      helpId: {
        type: Sequelize.INTEGER,
        references: {
          model: "help",
          key: "id",
        },
      },
      message: {
        type: Sequelize.TEXT,
        allowNull: false,
      },
      senderName: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      senderEmail: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      attachments: {
        type: Sequelize.JSON, // store array of file URLs
        allowNull: true,
      },
    },
    {
      timestamps: true,
    }
  );
  return TicketMessageSchema;
};
