// database/models/teamInterest.js
module.exports = (sequelize, DataTypes) => {
  const TeamInterestSchema = sequelize.define("teamInterest", {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    email: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    mobile: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    interestType: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    retreatIds: {
      type: DataTypes.TEXT, // store JSON string of retreat IDs
      allowNull: false,
      get() {
        const rawValue = this.getDataValue("retreatIds");
        return rawValue ? JSON.parse(rawValue) : [];
      },
      set(val) {
        this.setDataValue("retreatIds", JSON.stringify(val));
      },
    },
  });

  return TeamInterestSchema;
};
