module.exports = (sequelize, Sequelize) => {
  const RetreatRoaster = sequelize.define("retreatroaster", {
    retreatId: {
      type: Sequelize.INTEGER,
      references: {
        model: "retreats",
        key: "id",
      },
    },
    coupleId: {
      type: Sequelize.INTEGER,
      references: {
        model: "couples",
        key: "id",
      },
    },
    parishId: {
      type: Sequelize.INTEGER,
      references: {
        model: "parishes",
        key: "id",
      },
    },
    roleId: {
      type: Sequelize.INTEGER,
      references: {
        model: "roles",
        key: "id",
      },
    },
    serviceId: {
      type: Sequelize.INTEGER,
      references: {
        model: "services",
        key: "id",
      },
    },
    talkId: {
      type: Sequelize.INTEGER,
      references: {
        model: "talks",
        key: "id",
      },
    },
    attendeeType: {
      type: Sequelize.ENUM("Team", "Retreatant"),
      defaultValue: "Retreatant",
    },
    roasterImage: {
      type: Sequelize.STRING(1234),
    },
    talk_question: {
      type: Sequelize.TEXT,
    },
    stage: {
      type: Sequelize.ENUM("DRAFT", "VERIFIED"),
      defaultValue: "VERIFIED",
    },
    imageUrl: {
      type: Sequelize.TEXT,
    },
  });
  return RetreatRoaster;
};
