// models/help.js
module.exports = (sequelize, Sequelize) => {
  const helpSchema = sequelize.define(
    "help",
    {
      firstName: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      lastName: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      email: {
        type: Sequelize.STRING,
        allowNull: false,
        validate: {
          isEmail: true,
        },
      },
      mobile: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      subject: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      message: {
        type: Sequelize.TEXT,
        allowNull: false,
      },
      captcha: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      pageName: {
        type: Sequelize.STRING,
        allowNull: false,
      },
      status: {
        type: Sequelize.ENUM("NEW", "INPROGRESS", "CLOSED"),
        defaultValue: "NEW",
      },
      assignedTo: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      category: {
        type: Sequelize.STRING,
        allowNull: true,
      },
      priority: {
        type: Sequelize.ENUM("LOW", "MEDIUM", "HIGH"),
        allowNull: true,
      },
      ticketNumber: {
        type: Sequelize.STRING,
        allowNull: false,
        unique: true, // ✅ only declare unique once
      },
      attachments: {
        type: Sequelize.JSON, // stores array of file URLs
        allowNull: true,
      },
    },
    {
      tableName: "help",
      timestamps: true, // adds createdAt, updatedAt
      indexes: [
        // ✅ don't add duplicate indexes for ticketNumber
        // only keep extra indexes if you really need them (example: email)
        { fields: ["email"] },
      ],
    }
  );

  return helpSchema;
};
