module.exports = (sequelize, Sequelize) => {
  const CoupleSchema = sequelize.define("couple", {
    primaryKey: {
      type: Sequelize.INTEGER,
    },
    hisFirstName: {
      type: Sequelize.STRING,
    },
    hisLastName: {
      type: Sequelize.STRING,
    },
    hisEmail: {
      type: Sequelize.STRING,
    },
    hisMobile: {
      type: Sequelize.STRING,
    },
    herFirstName: {
      type: Sequelize.STRING,
    },
    herLastName: {
      type: Sequelize.STRING,
    },
    herEmail: {
      type: Sequelize.STRING,
    },
    herMobile: {
      type: Sequelize.STRING,
    },
    city: {
      type: Sequelize.STRING,
    },
    state: {
      type: Sequelize.STRING,
    },
    zip: {
      type: Sequelize.STRING,
    },
    notes: {
      type: Sequelize.TEXT,
    },
    parishId: {
      type: Sequelize.INTEGER,
      references: {
        model: "parishes",
        key: "id",
      },
    },
    userRole: {
      type: Sequelize.ENUM("COUPLE", "ADMIN", "SUBADMIN"), //COUPLE, ADMIN
      defaultValue: "COUPLE",
    },
    accountStatus: {
      type: Sequelize.ENUM("ACTIVE", "DIVORCED", "DECEASED", "INACTIVE"), //ACTIVE,'DIVORCED','DECEASED','INACTIVE'
      defaultValue: "ACTIVE",
    },
    isAdminRight: {
      type: Sequelize.BOOLEAN,
      defaultValue: 0,
    },
    imageUrl: {
      type: Sequelize.STRING(1234),
    },
    marriageImageUrl: {
      type: Sequelize.STRING(1234),
    },
    linkverify: {
      type: Sequelize.BOOLEAN,
      defaultValue: 0,
    },
    address: {
      type: Sequelize.STRING(1234),
    },
    allergies: {
      type: Sequelize.STRING,
    },
    anniversary_date: {
      type: Sequelize.DATE,
    },
    hear_us: {
      type: Sequelize.TEXT,
    },
    emergency_name1: {
      type: Sequelize.STRING,
    },
    emergency_relationship1: {
      type: Sequelize.STRING,
    },
    emergency_phone1: {
      type: Sequelize.STRING,
    },
    emergency_name2: {
      type: Sequelize.STRING,
    },
    emergency_relationship2: {
      type: Sequelize.STRING,
    },
    emergency_phone2: {
      type: Sequelize.STRING,
    },
    under_age_35: {
      type: Sequelize.ENUM("NO", "YES"),
      defaultValue: "NO",
    },
    referral_from_a_friend_or_family_member: {
      type: Sequelize.STRING,
    },
    hisProfileImage: {
      type: Sequelize.STRING,
    },
    herProfileImage: {
      type: Sequelize.STRING,
    },
    emailVerified: {
      type: Sequelize.BOOLEAN,
      defaultValue: 0,
    },
    emailVerifyCode: {
      type: Sequelize.STRING(1234),
    },
    otp: {
      type: Sequelize.INTEGER,
    },
    jwtToken: {
      type: Sequelize.STRING(1234),
    },
  });

  return CoupleSchema;
};
