module.exports = (sequelize, Sequelize) => {
  const UserSchema = sequelize.define("user", {
    userName: {
      type: Sequelize.STRING,
    },
    email: {
      type: Sequelize.STRING,
    },
    emailVerified: {
      type: Sequelize.BOOLEAN,
    },
    emailVerifyCode: {
      type: Sequelize.STRING,
    },
    otp: {
      type: Sequelize.INTEGER,
    },
    password: {
      type: Sequelize.STRING(1234),
    },
    userRole: {
      type: Sequelize.ENUM("COUPLE", "SUBADMIN", "ADMIN"),
      defaultValue: "COUPLE",
    },
    accountStatus: {
      type: Sequelize.ENUM("ACTIVE", "BLOCKED", "DELETED"),
      defaultValue: "ACTIVE",
    },
    coupleId: {
      type: Sequelize.INTEGER,
    },
    deleteAccess: {
      type: Sequelize.BOOLEAN,
      defaultValue: 0,
    },

    firstName: {
      type: Sequelize.STRING,
    },
    lastName: {
      type: Sequelize.STRING,
    },
    mobile: {
      type: Sequelize.STRING,
    },
    jwtToken: {
      type: Sequelize.STRING(1234),
    },
    imageUpload: {
      type: Sequelize.STRING(1234),
    },
    isDisabled: {
      type: Sequelize.BOOLEAN,
      defaultValue: 0,
    },
  });
  return UserSchema;
};
