const db = require("../database/dbConnection");
const Parish = require("../database/dbConnection");
const perishSchema = Parish.parish;
const parishCategoriesSchema = db.parishCategories;
const { Op } = require("sequelize");
const { PROJECT_DIR } = require("../../config");
const fs = require("fs");
const path = require("path");

class PerishControler {
  async addPerish(req, res) {
    const STOP_WORDS = [
      "of",
      "and",
      "the",
      "is",
      "a",
      "an",
      "in",
      "to",
      "for",
      "with",
      "by",
    ];

    try {
      console.log(req.body.fromData);
      // Parse the incoming data
      let {
        parish,
        address,
        state,
        city,
        zip,
        imageUrl,
        link,
        forceSave,
        parishCategoryId,
        parishCategory,
      } = JSON.parse(`${req.body.fromData}`);

      // Check for an exact match (case-insensitive)
      let exactMatch = await perishSchema.findOne({
        where: { parish: { [Op.like]: parish } },
      });

      if (exactMatch) {
        return res.status(200).send({
          success: false,
          msg: "This parish already exists with an exact name match.",
        });
      }
      if (parishCategory) {
        var findParishCategory = await parishCategoriesSchema.findOne({
          where: { name: parishCategory },
        });
      }
      // Prepare the user data object to save
      let userDataToUpdate = {
        parish: parish,
        address: address,
        state: state,
        city: city,
        zip: zip,
        link: link,
        parishCategoryId: findParishCategory
          ? findParishCategory.id
          : parishCategoryId,
      };

      if (!forceSave) {
        // Split the input into individual words and filter out stop words
        const parishWords = parish
          .toLowerCase()
          .split(" ")
          .filter((word) => !STOP_WORDS.includes(word))
          .map((word) => `%${word}%`);

        /*const addressWords = address
          .toLowerCase()
          .split(" ")
          .filter((word) => !STOP_WORDS.includes(word))
          .map((word) => `%${word}%`);
        
        const cityWords = city
          .toLowerCase()
          .split(" ")
          .filter((word) => !STOP_WORDS.includes(word))
          .map((word) => `%${word}%`);*/

        // Perform fuzzy search by checking each significant word
        let matchingParishes = await perishSchema.findAll({
          where: {
            [Op.or]: parishWords.map((word) => ({
              parish: { [Op.like]: word },
            })),
          },
        });

        if (matchingParishes.length) {
          return res.status(200).send({
            success: true,
            msg: "Potential matches found. Please review before proceeding.",
            matches: matchingParishes,
          });
        }
      }

      // If no matches or forceSave is true, save the new perish data
      let newPerish = new perishSchema(userDataToUpdate);
      let succ = await newPerish.save();
      console.log("succ--->", succ);

      let result = {
        ...succ.get({ plain: true }),
        parishCategoryName: findParishCategory ? findParishCategory.name : null,
      };
      console.log("result--->", result);

      if (req.files) {
        // Save image if files are uploaded
        let imageSavedCouple = await this.saveLogoOfParish(req.files, succ.id);
      }

      if (succ) {
        return res.status(200).send({
          success: true,
          msg: "New Parish is created.",
          data: result,
        });
      } else {
        return res.status(500).send({
          success: false,
          msg: "Something went wrong. Please try again.",
        });
      }
    } catch (error) {
      return res.status(500).json({
        success: false,
        msg: "An error occurred while processing the request.",
        error: error.message,
      });
    }
  }

  async getAllPerishSearch(req, res) {
    try {
      let query;
      if (req && req.body && req.body.searchFor === "retreat") {
        query = `SELECT parishes.*
        FROM parishes
        LEFT JOIN retreats ON retreats.parishId = parishes.id
        WHERE retreats.parishId IS NOT NULL GROUP BY parishes.id`;
      } else {
        query = `SELECT retreatroasters.*,couples.parishId,parishes.id,parishes.parish
        FROM retreatroasters
        LEFT JOIN couples ON couples.id = retreatroasters.coupleId
        LEFT JOIN parishes ON parishes.id = couples.parishId
        WHERE couples.parishId IS NOT NULL GROUP BY couples.parishId;`;
      }
      let allParishes = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Perish fetched",
        data: allParishes,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async updatePerish(req, res) {
    try {
      let {
        parish,
        address,
        state,
        city,
        zip,
        imageUrl,
        link,
        parishCategoryId,
      } = JSON.parse(`${req.body.fromData}`);
      const existingParish = await perishSchema.findOne({
        where: {
          parish: parish,
          id: { [Op.ne]: req.params.perish_id },
        },
      });

      if (existingParish) {
        return res.status(200).json({
          success: false,
          msg: "This parish already exists. Please choose a different name.",
        });
      }
      let userDataToUpdate = {
        parish,
        address,
        state,
        city,
        zip,
        link,
        parishCategoryId,
      };
      const updated = await perishSchema.update(userDataToUpdate, {
        where: { id: req.params.perish_id },
      });

      let getParish = await perishSchema.findOne({
        where: { id: req.params.perish_id },
        raw: true,
      });
      if (req.files) {
        if (getParish && getParish.imageUrl) {
          const logoPath = path.join(
            PROJECT_DIR,
            "parishLogo",
            path.basename(getParish.imageUrl)
          );

          // Delete logo file if exists
          if (fs.existsSync(logoPath)) {
            fs.unlinkSync(logoPath);
          }
        }
        await this.saveLogoOfParish(req.files, getParish.id);
      } else if (imageUrl === "") {
        if (getParish && getParish.imageUrl) {
          const logoPath = path.join(
            PROJECT_DIR,
            "parishLogo",
            path.basename(getParish.imageUrl)
          );

          // Delete logo file if exists
          if (fs.existsSync(logoPath)) {
            fs.unlinkSync(logoPath);
          }
        }
        await perishSchema.update(
          { imageUrl: "" },
          { where: { id: req.params.perish_id } }
        );
      }
      return res.status(200).send({
        success: true,
        msg: "Record Updated",
        data: updated,
      });
    } catch (err) {
      return res.status(200).json({
        success: false,
        msg: err.message,
      });
    }
  }

  async deletePerish(req, res) {
    try {
      const parishId = req.params.service_id;

      // 1. Get parish details first
      const parishDetail = await perishSchema.findOne({
        where: { id: parishId },
        raw: true,
      });

      if (parishDetail && parishDetail.imageUrl) {
        const logoPath = path.join(
          PROJECT_DIR,
          "parishLogo",
          path.basename(parishDetail.imageUrl)
        );

        // Delete logo file if exists
        if (fs.existsSync(logoPath)) {
          fs.unlinkSync(logoPath);
        }
      }

      // 2. Delete parish record from DB
      const delete_service = await perishSchema.destroy({
        where: { id: parishId },
      });

      return res.status(200).send({
        success: true,
        msg: "Record and parish logo deleted successfully.",
        data: delete_service,
      });
    } catch (err) {
      console.log("error -->", err);
      return res.status(200).json({
        success: false,
        msg: err.message || err,
      });
    }
  }

  async searchKey(req, res) {
    try {
      const key = req.params.key;

      let query = `
      SELECT 
        p.*,
        pc.name AS parishCategoryName,
        (SELECT COUNT(*) 
           FROM retreats r 
           WHERE r.parishId = p.id 
             AND (r.deleteStatus = '' OR r.deleteStatus IS NULL)
        ) AS Retreats_count,
        (SELECT COUNT(*) 
           FROM couples c 
           WHERE c.parishId = p.id
        ) AS couples_count
      FROM 
        parishes p
      LEFT JOIN parishCategories pc 
        ON p.parishCategoryId = pc.id
      WHERE 
        p.parish LIKE :search OR 
        p.city LIKE :search OR 
        p.state LIKE :search OR 
        p.zip LIKE :search OR 
        p.link LIKE :search OR 
        p.address LIKE :search OR
        pc.name LIKE :search
    `;

      const results = await db.sequelize.query(query, {
        replacements: { search: `%${key}%` },
        type: db.Sequelize.QueryTypes.SELECT,
      });

      return res.status(200).send({
        success: true,
        msg: "Search result with counts & category",
        data: results,
      });
    } catch (error) {
      return res.status(500).json({
        success: false,
        msg: error.message,
      });
    }
  }

  async saveLogoOfParish(files, parishId) {
    try {
      let file;
      let fileUrl;
      file = files.file;
      let fileName = file.name;
      fileUrl = PROJECT_DIR + "/parishLogo/" + fileName;
      let imgUrl = process.env.SERVERADDRESS + "/public/parishLogo/" + fileName;
      let result = await perishSchema.update(
        { imageUrl: imgUrl },
        { where: { id: parishId } }
      );
      if (result) {
        file.mv(fileUrl, async function (err) {
          if (err) {
            return false;
          }
          return true;
        });
      }
    } catch (error) {
      return error;
    }
  }
}
module.exports = new PerishControler();
