import { useState } from "react";
import { toast } from "react-toastify";
import RetreatApi from "../api/retreatApi";
import CreatableSelect from "react-select/creatable";
import { Modal, Col, Button } from "react-bootstrap";

function CreateRetreatSubAdmin(props) {
  let retreatApi = new RetreatApi();
  let {
    show,
    alertHeader,
    alerMessage,
    allCoupleMails,
    ediUserIdClicked,
    data,
    handlerAccessRmvShow,
    editRetreat,
    getAllCouples,
    handleClose,
  } = props;
  const [coupleSelectForAccess, setCoupleSelectForAccess] = useState([]);
  const [accessGreenTick, setAccessGreenTick] = useState(false);

  const handleSelectOption = (val) => {
    setCoupleSelectForAccess(val);
  };

  const handleAccessSubmit = async () => {
    if (coupleSelectForAccess && coupleSelectForAccess.length) {
      if (ediUserIdClicked) {
        let submitData = {
          coupleIds: coupleSelectForAccess.map((option) => {
            return {
              label: option.label,
              value: option.value,
              isNew: option.__isNew__ || false,
            };
          }),
          retreatId: ediUserIdClicked,
        };
        setAccessGreenTick(true);
        await retreatApi
          .giveAccesssOfApprove(submitData)
          .then((res) => {
            if (res.success) {
              toast.success(res.msg);
              setCoupleSelectForAccess([]);
              editRetreat(ediUserIdClicked);
              getAllCouples();
              setTimeout(() => {
                setAccessGreenTick(false);
              }, 2000);
            } else {
              toast.error(res.msg);
              setAccessGreenTick(false);
            }
          })
          .catch((error) => {
            toast.error(error);
          });
      } else {
        setCoupleSelectForAccess([]);
        toast.error("Please enter the required fields.");
      }
    } else {
      toast.error("Please select or create at least one sub-admin.");
    }
  };

  return (
    <>
      <Modal
        show={show}
        onHide={handleClose}
        backdrop="static"
        keyboard={false}
        size="xl"
        className="custom-backdrop customSubAdminModal"
      >
        <Modal.Header closeButton>
          <Modal.Title>Add Retreat Sub-Admins</Modal.Title>
        </Modal.Header>

        <Modal.Body>
          <hr className="my-3" />
          <div className="d-flex align-items-start gap-2">
            <CreatableSelect
              className="flex-grow-1"
              id="couple"
              name="couple"
              options={allCoupleMails}
              value={coupleSelectForAccess}
              onChange={handleSelectOption}
              isSearchable
              isMulti
              placeholder="Select Couple"
              menuPlacement="top"
            />

            <div className="d-flex align-items-center">
              {accessGreenTick ? (
                <i
                  className="mdi mdi-check-circle text-success fs-3"
                  style={{ cursor: "default" }}
                ></i>
              ) : (
                <i
                  onClick={handleAccessSubmit}
                  className="mdi mdi-plus-circle text-primary fs-3"
                  style={{ cursor: "pointer" }}
                ></i>
              )}
            </div>
          </div>

          {/* Divider */}
          <hr className="my-3" />
          {/* Selected Couples */}
          {data?.userEmails?.length > 0 ? (
            <div className="selected-couples">
              {data.userEmails.map((item, index) => (
                <div
                  key={index}
                  className="d-flex justify-content-between align-items-center border rounded p-2 mb-2"
                >
                  <span>{item.label}</span>
                  <i
                    className="mdi mdi-delete-forever text-danger fs-4"
                    onClick={() => handlerAccessRmvShow(item.label)}
                    title="Remove Sub-Admin"
                    style={{ cursor: "pointer" }}
                  ></i>
                </div>
              ))}
            </div>
          ) : (
            <p className="text-muted">No couples added yet.</p>
          )}
        </Modal.Body>

        <Modal.Footer>
          <Button variant="secondary" onClick={handleClose}>
            Close
          </Button>
        </Modal.Footer>
      </Modal>
    </>
  );
}

export default CreateRetreatSubAdmin;
