import { useState } from "react";
import Button from "react-bootstrap/Button";
import Modal from "react-bootstrap/Modal";

function ViewMailMsg(props) {
  let { show, alertHeader, alertMessage, handleClose, language } = props;
  return (
    <>
      <Modal
        show={show}
        onHide={handleClose}
        backdrop="static"
        keyboard={false}
        size="xl"
        className="custom-backdrop"
      >
        <Modal.Header closeButton>
          <Modal.Title>{alertHeader}</Modal.Title>
        </Modal.Header>

        <Modal.Body className="mt-3">
          <div>
            <span
              style={{
                display: "block",
                fontFamily: "arial, verdana, sans-serif",
                background: "#f8f9fb",
                paddingTop: "0.5rem",
                border: "7px solid #eee",
                margin: "0.3rem",
                borderRadius: "1rem",
              }}
            >
              <table cellPadding={0} cellSpacing={0} width="100%">
                <tbody>
                  <tr>
                    <td style={{ paddingTop: "10px", textAlign: "center" }}>
                      <img
                        style={{ width: "150px" }}
                        src="https://lovestrong.koolderbyacademy.com/logo.png"
                        alt="Logo"
                      />
                    </td>
                  </tr>
                  <tr>
                    {language === "spanish" ? (
                      <td>
                        <table
                          style={{
                            fontSize: "14px",
                            width: "100%",
                            background: "#fff",
                            borderRadius: 0,
                          }}
                        >
                          <tbody>
                            <tr>
                              <td
                                style={{ padding: "30px", width: "100%" }}
                                valign="top"
                              >
                                <div
                                  style={{
                                    fontSize: "14px",
                                    fontWeight: "normal",
                                    lineHeight: "1.8em",
                                    textAlign: "left",
                                  }}
                                >
                                  Hola <b>Nombre Apellido</b>,
                                  <br />
                                </div>
                                {alertMessage &&
                                alertMessage !== "" &&
                                alertMessage !== null ? (
                                  <div
                                    dangerouslySetInnerHTML={{
                                      __html: alertMessage,
                                    }}
                                  />
                                ) : (
                                  <div style={{ textAlign: "center" }}>
                                    <p>
                                      Gracias por inscribirse en el retiro
                                      matrimonial LOVESTRONG de San Pedro y San
                                      Pablo, programado del 18 al 20 de octubre
                                      de 2024. ¡Nos entusiasma que nos
                                      acompañen!
                                    </p>
                                    <p>
                                      Si tienes alguna pregunta, contáctanos
                                      aquí...
                                    </p>
                                    <p>
                                      <strong>Correo electrónico: </strong>
                                      <a
                                        href="mailto:solizspp.lovestrong@gmail.com"
                                        target="_blank"
                                        rel="noopener noreferrer"
                                        style={{ color: "#1155CC" }}
                                      >
                                        solizspp.lovestrong@gmail.com
                                      </a>
                                    </p>
                                    <p style={{ color: "rgb(34, 34, 34)" }}>
                                      <strong>Jen Soliz</strong>
                                      <br />
                                      210-288-1908
                                    </p>
                                    <p style={{ color: "#222222" }}>
                                      <strong>Phil Soliz</strong>
                                      <br />
                                      210-779-3096
                                    </p>
                                    <p style={{ fontSize: "12px" }}>
                                      Por favor, espere saber de nosotras
                                      pronto!
                                    </p>
                                    <p style={{ fontSize: "12px" }}>
                                      <strong>¡VIVE! ¡AMA! ¡FUERTE!</strong>
                                    </p>
                                  </div>
                                )}
                                <p>
                                  Gracias,
                                  <br />
                                  <span style={{ lineHeight: "1.3" }}>
                                    Atentamente
                                    <br />
                                    Administradora
                                    <br />
                                    Vive ama fuerte
                                    <br />
                                    <b>Amor fuerte</b> Casamiento
                                  </span>
                                </p>
                              </td>
                            </tr>
                          </tbody>
                        </table>

                        <table
                          style={{ margin: "20px auto 10px auto" }}
                          cellPadding={0}
                          cellSpacing={0}
                          border={0}
                        >
                          <tbody>
                            <tr>
                              <td
                                style={{
                                  fontSize: "12px",
                                  fontWeight: "normal",
                                  lineHeight: "normal",
                                  color: "#001737",
                                }}
                              >
                                Copyright © {new Date().getFullYear()}{" "}
                                LoveStrong Marriage. Todos los derechos
                                reservados.
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    ) : (
                      <td>
                        <table
                          style={{
                            fontSize: "14px",
                            width: "100%",
                            background: "#fff",
                            borderRadius: 0,
                          }}
                        >
                          <tbody>
                            <tr>
                              <td
                                style={{ padding: "30px", width: "100%" }}
                                valign="top"
                              >
                                <div
                                  style={{
                                    fontSize: "14px",
                                    fontWeight: "normal",
                                    lineHeight: "1.8em",
                                    textAlign: "left",
                                  }}
                                >
                                  Hello <b>firstName lastName</b>,
                                  <br />
                                </div>
                                {alertMessage &&
                                alertMessage !== "" &&
                                alertMessage !== null ? (
                                  <div
                                    dangerouslySetInnerHTML={{
                                      __html: alertMessage,
                                    }}
                                  />
                                ) : (
                                  <div>
                                    <div>
                                      <div style={{ textAlign: "center" }}>
                                        <p>
                                          Thank you for registering for the Sts.
                                          Peter and Paul LOVESTRONG Marriage
                                          retreat scheduled for October 18-20,
                                          2024. We are excited that you will
                                          join us!
                                        </p>
                                        {/* <p>
                                      <a
                                        href="https://square.link/u/vHBA29pd"
                                        target="_blank"
                                        rel="noopener noreferrer"
                                        alt="Click Here for Payment"
                                      >
                                        Click Here for Payment
                                      </a>
                                    </p> */}
                                        <p>
                                          If you have any questions, please
                                          reach out to us here...
                                        </p>
                                        <p>
                                          <strong>Email: </strong>
                                          <a
                                            href="mailto:solizspp.lovestrong@gmail.com"
                                            target="_blank"
                                            rel="noopener noreferrer"
                                            style={{ color: "#1155CC" }}
                                          >
                                            solizspp.lovestrong@gmail.com
                                          </a>
                                        </p>
                                        <p style={{ color: "rgb(34, 34, 34)" }}>
                                          <strong>Jen Soliz</strong>
                                          <br />
                                          210-288-1908
                                        </p>
                                        <p style={{ color: "#222222" }}>
                                          <strong>Phil Soliz</strong>
                                          <br />
                                          210-779-3096
                                        </p>
                                        <p style={{ fontSize: "12px" }}>
                                          Please expect to hear from us soon!
                                        </p>
                                        <p style={{ fontSize: "12px" }}>
                                          <strong>LIVE! LOVE! STRONG!</strong>
                                        </p>
                                      </div>
                                      ​
                                    </div>
                                  </div>
                                )}

                                <p>
                                  Thank you,
                                  <br />
                                  <span style={{ lineHeight: "1.3" }}>
                                    Best Regards
                                    <br />
                                    Admin
                                    <br />
                                    Live Love Strong
                                    <br />
                                    <b>LoveStrong</b> Marriage
                                  </span>
                                </p>
                              </td>
                            </tr>
                          </tbody>
                        </table>

                        <table
                          style={{ margin: "20px auto 10px auto" }}
                          cellPadding={0}
                          cellSpacing={0}
                          border={0}
                        >
                          <tbody>
                            <tr>
                              <td
                                style={{
                                  fontSize: "12px",
                                  fontWeight: "normal",
                                  lineHeight: "normal",
                                  color: "#001737",
                                }}
                              >
                                Copyright © {new Date().getFullYear()}{" "}
                                LoveStrong Marriage. All rights reserved.
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    )}
                  </tr>
                </tbody>
              </table>
            </span>
          </div>
        </Modal.Body>

        <Modal.Footer>
          <Button variant="secondary" onClick={handleClose}>
            Close
          </Button>
        </Modal.Footer>
      </Modal>
    </>
  );
}

export default ViewMailMsg;
