import React, { useState, useEffect } from "react";
import { Button, Modal } from "react-bootstrap";
import SunEditor from "suneditor-react";
import "suneditor/dist/css/suneditor.min.css";

function AlertModal(props) {
  const {
    show,
    handleClose,
    message,
    actionFunction,
    cancel,
    okay,
    heading,
    showReasonBox = false,
    existingReason = "",
    alertData = {},
    editBox,
  } = props;

  const defaultInactiveHTML = `
    <div class="message-container">
      <h4 style="line-height:27px;">Thanks for your interest in <strong>LOVESTRONG Marriage Retreats</strong>. 
      We are so sorry, but this LOVESTRONG Retreat has exceeded capacity and is no longer accepting registrations.</h4>

      <h4 style="line-height:27px;">We are planning on hosting another LOVESTRONG Retreat at your parish in the near future. 
      Please contact us at <span><a href="mailto:info@LOVESTRONGMarriage.com">info@LOVESTRONGMarriage.com</a></span> 
      and send us your names and email address(es). You will be placed on a <strong>Priority Contact List</strong>, 
      so that we can reach out to you with dates and information once the next 
      <strong>${
        alertData?.parishName
          ? `${alertData.parishName[0].toUpperCase()}${alertData.parishName.slice(
              1
            )}`
          : ""
      } 
      (${
        alertData?.language
          ? `${alertData.language[0].toUpperCase()}${alertData.language.slice(
              1
            )}`
          : ""
      })</strong> 
      LOVESTRONG Retreat has been set for next Fall 2025.</h4>

      <h4 style="line-height:27px;">You can also visit 
      <a href="https://LOVESTRONGMarriage.com" target="_blank">LOVESTRONGMarriage.com</a> 
      to get updates on other future LOVESTRONG Retreats and special events.</h4>

      <h4 style="line-height:27px;">Thank you and God bless.</h4>
      <h4 style="line-height:27px;"><strong>- LOVESTRONG Staff</strong></h4>
    </div>
  `;

  const [reason, setReason] = useState("");

  useEffect(() => {
    // Only set reason on first open or if existingReason changes
    if ((showReasonBox || editBox) && show) {
      setReason((prev) =>
        existingReason && existingReason.trim() !== ""
          ? existingReason
          : prev || defaultInactiveHTML
      );
    } else {
      // Reset reason if modal is closed
      setReason("");
    }
  }, [existingReason, showReasonBox, editBox, show]);

  const handleConfirm = () => {
    if (showReasonBox && (!reason || reason.trim() === "")) {
      alert("Please provide a message before deactivating the retreat.");
      return;
    }
    actionFunction(reason);
  };
  console.log("reason----->", reason);

  return (
    <Modal
      show={show}
      onHide={() => {
        handleClose();
        setReason("");
      }}
      size={`${showReasonBox || editBox ? "lg" : "md"}`}
      centered
    >
      <Modal.Header
        closeButton
        style={heading === "ALERT!!" ? { color: "red" } : { color: "green" }}
      >
        <Modal.Title>{heading}</Modal.Title>
      </Modal.Header>

      <Modal.Body className="newAlert">
        {!editBox ? (
          <div dangerouslySetInnerHTML={{ __html: message }} />
        ) : null}
        {(showReasonBox || editBox) && (
          <div className="mt-3">
            <h6>Reason / Message to Display:</h6>
            <SunEditor
              onChange={(content) => setReason(content)}
              setContents={reason}
              setOptions={{
                height: 300,
                buttonList: [
                  ["undo", "redo"],
                  ["bold", "underline", "italic", "removeFormat"],
                  ["fontColor", "hiliteColor"],
                  ["align", "list", "link"],
                  ["fullScreen", "codeView"],
                ],
              }}
            />
          </div>
        )}
      </Modal.Body>

      <Modal.Footer>
        <Button
          variant="secondary"
          onClick={() => {
            handleClose();
            setReason("");
          }}
        >
          {cancel}
        </Button>
        <Button variant="primary" onClick={handleConfirm}>
          {okay}
        </Button>
      </Modal.Footer>
    </Modal>
  );
}

export default AlertModal;
