import React, { useState } from "react";
import { useRoutes, Navigate } from "react-router-dom";
import Header from "../layout/Header";
import Footer from "../layout/footer";
import SideBar from "../layout/SideBar";
import { UpdateCouple } from "../pages/couple/updateCouple";
import MyProfile from "../pages/admin/MyProfile";
import ParticipatedInRetreats from "../pages/couple/participatedInRetreats";
import { RegistrationRetreat } from "../pages/auth/registrationRetreat";
import RetreatRegistrations from "../pages/admin/retreatRegistrations";
import { Cookies, useCookies } from "react-cookie";
import RetreatRoaster from "../pages/admin/Retreats/RetreatRoaster";
import CreateOuterRetreat from "../pages/auth/CreateOuterRetreat";
import ManageRetreat from "../pages/admin/Retreats/ManageRetreat";
import RetretRoaster from "../pages/admin/Retreats/RetreatRoaster";
import { CreateRetreat } from "../pages/admin/Retreats/CreateRetreat";
import CreateTicket from "../pages/TicketSystem/CreateTicket";
import TicketReply from "../pages/TicketSystem/TicketReply";
import UpcomingRetreats from "../pages/auth/UpcomingRetreats";

const CoupleRouter = ({ logoutUser = null }) => {
  let cookies = new Cookies();
  let userData = cookies.get("LoveStrongUser") || null;

  const commonRotes = [
    { path: "/update-couple", element: <UpdateCouple /> },
    { path: "/my-profile", element: <MyProfile /> },
    { path: "/participated-in-retreats", element: <ParticipatedInRetreats /> },
    { path: "/registration-retreat/:id", element: <RegistrationRetreat /> },
    { path: "/registration-retreat", element: <RegistrationRetreat /> },
    { path: "/register-new-retreat", element: <CreateOuterRetreat /> },
    { path: "/create-ticket", element: <CreateTicket /> },
    { path: "/ticketReply/:id", element: <TicketReply /> },
    { path: "/upcoming-retreats", element: <UpcomingRetreats /> },
  ];
  if (userData && userData.access === true) {
    commonRotes.push({
      path: "/retreat-registrations",
      element: <RetreatRegistrations />,
    });
    commonRotes.push({
      path: "/retreatRoster",
      element: <RetreatRoaster />,
    });

    commonRotes.push({
      path: "/register-new-retreat",
      element: <CreateOuterRetreat />,
    });
  }

  if (userData && userData.committeeMember === true) {
    commonRotes.push({
      path: "/manageRetreat",
      element: <ManageRetreat />,
    });
    commonRotes.push({
      path: "/retreatRoster",
      element: <RetreatRoaster />,
    });
    commonRotes.push({
      path: "/create-retreat",
      element: <CreateRetreat />,
    });

    commonRotes.push({
      path: "/create-retreat/:id",
      element: <CreateRetreat />,
    });

    commonRotes.push({
      path: "/register-new-retreat",
      element: <CreateOuterRetreat />,
    });
  }

  if (userData && userData.coupleId === null) {
    commonRotes.push({
      path: "/*",
      element: <Navigate to="/retreat-registrations" />,
    });
    commonRotes.push({
      path: "/register-new-retreat",
      element: <CreateOuterRetreat />,
    });
  } else {
    commonRotes.push({ path: "/*", element: <Navigate to="/update-couple" /> });
    commonRotes.push({
      path: "/register-new-retreat",
      element: <CreateOuterRetreat />,
    });
  }
  const route = useRoutes(commonRotes);

  const [active, setActive] = useState("");
  const RightNav = () => {
    if (active === "active") {
      setActive("");
    } else {
      setActive("active");
    }
  };
  const [LeftPanel, setLeftPanel] = useState("");
  const LeftNav = () => {
    if (LeftPanel === "sidebar-icon-only") {
      setLeftPanel("");
    } else {
      setLeftPanel("sidebar-icon-only");
    }
  };

  let pathName = route;
  if (
    pathName.props.match.route.path === "/registration-retreat/:id" ||
    pathName.props.match.route.path === "/register-new-retreat" ||
    pathName.props.match.route.path === "/create-ticket" ||
    pathName.props.match.route.path === "/ticketReply/:id" ||
    pathName.props.match.route.path === "/upcoming-retreats"
  ) {
    return <>{route}</>;
  }
  return (
    <div className={`${LeftPanel}`}>
      <div className="container-scroller" id="container-scroller">
        <Header logoutUser={logoutUser} RightNav={RightNav} LeftNav={LeftNav} />
        <div className="container-fluid page-body-wrapper">
          <SideBar active={active} RightNav={RightNav} />
          <div className="main-panel">
            <div className="content-wrapper retreats">{route}</div>
            <Footer />
          </div>
        </div>
      </div>
    </div>
  );
};

export default CoupleRouter;
