const controller = require("../controllers/RetreatController");
const Router = require("express").Router;
const router = new Router();

// Retreat
router
  .route("/createRetreat")
  .post((...args) => controller.createRetreat(...args));
router
  .route("/getAllRetreats")
  .post((...args) => controller.getAllRetreats(...args));

router
  .route("/getAllRetreatSearch")
  .post((...args) => controller.getAllRetreatSearch(...args));

router
  .route("/getRetreatDetail")
  .post((...args) => controller.getRetreatDetail(...args));
router
  .route("/getRetreatDetailRos")
  .post((...args) => controller.getRetreatDetailRos(...args));
router.route("/editRetreat").post((...args) => controller.editRetreat(...args));
router
  .route("/tempDeleteRetreat")
  .post((...args) => controller.tempDeleteRetreat(...args));
router.route("/search/:key").get((...args) => controller.searchKey(...args));
router
  .route("/searchRetreatsAndCouples")
  .post((...args) => controller.searchRetreatsAndCouples(...args));
router
  .route("/getRetreatLocation")
  .post((...args) => controller.getRetreatLocation(...args));

router
  .route("/autoSaveRetreat")
  .post((...args) => controller.autoSaveRetreat(...args));

router
  .route("/giveAccesssOfApprove")
  .post((...args) => controller.giveAccesssOfApprove(...args));

router
  .route("/removeAccessFromRetreat")
  .post((...args) => controller.removeAccessFromRetreat(...args));

router
  .route("/getAllAccessedRetreats")
  .post((...args) => controller.getAllAccessedRetreats(...args));

router
  .route("/allretreatSubAdmins")
  .post((...args) => controller.allretreatSubAdmins(...args));

router
  .route("/retreatAdminAccess")
  .post((...args) => controller.retreatAdminAccess(...args));

router
  .route("/getAllTempRetreats")
  .post((...args) => controller.getAllTempRetreats(...args));

router
  .route("/deleteTempRetreat")
  .post((...args) => controller.deleteTempRetreat(...args));

router
  .route("/approveRetreat")
  .post((...args) => controller.approveRetreat(...args));

router.route("/uploadFiles").post((...args) => controller.uploadFiles(...args));

router.route("/deleteFile").post((...args) => controller.deleteFile(...args));

router
  .route("/retreat-freeze")
  .post((...args) => controller.retreatFreeze(...args));

router
  .route("/handle-confirmation")
  .post((...args) => controller.handleConfirmation(...args));

router
  .route("/retreat-change-status")
  .post((...args) => controller.retreatChangeStatus(...args));

router
  .route("/retreat-close-Status")
  .post((...args) => controller.retreatCloseStatus(...args));

router
  .route("/get-selected-retreat-data")
  .post((...args) => controller.getSelectedRetreatData(...args));


  router
  .route("/get-all-retreat-data")
  .post((...args) => controller.getAllRetreatData(...args));

  

  router
  .route("/retreat-disabled-sub-admin")
  .post((...args) => controller.retreatDisabledSubAdmin(...args));


module.exports = router;
