const controller = require("../controllers/AuthController.js");
const adminController = require("../controllers/AdminController");
const directoryController = require("../controllers/DirectoryController");
const retreatController = require("../controllers/RetreatController");
const programController = require("../controllers/ProgramController");
const helpController = require("../controllers/HelpController");
const middleware = require("../middleware/middleware");
const Router = require("express").Router;
const router = new Router();

router.route("/login").post((...args) => controller.login(...args));

router
  .route("/changePassword")
  .post((...args) => controller.changePassword(...args));

router.route("/forgetPassword").post((...args) => controller.OtpSend(...args));

router
  .route("/verify-email")
  .post((...args) => controller.emailVerify(...args));

router
  .route("/get-profile")
  .post((...args) => controller.getProfileData(...args));

router.route("/update-profile").post(
  (...args) => middleware(...args),
  (...args) => controller.EditProfile(...args)
);

router.route("/update-password").post(
  (...args) => middleware(...args),
  (...args) => controller.passwordChangeAfterLogin(...args)
);

router
  .route("/getCouplesDetail")
  .post((...args) => adminController.getCouplesDetail(...args));

router
  .route("/editCouple")
  .post((...args) => adminController.editCouple(...args));

router
  .route("/getallperishlist")
  .get((...args) => controller.getAllPerishlist(...args));

router
  .route("/checkPKCouple")
  .post((...args) => controller.checkPKCouple(...args));

router
  .route("/getAllIncommingRetreats")
  .get((...args) => controller.getAllIncommingRetreats(...args));

router
  .route("/getRolesOfRetreats")
  .post((...args) => controller.getRolesOfRetreats(...args));

router
  .route("/registerCoupleForRetrteat")
  .post((...args) => controller.registerCoupleForRetrteat(...args));

router
  .route("/getDirectoryDetail")
  .post((...args) => directoryController.getDirectoryDetail(...args));

router
  .route("/getAllRoastersOfRetreat")
  .post((...args) => directoryController.getAllRoastersOfRetreat(...args));

router
  .route("/getRetreatDetail")
  .post((...args) => retreatController.getRetreatDetail(...args));

router
  .route("/getAllRoastersInfo")
  .post((...args) => programController.getAllRoastersInfo(...args));

router
  .route("/getProgramDetail")
  .post((...args) => programController.getProgramDetail(...args));

router
  .route("/createTempRetreat")
  .post((...args) => controller.createTempRetreat(...args));

router
  .route("/getMissionStatement")
  .get((...args) => controller.getMissionStatement(...args));

router
  .route("/check-mail-in-Db")
  .post((...args) => controller.checkMailInDb(...args));

router
  .route("/category/:categoryId")
  .get((...args) => controller.getParishByCategory(...args));

router.route("/allCouples").get((...args) => controller.allCouples(...args));

router.route("/outerUsers").get((...args) => controller.outerUsers(...args));

router
  .route("/create-ticket")
  .post((...args) => helpController.createTicket(...args));

router
  .route("/get-ticket-by-id")
  .post((...args) => helpController.getTicketById(...args));

router
  .route("/get-ticket-messages")
  .post((...args) => helpController.getTicketMessages(...args));

router
  .route("/add-ticket-message")
  .post((...args) => helpController.addTicketMessage(...args));

router
  .route("/submit-team-interest")
  .post((...args) => controller.submitTeamInterest(...args));

module.exports = router;
