import React, { useState, useEffect, useContext } from "react";
import { toast } from "react-toastify";
import { Form, Button, Row } from "react-bootstrap";
import AuthApi from "../../api/authApi";
import { useCookies } from "react-cookie";
import AdminApi from "../../api/admin";

const ProfileDetails = ({ userProfileData = {} }) => {
  let api = new AuthApi();
  let adminApi = new AdminApi();
  const [Updateprofile, SetUpdateprofile] = useState({
    email: "",
  });
  const [validated, setValidated] = useState(false);
  const [cookies, setCookie] = useCookies(["LoveStrongUser"]);
  const [oneClick, setOneClick] = useState(true);
  const [oldData, setOldData] = useState([]);
  const [oldValues, setOldValues] = useState([]);

  useEffect(() => {
    setSectionData();
  }, [userProfileData]);

  const setSectionData = () => {
    if (userProfileData) {
      SetUpdateprofile(userProfileData);
      setOldValues(userProfileData);
    }
  };

  const handleChanges = (e) => {
    setOneClick(true);
    let { name, value } = e.target;
    let d = { ...Updateprofile };
    let o = { ...oldData };
    if (name === "email") {
      o.email = oldValues.email;
    }
    setOldData(o);

    d[name] = value;
    SetUpdateprofile(d);
  };
  const handleSubmit = async (event) => {
    setOneClick(false);
    const form = event.currentTarget;
    event.preventDefault();
    event.stopPropagation();
    if (form.checkValidity()) {
      await api
        .EditProfile(Updateprofile)
        .then((res) => {
          if (res.success) {
            setValidated(true);
            SetUpdateprofile(res.data);
            if (res.data) {
              if (
                oldData.email ||
                (oldData.email == "" && oldData.email != res.data.email)
              ) {
                let report = {
                  byWhom:
                    `${
                      cookies.LoveStrongUser && cookies.LoveStrongUser.firstName
                        ? cookies.LoveStrongUser.firstName
                        : null
                    } ` +
                    `${
                      cookies.LoveStrongUser && cookies.LoveStrongUser.lastName
                        ? cookies.LoveStrongUser.lastName
                        : null
                    }` +
                    ` (${
                      cookies.LoveStrongUser && cookies.LoveStrongUser.userRole
                        ? cookies.LoveStrongUser.userRole
                        : null
                    })`,
                  pagelink: window.location.href,
                  description:
                    "Updated Email in  Profile Details" +
                    ` From "${oldData.email ? oldData.email : "Nil"}" to "${
                      res.data.email ? res.data.email : "Nil"
                    }"`,
                  action: "Click",
                };
                adminApi
                  .addLogReport(report)
                  .then((response) => {
                    if (response.success) {
                      console.log("Created new log report.");
                    }
                  })
                  .catch((error) => {
                    console.log(error);
                  });
              }
              setCookie("LoveStrongUser", res.data, {
                path: "/",
                maxAge: 60 * 60 * 100,
                expires: new Date(Date.now() + 60 * 60 * 100),
              });
            }
            setOneClick(false);
            toast.success(res.msg);
          } else {
            toast.error(res.msg);
          }
        })
        .catch((error) => {
          toast.error(error);
          setOneClick(false);
        });
    }
  };

  return (
    <div className="media1">
      <div className="media-body">
        <h4 className="card-title">Profile Details</h4>
        <Form
          className="forms-sample"
          onSubmit={handleSubmit}
          noValidate
          validated={validated}
        >
          <Row>
            <div className="col-md-8 col-sm-12">
              <Form.Group className="form-group">
                <Form.Label>Email</Form.Label>
                <Form.Group className="input-group">
                  <Form.Control
                    required
                    type="email"
                    name="email"
                    className="form-control form-control-sm border-left-0"
                    placeholder="Enter Your Email"
                    value={Updateprofile.email}
                    onChange={(e) => handleChanges(e)}
                  />
                  <Form.Control.Feedback type="invalid">
                    Email is Required !
                  </Form.Control.Feedback>
                </Form.Group>
              </Form.Group>
            </div>
          </Row>
          <div className="profile-btn">
            <Button type="submit" className="btn btn-primary me-2">
              {" "}
              Update Profile
            </Button>
          </div>
        </Form>
      </div>
    </div>
  );
};
export default ProfileDetails;
