import React, { useState, useEffect, useContext } from "react";
import { Form, Button, Row, Col, Modal, Tabs, Tab } from "react-bootstrap";
import { toast } from "react-toastify";
import Select from "react-select";
import AdminApi from "../../api/admin";
import AuthApi from "../../api/authApi";

import DeleteModel from "../../components/DeleteModel";
import AlertModal from "../../components/AlertModel";
import RetreatApi from "../../api/retreatApi";
import CommitteeApi from "../../api/committeeApi";
import { Cookies, useCookies } from "react-cookie";
import moment from "moment";


// Custom MultiValueRemove component to hide "x"
const CustomMultiValueRemove = (props) => null;


const AdminDashboard = () => {
  const [show, setShow] = useState(false);
  const [mailId, setMailId] = useState([]);
  const [removeId, setRemoveId] = useState([]);
  const [allcouple, setAllcouple] = useState([]);
  const [allAdminList, setAllAdminList] = useState([]);
  const [allSubAdminList, setAllSubAdminList] = useState([]);
  const [showAccessAlert, setShowAccessAlert] = useState(false);
  const [coupleSelectAdmin, setCoupleSelectAdmin] = useState([]);
  const [removeAccessShow, setRemoveAccessShow] = useState(false);
  const [retAdminAccessAlert, setRetAdminAccessAlert] = useState(false);
  const [coupleSelectSubAdmin, setCoupleSelectSubAdmin] = useState([]);
  const [allRetreatSubAdminList, setAllRetreatSubAdminList] = useState([]);
  const [showMailAlert, setShowMailAlert] = useState(false);
  const [myRoleIs, setMyRoleIs] = useState(null);
  const [showRegModal, setShowREgModal] = useState(false);
  const [validated, setValidated] = useState(false);
  const [retreatOptions, setRetreatOptions] = useState([]);
  const [selectedRetreats, setSelectedRetreats] = useState([]);
  const [loadData, setLoadData] = useState(false);
  const [allCommittee, setAllCommittee] = useState([]);
  const [deleteMember, setDeleteMember] = useState(false);
  const [alert, setAlert] = useState(false);
  const [member, setMember] = useState("");
  const [show5, setShow5] = useState(false);
  const [parishList, setParishList] = useState([]);
  const [allRetreats, setAllRetreats] = useState([]);
  const [selecterdCommittee, setSelecterdCommittee] = useState("");
  const [selectUserCheck, setSelectUserCheck] = useState(false);
  const [selectedEditRetreats, setSelectedEditRetreats] = useState([]);
  const [openModalFor, setOpenModalFor] = useState("");

  const [data, setData] = useState({
    id: "",
    parishId: null,
    retreats: [],
    userId: [],
  });

  let committeeApi = new CommitteeApi();
  let adminApi = new AdminApi();
  let retreatApi = new RetreatApi();
  let authApi = new AuthApi();
  let cookies = new Cookies();
  let userData = cookies.get("LoveStrongUser") || null;
  const [cookie, setCookie] = useCookies(["LoveStrongUser"]);

  useEffect(() => {
    getAllCouples();
    adminsAndSubAdmins();
    getAllretreatSubAdmins();
    allCommitteMembers();
    getAllRetreats();
    getParishList();
  }, []);

  const adminsAndSubAdmins = async () => {
    await adminApi
      .geAdminsAndSubAdmins()
      .then(async (res) => {
        if (res.success) {
          if (res.admins) {
            setAllAdminList(res.admins);
          }
          if (res.subAdmins) {
            setAllSubAdminList(res.subAdmins);
          }
        } else {
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const getAllretreatSubAdmins = async () => {
    await retreatApi
      .allretreatSubAdmins()
      .then(async (res) => {
        if (res.success) {
          setAllRetreatSubAdminList(res.data);
        } else {
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const getAllCouples = async () => {
    await adminApi
      .allCouples()
      .then(async (res) => {
        if (res.success) {
          let Allcouple = [];
          res.data &&
            res.data.forEach((item) => {
              if (item.hisEmail) {
                Allcouple.push({
                  label: `${item.hisFirstName} ${item.hisLastName} (${item.hisEmail})`,
                  value: item.hisEmail,
                });
              }
              if (item.herEmail) {
                Allcouple.push({
                  label: `${item.herFirstName} ${item.herLastName} (${item.herEmail})`,
                  value: item.herEmail,
                });
              }
            });
          setAllcouple(Allcouple);
        } else {
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const handleSelectOption = (val, selection) => {
    if (selection === "forAdmins") {
      setCoupleSelectAdmin(val);
    } else {
      setCoupleSelectSubAdmin(val);
    }
  };

  const handleSelectSubmit = async () => {
    let submitData = null;
    if (coupleSelectAdmin && Object.keys(coupleSelectAdmin).length > 0) {
      submitData = {
        role: "ADMIN",
        email: coupleSelectAdmin.value,
      };
    }
    if (coupleSelectSubAdmin && Object.keys(coupleSelectSubAdmin).length > 0) {
      submitData = {
        role: "SUBADMIN",
        email: coupleSelectSubAdmin.value,
      };
    }
    if (submitData) {
      try {
        const res = await adminApi.updateUserRole(submitData);
        if (res.success) {
          setCoupleSelectSubAdmin([]);
          setCoupleSelectAdmin([]);
          toast.success(res.msg);
          adminsAndSubAdmins();
        } else {
          toast.error(res.msg);
        }
      } catch (error) {
        toast.error(error);
      }
    } else {
      toast.error("No valid data to submit.");
    }
  };

  const handleShow = (i, check) => {
    setRemoveId(i);
    setShow(true);
    setMyRoleIs(check);
  };

  const handleClose = () => {
    setShow(false);
  };

  const handleShowOfAccess = (retreatData, removed_mail) => {
    setRemoveId(retreatData);
    setMailId(removed_mail);
    setRemoveAccessShow(true);
  };

  const handleCloseOfAccess = () => {
    setRemoveAccessShow(false);
  };

  const removeRole = () => {
    adminApi
      .removeUserRole({
        removeId: removeId.id,
      })
      .then((res) => {
        adminsAndSubAdmins();
        toast.success(res.msg);
        setRemoveId([]);
        handleClose();
      })
      .catch((error) => {
        console.error(error);
        toast.error(error);
      });
  };

  const removeAccessFromRetreat = () => {
    // Combine array elements into a single object
    retreatApi
      .removeAccessFromRetreat({
        remove_access_mail: mailId,
        retreatId: removeId.id,
      })
      .then((res) => {
        // Check if response has a message
        if (res.msg) {
          toast.success(res.msg);
        } else {
          toast.success("Access removed successfully");
        }
        getAllretreatSubAdmins();
        setMailId([]);
        handleCloseOfAccess();
      })
      .catch((error) => {
        console.error(error);
        toast.error("An error occurred while removing access");
      });
  };

  const handleShowAlert = (event, item) => {
    let { name, value } = event.target;
    setRemoveId(item);
    setShowAccessAlert(true);
  };

  const handleCloseAlert = () => {
    setShowAccessAlert(false);
  };

  const adminAccess = () => {
    adminApi
      .changeAdminAccess({
        id: removeId.id,
        isDisabled: removeId.isDisabled,
      })
      .then((res) => {
        adminsAndSubAdmins();
        toast.success(res.msg);
        setRemoveId([]);
        handleCloseAlert();
      })
      .catch((error) => {
        console.error(error);
        toast.error(error);
      });
  };

  const showRetreatAdminAlert = (retreat, UserData) => {
    setRemoveId(UserData);
    setMailId(retreat.id);
    setRetAdminAccessAlert(true);
  };

  const closeretAdminAlert = () => {
    setRetAdminAccessAlert(false);
  };

  const sendLoginDetail = () => {
    adminApi
      .sendLoginDetail({ myData: removeId, myRole: myRoleIs })
      .then((res) => {
        if (res.success) {
          toast.success(res.msg);
          handleClose2();
        } else {
          toast.error(res.msg);
          handleClose2();
        }
      })
      .catch((error) => {
        console.error(error);
        toast.error(error);
        handleClose2();
      });
  };

  const retreatAdminAccess = () => {
    retreatApi
      .retreatAdminAccess({
        userId: removeId.id,
        retreatId: mailId,
        checkAccess: removeId.isDisabled,
      })
      .then((res) => {
        getAllretreatSubAdmins();
        toast.success(res.msg);
        setRemoveId([]);
        setMailId([]);
        closeretAdminAlert();
      })
      .catch((error) => {
        console.error(error);
        toast.error(error);
      });
  };

  const handleShow2 = (item, check) => {
    setMyRoleIs(check);
    setShowMailAlert(true);
    setRemoveId(item);
  };

  const handleClose2 = () => {
    setShowMailAlert(false);
    setRemoveId([]);
    setMyRoleIs(null);
  };

  const getAllRetreats = async () => {
    try {
      const response = await retreatApi.getAllRetreatSearch();
      const sortedList = response.data.sort((a, b) =>
        a.title.localeCompare(b.title)
      );
      setAllRetreats(sortedList);
      let retreatList = sortedList.map((item) => ({
        label: item.title
          ? `${item?.parishName || ""}${
              item.language
                ? ` (${item.language[0].toUpperCase()}${item.language.slice(
                    1
                  )})`
                : ""
            } ${
              item.location
                ? `${item.location[0].toUpperCase()}${item.location.slice(1)} `
                : ""
            } ${
              moment(item.dateFrom).format("MMM DD") +
              " - " +
              moment(item.dateTo).format("MMM DD") +
              ", " +
              moment(item.dateFrom).format("YYYY")
            }`
          : "",
        value: item.id,
        dateFrom: moment(item.dateFrom),
        disabled: false,
        parishId: item.parishId,
      }));
      setRetreatOptions(retreatList);
    } catch (error) {
      toast.error(error.toString());
    }
  };

  const clearfield = () => {
    setData({
      id: "",
      parishId: null,
      retreats: [],
      userId: [],
    });
    setSelecterdCommittee("");
    setSelectedRetreats([]);
    setValidated(false);
    setSelectedEditRetreats([]);
    getAllRetreats();
    setOpenModalFor("");
  };

  const handleSelectRetreat = (selectedOptions) => {
    if (data.parishId && data.parishId !== null) {
      const validOptions = selectedOptions.filter((option) =>
        retreatOptions.some((ro) => ro.value === option.value)
      );

      setSelectedRetreats(validOptions);
      const newRetreats = validOptions.map((option) => ({
        retreatId: option.value,
        disabled: option.disabled,
      }));
      const editRetreats = (selectedEditRetreats || []).map((option) => ({
        retreatId: option.value,
        disabled: option.disabled,
      }));
      const mergedRetreatsMap = new Map();
      [...editRetreats, ...newRetreats].forEach((r) => {
        mergedRetreatsMap.set(r.retreatId, r);
      });
      const mergedRetreats = Array.from(mergedRetreatsMap.values());
      setData((prev) => ({
        ...prev,
        retreats: mergedRetreats,
      }));
    } else {
      toast.error("Please select a parish first.");
    }
  };

  const handleSelectUserId = (val) => {
    setSelecterdCommittee(val);
    let a = data;
    a.userId = val;
    setData(a);
  };

  const handleChanges = (e) => {
    let { name, value } = e.target;

    if (name === "parishId") {
      const filteredList = allRetreats.filter((item) => item.parishId == value);
      const selectedIds = selectedEditRetreats.map((r) => r.value);

      let retreatList = filteredList
        .filter((item) => !selectedIds.includes(item.id))
        .map((item) => ({
          label: item.title
            ? `${item?.parishName || ""}${
                item.language
                  ? ` (${item.language[0].toUpperCase()}${item.language.slice(
                      1
                    )})`
                  : ""
              } ${
                item.location
                  ? `${item.location[0].toUpperCase()}${item.location.slice(
                      1
                    )} `
                  : ""
              } ${
                moment(item.dateFrom).format("MMM DD") +
                " - " +
                moment(item.dateTo).format("MMM DD") +
                ", " +
                moment(item.dateFrom).format("YYYY")
              }`
            : "",
          value: item.id,
          dateFrom: moment(item.dateFrom),
          disabled: false,
          parishId: item.parishId,
        }));
      setRetreatOptions(retreatList);
      setSelectedRetreats(retreatList);
      const validOptions = retreatList.filter((option) =>
        retreatList.some((ro) => ro.value === option.value)
      );

      const newRetreats = validOptions.map((option) => ({
        retreatId: option.value,
        disabled: option.disabled,
      }));

      const editRetreats = (selectedEditRetreats || []).map((option) => ({
        retreatId: option.value,
        disabled: option.disabled,
      }));

      const mergedRetreatsMap = new Map();
      [...editRetreats, ...newRetreats].forEach((r) => {
        mergedRetreatsMap.set(r.retreatId, r);
      });
      const mergedRetreats = Array.from(mergedRetreatsMap.values());
      setData((prev) => ({
        ...prev,
        retreats: mergedRetreats,
        parishId: value,
      }));

      return;
    }
    setData((prev) => ({
      ...prev,
      [name]: value,
    }));
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    e.stopPropagation();
    const form = e.currentTarget;
    if (form.checkValidity()) {
      try {
        let data1 = new FormData();
        let stateRef = { ...data };
        data1.append("fromData", JSON.stringify(stateRef));
        if (openModalFor === "NewSteeringMember") {
          committeeApi
            .newSteeringMember(data1)
            .then(async (res) => {
              if (res.success) {
                toast.success(res.msg);
                clearfield();
                setShowREgModal(false);
                allCommitteMembers();
              } else {
                toast.error(res.msg);
              }
            })
            .catch((error) => {
              console.log(error);
            });
        } else {
          committeeApi
            .createCommitteeMember(data1)
            .then(async (res) => {
              if (res.success) {
                userData.committeeMember = true;
                setCookie("LoveStrongUser", userData, {
                  path: "/",
                  maxAge: 60 * 60 * 100,
                  expires: new Date(Date.now() + 60 * 60 * 100),
                });
                if (data.id) {
                  let report = {
                    byWhom:
                      `${
                        userData && userData.userName ? userData.userName : null
                      } ` +
                      ` (${
                        userData && userData.userRole ? userData.userRole : null
                      })`,
                    pagelink: window.location.href,
                    description:
                      `Edited the committee member` +
                      ` (${data && data.firstName ? `${data.firstName}` : ""}` +
                      `${data && data.lastName ? ` ${data.lastName}` : ""})`,
                    action: "Edit",
                  };
                  await adminApi
                    .addLogReport(report)
                    .then((response) => {
                      if (response.success) {
                        console.log("Created new log report.");
                      }
                    })
                    .catch((error) => {
                      console.log(error);
                    });
                } else {
                  let report = {
                    byWhom:
                      `${
                        userData && userData.userName ? userData.userName : null
                      } ` +
                      ` (${
                        userData && userData.userRole ? userData.userRole : null
                      })`,
                    pagelink: window.location.href,
                    description:
                      `Added new committee member` +
                      ` (${data && data.firstName ? `${data.firstName}` : ""}` +
                      `${data && data.lastName ? ` ${data.lastName}` : ""})`,
                    action: "Add",
                  };
                  await adminApi
                    .addLogReport(report)
                    .then((response) => {
                      if (response.success) {
                        console.log("Created new log report.");
                      }
                    })
                    .catch((error) => {
                      console.log(error);
                    });
                }

                toast.success(res.msg);
                clearfield();
                setShowREgModal(false);
                allCommitteMembers();
              } else {
                toast.error(res.msg);
              }
            })
            .catch((error) => {
              console.log(error);
            });
        }
      } catch (err) {
        toast.error("Error submitting data.");
      }
    }
    setValidated(true);
  };

  const allCommitteMembers = async () => {
    setLoadData(true);
    await committeeApi
      .getAllCommitteMembers()
      .then((res) => {
        if (res.success) {
          setLoadData(false);
          setAllCommittee(res.data);
        } else {
          setLoadData(false);
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        setLoadData(false);
        toast.error(error);
      });
  };

  const deleteMemberPopUpOpen = (userData, parishData) => {
    setDeleteMember(true);
    setMember({ userData: userData, parishData: parishData });
  };

  const deleteMemberPopUpClose = () => setDeleteMember(false);

  const deleteMemberFun = async () => {
    await committeeApi
      .deleteMember({
        userId: member?.userData?.userId,
        parishId: member?.parishData?.parishId,
      })
      .then(async (res) => {
        if (res.success) {
          allCommitteMembers();
          setShow(false);
          setMember("");
          deleteMemberPopUpClose();
          toast.success(res.msg);
          let report = {
            byWhom:
              `${userData && userData.userName ? userData.userName : null} ` +
              ` (${userData && userData.userRole ? userData.userRole : null})`,
            pagelink: window.location.href,
            description:
              `Deleted Committee member` +
              ` (${member && member.firstName ? `${member.firstName}` : ""}` +
              `${member && member.lastName ? ` ${member.lastName}` : ""})`,
            action: "Delete",
          };
          await adminApi
            .addLogReport(report)
            .then((response) => {
              if (response.success) {
                console.log("Created new log report.");
              }
            })
            .catch((error) => {
              console.log(error);
            });
        } else {
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const handleShow3 = (retreat, parishdata) => {
    setMember({ retreat: retreat, parishId: parishdata.parishId });
    setAlert(true);
  };

  const handleClose3 = () => {
    setAlert(false);
    setMember("");
  };

  const getParishList = async () => {
    setLoadData(true);
    await authApi
      .getPerishList()
      .then((response) => {
        const sortedList = response.data.sort((a, b) =>
          a.parish.localeCompare(b.parish)
        );
        setParishList(sortedList);
      })
      .catch((error) => {
        toast.error(error.toString());
      });
  };

  const retreatDisabledForMem = async () => {
    await committeeApi
      .retreatDisabledForMem(member)
      .then(async (res) => {
        if (res.success) {
          allCommitteMembers();
          handleClose3();
          toast.success(res.msg);
          let report = {
            byWhom:
              `${userData && userData.userName ? userData.userName : null} ` +
              ` (${userData && userData.userRole ? userData.userRole : null})`,
            pagelink: window.location.href,
            description:
              `${
                member?.retreat?.disabled === false ? "Disabled" : "Enabled"
              } the retreat (${
                member?.retreat?.retreatTitle
              }) for the committee member` +
              ` (${
                res.data && res.data.firstName ? `${res.data.firstName}` : ""
              }` +
              `${
                res.data && res.data.lastName ? ` ${res.data.lastName}` : ""
              })`,
            action: "Access",
          };
          await adminApi
            .addLogReport(report)
            .then((response) => {
              if (response.success) {
                console.log("Created new log report.");
              }
            })
            .catch((error) => {
              console.log(error);
            });
        } else {
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const handleshow5 = (parishData) => {
    setMember(parishData);
    setShow5(true);
  };

  const handleClose5 = () => {
    setShow5(false);
    setMember("");
  };

  const deleteParishMembers = async () => {
    await committeeApi
      .deleteParishMembers({ parishId: member.parishId })
      .then(async (res) => {
        if (res.success) {
          allCommitteMembers();
          handleClose5();
          toast.success(res.msg);
          let report = {
            byWhom:
              `${userData && userData.userName ? userData.userName : null} ` +
              ` (${userData && userData.userRole ? userData.userRole : null})`,
            pagelink: window.location.href,
            description: `Deleted the Parish (${member?.parishName}) committee members`,
            action: "Delete",
          };
          await adminApi
            .addLogReport(report)
            .then((response) => {
              if (response.success) {
                console.log("Created new log report.");
              }
            })
            .catch((error) => {
              console.log(error);
            });
        } else {
          toast.error(res.msg);
        }
      })
      .catch((error) => {
        toast.error(error);
      });
  };

  const filterParishesWithRetreats = () => {
    const retreatParishIds = retreatOptions.map((retreat) => retreat.parishId);
    const filteredParishList = parishList.filter((parish) =>
      retreatParishIds.includes(parish.id)
    );
    setParishList(filteredParishList);
  };

  const createNewSteeringMember = (parishdata) => {
    setOpenModalFor("NewSteeringMember");
    setShowREgModal(true);
    setSelectUserCheck(false);
    setData({
      retreats: parishdata.retreatIds,
      parishId: parishdata.parishId,
    });
  };

  return (
    <div className="settings">
      <div className="card shadow-lg border-0 rounded-4">
        <div className="card-body">
          {/* Dashboard Heading */}
          <h2 className="card-title mb-4 text-primary fw-bold">
            <i className="mdi mdi-view-dashboard-outline me-2"></i> Admin
            Dashboard
          </h2>

          <Tabs
            defaultActiveKey="steeringCommittee"
            id="justify-tab-example"
            className="mb-4 admin-tabs fw-semibold"
            justify
          >
            {/* ================= Steering Committee ================= */}
            <Tab
              eventKey="steeringCommittee"
              title={
                <span className="bold ">
                  <i className="mdi mdi-account-group-outline me-2"></i>{" "}
                  Steering Committee
                </span>
              }
            >
              <Row className="justify-content-center mt-4">
                <Col lg={10} md={10} sm={12}>
                  {/* Header + Add Button */}
                  <div className="d-flex justify-content-between align-items-center mb-4">
                    <h4 className="m-0 fw-bold text-secondary">
                      Steering Committee
                    </h4>
                    <Button
                      className="btn btn-primary btn-sm shadow-sm d-flex align-items-center gap-2"
                      onClick={() => {
                        setShowREgModal(true);
                        clearfield();
                        setSelectUserCheck(false);
                        filterParishesWithRetreats();
                      }}
                    >
                      <i className="mdi mdi-plus-circle fs-5"></i> Add Steering
                      Committee
                    </Button>
                  </div>

                  {allCommittee && Object.keys(allCommittee).length > 0 ? (
  Object.entries(allCommittee).map(([parishName, parishData], parishIdx) => (
    <div
      key={parishIdx}
      className="committee-parish border rounded-3 mb-4 shadow-sm"
    >
      {/* Parish Header */}
      <div className="d-flex justify-content-between align-items-center px-3 py-2">
        <div className="d-flex align-items-center gap-3">
          <h5 className="mb-0 fw-bold">
            <span className="badge bg-primary rounded-pill px-3 py-2 fs-6">
              <i className="mdi mdi-church me-2"></i>
              {parishData.parishName}
            </span>
          </h5>

          {/* Add Member Button (minimal style) */}
          <button
            className="btn btn-link text-decoration-none text-primary p-0 d-flex align-items-center gap-1"
            onClick={() => createNewSteeringMember(parishData)}
            title="Add Member"
          >
            <i className="mdi mdi-plus-circle-outline fs-5"></i>
            <span className="d-none d-sm-inline">Add Member</span>
          </button>
        </div>

        {/* Delete Parish Icon */}
        <i
          className="mdi mdi-delete-forever text-danger fs-4 cursor-pointer"
          style={{ transition: "0.3s ease-in-out" }}
          onClick={() => handleshow5(parishData)}
          title="Delete Parish Steering Members"
          onMouseEnter={(e) =>
            (e.currentTarget.style.transform = "scale(1.2)")
          }
          onMouseLeave={(e) =>
            (e.currentTarget.style.transform = "scale(1)")
          }
        ></i>
      </div>

      {/* Committee Members List */}
      {parishData.users.length > 0 ? (
        <ul className="list-group list-group-flush">
          {parishData.users.map((user, idx) => (
            <li
              key={idx}
              className="list-group-item d-flex justify-content-between align-items-center"
            >
              <div>
                <h6 className="fw-bold mb-1">
                  {user.firstName} {user.lastName}
                </h6>
                <small className="text-muted fs-6">
                  <i className="mdi mdi-email-outline me-1"></i>
                  {user.email || "N/A"}
                  <span className="mx-2">|</span>
                  <i className="mdi mdi-key-variant me-1"></i>
                  {user.password || "N/A"}
                </small>
              </div>
              <div className="d-flex gap-3">
                <i
                  className="mdi mdi-account-card-details text-primary fs-5 cursor-pointer"
                  title="Send Login Details"
                  onClick={() => handleShow2(user, "Committee Member")}
                ></i>
                <i
                  className="mdi mdi-close-circle text-danger fs-5 cursor-pointer"
                  title="Remove Member"
                  onClick={() => deleteMemberPopUpOpen(user, parishData)}
                ></i>
              </div>
            </li>
          ))}
        </ul>
      ) : (
        <div className="p-3 text-center text-muted">
          No members added yet.
        </div>
      )}
    </div>
  ))
) : (
  <div className="alert alert-light text-center mt-4 shadow-sm">
    <i className="mdi mdi-information-outline me-2"></i>
    No Steering Committee members found.
  </div>
)}

                </Col>
              </Row>
            </Tab>

            {/* ================= Super Admins ================= */}
            <Tab
              eventKey="superAdmins"
              title={
                <span className="bold">
                  <i className="mdi mdi-shield-account-outline me-2"></i> Super
                  Admins
                </span>
              }
            >
              <h4 className="fw-bold text-secondary mt-4 mb-3">Super Admins</h4>

              {/* Add Super Admin Select */}
              <div className="d-flex justify-content-between align-items-center mb-3">
                <Select
                  className="flex-grow-1"
                  id="couple"
                  name="couple"
                  placeholder="Select Couple"
                  menuPlacement="top"
                  isSearchable
                  options={allcouple}
                  onChange={(val) => handleSelectOption(val, "forAdmins")}
                  value={coupleSelectAdmin}
                />
                <i
                  className="mdi mdi-plus-circle text-primary fs-3 ms-3 cursor-pointer"
                  title="Add Super Admin"
                  onClick={() => handleSelectSubmit()}
                ></i>
              </div>

              {/* List of Super Admins */}
              {allAdminList && allAdminList.length > 0 ? (
                allAdminList.map((item) => {
                  const isProtected = [
                    "tkolkebeck@me.com",
                    "jimmieflores@gmail.com",
                    "dulceaflores@gmail.com",
                    "kolkebeckd@gmail.com",
                    userData.email,
                  ].includes(item.email);

                  return (
                    <div
                      className="d-flex justify-content-between align-items-center border rounded-3 p-3 mb-2 shadow-sm bg-light"
                      key={item.id}
                    >
                      <div className="d-flex align-items-center gap-2">
                        <input
                          disabled={isProtected}
                          type="checkbox"
                          className="form-check-input me-2"
                          onChange={(e) => handleShowAlert(e, item)}
                          value={item.id}
                          checked={item.isDisabled !== 1}
                        />
                        <span>
                          <strong>
                            {item?.firstName || ""} {item?.lastName || ""}
                          </strong>
                          <small className="text-muted">
                            {" "}
                            ({item?.email || "N/A"}) | {item?.password || "N/A"}
                          </small>
                        </span>
                      </div>
                      <div className="d-flex gap-3">
                        {!isProtected && (
                          <i
                            className="mdi mdi-delete-forever text-danger fs-4 cursor-pointer"
                            onClick={() => handleShow(item, "Super Admin")}
                            title="Delete Admin"
                          ></i>
                        )}
                        <i
                          className="mdi mdi-account-card-details text-primary fs-4 cursor-pointer"
                          onClick={() => handleShow2(item, "Super Admin")}
                          title="Send Login Details"
                        ></i>
                      </div>
                    </div>
                  );
                })
              ) : (
                <div className="alert alert-light text-center mt-3 shadow-sm">
                  <i className="mdi mdi-information-outline me-2"></i> No super
                  admins available.
                </div>
              )}
            </Tab>

            {/* ================= Sub Admins ================= */}
            <Tab
              eventKey="subAdmins"
              title={
                <span className="bold">
                  <i className="mdi mdi-account-multiple-outline me-2"></i> Sub
                  Admins
                </span>
              }
            >
              <h4 className="fw-bold text-secondary mt-4 mb-3">Sub Admins</h4>

              {/* Add Sub Admin Select */}
              <div className="d-flex justify-content-between align-items-center mb-3">
                <Select
                  className="flex-grow-1"
                  id="couple"
                  name="couple"
                  placeholder="Select Couple"
                  menuPlacement="top"
                  isSearchable
                  options={allcouple}
                  value={coupleSelectSubAdmin}
                  onChange={(val) => handleSelectOption(val, "forSubAdmin")}
                />
                <i
                  className="mdi mdi-plus-circle text-primary fs-3 ms-3 cursor-pointer"
                  title="Add Sub Admin"
                  onClick={() => handleSelectSubmit()}
                ></i>
              </div>

              {/* List of Sub Admins */}
              {allSubAdminList && allSubAdminList.length > 0 ? (
                allSubAdminList.map((item) => {
                  const isSelf = item.email === userData.email;

                  return (
                    <div
                      className="d-flex justify-content-between align-items-center border rounded-3 p-3 mb-2 shadow-sm bg-light"
                      key={item.id}
                    >
                      <div className="d-flex align-items-center gap-2">
                        <input
                          disabled={isSelf}
                          type="checkbox"
                          className="form-check-input me-2"
                          onChange={(e) => handleShowAlert(e, item)}
                          value={item.id}
                          checked={item.isDisabled !== 1}
                        />
                        <span>
                          <strong>
                            {item?.firstName || ""} {item?.lastName || ""}
                          </strong>
                          <small className="text-muted">
                            {" "}
                            ({item?.email || "N/A"}) | {item?.password || "N/A"}
                          </small>
                        </span>
                      </div>
                      <div className="d-flex gap-3">
                        {!isSelf && (
                          <i
                            className="mdi mdi-delete-forever text-danger fs-4 cursor-pointer"
                            onClick={() => handleShow(item, "Sub-Admin")}
                            title="Delete Sub Admin"
                          ></i>
                        )}
                        <i
                          className="mdi mdi-account-card-details text-primary fs-4 cursor-pointer"
                          onClick={() => handleShow2(item, "Sub-Admin")}
                          title="Send Login Details"
                        ></i>
                      </div>
                    </div>
                  );
                })
              ) : (
                <div className="alert alert-light text-center mt-3 shadow-sm">
                  <i className="mdi mdi-information-outline me-2"></i> No sub
                  admins available.
                </div>
              )}
            </Tab>

            {/* ================= Retreat Sub Admins ================= */}
            <Tab
              eventKey="retreatSubAdmins"
              title={
                <span className="bold">
                  <i className="mdi mdi-map-marker-outline me-2"></i> Retreat
                  Sub Admins
                </span>
              }
            >
              <h4 className="fw-bold text-secondary mt-4 mb-3">
                Retreat Sub Admins
              </h4>

              {allRetreatSubAdminList && allRetreatSubAdminList.length > 0 ? (
                allRetreatSubAdminList.map((item, index) => (
                  <div key={index} className="mb-4">
                    <h5 className="fw-bold text-primary mb-3 mt-4">
                      {item.title}
                    </h5>
                    {item.subAdmins && item.subAdmins.length > 0 ? (
                      item.subAdmins.map((subAdmin, subIndex) => (
                        <div
                          className="d-flex justify-content-between align-items-center border rounded-3 p-3 mb-2 shadow-sm bg-light"
                          key={subIndex}
                        >
                          <div className="d-flex align-items-center gap-2">
                            <input
                              type="checkbox"
                              className="form-check-input me-2"
                              onChange={() =>
                                showRetreatAdminAlert(item, subAdmin)
                              }
                              value={subAdmin.id}
                              checked={!subAdmin.isDisabled}
                            />
                            <span>
                              <strong>{subAdmin.name}</strong>
                              <small className="text-muted">
                                {" "}
                                ({subAdmin.password})
                              </small>
                            </span>
                          </div>
                          <div className="d-flex gap-3">
                            <i
                              className="mdi mdi-delete-forever text-danger fs-4 cursor-pointer"
                              onClick={() =>
                                handleShowOfAccess(item, subAdmin.email)
                              }
                              title="Delete Retreat Sub Admin"
                            ></i>
                            <i
                              className="mdi mdi-account-card-details text-primary fs-4 cursor-pointer"
                              onClick={() =>
                                handleShow2(subAdmin, "Retreat Sub Admin")
                              }
                              title="Send Login Details"
                            ></i>
                          </div>
                        </div>
                      ))
                    ) : (
                      <p className="text-muted ms-2">
                        No sub admins for this retreat.
                      </p>
                    )}
                  </div>
                ))
              ) : (
                <div className="alert alert-light text-center mt-3 shadow-sm">
                  <i className="mdi mdi-information-outline me-2"></i> No
                  retreat sub admins found.
                </div>
              )}
            </Tab>
          </Tabs>
        </div>
      </div>
      {show ? (
        <DeleteModel
          show={show}
          content={
            <>
              <h5 className="mt-4 fw-bold">{myRoleIs} Detail</h5>
              <div className="p-3 border rounded-3 bg-light shadow-sm">
                <h5 className="mt-4 fw-bold">{myRoleIs} : </h5>
                <div>
                  {(removeId.firstName ||
                    removeId.lastName ||
                    removeId.email) && (
                    <div className="mb-2">
                      {removeId.firstName} {removeId.lastName}
                      {removeId.email && (
                        <span className="text-muted"> – {removeId.email}</span>
                      )}
                    </div>
                  )}
                </div>
              </div>
            </>
          }
          handleClose={handleClose}
          DeleteData={removeRole}
        ></DeleteModel>
      ) : null}
      {removeAccessShow ? (
        <DeleteModel
          show={removeAccessShow}
          content={
            <>
              <h5 className="mt-4 fw-bold">Retreat Sub Admin Detail</h5>
              <div className="p-3 border rounded-3 bg-light shadow-sm">
                <h5 className="mt-4 fw-bold">Retreat Sub Admin : </h5>
                <div>
                  {removeId?.subAdmins && (
                    <div className="mb-2">
                      {(() => {
                        const matchedAdmin = removeId.subAdmins.find(
                          (sub) => sub.email === mailId
                        );
                        return matchedAdmin ? (
                          <span className="text-muted">
                            {matchedAdmin.name}
                          </span>
                        ) : null;
                      })()}
                    </div>
                  )}
                </div>

                <h5 className="mt-4 fw-bold">Retreat : </h5>
                <div>
                  <div>
                    <strong className="text-primary d-block">
                      {removeId.title}
                    </strong>
                    <small className="text-muted ms-3">
                      {moment(removeId.dateFrom).format("MMM DD")} -{" "}
                      {moment(removeId.dateTo).format("MMM DD, YYYY")}
                    </small>
                  </div>
                </div>
              </div>
            </>
          }
          handleClose={handleCloseOfAccess}
          DeleteData={removeAccessFromRetreat}
        ></DeleteModel>
      ) : null}
      {showAccessAlert ? (
        <AlertModal
          cancel={"Cancel"}
          okay={"Okay"}
          show={showAccessAlert}
          handleClose={handleCloseAlert}
          message={`Are you sure you want to ${
            removeId && removeId.isDisabled === 1 ? "enable" : "disable"
          } this admin?`}
          actionFunction={adminAccess}
          heading={"ALERT!!"}
        />
      ) : null}
      {retAdminAccessAlert ? (
        <AlertModal
          cancel={"Cancel"}
          okay={"Okay"}
          show={retAdminAccessAlert}
          handleClose={closeretAdminAlert}
          message={`Are you sure you want to ${
            removeId && removeId.isDisabled === 1 ? "enable" : "disable"
          } this admin?`}
          actionFunction={retreatAdminAccess}
          heading={"ALERT!!"}
        />
      ) : null}
      {showMailAlert ? (
        <AlertModal
          show={showMailAlert}
          handleClose={handleClose2}
          message={`Are you sure you want to send the login details?`}
          actionFunction={sendLoginDetail}
          cancel={"Cancel"}
          okay={"Okay"}
          heading={"ALERT!!"}
        />
      ) : null}

      <Modal
        show={showRegModal}
        onHide={() => {
          setShowREgModal(false);
          clearfield();
        }}
        size="xl"
      >
        <Modal.Header closeButton>
          <Modal.Title>
            {selectUserCheck === true ? "Edit" : "Add"} Committee Member
          </Modal.Title>
        </Modal.Header>
        <Form
          onSubmit={handleSubmit}
          noValidate
          validated={validated}
          className="forms-sample"
        >
          <Modal.Body>
            <p className="card-description mt-3">
              Enter Committee Member details here..
            </p>
            <hr />
            <Row>
              <Col lg={12} md={12} sm={12} xs={12}>
                <Form.Label>Select User</Form.Label>
                <Select
                  id="userId"
                  name="userId"
                  labelledBy="Select"
                  isSearchable={true}
                  isMulti={true}
                  placeholder="Select User"
                  menuPlacement="top"
                  options={allcouple}
                  onChange={(e) => handleSelectUserId(e)}
                  value={selecterdCommittee}
                  required
                />
              </Col>

              {openModalFor !== "NewSteeringMember" && (
                <>
                  <Col lg={12} md={12} sm={12} xs={12} className="mt-2">
                    <Form.Group className="form-group">
                      <Form.Label>Parish</Form.Label>
                      <Form.Select
                        required
                        className="form-control minimal parishListInAmin"
                        size="sm"
                        type="text"
                        name="parishId"
                        id="parishId"
                        placeholder="Parish"
                        value={data.parishId || ""}
                        onChange={(e) => handleChanges(e)}
                      >
                        <option value="">Select Parish</option>
                        <optgroup label="Parish">
                          {parishList
                            .filter(
                              (p) =>
                                p.parishCategoryName?.toUpperCase() !== "OTHER"
                            )
                            .map((item, index) => {
                              const labelParts = [
                                item.parish,
                                item.city,
                                item.parishCategoryName,
                              ].filter(Boolean);
                              const label =
                                labelParts.join(" | ") ||
                                "No details available";

                              return (
                                <option key={index} value={item.id}>
                                  {label}
                                </option>
                              );
                            })}
                        </optgroup>
                        <optgroup label="OTHER">
                          {parishList
                            .filter(
                              (p) =>
                                p.parishCategoryName?.toUpperCase() === "OTHER"
                            )
                            .map((item, index) => {
                              const labelParts = [
                                item.parish,
                                item.city,
                              ].filter(Boolean);
                              const label =
                                labelParts.join(" | ") ||
                                "No details available";

                              return (
                                <option key={`other-${index}`} value={item.id}>
                                  {label}
                                </option>
                              );
                            })}
                        </optgroup>
                      </Form.Select>

                      <Form.Control.Feedback type="invalid">
                        Parish is required!
                      </Form.Control.Feedback>
                    </Form.Group>
                  </Col>

                  <Col
                    lg={12}
                    md={12}
                    sm={12}
                    xs={12}
                    className="form-group bold "
                  >
                    <Form.Label>Retreats</Form.Label>
                    <Select
                      id="retreat"
                      name="retreat"
                      options={retreatOptions}
                      value={selectedRetreats}
                      onChange={handleSelectRetreat}
                      isSearchable
                      isMulti
                      isDisabled={true}
                      components={{
                        MultiValueRemove: CustomMultiValueRemove,
                      }}
                    />
                  </Col>

                  {selectedEditRetreats && selectedEditRetreats.length > 0 && (
                    <Col
                      lg={12}
                      md={12}
                      sm={12}
                      xs={12}
                      className="form-group bold"
                    >
                      <h5 className="alreadySelected">
                        Already Selected Retreats
                      </h5>
                      <ul className="selectedRetreatsList">
                        {selectedEditRetreats.map((item, index) => (
                          <li key={index} className="selectedRetreatItem">
                            {item.label}
                          </li>
                        ))}
                      </ul>
                    </Col>
                  )}
                </>
              )}
            </Row>

            <hr />
          </Modal.Body>
          <Modal.Footer>
            {userData?.userRole !== "SUBADMIN" && (
              <Button variant="primary" type="submit">
                Submit
              </Button>
            )}
            <Button
              variant="secondary"
              onClick={() => {
                setShowREgModal(false);
                clearfield();
              }}
            >
              Cancel
            </Button>
          </Modal.Footer>
        </Form>
      </Modal>

      {deleteMember ? (
        <DeleteModel
          show={deleteMember}
          content={
            <>
              <h5 className="mt-4 fw-bold">Steering Committee Detail</h5>
              <div className="p-3 border rounded-3 bg-light shadow-sm">
                {member?.parishData?.parishName && (
                  <div className="mb-2">
                    <span className="fw-bold">Parish:</span>{" "}
                    {member?.parishData?.parishName}{" "}
                  </div>
                )}
                <h5 className="mt-4 fw-bold">User Detail</h5>
                <div>
                  {(member.userData.firstName ||
                    member.userData.lastName ||
                    member.userData.email) && (
                    <div className="mb-2">
                      {member.userData.firstName} {member.userData.lastName}
                      {member.userData.email && (
                        <span className="text-muted">
                          {" "}
                          – {member.userData.email}
                        </span>
                      )}
                    </div>
                  )}
                </div>
              </div>
            </>
          }
          handleClose={deleteMemberPopUpClose}
          DeleteData={deleteMemberFun}
        ></DeleteModel>
      ) : null}

      {alert ? (
        <AlertModal
          show={alert}
          handleClose={handleClose3}
          message={`Are you sure you want to ${
            member?.retreat?.disabled === false ? "DISABLE" : "ENABLE"
          } this retreat`}
          actionFunction={retreatDisabledForMem}
          cancel={"Cancel"}
          okay={"Okay"}
          heading={"ALERT!!"}
        />
      ) : null}

      {show5 ? (
        <DeleteModel
          show={show5}
          content={
            <>
              <h5 className="mt-4 fw-bold">Steering Committee Detail</h5>
              <div className="p-3 border rounded-3 bg-light shadow-sm">
                {member.parishName && (
                  <div className="mb-2">
                    <span className="fw-bold">Parish:</span> {member.parishName}{" "}
                  </div>
                )}

                <h5 className="mt-4 fw-bold">Users Detail</h5>
                {member.users.map((user, idx) => (
                  <div>
                    {/* His Details */}
                    {(user.firstName || user.lastName || user.email) && (
                      <div className="mb-2">
                        {user.firstName} {user.lastName}
                        {user.email && (
                          <span className="text-muted"> – {user.email}</span>
                        )}
                      </div>
                    )}
                  </div>
                ))}
              </div>
            </>
          }
          handleClose={handleClose5}
          DeleteData={deleteParishMembers}
        ></DeleteModel>
      ) : null}
    </div>
  );
};

export default AdminDashboard;
