module.exports = (sequelize, Sequelize) => {
  const TempRetreatSchema = sequelize.define("tempRetreat", {
    title: {
      type: Sequelize.STRING,
    },
    parishId: {
      type: Sequelize.INTEGER,
      references: {
        model: "parishes",
        key: "id",
      },
    },
    language: {
      type: Sequelize.STRING,
    },
    location: {
      type: Sequelize.STRING,
    },
    image1: {
      type: Sequelize.STRING(1234),
    },
    heading: {
      type: Sequelize.STRING,
    },
    mission_statement: {
      type: Sequelize.TEXT,
    },
    description: {
      type: Sequelize.TEXT,
    },
    schedule: {
      type: Sequelize.TEXT,
    },
    mail_msg: {
      type: Sequelize.TEXT,
    },
    contact_name: {
      type: Sequelize.STRING,
    },
    contact_email: {
      type: Sequelize.STRING,
    },
    contact_mobile: {
      type: Sequelize.STRING,
    },
    retreat_team: {
      type: Sequelize.TEXT,
    },
    dateFrom: {
      type: Sequelize.DATE,
    },
    dateTo: {
      type: Sequelize.DATE,
    },
    subAdmins: {
      type: Sequelize.TEXT,
    },
  });

  return TempRetreatSchema;
};
