module.exports = (sequelize, Sequelize) => {
  const DirectorySchema = sequelize.define("directory", {
    retreatId: {
      type: Sequelize.INTEGER,
      references: {
        model: "retreats",
        key: "id",
      },
    },
    headerImage: {
      type: Sequelize.STRING(1234),
    },
    footerImage: {
      type: Sequelize.STRING(1234),
    },
    footerText: {
      type: Sequelize.STRING,
    },
    status: {
      type: Sequelize.ENUM("PUBLISH", "UNPUBLISH"),
      defaultValue: "UNPUBLISH",
    },
    socialLinks: {
      type: Sequelize.JSON,
      allowNull: true,
    },
  });

  return DirectorySchema;
};
