const db = require("../database/dbConnection");
const Services = require("../database/dbConnection");
const { Op } = require("sequelize");
const serviceSchema = Services.service;
class ServiceController {
  async getService(req, res) {
    try {
      const service = await serviceSchema.findByPk(req.params.service_id);
      return res.status(200).send({
        success: true,
        msg: "Service",
        data: service,
      });
    } catch (error) {
      console.log("error: ", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async addService(req, res) {
    const STOP_WORDS = ["of", "and", "the", "is", "a", "an", "in", "to", "for", "with", "by"];
  
    try {
      const { service, forceSave } = req.body;
  
      // Check for an exact match (case-insensitive)
      let exactMatch = await serviceSchema.findOne({
        where: { service: { [Op.like]: service } },
      });
  
      if (exactMatch) {
        return res.status(200).send({
          success: false,
          msg: "This service already exists with an exact match.",
        });
      }
  
      // Proceed to fuzzy search if forceSave is not true
      if (!forceSave) {
        const serviceWords = service
          .toLowerCase()
          .split(" ")
          .filter((word) => !STOP_WORDS.includes(word))
          .map((word) => `%${word}%`);
  
        if (serviceWords.length > 0) {
          let matchingServices = await serviceSchema.findAll({
            where: {
              [Op.or]: serviceWords.map((word) => ({
                service: { [Op.like]: word },
              })),
            },
          });
  
          if (matchingServices.length) {
            return res.status(200).send({
              success: true,
              msg: "Potential matches found. Please review before proceeding.",
              matches: matchingServices,
            });
          }
        }
      }
  
      // Save the new service if no matches or forceSave is true
      let newService = new serviceSchema(req.body);
      let succ = await newService.save();
  
      if (succ) {
        return res.status(200).send({
          success: true,
          msg: "New Service is created.",
          data: succ,
        });
      } else {
        return res.status(500).send({
          success: false,
          msg: "Something went wrong. Please try again.",
        });
      }
    } catch (error) {
      return res.status(500).json({
        success: false,
        msg: "An error occurred while processing the request.",
        error: error.message,
      });
    }
  }  

  async getAllServiceSearch(req, res) {
    try {
      let query = `SELECT services.*
       FROM services
        LEFT JOIN retreatroasters ON retreatroasters.serviceId = services.id
    WHERE retreatroasters.serviceId IS NOT NULL GROUP BY services.id`;
      let allServices = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Services",
        data: allServices,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async getAllServicelist(req, res) {
    try {
      let query = `SELECT services.*, COUNT(retreatroasters.id) AS roasters_count 
      FROM services 
      LEFT JOIN retreatroasters ON retreatroasters.serviceId = services.id 
      GROUP BY services.id 
      ORDER BY services.id ASC;
      `;
      let allServices = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Services",
        data: allServices,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async updateService(req, res) {
    try {
      let updated = await serviceSchema.update(req.body, {
        where: { id: req.params.service_id },
      });
      return res.status(200).send({
        success: true,
        msg: "Record Updated",
        data: updated,
      });
    } catch (err) {
      return res.status(200).json({
        success: false,
        msg: err,
      });
    }
  }

  async deleteService(req, res) {
    try {
      let delete_service = await serviceSchema.destroy({
        where: { id: req.params.service_id },
      });
      return res.status(200).send({
        success: true,
        msg: "Record Deleted",
        data: delete_service,
      });
    } catch (err) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async searchKey(req, res) {
    try {
      let result = await serviceSchema.findAll({
        where: {
          service: {
            [Op.like]: `%${req.params.key}%`,
          },
        },
        raw: true,
      });
      return res.status(200).send({
        success: true,
        msg: "",
        data: result,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }
}
module.exports = new ServiceController();
