import React, { useState, useEffect } from "react";
import Loader from "../components/loader";
import PerishApi from "../api/perishApi";
import AdminApi from "../api/admin";
import { toast } from "react-toastify";
import { Cookies, useCookies } from "react-cookie";
import { Form, Col, Button, Modal } from "react-bootstrap";
import ImagePlaceHolder from "../assets/images/image-placeholder.png";
import MasterDataConfirmationModal from "../components/MasterDataConfirmationModal";

function OtherParishModal(props) {
  let {
    show,
    handleClose,
    registerationData,
    setRegisterationData,
    setParishList,
    parishList,
  } = props;
  let adminApi = new AdminApi();
  let perishApi = new PerishApi();
  let cookies = new Cookies();
  let userData = cookies.get("LoveStrongUser") || null;

  const [data, setData] = useState({
    parish: "",
    address: "",
    state: "",
    city: "",
    zip: "",
    imageUrl: "",
    link: "",
    parishCategory: "OTHER",
  });

  const [matches, setMatches] = useState([]);
  const [loader, setLoader] = useState(false);
  const [validated, setValidated] = useState(false);
  const [isImgpUpload, setIsImgpUpload] = useState(false);
  const [showConfirmationModal, setShowConfirmationModal] = useState(false);

  const handleChanges = (e) => {
    let { name, value } = e.target;
    let d = { ...data };
    if (name == "imageUrl") {
      d.imageUrl = e.target.files[0];
      toast.success("The profile image has been successfully added.");
    } else {
      d[name] = value;
    }
    setData(d);
  };

  const handleSubmit = (e) => {
    const form = e.currentTarget;
    e.preventDefault();
    e.stopPropagation();

    if (!form.checkValidity()) {
      setValidated(true);
      return;
    }
    setLoader(true);
    let data1 = new FormData();
    data1.append("file", data.imageUrl);
    let stateRef = { ...data };
    delete stateRef.imageUrl;
    data1.append("fromData", JSON.stringify(stateRef));
    perishApi
      .addPerish(data1)
      .then(async (res) => {
        if (res.success) {
          setLoader(false);
          if (res.matches && res.matches.length > 0) {
            setMatches(res.matches);
            setShowConfirmationModal(true);
          } else {
            handleAfterSubmit(res);
          }
        } else {
          toast.error(res.msg);
          setLoader(false);
        }
      })
      .catch((error) => {
        toast.error(error.toString());
        setLoader(false);
      });
  };

  const handleConfirmSubmit = () => {
    if (matches.length > 0) {
      let data1 = new FormData();
      data1.append("file", data.imageUrl);
      let stateRef = { ...data, forceSave: true };
      delete stateRef.imageUrl;
      stateRef = { ...stateRef };
      data1.append("fromData", JSON.stringify(stateRef));
      perishApi
        .addPerish(data1)
        .then((res) => {
          if (res.success) {
            handleAfterSubmit(res);
          } else {
            toast.error(res.msg);
          }
        })
        .catch((error) => {
          console.error(error);
          toast.error(error.toString());
        });
      setShowConfirmationModal(false);
    }
  };

  const handleAfterSubmit = async (response) => {
    let a = { ...registerationData };
    a.parishId = response.data.id;
    a.parishName = response.data.parish;
    console.log("response.data---->", response.data);

    setRegisterationData(a);
    setParishList((prev) => [...prev, response.data]);
    toast.success(response.msg);
    clearfield();
    setValidated(false);
    handleClose();
    let report = {
      byWhom: `${userData?.userName || ""} (${userData?.userRole || ""})`,
      pagelink: window.location.href,
      description: `Added New Perish in Other category (Perish Id: ${response.data?.id}, Parish Name: ${response.data?.parish})`,
      action: "Add",
    };
    await adminApi.addLogReport(report).catch((error) => {
      console.error(error);
    });
  };

  const upload = () => {
    document.getElementById("parishImageUpload").click();
    setIsImgpUpload(true);
  };

  const remove = () => {
    let d = { ...data };
    d.imageUrl = "";
    setData(d);
    setIsImgpUpload(false);
  };

  const clearfield = () => {
    setData({
      parish: "",
      address: "",
      state: "",
      city: "",
      zip: "",
      imageUrl: "",
      link: "",
      parishCategory: "OTHER",
    });
  };

  const resetForm = () => {
    clearfield();
    setValidated(false);
    handleClose();
  };

  return (
    <div>
      <Modal
        show={show}
        onHide={handleClose}
        size="xl"
        className="custom-backdrop"
      >
        <Form
          onSubmit={handleSubmit}
          noValidate
          validated={validated}
          className="forms-sample Couple_heading"
        >
          <Modal.Header style={{ color: "green" }} closeButton>
            <Modal.Title>Create Other Retreat</Modal.Title>
          </Modal.Header>
          <Modal.Body>
            <div className="col-md-12 grid-margin stretch-card">
              <div style={{ position: "relative" }}>
                {loader && (
                  <div
                    style={{
                      position: "absolute",
                      top: 0,
                      left: 0,
                      width: "100%",
                      height: "100%",
                      background: "rgba(255,255,255,0.7)",
                      display: "flex",
                      justifyContent: "center",
                      alignItems: "center",
                      zIndex: 9999,
                    }}
                  >
                    <Loader />
                  </div>
                )}
                <div className="form-group row flex-grow">
                  <Form.Group className="form-group col-xs-12 col-sm-12 col-md-6 col-lg-6">
                    <Form.Label>
                      Parish Name <span className="text-danger">*</span>
                    </Form.Label>
                    <Form.Control
                      required
                      size="sm"
                      type="text"
                      name="parish"
                      id="parish"
                      placeholder="Enter New Parish"
                      value={data.parish}
                      className="form-control Couple_heading"
                      onChange={(e) => handleChanges(e)}
                    />
                    <Form.Control.Feedback type="invalid">
                      Parish Name is required!
                    </Form.Control.Feedback>
                  </Form.Group>
                  <Form.Group className="form-group col-xs-12 col-sm-12 col-md-6 col-lg-6">
                    <Form.Label>Address</Form.Label>
                    <Form.Control
                      size="sm"
                      type="text"
                      name="address"
                      id="address"
                      placeholder="Address"
                      value={data.address}
                      onChange={(e) => handleChanges(e)}
                    />
                    <Form.Control.Feedback type="invalid">
                      Address is required!
                    </Form.Control.Feedback>
                  </Form.Group>
                  <Form.Group className="form-group col-xs-12 col-sm-12 col-md-6 col-lg-6">
                    <Form.Label>State</Form.Label>
                    <Form.Select
                      size="sm"
                      type="text"
                      name="state"
                      id="state"
                      placeholder="State"
                      value={data.state}
                      onChange={(e) => handleChanges(e)}
                    >
                      <option value="">Select State</option>
                      <option value="Texas">Texas</option>
                      <option value="Alaska">Alaska</option>
                      <option value="Alabama">Alabama</option>
                      <option value="Arkansas">Arkansas</option>
                      <option value="Arizona">Arizona</option>
                      <option value="California">California</option>
                      <option value="Colorado">Colorado</option>
                      <option value="Connecticut">Connecticut</option>
                      <option value="District of Columbia">
                        District of Columbia
                      </option>
                      <option value="Delaware">Delaware</option>
                      <option value="Florida">Florida</option>
                      <option value="Georgia">Georgia</option>
                      <option value="Hawaii">Hawaii</option>
                      <option value="Iowa">Iowa</option>
                      <option value="Idaho">Idaho</option>
                      <option value="Illinois">Illinois</option>
                      <option value="Indiana">Indiana</option>
                      <option value="Kansas">Kansas</option>
                      <option value="Kentucky">Kentucky</option>
                      <option value="Louisiana">Louisiana</option>
                      <option value="Massachusetts">Massachusetts</option>
                      <option value="Maryland">Maryland</option>
                      <option value="Maine">Maine</option>
                      <option value="Michigan">Michigan</option>
                      <option value="Minnesota">Minnesota</option>
                      <option value="Missouri">Missouri</option>
                      <option value="Mississippi">Mississippi</option>
                      <option value="Montana">Montana</option>
                      <option value="North Carolina<">North Carolina</option>
                      <option value="North Dakota">North Dakota</option>
                      <option value="Nebraska">Nebraska</option>
                      <option value="New Hampshire">New Hampshire</option>
                      <option value="New Jersey">New Jersey</option>
                      <option value="New Mexico">New Mexico</option>
                      <option value="Nevada">Nevada</option>
                      <option value="New York">New York</option>
                      <option value="Ohio">Ohio</option>
                      <option value="Oklahoma">Oklahoma</option>
                      <option value="Oregon">Oregon</option>
                      <option value="Pennsylvania">Pennsylvania</option>
                      <option value="Puerto Rico">Puerto Rico</option>
                      <option value="Rhode Island">Rhode Island</option>
                      <option value="South Carolina">South Carolina</option>
                      <option value="South Dakota">South Dakota</option>
                      <option value="Tennessee">Tennessee</option>
                      <option value="Texas">Texas</option>
                      <option value="Utah">Utah</option>
                      <option value="Virginia">Virginia</option>
                      <option value="Vermont">Vermont</option>
                      <option value="Washington">Washington</option>
                      <option value="Wisconsin">Wisconsin</option>
                      <option value="West Virginia">West Virginia</option>
                      <option value="Wyoming">Wyoming</option>
                    </Form.Select>
                    <Form.Control.Feedback type="invalid">
                      State is required!
                    </Form.Control.Feedback>
                  </Form.Group>
                  <Form.Group className="form-group col-xs-12 col-sm-12 col-md-6 col-lg-6">
                    <Form.Label>City</Form.Label>
                    <Form.Control
                      // required
                      size="sm"
                      type="text"
                      name="city"
                      id="city"
                      placeholder="City"
                      value={data.city}
                      onChange={(e) => handleChanges(e)}
                    />
                    <Form.Control.Feedback type="invalid">
                      City is required!
                    </Form.Control.Feedback>
                  </Form.Group>
                  <Form.Group className="form-group col-xs-12 col-sm-12 col-md-6 col-lg-6">
                    <Form.Label>Zip</Form.Label>
                    <Form.Control
                      // required
                      size="sm"
                      type="text"
                      name="zip"
                      id="zip"
                      placeholder="Zip"
                      value={data.zip}
                      onChange={(e) => handleChanges(e)}
                    />
                    <Form.Control.Feedback type="invalid">
                      Zip is required!
                    </Form.Control.Feedback>
                  </Form.Group>

                  <Form.Group className="form-group col-xs-12 col-sm-12 col-md-6 col-lg-6">
                    <Form.Label>Link</Form.Label>
                    <Form.Control
                      // required
                      size="sm"
                      type="text"
                      name="link"
                      id="link"
                      placeholder="Link"
                      value={data.link}
                      onChange={(e) => handleChanges(e)}
                    />
                    <Form.Control.Feedback type="invalid">
                      Link is required!
                    </Form.Control.Feedback>
                    <h5 className="mt-2">(example - https://www.xyz.com)</h5>
                  </Form.Group>
                  <Col lg={6} md={6} xs={12}>
                    <Form.Group>
                      {data.imageUrl == "" || data.imageUrl == undefined ? (
                        <div className="edit-profile-img mb-2 text-center">
                          <img src={ImagePlaceHolder} />
                        </div>
                      ) : (
                        <div className="edit-profile-img mb-2 text-center">
                          {isImgpUpload ? (
                            <>
                              <img src={URL.createObjectURL(data?.imageUrl)} />
                            </>
                          ) : (
                            <>
                              <img src={data?.imageUrl} />
                            </>
                          )}
                        </div>
                      )}{" "}
                      <div className="text-center mt-3">
                        {data.imageUrl == "" || data.imageUrl == undefined ? (
                          <>
                            <input
                              name="imageUrl"
                              className="pt-1"
                              type="file"
                              accept="image/*"
                              style={{ display: "none" }}
                              id="parishImageUpload"
                              onChange={(e) => handleChanges(e)}
                            />
                            <Button
                              variant="primary"
                              className="mb-1 text-center"
                              onClick={(e) => {
                                upload();
                              }}
                            >
                              Upload Parish Logo
                            </Button>
                          </>
                        ) : (
                          <Button
                            variant="danger"
                            className="mb-1 mt-2 "
                            onClick={(e) => {
                              remove();
                            }}
                          >
                            Remove
                          </Button>
                        )}
                      </div>
                    </Form.Group>
                  </Col>
                </div>
                <Form.Control.Feedback type="invalid">
                  Parish is required!
                </Form.Control.Feedback>
              </div>
            </div>
          </Modal.Body>

          <Modal.Footer>
            <Button variant="secondary" onClick={resetForm}>
              Cancel
            </Button>
            <Button variant="primary" type="submit">
              Create
            </Button>
          </Modal.Footer>
        </Form>
      </Modal>

      <MasterDataConfirmationModal
        show={showConfirmationModal}
        onClose={() => setShowConfirmationModal(false)}
        onConfirm={handleConfirmSubmit}
        matches={matches}
        dataKey="parish"
      />
    </div>
  );
}

export default OtherParishModal;
