import BaseApi from "./BaseApi";

class ParishCategoryApi extends BaseApi {
  async addCategory(data) {
    return await this.API({
      url: "/parish-categories/add",
      data: data,
      method: "post",
    });
  }

  async getAllCategories() {
    return await this.API({
      url: "/parish-categories/list",
      method: "get",
    });
  }

  async getCategory(id) {
    return await this.API({
      url: `/parish-categories/${id}`,
      method: "get",
    });
  }

  async updateCategory(data, id) {
    return await this.API({
      url: `/parish-categories/update/${id}`,
      data: data,
      method: "put",
    });
  }

  async deleteCategory(data, id) {
    return await this.API({
      url: `/parish-categories/delete/${id}`,
      data: data,
      method: "delete",
    });
  }

  async searchCategory(key) {
    return await this.API({
      url: `/parish-categories/search/${key}`,
      method: "get",
    });
  }
}

export default ParishCategoryApi;
