module.exports = (sequelize, Sequelize) => {
  const ProgramSchema = sequelize.define("program", {
    retreatId: {
      type: Sequelize.INTEGER,
      references: {
        model: "retreats",
        key: "id",
      },
    },
    headerImage: {
      type: Sequelize.STRING(1234),
    },
    wisdom_from_mt: {
      type: Sequelize.TEXT,
    },
    guidelines: {
      type: Sequelize.TEXT,
    },
    parishMission: {
      type: Sequelize.TEXT,
    },
    qrCodeImage: {
      type: Sequelize.STRING(1234),
    },
    footerImages: {
      type: Sequelize.TEXT,
    },
    tableContent: {
      type: Sequelize.TEXT,
    },
    fbLink: {
      type: Sequelize.TEXT,
    },
    status: {
      type: Sequelize.ENUM("PUBLISH", "UNPUBLISH"),
      defaultValue: "UNPUBLISH",
    },
    stage: {
      type: Sequelize.ENUM("DRAFT", "VERIFIED"),
      defaultValue: "DRAFT",
    },
  });

  return ProgramSchema;
};
