const Sequelize = require("sequelize");
const { Op } = require("sequelize");
const sequelize = new Sequelize(
  process.env.DB_NAME,
  process.env.DB_USER,
  process.env.DB_PASSWORD,
  {
    host: process.env.DB_HOST,
    dialect: "mysql",
    operatorsAliases: "0",
    logging: false,
    pool: {
      max: 5,
      min: 0,
      idle: 10000,
    },
  }
);
sequelize
  .authenticate()
  .then(() => {
    console.log("Connection has been established successfully.");
  })
  .catch((error) => {
    console.error("Unable to connect to the database: ", error);
  });
const db = {};

db.Sequelize = Sequelize;
db.sequelize = sequelize;

db.service = require("./ServiceModel")(sequelize, Sequelize);
db.user = require("./UserModel")(sequelize, Sequelize);
db.talk = require("./TalksModel")(sequelize, Sequelize);
db.parishCategories = require("./ParishCategoriesModel")(sequelize, Sequelize);
db.sendEmail = require("./SendEmailModel")(sequelize, Sequelize);
db.couple = require("./coupleModel")(sequelize, Sequelize);
db.parish = require("./parishModel")(sequelize, Sequelize);
db.retreat = require("./retreatModel")(sequelize, Sequelize);
db.roles = require("./RolesModel")(sequelize, Sequelize);
db.logreport = require("./logReportModel")(sequelize, Sequelize);
db.retreatRoaster = require("./retreatRoasterModel")(sequelize, Sequelize);
db.directory = require("./directoryModel")(sequelize, Sequelize);
db.program = require("./programModel")(sequelize, Sequelize);
db.tempRetreat = require("./tempRetreatModel")(sequelize, Sequelize);
db.committeeMember = require("./committeeMemberModel")(sequelize, Sequelize);
db.help = require("./helpModel")(sequelize, Sequelize);
db.ticketMessage = require("./ticketMessageModel")(sequelize, Sequelize);
db.teamInterest = require("./teamInterestModel")(sequelize, Sequelize);

db.couple.hasMany(db.retreat, { foreignKey: "coupleId", onUpdate: "CASCADE" });
db.parish.hasMany(db.retreat, { foreignKey: "parishId", onUpdate: "CASCADE" });

db.retreat.belongsTo(db.couple);
db.retreat.belongsTo(db.parish);

db.couple.hasMany(db.retreatRoaster, {
  foreignKey: "coupleId",
  onUpdate: "CASCADE",
});
db.retreat.hasMany(db.retreatRoaster, {
  foreignKey: "retreatId",
  onUpdate: "CASCADE",
});
db.parish.hasMany(db.retreatRoaster, {
  foreignKey: "parishId",
  onUpdate: "CASCADE",
});
db.roles.hasMany(db.retreatRoaster, {
  foreignKey: "roleId",
  onUpdate: "CASCADE",
});
db.service.hasMany(db.retreatRoaster, {
  foreignKey: "serviceId",
  onUpdate: "CASCADE",
});
db.talk.hasMany(db.retreatRoaster, {
  foreignKey: "talkId",
  onUpdate: "CASCADE",
});

db.help.hasMany(db.ticketMessage, {
  foreignKey: "ticketId",
  onUpdate: "CASCADE",
});

db.ticketMessage.belongsTo(db.help);

db.retreatRoaster.belongsTo(db.couple);
db.retreatRoaster.belongsTo(db.retreat);
db.retreatRoaster.belongsTo(db.parish);
db.retreatRoaster.belongsTo(db.roles);
db.retreatRoaster.belongsTo(db.service);
db.retreatRoaster.belongsTo(db.talk);

const Users = db.user;
const Couples = db.couple;

try {
  Couples.findAll({
    attributes: ["userRole", "hisEmail"],
    where: {
      userRole: "ADMIN",
      hisEmail: { [Op.in]: ["manpreet02701@gmail.com"] },
    },
    raw: true,
  })
    .then(async (res) => {
      if (res && res.length === 0) {
        let adminObj1 = [
          {
            primaryKey: 1001,
            hisFirstName: "Manpreet",
            hisLastName: "Singh",
            hisEmail: "manpreet02701@gmail.com",
            hisMobile: "",
            herFirstName: "",
            herLastName: "",
            herEmail: "",
            herMobile: "",
            city: "",
            state: "",
            notes: "",
            userRole: "ADMIN",
            emailVerified: 1,
            isAdminRight: 1,
            hear_us: "[]",
          },
        ];
        await Promise.all(adminObj1.map((item) => Couples.create(item)));

        const createdCouple = await Couples.findOne({
          where: {
            userRole: "ADMIN",
            hisEmail: "manpreet02701@gmail.com",
          },
          raw: true,
        });

        if (createdCouple) {
          let adminObj = [
            {
              userName: "Manpreet",
              firstName: "Manpreet",
              lastName: "Singh",
              imageUpload: "",
              email: "manpreet02701@gmail.com",
              password: "Admin123",
              accountStatus: "ACTIVE",
              userRole: "ADMIN",
              mobile: "",
              coupleId: createdCouple.id,
              emailVerified: 1,
            },
          ];
          await Promise.all(adminObj.map((item) => Users.create(item)));
        }
      }
    })
    .catch((err) => {
      console.log("err: ", err);
    });
} catch (error) {
  console.log(error);
}

module.exports = db;
