const db = require("../database/dbConnection");
const SendEmailSchema = require("../database/dbConnection");
const { Op } = require("sequelize");
const coupleSchema = db.couple;
const sendEmailSchema = SendEmailSchema.sendEmail;
const Email = require("../helper/sendEmail");
const { EMAIL_INVITECOUPLE } = require("../helper/emailTemplate");
class SendEmailController {
  async getAllComposedMails(req, res) {
    try {
      const allMails = await sendEmailSchema.findAll({
        order: [["id", "DESC"]],
      });
      return res.status(200).send({
        success: true,
        msg: "All Mails",
        data: allMails,
      });
    } catch (error) {
      console.log("error: ", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async addSendEmail(req, res) {
    try {
      let newmail = new sendEmailSchema(req.body);
      let succ = await newmail.save();
      let allEmail = req.body.couple.map((item) => {
        let obj = {};
        obj.firstName = item.email.split("(")[0].split(" ")[0];
        obj.lastName = item.email.split("(")[0].split(" ")[1];
        obj.email = item.value;
        obj.subject = req.body.subject;
        obj.message = req.body.message;
        return obj;
      });
      // console.log("allEmail---->",allEmail);
      allEmail.forEach(async (element) => {
        let position = req.body.message.includes("$link");
        // console.log("${link}---->",position);
        if (position) {
          // console.log("position-->",position);
          let found = await coupleSchema.findAll({
            where: {
              [Op.or]: [
                { hisEmail: element.email },
                { herEmail: element.email },
              ],
            },
            raw: true,
          });
          // console.log("found", found[0]);
          let updateCouple = await coupleSchema.update(
            { linkverify: "1" },
            {
              where: {
                [Op.or]: [
                  { hisEmail: element.email },
                  { herEmail: element.email },
                ],
              },
              raw: true,
            }
          );
          if (found) {
            let ancertag =
              `<a href="${process.env.SERVERADDRESS}/couple-update/${found[0].id}-1">` +
              `${process.env.SERVERADDRESS}/couple-update/${found[0].id}-1` +
              "</a>";

            // console.log("ancertag", ancertag);

            element.message = element.message.replace(/\$link/g, ancertag);
          }
        }
        element.message = element.message.replace(
          /\${firstName}/g,
          element.firstName &&
            element.firstName != "" &&
            element.firstName != null
            ? element.firstName
            : ""
        );
        element.message = element.message.replace(
          /\${lastName}/g,
          element.lastName && element.lastName != "" && element.lastName != null
            ? element.lastName
            : ""
        );
        let verifyEmailData = EMAIL_INVITECOUPLE.replace(
          /#body#/g,
          element.message
        );
        // console.log("verifyEmailData", verifyEmailData);
        let ans = Email.sendEmail(
          element.email,
          element.subject,
          verifyEmailData
        );
      });
      if (succ) {
        return res.status(200).send({
          success: true,
          msg: " Email sent successfully.",
          data: succ,
        });
      } else {
        return res.status(200).send({
          msg: `Something went wrong. Please try again`,
          error: true,
          success: false,
        });
      }
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async deleteMail(req, res) {
    try {
      let delete_mail = await sendEmailSchema.destroy({
        where: { id: req.params.mail_id },
      });
      return res.status(200).send({
        success: true,
        msg: "Mail Deleted",
        data: delete_mail,
      });
    } catch (err) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }
}
module.exports = new SendEmailController();
