const db = require("../database/dbConnection");
const retreatRoastSchema = db.retreatRoaster;
const programSchema = db.program;
const directorySchema = db.directory;
const serviceSchema = db.service;
const { Op } = require("sequelize");
const { PROJECT_DIR } = require("../../config");
const { json } = require("body-parser");
const fs = require("fs");
const path = require("path");

class ProgramController {
  async getAllRoastersInfo(req, res) {
    try {
      let queryRecords = `SELECT 
    retreatroasters.id,retreats.id AS retreatId,retreatroasters.coupleId,retreatroasters.attendeeType,retreatroasters.roasterImage,
        retreatroasters.createdAt, retreatroasters.talk_question,
        couples.hisLastName, couples.hisFirstName,
        couples.herFirstName, couples.herLastName,
        couples.hisEmail, couples.primaryKey,
        couples.herEmail, couples.hisMobile, 
        couples.herMobile, couples.city, 
        couples.state, couples.zip, couples.notes, couples.imageUrl,couples.address,couples.allergies,couples.anniversary_date,couples.hear_us,couples.emergency_name1,couples.emergency_relationship1,couples.emergency_phone1,couples.emergency_name2,couples.emergency_relationship2,couples.emergency_phone2,couples.under_age_35,couples.referral_from_a_friend_or_family_member,parishes.parish, roles.role, services.service,talks.talk,couples.parishId,retreatroasters.roleId,retreatroasters.serviceId,retreatroasters.talkId FROM retreatroasters
        LEFT JOIN couples ON retreatroasters.coupleId = couples.id 
        LEFT JOIN parishes ON couples.parishId = parishes.id
        LEFT JOIN roles ON retreatroasters.roleId = roles.id
        LEFT JOIN services ON retreatroasters.serviceId = services.id
        LEFT JOIN talks ON retreatroasters.talkId = talks.id
        INNER JOIN retreats on retreatroasters.retreatId = retreats.id WHERE retreatroasters.retreatId = ${req.body.rereatId} AND retreatroasters.stage = "DRAFT"`;
      let queryRole = `${queryRecords} AND roles.role IS NOT NULL AND roles.role != ''`;
      let querySpeakers = `${queryRecords} AND retreatroasters.talkId IS NOT NULL AND retreatroasters.talkId != ''`;
      let queryServices = `${queryRecords} AND services.service IS NOT NULL AND services.service != ''`;
      let responseDataRole = await db.sequelize.query(queryRole);
      let responseSperakers = await db.sequelize.query(querySpeakers);
      let responseServices = await db.sequelize.query(queryServices);
      let wholeData = [
        { role: responseDataRole[0] },
        { speakers: responseSperakers[0] },
        { services: responseServices[0] },
      ];
      return res.status(200).send({
        success: true,
        data: wholeData,
      });
    } catch (error) {
      console.log("error:", error);
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async getProgramDetail(req, res) {
    try {
      let queryRecords = `SELECT programs.*,retreats.title,parishes.parish AS parishName,parishes.city AS parishCity,parishes.address AS parishAddress,parishes.state AS parishState,parishes.zip AS parishzip,parishes.link AS parishLink,parishes.imageUrl AS parishImageUrl,retreats.id AS retreatId FROM programs LEFT JOIN retreats ON programs.retreatId = retreats.id LEFT JOIN parishes ON retreats.parishId = parishes.id WHERE programs.retreatId = ${req.body.rereatId} AND programs.stage = "DRAFT"`;
      let getData = await db.sequelize.query(queryRecords);
      return res.status(200).send({
        success: true,
        data: getData[0],
      });
    } catch (error) {
      console.log("error:", error);
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async saveFile(file, folder, oldFilePath = null) {
    return new Promise((resolve, reject) => {
      try {
        const fileName = file.name;
        const fileUrl = path.join(PROJECT_DIR, folder, fileName);
        if (oldFilePath && fs.existsSync(oldFilePath)) {
          fs.unlinkSync(oldFilePath); // remove old file
        }
        file.mv(fileUrl, (err) => {
          if (err) reject(err);
          else resolve(fileUrl);
        });
      } catch (err) {
        reject(err);
      }
    });
  }

  async createProgram(req, res) {
    try {
      let succ;
      const { programId, retreatId, imageSelection, programField, text } =
        req.body;

      // ================== FILE UPLOADS ==================
      if (req.files && req.files.file) {
        const file = req.files.file;
        let imgUrl = `${process.env.SERVERADDRESS}/public/programImages/${file.name}`;
        let filePath = path.join(PROJECT_DIR, "programImages", file.name);

        if (imageSelection === "mainImage") {
          // If update, delete old file
          let oldData = programId
            ? await programSchema.findOne({
                where: { id: programId },
                raw: true,
              })
            : null;

          succ = programId
            ? await programSchema.update(
                { headerImage: imgUrl },
                { where: { id: programId } }
              )
            : await new programSchema({
                headerImage: imgUrl,
                retreatId,
                stage: "DRAFT",
              }).save();

          await saveFile(
            file,
            "programImages",
            oldData?.headerImage &&
              path.join(
                PROJECT_DIR,
                "programImages",
                path.basename(oldData.headerImage)
              )
          );

          return res.status(200).send({
            success: true,
            msg: programId ? "Header image updated" : "Header image uploaded",
            mode: programId ? "edit" : "create",
          });
        }

        if (imageSelection === "footerImages") {
          let program = await programSchema.findOne({
            where: { id: programId },
            raw: true,
          });
          let footerImages = program?.footerImages
            ? JSON.parse(program.footerImages)
            : [];

          footerImages.push(imgUrl);

          succ = programId
            ? await programSchema.update(
                { footerImages: JSON.stringify(footerImages) },
                { where: { id: programId } }
              )
            : await new programSchema({
                footerImages: JSON.stringify([imgUrl]),
                retreatId,
                stage: "DRAFT",
              }).save();

          await saveFile(file, "programImages");

          return res.status(200).send({
            success: true,
            msg: "Footer image added",
            mode: programId ? "edit" : "create",
          });
        }

        // QR Code Image
        succ = programId
          ? await programSchema.update(
              { qrCodeImage: imgUrl },
              { where: { id: programId } }
            )
          : await new programSchema({
              qrCodeImage: imgUrl,
              retreatId,
              stage: "DRAFT",
            }).save();

        await saveFile(file, "programImages");

        return res.status(200).send({
          success: true,
          msg: programId ? "QR-Code image updated" : "QR-Code image uploaded",
          mode: programId ? "edit" : "create",
        });
      }

      // ================== TEXT FIELDS ==================
      let fieldMap = {
        WisdomDescription: "wisdom_from_mt",
        ParishMission: "parishMission",
        tableContent: "tableContent",
        fbLink: "fbLink",
        guidelines: "guidelines",
      };

      if (programField && fieldMap[programField]) {
        const field = fieldMap[programField];
        if (!programId) {
          succ = await new programSchema({
            [field]: text,
            retreatId,
            stage: "DRAFT",
          }).save();
          return res
            .status(200)
            .send({
              success: true,
              msg: `${programField} added`,
              mode: "create",
            });
        } else {
          await programSchema.update(
            { [field]: text },
            { where: { id: programId } }
          );
          return res
            .status(200)
            .send({
              success: true,
              msg: `${programField} updated`,
              mode: "edit",
            });
        }
      }

      // Talk Question (special case)
      if (programField === "talk_question") {
        await retreatRoastSchema.update(
          { talk_question: text },
          { where: { id: req.body.roasterId } }
        );
        return res
          .status(200)
          .send({ success: true, msg: "Talk content updated", mode: "edit" });
      }

      return res.status(200).send({ success: false, msg: "Invalid request" });
    } catch (error) {
      console.log("error-->", error);
      return res
        .status(200)
        .json({ success: false, msg: error.message || error });
    }
  }

  async removeProgramImage(req, res) {
    try {
      let fieldToUpdate = "";
      let successMsg = "";

      if (req.body.checkImage === "mainImage") {
        fieldToUpdate = "headerImage";
        successMsg = "Header image has been removed.";
      } else {
        fieldToUpdate = "qrCodeImage";
        successMsg = "QR-Code image has been removed.";
      }

      // 1. Get program details first
      const programDetail = await programSchema.findOne({
        where: { id: req.body.id },
        raw: true,
      });

      if (programDetail && programDetail[fieldToUpdate]) {
        const imagePath = path.join(
          PROJECT_DIR,
          "programImages",
          path.basename(programDetail[fieldToUpdate])
        );

        // 2. Delete file if exists
        if (fs.existsSync(imagePath)) {
          fs.unlinkSync(imagePath);
        }
      }

      // 3. Update DB field
      let result = await programSchema.update(
        { [fieldToUpdate]: "" },
        { where: { id: req.body.id } }
      );

      if (result) {
        return res.status(200).send({
          success: true,
          msg: successMsg,
        });
      } else {
        return res.status(200).json({
          success: false,
          msg: "No record updated.",
        });
      }
    } catch (error) {
      console.log("error -->", error);
      return res.status(200).json({
        success: false,
        msg: error.message || error,
      });
    }
  }

  async removeProgramFooterImage(req, res) {
    try {
      let result = await programSchema.findOne({ where: { id: req.body.id } });
      if (result) {
        let parseData = JSON.parse(result.footerImages);
        const filteredData = parseData.filter((item) => item !== req.body.item);
        let j;
        if (filteredData && filteredData.length) {
          j = JSON.stringify(filteredData);
        } else {
          j = null;
        }
        let r = await programSchema.update(
          { footerImages: j },
          { where: { id: req.body.id } }
        );
      }
      return res.status(200).send({
        success: true,
        msg: "Footer Image removed.",
      });
    } catch (error) {
      console.log("error-->", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async togglePublishStatus(model, id) {
    let checkStatus = await model.findOne({ where: { id } });
    if (!checkStatus) {
      throw new Error(`Entry with ID ${id} not found.`);
    }
    const newStatus =
      checkStatus.status === "PUBLISH" ? "UNPUBLISH" : "PUBLISH";
    await model.update({ status: newStatus }, { where: { id } });
    return newStatus;
  }

  async changePublishStatus(req, res) {
    try {
      let result;
      if (req.body.select === "directory") {
        result = await this.togglePublishStatus(directorySchema, req.body.id);
      } else {
        result = await this.togglePublishStatus(programSchema, req.body.id);
      }
      return res.status(200).send({
        success: true,
        msg: `Status changed to ${result}.`,
      });
    } catch (error) {
      console.log("error-->", error);
      return res.status(200).json({
        success: false,
        msg: error.message,
      });
    }
  }

  async createRetreatTeam(req, res) {
    try {
      var findRoaster;
      if (req.body.coupleId) {
        findRoaster = await retreatRoastSchema.findOne({
          where: {
            [Op.and]: [
              { retreatId: req.body.retreatId },
              { coupleId: req.body.coupleId },
            ],
          },
        });
      }
      let succ;
      if (req.body.selection === "forRole") {
        if (!req.body.roleId && !req.body.coupleId) {
          return res.send({
            error: true,
            msg: "Please select Role and Couple.",
          });
        } else if (!req.body.roleId && req.body.coupleId) {
          return res.send({
            error: true,
            msg: "Please select Role.",
          });
        } else if (req.body.roleId && !req.body.coupleId) {
          return res.send({
            error: true,
            msg: "Please select Couple Role.",
          });
        } else {
          if (!findRoaster) {
            let newRoaster = new retreatRoastSchema({
              roleId: req.body.roleId,
              retreatId: req.body.retreatId,
              coupleId: req.body.coupleId,
              attendeeType: "TEAM",
              stage: "DRAFT",
            });
            succ = await newRoaster.save();
            if (succ) {
              return res.status(200).send({
                success: true,
                msg: "New Retreat Team added to the Program.",
              });
            }
          } else {
            succ = await retreatRoastSchema.update(
              {
                roleId: req.body.roleId,
                retreatId: req.body.retreatId,
                coupleId: req.body.coupleId,
                attendeeType: "TEAM",
                stage: "DRAFT",
              },
              { where: { id: findRoaster.id } }
            );
            return res.status(200).send({
              success: true,
              msg: "Couple updated in the roster.",
            });
          }
        }
      } else if (req.body.selection === "forTalk") {
        if (!req.body.talkId && !req.body.coupleId) {
          return res.send({
            error: true,
            msg: "Please select Talk and Couple.",
          });
        } else if (!req.body.talkId && req.body.coupleId) {
          return res.send({
            error: true,
            msg: "Please select Talk.",
          });
        } else if (req.body.talkId && !req.body.coupleId) {
          return res.send({
            error: true,
            msg: "Please select Couple for Talk.",
          });
        } else {
          if (!findRoaster) {
            let newRoaster = new retreatRoastSchema({
              talkId: req.body.talkId,
              retreatId: req.body.retreatId,
              coupleId: req.body.coupleId,
              attendeeType: "TEAM",
              stage: "DRAFT",
            });
            succ = await newRoaster.save();
            if (succ) {
              return res.status(200).send({
                success: true,
                msg: "New Speaker added to the Program.",
              });
            }
          } else {
            succ = await retreatRoastSchema.update(
              {
                talkId: req.body.talkId,
                retreatId: req.body.retreatId,
                coupleId: req.body.coupleId,
                attendeeType: "TEAM",
                stage: "DRAFT",
              },
              { where: { id: findRoaster.id } }
            );
            return res.status(200).send({
              success: true,
              msg: "Couple updated in the roster.",
            });
          }
        }
      } else if (req.body.selection === "forService") {
        if (!req.body.serviceId && !req.body.coupleId) {
          return res.send({
            error: true,
            msg: "Please select Service and Couple.",
          });
        } else if (!req.body.serviceId && req.body.coupleId) {
          return res.send({
            error: true,
            msg: "Please select Talk.",
          });
        } else if (req.body.serviceId && !req.body.coupleId) {
          return res.send({
            error: true,
            msg: "Please select Couple for Talk.",
          });
        } else {
          if (!findRoaster) {
            let newRoaster = new retreatRoastSchema({
              serviceId: req.body.serviceId,
              retreatId: req.body.retreatId,
              coupleId: req.body.coupleId,
              attendeeType: "TEAM",
              stage: "DRAFT",
            });
            succ = await newRoaster.save();
            if (succ) {
              return res.status(200).send({
                success: true,
                msg: "New Support Team added to the Program.",
              });
            }
          } else {
            succ = await retreatRoastSchema.update(
              {
                serviceId: req.body.serviceId,
                retreatId: req.body.retreatId,
                coupleId: req.body.coupleId,
                attendeeType: "TEAM",
                stage: "DRAFT",
              },
              { where: { id: findRoaster.id } }
            );
            return res.status(200).send({
              success: true,
              msg: "Couple updated in the roster.",
            });
          }
        }
      }
    } catch (error) {
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async deleteRoasterCouple(req, res) {
    try {
      if (req.body.id) {
        let delete_couple = await retreatRoastSchema.destroy({
          where: { id: req.body.id },
        });
        return res.status(200).send({
          success: true,
          msg: "Couple removed from retreat roster.",
        });
      }
    } catch (error) {
      console.log("error-->", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }
}

module.exports = new ProgramController();
