const db = require("../database/dbConnection");
const retreatRoastSchema = db.retreatRoaster;
const directorySchema = db.directory;
const coupleSchema = db.couple;
const userSchema = db.user;
const { PROJECT_DIR } = require("../../config");
const { Op, Sequelize } = require("sequelize");
const fs = require("fs");
const path = require("path");

class DirectoryController {
  async getAllRoastersOfRetreat(req, res) {
    try {
      if (req.body.rereatId) {
        let queryRecords = `SELECT 
    retreatroasters.id,retreats.id AS retreatId,retreatroasters.coupleId,retreatroasters.attendeeType,
        retreatroasters.createdAt, 
        couples.hisLastName, couples.hisFirstName,
        couples.herFirstName, couples.herLastName,
        couples.hisEmail, couples.primaryKey,
        couples.herEmail, couples.hisMobile, 
        couples.herMobile, couples.city, 
        couples.state, couples.zip, couples.notes, couples.imageUrl,couples.address,couples.allergies,couples.anniversary_date,couples.hear_us,couples.emergency_name1,couples.emergency_relationship1,couples.emergency_phone1,couples.emergency_name2,couples.emergency_relationship2,couples.emergency_phone2,couples.under_age_35,couples.referral_from_a_friend_or_family_member,parishes.parish, roles.role, services.service,talks.talk,couples.parishId,retreatroasters.roleId,retreatroasters.serviceId,retreatroasters.talkId FROM retreatroasters
        LEFT JOIN couples ON retreatroasters.coupleId = couples.id 
        LEFT JOIN parishes ON couples.parishId = parishes.id
        LEFT JOIN roles ON retreatroasters.roleId = roles.id
        LEFT JOIN services ON retreatroasters.serviceId = services.id
        LEFT JOIN talks ON retreatroasters.talkId = talks.id
        INNER JOIN retreats on retreatroasters.retreatId = retreats.id WHERE retreatroasters.retreatId = ${req.body.rereatId}`;

        // Constructing queries for different role types
        let queryLead = `${queryRecords} AND roles.role = "Lead" ORDER BY couples.hisLastName ASC`;

        let queryCoLead = `${queryRecords} AND roles.role ="Co-Lead" ORDER BY couples.hisLastName ASC`;

        let queryMentor = `${queryRecords} AND roles.role = "Mentor" ORDER BY couples.hisLastName ASC`;

        let querySpritualAdvisor = `${queryRecords} AND roles.role = "Spiritual Mentor" ORDER BY couples.hisLastName ASC`;

        let querySpritualDirector = `${queryRecords} AND roles.role = "Spiritual Director" ORDER BY couples.hisLastName ASC`;

        let queryTeam = `${queryRecords} AND retreatroasters.attendeeType="Team"  ORDER BY couples.hisLastName ASC`;

        let queryRetreatant = `${queryRecords} AND retreatroasters.attendeeType="Retreatant"  ORDER BY couples.hisLastName ASC`;
        let responseDataLead = await db.sequelize.query(queryLead);
        let responseDataCoLead = await db.sequelize.query(queryCoLead);
        let responseDataMentor = await db.sequelize.query(queryMentor);
        let responseDataTeam = await db.sequelize.query(queryTeam);
        let responseDataSprAdvisor = await db.sequelize.query(
          querySpritualAdvisor
        );
        let responseDataSprDirector = await db.sequelize.query(
          querySpritualDirector
        );

        const leadCoupleIds =
          responseDataLead &&
          responseDataLead[0].map((couple) => couple.coupleId);

        const coLeadCoupleIds =
          responseDataCoLead &&
          responseDataCoLead[0].map((couple) => couple.coupleId);

        const mentorCoupleIds =
          responseDataMentor &&
          responseDataMentor[0].map((couple) => couple.coupleId);

        const sprAdvisorCoupleIds =
          responseDataSprAdvisor &&
          responseDataSprAdvisor[0].map((couple) => couple.coupleId);

        const sprDirectorCoupleIds =
          responseDataSprDirector &&
          responseDataSprDirector[0].map((couple) => couple.coupleId);

        let responseDataTeam1 =
          responseDataTeam &&
          responseDataTeam[0].filter((couple) => {
            const coupleId = couple.coupleId;
            return (
              !leadCoupleIds.includes(coupleId) &&
              !coLeadCoupleIds.includes(coupleId) &&
              !mentorCoupleIds.includes(coupleId) &&
              !sprAdvisorCoupleIds.includes(coupleId) &&
              !sprDirectorCoupleIds.includes(coupleId)
            );
          });

        let responseDataRetreatant = await db.sequelize.query(queryRetreatant);
        let responseDataRetreatant1 =
          responseDataRetreatant &&
          responseDataRetreatant[0].filter((couple) => {
            const coupleId = couple.coupleId;
            return (
              !leadCoupleIds.includes(coupleId) &&
              !coLeadCoupleIds.includes(coupleId) &&
              !mentorCoupleIds.includes(coupleId) &&
              !sprAdvisorCoupleIds.includes(coupleId) &&
              !sprDirectorCoupleIds.includes(coupleId)
            );
          });

        let wholeData = [
          { lead: responseDataLead[0] },
          { coLead: responseDataCoLead[0] },
          { mentor: responseDataMentor[0] },
          { sprAdvisor: responseDataSprAdvisor[0] },
          { sprDirector: responseDataSprDirector[0] },
          { team: responseDataTeam1 },
          { retreatant: responseDataRetreatant1 },
        ];
        return res.status(200).send({
          success: true,
          data: wholeData,
        });
      } else {
        return res.status(200).send({
          success: false,
          msg: "RereatId is undefined.",
        });
      }
    } catch (error) {
      console.log("error:", error);
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async getDirectoryDetail(req, res) {
    try {
      if (req.body.rereatId) {
        let queryRecords = `SELECT directories.*,retreats.id AS retreatId FROM directories LEFT JOIN retreats ON directories.retreatId = retreats.id WHERE directories.retreatId = ${req.body.rereatId}`;
        let getData = await db.sequelize.query(queryRecords);
        return res.status(200).send({
          success: true,
          data: getData[0],
        });
      } else {
        return res.status(200).send({
          success: fasle,
          msg: "RereatId is undefined.",
        });
      }
    } catch (error) {
      console.log("error:", error);
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async createDirectory(req, res) {
    try {
      const { directoryId, retreatId, imageSelection, headerText } = req.body;

      // Function to move uploaded file
      const moveFile = (file, filePath) =>
        new Promise((resolve, reject) => {
          file.mv(filePath, (err) => {
            if (err) reject(err);
            else resolve();
          });
        });

      let succ;
      if (req.files && req.files.file) {
        const file = req.files.file;
        const fileName = file.name;
        const folder =
          imageSelection === "mainImage"
            ? "directoryImages"
            : "directoryImages";
        const fileUrl = path.join(PROJECT_DIR, folder, fileName);
        const imgUrl = `${process.env.SERVERADDRESS}/public/${folder}/${fileName}`;

        if (!directoryId || directoryId === "undefined") {
          // Create new directory
          const newDir = new directorySchema({
            [imageSelection === "mainImage" ? "headerImage" : "footerImage"]:
              imgUrl,
            retreatId,
          });
          succ = await newDir.save();
        } else {
          // Edit existing directory
          const directoryDetail = await directorySchema.findOne({
            where: { id: directoryId },
            raw: true,
          });

          if (directoryDetail) {
            const oldImage =
              imageSelection === "mainImage"
                ? directoryDetail.headerImage
                : directoryDetail.footerImage;
            if (oldImage) {
              const oldFilePath = path.join(
                PROJECT_DIR,
                "directoryImages",
                path.basename(oldImage)
              );
              if (fs.existsSync(oldFilePath)) fs.unlinkSync(oldFilePath);
            }
          }

          succ = await directorySchema.update(
            {
              [imageSelection === "mainImage" ? "headerImage" : "footerImage"]:
                imgUrl,
            },
            { where: { id: directoryId } }
          );
        }

        if (succ) await moveFile(file, fileUrl);

        return res.status(200).send({
          success: true,
          msg: `${
            imageSelection === "mainImage" ? "Header" : "Footer1"
          } image has been ${!directoryId ? "uploaded" : "updated"}.`,
          mode: !directoryId ? "create" : "edit",
        });
      } else {
        // Only text (no file)
        if (!directoryId || directoryId === "undefined") {
          const newDir = new directorySchema({
            footerText: headerText,
            retreatId,
          });
          succ = await newDir.save();
        } else {
          succ = await directorySchema.update(
            { footerText: headerText },
            { where: { id: directoryId } }
          );
        }

        return res.status(200).send({
          success: true,
          msg: !directoryId
            ? "Directory Footer has been added"
            : "Directory Footer has been updated",
          mode: !directoryId ? "create" : "edit",
        });
      }
    } catch (error) {
      console.log("error-->", error);
      return res.status(200).json({
        success: false,
        msg: error.message || error,
      });
    }
  }

  async saveCoupleImage(req, res) {
    try {
      if (req.files) {
        let file;
        let fileUrl;
        file = req.files.file;
        let fileName = file.name;
        fileUrl = PROJECT_DIR + "/profileImage/" + fileName;
        let imgUrl =
          process.env.SERVERADDRESS + "/public/profileImage/" + fileName;
        let result = await coupleSchema.update(
          { imageUrl: imgUrl },
          { where: { id: req.body.coupleId } }
        );
        await userSchema.update(
          { imageUpload: imgUrl },
          {
            where: {
              [Op.or]: [{ coupleId: req.body.coupleId }],
            },
          }
        );
        if (result) {
          file.mv(fileUrl, async function (err) {
            if (err) {
              return false;
            }
            return true;
          });
        }
        return res.status(200).send({
          success: true,
          msg: "Couple image uploaded successfully.",
        });
      } else {
        return res.status(200).send({
          msg: `Something went wrong. Please try again.`,
          error: true,
          success: false,
        });
      }
    } catch (error) {
      console.log("error-->", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async removeImage(req, res) {
    try {
      const coupleDetail = await coupleSchema.findOne({
        where: { id: req.body.id },
        raw: true,
      });

      if (coupleDetail && coupleDetail.imageUrl) {
        const profileImagePath = path.join(
          PROJECT_DIR,
          "profileImage",
          path.basename(coupleDetail.imageUrl)
        );

        // Delete file if it exists
        if (fs.existsSync(profileImagePath)) {
          fs.unlinkSync(profileImagePath);
        }
      }

      // Clear image from coupleSchema
      let result = await coupleSchema.update(
        { imageUrl: "" },
        { where: { id: req.body.id } }
      );

      // Clear image from userSchema
      await userSchema.update(
        { imageUpload: "" },
        { where: { coupleId: req.body.id } }
      );

      if (result) {
        return res.status(200).send({
          success: true,
          msg: "Couple image removed successfully.",
        });
      } else {
        return res.status(200).json({
          success: false,
          msg: "No record updated.",
        });
      }
    } catch (error) {
      console.log("error -->", error);
      return res.status(200).json({
        success: false,
        msg: error.message || error,
      });
    }
  }

  async removeDirectoryImage(req, res) {
    try {
      let fieldToUpdate = "";
      let successMsg = "";

      if (req.body.checkImage === "mainImage") {
        fieldToUpdate = "headerImage";
        successMsg = "Header image has been removed.";
      } else if (req.body.checkImage === "footerImage") {
        fieldToUpdate = "footerImage";
        successMsg = "Footer image has been removed.";
      }

      // Get current image details
      const directoryDetail = await directorySchema.findOne({
        where: { id: req.body.id },
        raw: true,
      });

      if (directoryDetail && directoryDetail[fieldToUpdate]) {
        const imagePath = path.join(
          PROJECT_DIR,
          "directoryImages",
          path.basename(directoryDetail[fieldToUpdate])
        );

        // Delete file if exists
        if (fs.existsSync(imagePath)) {
          fs.unlinkSync(imagePath);
        }
      }

      // Update DB to clear the image field
      let result = await directorySchema.update(
        { [fieldToUpdate]: "" },
        { where: { id: req.body.id } }
      );

      if (result) {
        return res.status(200).send({
          success: true,
          msg: successMsg,
        });
      } else {
        return res.status(200).json({
          success: false,
          msg: "No record updated.",
        });
      }
    } catch (error) {
      console.log("error -->", error);
      return res.status(200).json({
        success: false,
        msg: error.message || error,
      });
    }
  }

  async uploadLinks(req, res) {
    try {
      const { directoryId, socialLinks } = req.body;

      if (!directoryId) {
        return res.status(200).send({
          success: false,
          msg: "Directory ID is required.",
        });
      }

      const succ = await directorySchema.update(
        { socialLinks: socialLinks },
        { where: { id: directoryId } }
      );

      if (succ) {
        return res.status(200).send({
          success: true,
          msg: "Social links updated successfully.",
          data: socialLinks,
        });
      } else {
        return res.status(200).send({
          success: false,
          msg: "Directory not found.",
        });
      }
    } catch (error) {
      console.error("uploadLinks error:", error);
      return res.status(200).send({
        success: false,
        msg: "Server error while saving links.",
      });
    }
  }
}

module.exports = new DirectoryController();
