const moment = require("moment-timezone");
const Email = require("../helper/sendEmail");
const db = require("../database/dbConnection");
const retreatRoastSchema = db.retreatRoaster;
const retreatSchema = db.retreat;
const {
  EMAIL_COUPLEASADMIN,
  DELETE_MESSAGE,
  SENDLOGINDETAILBYADMIN,
  SENDLOGINDETAILTOSUBADMIN,
} = require("../helper/emailTemplate");
const { Op, Sequelize } = require("sequelize");
const coupleSchema = db.couple;
const parishSchema = db.parish;
const userSchema = db.user;
const logReportSchema = db.logreport;
const { PROJECT_DIR } = require("../../config");
const fs = require("fs");
const path = require("path");

class AdminController {
  async createCouple(req, res) {
    let {
      primaryKey,
      hisFirstName,
      hisLastName,
      hisEmail,
      hisMobile,
      herFirstName,
      herLastName,
      herEmail,
      herMobile,
      city,
      state,
      notes,
      parishId,
      zip,
      address,
      allergies,
      anniversary_date,
      under_age_35,
      emergency_name1,
      emergency_relationship1,
      emergency_phone1,
      emergency_name2,
      emergency_relationship2,
      emergency_phone2,
      hear_us,
      referral_from_a_friend_or_family_member,
    } = JSON.parse(`${req.body.fromData}`);
    try {
      //Validations
      if (!(hisFirstName || hisLastName || herFirstName || herLastName)) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Please add at least one name.",
        });
      }
      if (!hisEmail && !herEmail) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Please add at least one email ID.",
        });
      }
      // if (hisEmail === herEmail) {
      //   return res.status(200).json({
      //     success: false,
      //     error: true,
      //     msg: "His Email and Her Email should be different.",
      //   });
      // }
      let checkMailInDb = await coupleSchema.findOne({
        where: {
          [Op.or]: [
            {
              [Op.and]: [
                { hisEmail: { [Op.ne]: null } },
                { hisEmail: { [Op.ne]: "" } },
                { [Op.or]: [{ hisEmail: hisEmail }, { hisEmail: herEmail }] },
              ],
            },
            {
              [Op.and]: [
                { herEmail: { [Op.ne]: null } },
                { herEmail: { [Op.ne]: "" } },
                { [Op.or]: [{ herEmail: hisEmail }, { herEmail: herEmail }] },
              ],
            },
          ],
        },
      });
      if (checkMailInDb) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "This email is already exist.",
        });
      }
      const normalizedHisMobile = hisMobile && hisMobile.replace(/\D/g, "");
      const normalizedHerMobile = herMobile && herMobile.replace(/\D/g, "");
      let checkMobileInDb = await coupleSchema.findOne({
        where: {
          [Op.or]: [
            {
              [Op.and]: [
                { hisMobile: { [Op.ne]: null } },
                { hisMobile: { [Op.ne]: "" } },
                Sequelize.literal(
                  `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
                ),
              ],
            },
            {
              [Op.and]: [
                { hisMobile: { [Op.ne]: null } },
                { hisMobile: { [Op.ne]: "" } },
                Sequelize.literal(
                  `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
                ),
              ],
            },
            {
              [Op.and]: [
                { herMobile: { [Op.ne]: null } },
                { herMobile: { [Op.ne]: "" } },
                Sequelize.literal(
                  `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
                ),
              ],
            },
            {
              [Op.and]: [
                { herMobile: { [Op.ne]: null } },
                { herMobile: { [Op.ne]: "" } },
                Sequelize.literal(
                  `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
                ),
              ],
            },
          ],
        },
      });
      if (checkMobileInDb) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "This mobile number already exists.",
        });
      }
      if (primaryKey) {
        const primaryKeyCheck = await coupleSchema.findOne({
          where: { primaryKey: primaryKey },
        });
        if (primaryKeyCheck) {
          return res.status(200).json({
            success: false,
            error: true,
            msg: "Primary Key already exists.",
          });
        }
      } else {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Primary Key is required.",
        });
      }
      let jsonObj = JSON.parse(req.body.fromData);
      ["hisEmail", "herEmail", "hisMobile", "herMobile"].forEach((field) => {
        if (jsonObj[field] === "") {
          jsonObj[field] = null;
        }
      });
      if (jsonObj.anniversary_date === "") {
        jsonObj.anniversary_date = null;
      }
      if (jsonObj.hear_us) {
        jsonObj.hear_us = JSON.stringify(hear_us);
      }
      jsonObj.accountStatus = "ACTIVE";
      jsonObj.emailVarified = false;
      delete jsonObj.id;
      //Create new couple
      let newUser = new coupleSchema(jsonObj);
      let succ = await newUser.save();
      let getCoupleSavedPK = await coupleSchema.findAll({
        where: {
          primaryKey: primaryKey,
        },
        raw: true,
      });
      let imageSavedCouple;
      if (req.files) {
        imageSavedCouple = await this.saveImageForCouple(
          req.files,
          getCoupleSavedPK[0].id
        );
      }
      let newCouple = await coupleSchema.findOne({
        where: {
          id: succ.id,
        },
        raw: true,
      });
      let paswordForCouple1;
      let paswordForCouple2;
      if (hisEmail) {
        let randompass1 = Math.random().toString(36).slice(-8);
        paswordForCouple1 =
          randompass1.slice(0, 0) + "p" + randompass1.slice(1);
      }
      if (herEmail) {
        let randompass2 = Math.random().toString(36).slice(-8);
        paswordForCouple2 =
          randompass2.slice(0, 0) + "p" + randompass2.slice(1);
      }
      let adminObj = [
        {
          userName: newCouple && newCouple.hisFirstName,
          firstName:
            newCouple && newCouple.hisFirstName ? newCouple.hisFirstName : "",
          lastName:
            newCouple && newCouple.hisLastName ? newCouple.hisLastName : "",
          mobile: newCouple && newCouple.hisMobile ? newCouple.hisMobile : "",
          email: newCouple && newCouple.hisEmail,
          password: paswordForCouple1 ? paswordForCouple1 : null,
          accountStatus: "ACTIVE",
          userRole: "COUPLE",
          coupleId: newCouple && newCouple.id,
          imageUpload: newCouple && newCouple.imageUrl,
        },
        {
          userName: newCouple && newCouple.herFirstName,
          firstName:
            newCouple && newCouple.herFirstName ? newCouple.herFirstName : "",
          lastName:
            newCouple && newCouple.herLastName ? newCouple.herLastName : "",
          mobile: newCouple && newCouple.herMobile ? newCouple.herMobile : "",
          email: newCouple && newCouple.herEmail,
          password: paswordForCouple2 ? paswordForCouple2 : null,
          accountStatus: "ACTIVE",
          userRole: "COUPLE",
          coupleId: newCouple && newCouple.id,
          imageUpload: newCouple && newCouple.imageUrl,
        },
      ];
      if (succ.hisEmail && succ.hisEmail !== "" && succ.hisEmail !== null) {
        let checkUser = await userSchema.findOne({
          where: { email: succ.hisEmail },
        });
        if (checkUser) {
          const updateUser = await userSchema.update(
            {
              userName: newCouple && newCouple.hisFirstName,
              coupleId: newCouple && newCouple.id,
              firstName:
                newCouple && newCouple.hisFirstName
                  ? newCouple.hisFirstName
                  : "",
              lastName:
                newCouple && newCouple.hisLastName ? newCouple.hisLastName : "",
              mobile:
                newCouple && newCouple.hisMobile ? newCouple.hisMobile : "",
              imageUpload: newCouple && newCouple.imageUrl,
            },
            { where: { id: checkUser.id } }
          );

          let replData = SENDLOGINDETAILBYADMIN.replace(
            /#firstName#/g,
            succ.hisFirstName ? succ.hisFirstName : ""
          )
            .replace(/#lastName#/g, succ.hisLastName ? succ.hisLastName : "")
            .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)

            .replace(/#email#/g, hisEmail ? hisEmail : "Nil")

            .replace(
              /#password#/g,
              checkUser.password ? checkUser.password : "Nil"
            );
          Email.sendEmail(
            succ.hisEmail,
            "Login Details - LOVESTRONG Marriage",
            replData
          );
        } else {
          userSchema.create(adminObj[0]);
          let replData = SENDLOGINDETAILBYADMIN.replace(
            /#firstName#/g,
            succ.hisFirstName ? succ.hisFirstName : ""
          )
            .replace(/#lastName#/g, succ.hisLastName ? succ.hisLastName : "")
            .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)

            .replace(/#email#/g, hisEmail ? hisEmail : "Nil")

            .replace(
              /#password#/g,
              paswordForCouple1 ? paswordForCouple1 : "Nil"
            );
          Email.sendEmail(
            succ.hisEmail,
            "Login Details - LOVESTRONG Marriage ",
            replData
          );
        }
      }
      if (succ.herEmail && succ.herEmail !== "" && succ.herEmail !== null) {
        let checkUser1 = await userSchema.findOne({
          where: { email: succ.herEmail },
        });
        if (checkUser1) {
          const updateUser1 = await userSchema.update(
            {
              userName: newCouple.herFirstName,
              coupleId: newCouple.id,
              firstName: newCouple.herFirstName ? newCouple.herFirstName : "",
              lastName: newCouple.herLastName ? newCouple.herLastName : "",
              mobile: newCouple.herMobile ? newCouple.herMobile : "",
              imageUpload: newCouple.imageUrl,
            },
            { where: { id: checkUser1.id } }
          );

          let replData = SENDLOGINDETAILBYADMIN.replace(
            /#firstName#/g,
            succ.herFirstName ? succ.herFirstName : ""
          )
            .replace(/#lastName#/g, succ.herLastName ? succ.herLastName : "")
            .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)

            .replace(/#email#/g, herEmail ? herEmail : "Nil")
            .replace(
              /#password#/g,
              checkUser1.password ? checkUser1.password : "Nil"
            );
          Email.sendEmail(
            succ.herEmail,
            "Login Details- LOVESTRONG Marriage",
            replData
          );
        } else {
          userSchema.create(adminObj[1]);
          let replData = SENDLOGINDETAILBYADMIN.replace(
            /#firstName#/g,
            succ.herFirstName ? succ.herFirstName : ""
          )
            .replace(/#lastName#/g, succ.herLastName ? succ.herLastName : "")
            .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)

            .replace(/#email#/g, herEmail ? herEmail : "Nil")
            .replace(
              /#password#/g,
              paswordForCouple2 ? paswordForCouple2 : "Nil"
            );
          Email.sendEmail(
            succ.herEmail,
            "Login Details - LOVESTRONG Marriage",
            replData
          );
        }
      }
      if (succ) {
        return res.status(200).send({
          success: true,
          msg: "Couple added successfully.",
          data: succ,
        });
      } else {
        return res.status(200).send({
          msg: `Something went wrong. Please try again.`,
          error: true,
          success: false,
        });
      }
    } catch (error) {
      console.log(
        `createCouple [${new Date().toLocaleString("en-US", {
          timeZoneName: "short",
        })}] error -->`,
        error
      );
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async saveImageForCouple(files, coupleId) {
    try {
      let updateData = {}; // Object to hold the fields to be updated
      let coupleDetail = await coupleSchema.findOne({
        where: { id: coupleId },
        raw: true,
      });
      if (files.file && files.file != "null") {
        const file = files.file;
        const now = new Date();
        const currentDate = now.toISOString().split("T")[0];
        const fileExtension = file.name.substring(file.name.lastIndexOf("."));
        const fileName = `${coupleDetail.hisLastName}, ${coupleDetail.hisFirstName} & ${coupleDetail.herFirstName}_${currentDate}${fileExtension}`;
        const fileUrl = PROJECT_DIR + "/profileImage/" + fileName;
        const imgUrl =
          process.env.SERVERADDRESS + "/public/profileImage/" + fileName;

        // Add imageUrl to the update object
        updateData.imageUrl = imgUrl;

        // Move the file to the destination
        file.mv(fileUrl, async function (err) {
          if (err) {
            return false;
          }
        });
      }

      // Check if the Wedding image file is provided
      // if (files.marriage_file && files.marriage_file != "null") {
      //   const marriageFile = files.marriage_file;
      //   const marriageFileName = marriageFile.name;
      //   const marriageFileUrl =
      //     PROJECT_DIR + "/profileImage/" + marriageFileName;
      //   const marriageImgUrl =
      //     process.env.SERVERADDRESS +
      //     "/public/profileImage/" +
      //     marriageFileName;

      //   // Add marriageImageUrl to the update object
      //   updateData.marriageImageUrl = marriageImgUrl;

      //   // Move the marriage file to the destination
      //   marriageFile.mv(marriageFileUrl, async function (err) {
      //     if (err) {
      //       return false;
      //     }
      //   });
      // }
      // If there is anything to update
      if (Object.keys(updateData).length > 0) {
        await coupleSchema.update(updateData, { where: { id: coupleId } });
        return true;
      } else {
        return false; // No update was made since no files were provided
      }
    } catch (error) {
      return error;
    }
  }

  async makeCoupleAsSubAdmin(req, res) {
    try {
      let { id, value, adminType } = req.body;
      let paswordForCouple1 = "";
      let paswordForCouple2 = "";
      let userRole =
        adminType && adminType === "SUBADMIN" && value == 1
          ? "SUBADMIN"
          : adminType && adminType === "ADMIN" && value == 1
          ? "ADMIN"
          : adminType && adminType === "SUBADMIN" && value == 0
          ? "COUPLE"
          : adminType && adminType === "ADMIN" && value == 0
          ? "SUBADMIN"
          : "";
      if (userRole == "SUBADMIN" && value == 0) value = 1;
      let makeAdmin = await coupleSchema.update(
        {
          isAdminRight: value,
          userRole: userRole,
        },
        {
          where: { id: id },
          raw: true,
        }
      );

      let updateAdmin = await coupleSchema.findAll({
        where: {
          id: id,
        },
        raw: true,
      });

      if (updateAdmin && updateAdmin[0].hisEmail) {
        let randompass1 = Math.random().toString(36).slice(-8);
        paswordForCouple1 =
          randompass1.slice(0, 0) + "p" + randompass1.slice(1);
      }

      if (updateAdmin && updateAdmin[0].herEmail) {
        let randompass2 = Math.random().toString(36).slice(-8);
        paswordForCouple2 =
          randompass2.slice(0, 0) + "p" + randompass2.slice(1);
      }

      let adminObjHis = {
        userName: updateAdmin[0].hisFirstName
          ? updateAdmin[0].hisFirstName
          : "",
        firstName: updateAdmin[0].hisFirstName
          ? updateAdmin[0].hisFirstName
          : "",
        lastName: updateAdmin[0].hisLastName ? updateAdmin[0].hisLastName : "",
        mobile: updateAdmin[0].hisMobile ? updateAdmin[0].hisMobile : "",
        email:
          updateAdmin[0] && updateAdmin[0].hisEmail
            ? updateAdmin[0].hisEmail
            : "",
        password: paswordForCouple1,
        emailVerified: 1,
        userRole: userRole,
        coupleId: updateAdmin[0] && updateAdmin[0].id,
        imageUpload: updateAdmin[0].imageUrl,
      };

      let adminObjHer = {
        userName: updateAdmin[0].herFirstName
          ? updateAdmin[0].herFirstName
          : "",
        firstName: updateAdmin[0].herFirstName
          ? updateAdmin[0].herFirstName
          : "",
        lastName: updateAdmin[0].herLastName ? updateAdmin[0].herLastName : "",
        mobile: updateAdmin[0].herMobile ? updateAdmin[0].herMobile : "",
        email:
          updateAdmin[0] && updateAdmin[0].herEmail
            ? updateAdmin[0].herEmail
            : "",
        password: paswordForCouple2,

        emailVerified: 1,
        userRole: userRole,
        coupleId: updateAdmin[0] && updateAdmin[0].id,
        imageUpload: updateAdmin[0].imageUrl,
      };

      if (updateAdmin && updateAdmin.length > 0) {
        if (updateAdmin[0].isAdminRight) {
          let flag = false;

          if (
            updateAdmin[0] &&
            updateAdmin[0].hisEmail &&
            updateAdmin[0].hisEmail != ""
          ) {
            let updateAdmin1 = await userSchema.findAll({
              where: {
                email: updateAdmin[0].hisEmail,
              },
              raw: true,
            });
            if (updateAdmin1.length > 0) {
              let update = await userSchema.update(
                {
                  emailVerified: 1,
                  userRole: userRole,
                },
                {
                  where: { coupleId: updateAdmin[0].id },
                  raw: true,
                }
              );
              if (update) flag = true;
              if (userRole === "SUBADMIN") {
                let verifyEmailData = EMAIL_COUPLEASADMIN.replace(
                  /#firstname#/g,
                  updateAdmin[0].hisFirstName
                )
                  .replace(/#email#/g, updateAdmin[0].hisEmail)
                  .replace(/#password#/g, updateAdmin1[0].password);
                let ans = Email.sendEmail(
                  updateAdmin[0].hisEmail,
                  "Couple As Admin",
                  verifyEmailData
                );
              }
            } else {
              let newUser = new userSchema(adminObjHis);
              let entryInUserColl = await newUser.save();
              if (entryInUserColl) flag = true;
              if (userRole === "SUBADMIN") {
                let verifyEmailData = EMAIL_COUPLEASADMIN.replace(
                  /#firstname#/g,
                  updateAdmin[0].hisFirstName
                )
                  .replace(/#email#/g, updateAdmin[0].hisEmail)
                  .replace(/#password#/g, paswordForCouple1);
                let ans = Email.sendEmail(
                  updateAdmin[0].hisEmail,
                  "Couple As Admin",
                  verifyEmailData
                );
              }
            }
          }
          if (
            updateAdmin[0] &&
            updateAdmin[0].herEmail &&
            updateAdmin[0].hisEmail != ""
          ) {
            let updateAdmin1 = await userSchema.findAll({
              where: {
                email: updateAdmin[0].herEmail,
              },
              raw: true,
            });

            if (updateAdmin1.length > 0) {
              let update = await userSchema.update(
                {
                  emailVerified: 1,
                  userRole: userRole,
                },
                {
                  where: { coupleId: updateAdmin[0].id },
                  raw: true,
                }
              );
              if (update) flag = true;

              if (userRole === "SUBADMIN") {
                let verifyEmailData = EMAIL_COUPLEASADMIN.replace(
                  /#firstname#/g,
                  updateAdmin[0].herFirstName
                )
                  .replace(/#email#/g, updateAdmin[0].herEmail)
                  .replace(/#password#/g, updateAdmin1[0].password);
                let ans = Email.sendEmail(
                  updateAdmin[0].herEmail,
                  "Couple As Admin",
                  verifyEmailData
                );
              }
            } else {
              let newUser = new userSchema(adminObjHer);
              let entryInUserColl = await newUser.save();
              if (entryInUserColl) flag = true;
              if (userRole === "SUBADMIN") {
                let verifyEmailData = EMAIL_COUPLEASADMIN.replace(
                  /#firstname#/g,
                  updateAdmin[0].herFirstName
                )
                  .replace(/#email#/g, updateAdmin[0].herEmail)
                  .replace(/#password#/g, paswordForCouple2);
                let ans = Email.sendEmail(
                  updateAdmin[0].herEmail,
                  "Couple As Admin",
                  verifyEmailData
                );
              }
            }
          }

          if (flag) {
            return res.status(200).send({
              success: true,
              msg:
                adminType && adminType === "SUBADMIN"
                  ? "Couple made as Sub-Admin."
                  : "Couple made as Admin.",
            });
          }
        } else {
          if (updateAdmin[0].id) {
            let removeAdmin = await userSchema.update(
              {
                userRole: "COUPLE",
              },
              {
                where: { coupleId: updateAdmin[0].id },
                raw: true,
              }
            );
          }
          return res.status(200).send({
            success: true,
            msg: "Couple removed from admin right",
          });
        }
      } else {
        return res.status(200).send({
          msg: `Something went wrong. Please try again.`,
          error: true,
          success: false,
        });
      }
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async getAllCouplesList(req, res) {
    try {
      let {
        searchKeyword,
        sortBy,
        pageNo,
        size,
        parishValue,
        withoutParishCouples,
      } = req.body;

      let query = { skip: 0, limit: 0 };
      let sort1 = "ASC";
      let sortColumn = "couples.hisLastName";

      if (pageNo || size) {
        pageNo = parseInt(pageNo);
        size = parseInt(size);
        if (pageNo < 1) {
          return res.status(200).send({
            error: true,
            msg: "Invalid page number, should start with 1",
          });
        }
        query.skip = size * (pageNo - 1);
        query.limit = size;
      }

      if (sortBy && sortBy.sortDirection == 1) {
        sort1 = "ASC";
      } else {
        sort1 = "DESC";
      }

      if (sortBy?.sortColumn) {
        const columnMap = {
          hisFirstName: "couples.hisFirstName",
          hisLastName: "couples.hisLastName",
          primaryKey: "couples.primaryKey",
          hisEmail: "couples.hisEmail",
          hisMobile: "couples.hisMobile",
          herFirstName: "couples.herFirstName",
          herLastName: "couples.herLastName",
          herEmail: "couples.herEmail",
          herMobile: "couples.herMobile",
          city: "couples.city",
          state: "couples.state",
          zip: "couples.zip",
          notes: "couples.notes",
          created: "couples.createdAt",
          Parish: "parishes.parish",
          Address: "couples.address",
          Allergies: "couples.allergies",
          "Anniversary Date": "couples.anniversary_date",
        };
        sortColumn = columnMap[sortBy.sortColumn] || sortColumn;
      }

      // Build WHERE clause parts
      const whereParts = [];

      if (searchKeyword && searchKeyword !== "") {
        const searchColumn = `couples.hisFirstName LIKE "%${searchKeyword}%" OR
        couples.hisLastName LIKE "%${searchKeyword}%" OR
        couples.herFirstName LIKE "%${searchKeyword}%" OR
        couples.herLastName LIKE "%${searchKeyword}%" OR
        couples.primaryKey LIKE "%${searchKeyword}%" OR
        CONCAT(couples.hisFirstName, " ", couples.hisLastName) LIKE "%${searchKeyword}%" OR
        CONCAT(couples.herFirstName, " ", couples.herLastName) LIKE "%${searchKeyword}%" OR
        couples.hisEmail LIKE "%${searchKeyword}%" OR
        couples.herEmail LIKE "%${searchKeyword}%" OR
        couples.herMobile LIKE "%${searchKeyword}%" OR
        couples.hisMobile LIKE "%${searchKeyword}%" OR
        couples.city LIKE "%${searchKeyword}%" OR
        couples.state LIKE "%${searchKeyword}%" OR
        couples.notes LIKE "%${searchKeyword}%" OR
        couples.zip LIKE "%${searchKeyword}%" OR
        couples.address LIKE "%${searchKeyword}%" OR
        couples.allergies LIKE "%${searchKeyword}%" OR
        couples.anniversary_date LIKE "%${searchKeyword}%" OR
        parishes.parish LIKE "%${searchKeyword}%"`;
        whereParts.push(`(${searchColumn})`);
      }

      if (withoutParishCouples) {
        whereParts.push(`(couples.parishId IS NULL OR couples.parishId = "")`);
      } else if (parishValue && parishValue !== "") {
        whereParts.push(`couples.parishId = ${parseInt(parishValue)}`);
      }

      const where = whereParts.length
        ? `WHERE ${whereParts.join(" AND ")}`
        : "";

      const select = `
      SELECT couples.*, parishes.parish, COUNT(couples.primarykey) AS totalRecords
      FROM couples
      LEFT JOIN parishes ON parishes.id = couples.parishId
    `;

      const groupBy = ` GROUP BY couples.primarykey ORDER BY ${sortColumn} ${sort1}`;
      const limitOffset = req.body.export
        ? ""
        : ` LIMIT ${query.limit} OFFSET ${query.skip}`;
      const queryRecords = select + where + groupBy + limitOffset;

      const responseData1 = await db.sequelize
        .query(queryRecords)
        .then(([results]) => results);

      const countQuery = `
      SELECT COUNT(DISTINCT couples.primarykey) AS totalRecords
      FROM couples
      LEFT JOIN parishes ON parishes.id = couples.parishId
      ${where}
    `;

      const totalRecords = await db.sequelize
        .query(countQuery)
        .then(([results]) => results[0]);

      return res.status(200).send({
        success: true,
        data: responseData1,
        totalRecords: totalRecords?.totalRecords || 0,
      });
    } catch (error) {
      console.log("error:", error);
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async getMissingData(req, res) {
    try {
      let select = `SELECT *`;
      let from = ` FROM couples
      WHERE primaryKey IS NULL OR hisFirstName IS NULL OR hisLastName IS NULL OR hisEmail IS NULL OR hisMobile IS NULL OR herFirstName IS NULL OR herLastName IS NULL OR herEmail IS NULL OR herMobile IS NULL OR city IS NULL OR state IS NULL OR notes IS NULL OR  address IS NULL OR allergies IS NULL OR anniversary_date IS NULL OR hear_us IS NULL OR emergency_name1 IS NULL OR emergency_relationship1 IS NULL OR emergency_phone1 IS NULL OR emergency_name2 IS NULL OR emergency_relationship2 IS NULL OR emergency_phone2 IS NULL OR referral_from_a_friend_or_family_member IS NULL OR primaryKey = "" OR hisFirstName = "" OR hisLastName = "" OR hisEmail = "" OR hisMobile = "" OR herFirstName = "" OR herLastName = "" OR herEmail = "" OR herMobile = "" OR city = "" OR state = "" OR notes = "" OR address = "" OR allergies = "" OR anniversary_date = "" OR hear_us = "" OR emergency_name1 = "" OR emergency_relationship1 = "" OR emergency_phone1 = "" OR emergency_name2 = "" OR emergency_relationship2 = "" OR emergency_phone2 = "" OR referral_from_a_friend_or_family_member = ""`;
      let queryRecords = select + from;
      let responseData1 = await db.sequelize
        .query(queryRecords)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        data: responseData1,
        totalRecords: responseData1.length,
      });
    } catch (error) {
      console.log("error:", error);
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async getCouplesDetail(req, res) {
    let { userRole, coupleId } = req.body;
    try {
      let foundUser = await coupleSchema.findAll({ where: { id: coupleId } });
      if (foundUser) {
        return res.status(200).send({
          success: true,
          data: foundUser,
          msg: "User found...",
        });
      }
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async getAllCouplesSearch(req, res) {
    try {
      let query = `SELECT couples.*
      FROM couples
      LEFT JOIN retreatroasters ON retreatroasters.coupleId = couples.id
      WHERE retreatroasters.coupleId IS NOT NULL GROUP BY couples.id`;
      let allCouples = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Couples",
        data: allCouples,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async editCouple(req, res) {
    let {
      hisFirstName,
      hisLastName,
      hisEmail,
      hisMobile,
      id,
      herFirstName,
      herLastName,
      herEmail,
      herMobile,
      city,
      state,
      zip,
      notes,
      linkverify,
      imageUrl,
      // marriageImageUrl,
      parishId,
      address,
      allergies,
      anniversary_date,
      under_age_35,
      emergency_name1,
      emergency_relationship1,
      emergency_phone1,
      emergency_name2,
      emergency_relationship2,
      emergency_phone2,
      hear_us,
      referral_from_a_friend_or_family_member,
    } = JSON.parse(`${req.body.fromData}`);
    try {
      //Add Validations
      if (!(hisFirstName || hisLastName || herFirstName || herLastName)) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Please add at least one name.",
        });
      }
      if (!hisEmail && !herEmail) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Please add at least one email ID.",
        });
      }
      // if (hisEmail === herEmail) {
      //   return res.status(200).json({
      //     success: false,
      //     error: true,
      //     msg: "His Email and Her Email should be different.",
      //   });
      // }
      let checkMailInDb = await coupleSchema.findOne({
        where: {
          id: { [Op.ne]: id },
          [Op.or]: [
            hisEmail && {
              // Only check if hisEmail is not an empty string
              [Op.and]: [
                { hisEmail: { [Op.ne]: null } },
                { hisEmail: { [Op.ne]: "" } },
                { [Op.or]: [{ hisEmail: hisEmail }, { hisEmail: herEmail }] },
              ],
            },
            herEmail && {
              // Only check if herEmail is not an empty string
              [Op.and]: [
                { herEmail: { [Op.ne]: null } },
                { herEmail: { [Op.ne]: "" } },
                { [Op.or]: [{ herEmail: hisEmail }, { herEmail: herEmail }] },
              ],
            },
          ],
        },
      });
      if (checkMailInDb) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "This email is already exist.",
        });
      }
      const normalizedHisMobile = hisMobile && hisMobile.replace(/\D/g, "");
      const normalizedHerMobile = herMobile && herMobile.replace(/\D/g, "");
      let checkMobileInDb = await coupleSchema.findOne({
        where: {
          id: { [Op.ne]: id },
          [Op.or]: [
            {
              [Op.and]: [
                { hisMobile: { [Op.ne]: null } },
                { hisMobile: { [Op.ne]: "" } },
                Sequelize.literal(
                  `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
                ),
              ],
            },
            {
              [Op.and]: [
                { hisMobile: { [Op.ne]: null } },
                { hisMobile: { [Op.ne]: "" } },
                Sequelize.literal(
                  `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
                ),
              ],
            },
            {
              [Op.and]: [
                { herMobile: { [Op.ne]: null } },
                { herMobile: { [Op.ne]: "" } },
                Sequelize.literal(
                  `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
                ),
              ],
            },
            {
              [Op.and]: [
                { herMobile: { [Op.ne]: null } },
                { herMobile: { [Op.ne]: "" } },
                Sequelize.literal(
                  `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
                ),
              ],
            },
          ],
        },
      });
      if (checkMobileInDb) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "This mobile number already exists.",
        });
      }
      let userDataToUpdate = {
        hisFirstName: hisFirstName,
        hisLastName: hisLastName,
        hisEmail: hisEmail !== "" ? hisEmail : null,
        hisMobile: hisMobile !== "" ? hisMobile : null,
        herFirstName: herFirstName,
        herLastName: herLastName,
        herEmail: herEmail !== "" ? herEmail : null,
        herMobile: herMobile !== "" ? herMobile : null,
        city: city,
        state: state,
        zip: zip,
        notes: notes,
        parishId: parishId && parishId !== "" ? parishId : null,
        linkverify: linkverify,
        address: address,
        allergies: allergies,
        anniversary_date: anniversary_date === "" ? null : anniversary_date,
        under_age_35: under_age_35,
        emergency_name1: emergency_name1,
        emergency_relationship1: emergency_relationship1,
        emergency_phone1: emergency_phone1,
        emergency_name2: emergency_name2,
        emergency_relationship2: emergency_relationship2,
        emergency_phone2: emergency_phone2,
        hear_us: JSON.stringify(hear_us),
        referral_from_a_friend_or_family_member:
          referral_from_a_friend_or_family_member,
      };
      let imageSavedCouple;
      let coupleDetail = await coupleSchema.findOne({
        where: { id: id },
        raw: true,
      });
      if (req.files && req.files.file) {
        if (coupleDetail) {
          if (coupleDetail.imageUrl) {
            const profileImagePath = path.join(
              PROJECT_DIR,
              "profileImage",
              path.basename(coupleDetail.imageUrl)
            );
            if (fs.existsSync(profileImagePath)) {
              fs.unlinkSync(profileImagePath);
            }
          }
        }
        imageSavedCouple = await this.saveImageForCouple(req.files, id);
      } else {
        if (imageUrl === "" || imageUrl === "null" || imageUrl === null) {
          if (coupleDetail) {
            if (coupleDetail.imageUrl) {
              const profileImagePath = path.join(
                PROJECT_DIR,
                "profileImage",
                path.basename(coupleDetail.imageUrl)
              );
              if (fs.existsSync(profileImagePath)) {
                fs.unlinkSync(profileImagePath);
              }
            }
          }
          let removeImage = await coupleSchema.update(
            { imageUrl: "" },
            { where: { id: id } }
          );
        } else {
          let uploadImage = await coupleSchema.update(
            { imageUrl: req.body.file },
            { where: { id: id } }
          );
        }
      }
      // if (req.files && req.files.marriage_file) {
      //   imageSavedCouple = await this.saveImageForCouple(req.files, id);
      // } else {
      //   if (marriageImageUrl === "") {
      //     let removeImage = await coupleSchema.update(
      //       { marriageImageUrl: "" },
      //       { where: { id: id } }
      //     );
      //   } else {
      //     let uploadImage = await coupleSchema.update(
      //       { marriageImageUrl: req.body.marriage_file },
      //       { where: { id: id } }
      //     );
      //   }
      // }
      let update = await coupleSchema.update(userDataToUpdate, {
        where: { id: id },
      });
      let findCouple = await coupleSchema.findAll({
        where: { id: id },
        raw: true,
      });
      let adminObj = [
        {
          coupleId: findCouple[0].id,
          firstName: findCouple[0].hisFirstName,
          lastName: findCouple[0].hisLastName,
          mobile: findCouple[0].hisMobile,
          userName: findCouple[0].hisFirstName,
          imageUpload: findCouple[0].imageUrl,
        },

        {
          coupleId: findCouple[0].id,
          userName: findCouple[0].herFirstName,
          firstName: findCouple[0].herFirstName,
          lastName: findCouple[0].herLastName,
          mobile: findCouple[0].herMobile,
          imageUpload: findCouple[0].imageUrl,
        },
      ];
      if (
        findCouple &&
        findCouple[0].hisEmail &&
        findCouple[0].hisEmail !== "" &&
        findCouple[0].hisEmail !== null
      ) {
        let upDate = await userSchema.update(adminObj[0], {
          where: { email: findCouple[0].hisEmail },
        });
      }
      if (
        findCouple &&
        findCouple[0].herEmail &&
        findCouple[0].herEmail !== "" &&
        findCouple[0].herEmail !== null
      ) {
        let upDate1 = await userSchema.update(adminObj[1], {
          where: { email: findCouple[0].herEmail },
        });
      }
      if (update) {
        return res.send({
          success: true,
          data: findCouple[0],
          msg: `Couple updated successfully`,
        });
      } else {
        return res.send({
          error: true,
          msg: "Something went wrong please try again.",
        });
      }
    } catch (error) {
      console.log(
        `editCouple [${new Date().toLocaleString("en-US", {
          timeZoneName: "short",
        })}] error -->`,
        error
      );
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async deleteCouple(req, res) {
    let { id, couple_id } = req.body;
    try {
      if (couple_id) {
        const coupleDetail = await coupleSchema.findOne({
          where: { id: couple_id },
          raw: true,
        });
        if (coupleDetail) {
          if (coupleDetail.imageUrl) {
            const profileImagePath = path.join(
              PROJECT_DIR,
              "profileImage",
              path.basename(coupleDetail.imageUrl)
            );
            if (fs.existsSync(profileImagePath)) {
              fs.unlinkSync(profileImagePath);
            }
          }
        }
        // Delete records from DB
        await coupleSchema.destroy({ where: { id: couple_id } });
        await userSchema.destroy({ where: { coupleId: couple_id } });
        await retreatRoastSchema.destroy({ where: { coupleId: couple_id } });
        return res.status(200).send({
          success: true,
          msg: "Couple deleted successfully along with images.",
        });
      } else {
        return res.status(200).json({
          success: false,
          msg: "Error in Primary Key.",
        });
      }
    } catch (error) {
      console.log("error:", error);
      return res.status(200).json({
        success: false,
        msg: error.message || error,
      });
    }
  }

  async searchKey(req, res) {
    try {
      let result = await coupleSchema.find({
        where: {
          primaryKey: { [Op.like]: `%${req.params.key}%` },
          hisFirstName: { [Op.like]: `%${req.params.key}%` },
          hisLastName: { [Op.like]: `%${req.params.key}%` },
          hisEmail: { [Op.like]: `%${req.params.key}%` },
          hisMobile: { [Op.like]: `%${req.params.key}%` },
          herFirstName: { [Op.like]: `%${req.params.key}%` },
          herLastName: { [Op.like]: `%${req.params.key}%` },
          herEmail: { [Op.like]: `%${req.params.key}%` },
          city: { [Op.like]: `%${req.params.key}%` },
          state: { [Op.like]: `%${req.params.key}%` },
          zip: { [Op.like]: `%${req.params.key}%` },
          notes: { [Op.like]: `%${req.params.key}%` },

          address: { [Op.like]: `%${req.params.key}%` },
          allergies: { [Op.like]: `%${req.params.key}%` },
          anniversary_date: { [Op.like]: `%${req.params.key}%` },
          under_age_35: { [Op.like]: `%${req.params.key}%` },
          emergency_name1: { [Op.like]: `%${req.params.key}%` },
          emergency_relationship1: { [Op.like]: `%${req.params.key}%` },
          emergency_phone1: { [Op.like]: `%${req.params.key}%` },
          emergency_name2: { [Op.like]: `%${req.params.key}%` },
          emergency_relationship2: { [Op.like]: `%${req.params.key}%` },
          emergency_phone2: { [Op.like]: `%${req.params.key}%` },
          hear_us: { [Op.like]: `%${req.params.key}%` },
          referral_from_a_friend_or_family_member: {
            [Op.like]: `%${req.params.key}%`,
          },
        },
        raw: true,
      });
      return res.status(200).send({
        success: true,
        msg: "",
        data: result,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async changeStatus(req, res) {
    try {
      let { id, value } = req.body;
      let userDataToUpdate = {
        accountStatus: value,
      };
      let changeStatus = await coupleSchema.update(userDataToUpdate, {
        where: { id: id },
        raw: true,
      });

      if (changeStatus) {
        const user = await coupleSchema.findAll({
          where: {
            id: id,
          },
          raw: true,
        });
        if (changeStatus && user) {
          return res.status(200).send({
            success: true,
            msg: "Couple status changed.",
            data: user[0],
          });
        }
      }
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async saveCoupleExcel(req, res) {
    try {
      let coupleData = req.body;
      let chunkSize = 1000;
      let coupleWithPk = [];
      let coupleWithoutPk = [];
      let updateCouple = [];
      let createdCouple = [];

      const normalize = (num) => (num ? String(num).replace(/\D/g, "") : "");
      const cleanValue = (val) => {
        if (val === "" || val === null || val === undefined) return null;
        return val;
      };
      const fixUnderAge35 = (val) => {
        if (!val || val === "") return "NO";
        return val;
      };
      const fixAnniversaryDate = (val) => {
        if (!val || val === "" || val === "Invalid date") return null;
        return val;
      };

      // ✅ Separate couples with/without primaryKey
      coupleData.forEach((element) => {
        if (element.primaryKey && element.primaryKey !== "") {
          coupleWithPk.push(element);
        } else {
          coupleWithoutPk.push(element);
        }
      });

      let coupleArrMisMatchRec = [];

      // ✅ Handle couples with primaryKey
      if (coupleWithPk.length) {
        let coupleDataPk = coupleWithPk.map((item) => item.primaryKey);
        let foundRecord = await coupleSchema.findAll({
          where: { primaryKey: coupleDataPk },
          raw: true,
        });

        for (let index = 0; index < coupleWithPk.length; index++) {
          let couple = coupleWithPk[index];
          let existing = foundRecord.find(
            (f) => f.primaryKey == couple.primaryKey
          );
          if (!existing) continue;

          let flag = true;

          if (
            existing.hisEmail &&
            couple.hisEmail &&
            existing.hisEmail !== couple.hisEmail
          )
            flag = false;
          if (
            existing.herEmail &&
            couple.herEmail &&
            existing.herEmail !== couple.herEmail
          )
            flag = false;
          if (
            existing.hisMobile &&
            couple.hisMobile &&
            normalize(existing.hisMobile) !== normalize(couple.hisMobile)
          )
            flag = false;
          if (
            existing.herMobile &&
            couple.herMobile &&
            normalize(existing.herMobile) !== normalize(couple.herMobile)
          )
            flag = false;

          if (!flag) {
            coupleArrMisMatchRec.push(couple.primaryKey);
            continue;
          }

          couple.hisEmail = cleanValue(couple.hisEmail);
          couple.herEmail = cleanValue(couple.herEmail);
          couple.hisMobile = cleanValue(couple.hisMobile);
          couple.herMobile = cleanValue(couple.herMobile);
          couple.under_age_35 = fixUnderAge35(couple.under_age_35);
          couple.anniversary_date = fixAnniversaryDate(couple.anniversary_date);

          await coupleSchema.update(couple, {
            where: { primaryKey: couple.primaryKey },
          });
          updateCouple.push({
            primaryKey: couple.primaryKey,
            name: `${couple.hisFirstName} & ${couple.herFirstName}`,
          });
        }
      }

      // ✅ Handle couples WITHOUT primaryKey
      let maxPrimaryKeyDB = (await coupleSchema.max("primaryKey")) || 1000;
      let coupleNotRepeated = [];
      let alreadyAddedEmails = new Set();
      let alreadyAddedMobiles = new Set();
      let duplicateWithinFile = [];

      for (let i = 0; i < coupleWithoutPk.length; i++) {
        let couple = coupleWithoutPk[i];

        const emailsToCheck = [
          couple.hisEmail?.toLowerCase(),
          couple.herEmail?.toLowerCase(),
        ].filter(Boolean);

        const mobilesToCheck = [
          normalize(couple.hisMobile),
          normalize(couple.herMobile),
        ].filter(Boolean);

        let isDuplicateInFile =
          emailsToCheck.some((email) => alreadyAddedEmails.has(email)) ||
          mobilesToCheck.some((mobile) => alreadyAddedMobiles.has(mobile));

        if (isDuplicateInFile) {
          duplicateWithinFile.push({
            hisFirstName: couple.hisFirstName,
            herFirstName: couple.herFirstName,
            reason: "Duplicate within file",
          });
          continue;
        }

        let existing = await coupleSchema.findOne({
          where: {
            [Op.or]: [
              { hisEmail: couple.hisEmail },
              { herEmail: couple.hisEmail },
              { hisEmail: couple.herEmail },
              { herEmail: couple.herEmail },
              { hisMobile: normalize(couple.hisMobile) },
              { herMobile: normalize(couple.hisMobile) },
              { hisMobile: normalize(couple.herMobile) },
              { herMobile: normalize(couple.herMobile) },
            ],
          },
          raw: true,
        });

        if (existing) {
          duplicateWithinFile.push({
            hisFirstName: couple.hisFirstName,
            herFirstName: couple.herFirstName,
            reason: "Duplicate in DB",
          });
          continue;
        }

        emailsToCheck.forEach((email) => alreadyAddedEmails.add(email));
        mobilesToCheck.forEach((mobile) => alreadyAddedMobiles.add(mobile));

        couple.primaryKey = ++maxPrimaryKeyDB;
        couple.hisEmail = cleanValue(couple.hisEmail);
        couple.herEmail = cleanValue(couple.herEmail);
        couple.hisMobile = cleanValue(couple.hisMobile);
        couple.herMobile = cleanValue(couple.herMobile);
        couple.under_age_35 = fixUnderAge35(couple.under_age_35);
        couple.anniversary_date = fixAnniversaryDate(couple.anniversary_date);

        coupleNotRepeated.push(couple);
      }

      // ✅ Insert new couples + create users + send emails
      if (coupleNotRepeated.length) {
        for (let i = 0; i < coupleNotRepeated.length; i += chunkSize) {
          const chunk = coupleNotRepeated.slice(i, i + chunkSize);
          let inserted = await coupleSchema.bulkCreate(chunk);

          for (let item of inserted) {
            createdCouple.push({
              primaryKey: item.primaryKey,
              name: `${item.hisFirstName} & ${item.herFirstName}`,
            });

            let password1 = "";
            let password2 = "";

            if (item.hisEmail) {
              let randompass = Math.random().toString(36).slice(-8);
              password1 = "p" + randompass.slice(1);
            }
            if (item.herEmail) {
              let randompass = Math.random().toString(36).slice(-8);
              password2 = "p" + randompass.slice(1);
            }

            let userAccounts = [
              {
                userName: item.hisFirstName,
                email: item.hisEmail,
                firstName: item.hisFirstName,
                lastName: item.hisLastName,
                mobile: item.hisMobile,
                password: password1,
                accountStatus: "ACTIVE",
                userRole: "COUPLE",
                coupleId: item.id,
              },
              {
                userName: item.herFirstName,
                email: item.herEmail,
                firstName: item.herFirstName,
                lastName: item.herLastName,
                mobile: item.herMobile,
                password: password2,
                accountStatus: "ACTIVE",
                userRole: "COUPLE",
                coupleId: item.id,
              },
            ];

            for (let user of userAccounts) {
              if (user.email) {
                await userSchema.create(user);
              }
            }

            if (item.hisEmail) {
              let emailBody = SENDLOGINDETAILBYADMIN.replace(
                /#firstName#/g,
                item.hisFirstName
              )
                .replace(/#lastName#/g, item.hisLastName)
                .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)
                .replace(/#email#/g, item.hisEmail)
                .replace(/#password#/g, password1);
              Email.sendEmail(
                item.hisEmail,
                "Couple Login Details - LOVESTRONG Marriage",
                emailBody
              );
            }

            if (item.herEmail) {
              let emailBody = SENDLOGINDETAILBYADMIN.replace(
                /#firstName#/g,
                item.herFirstName
              )
                .replace(/#lastName#/g, item.herLastName)
                .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)
                .replace(/#email#/g, item.herEmail)
                .replace(/#password#/g, password2);
              Email.sendEmail(
                item.herEmail,
                "Couple Login Details - LOVESTRONG Marriage",
                emailBody
              );
            }
          }
        }
      }

      return res.send({
        success: true,
        mismatch: coupleArrMisMatchRec,
        updateCouple,
        createdCouple,
        duplicateWithinFile,
        msg: "Couple data imported successfully.",
      });
    } catch (err) {
      console.error(err);
      return res.send({
        success: false,
        msg: "Something went wrong.",
      });
    }
  }

  async recExitagainstPK(record) {
    try {
      if (record.hisEmail !== "") {
        let foundRecord = await coupleSchema.findAll({
          hisEmail: record.hisEmail,
          raw: true,
        });
        if (foundRecord.length) {
          return {
            record: foundRecord[0],
            found: true,
          };
        } else {
          return {
            record: foundRecord,
            found: false,
          };
        }
      }
      if (record.herEmail !== "") {
        let foundRecord = await coupleSchema.findAll({
          hisEmail: record.herEmail,
          raw: true,
        });
        if (foundRecord.length) {
          return {
            record: foundRecord[0],
            found: true,
          };
        } else {
          return {
            record: foundRecord,
            found: false,
          };
        }
      }

      if (record.heriEmail === "" && record.herEmail === "") {
        return {
          record: foundRecord,
          found: false,
        };
      } else {
        return {
          record: foundRecord,
          found: false,
        };
      }
    } catch (error) {
      return error;
    }
  }

  async getStateCity(req, res) {
    try {
      let select = `SELECT id, primaryKey, state, city`;
      let from = ` FROM couples `;
      let where = `WHERE (state IS NOT NULL AND state != '') AND (city IS NOT NULL AND city != '')`;
      let groupBy = `GROUP by state, city `;
      let orderBy = `ORDER BY state DESC, city`;
      let queryRecords = select + from + where + groupBy + orderBy;
      let responseData1 = await db.sequelize
        .query(queryRecords)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        data: responseData1,
      });
    } catch (error) {
      console.log("error:", error);
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async participatedInRetreats(req, res) {
    try {
      if (req.body.couple_Id) {
        let countQuery = `SELECT COUNT(*) AS totalRecords 
                        FROM retreats 
                        LEFT JOIN retreatroasters ON retreats.id = retreatroasters.retreatId
                        LEFT JOIN parishes AS parRetreat ON retreats.parishId = parRetreat.id
                        LEFT JOIN parishes AS parish1 ON retreatroasters.parishId = parish1.id
                        LEFT JOIN services ON retreatroasters.serviceId = services.id
                        LEFT JOIN roles ON retreatroasters.roleId = roles.id
                        LEFT JOIN talks ON retreatroasters.talkId = talks.id 
                        LEFT JOIN couples ON retreatroasters.coupleId = couples.id  
                        WHERE retreats.id NOT IN (0) AND (retreats.deleteStatus='' OR retreats.deleteStatus IS NULL) AND retreatroasters.coupleId = ${req.body.couple_Id}`;

        let query = `SELECT 
                      retreats.id, retreats.title, retreats.location, retreatroasters.attendeeType,
                      retreats.language, retreats.location,
                      retreats.createdAt, retreats.dateFrom, retreats.dateTo,
                      parish1.parish as coupleParish, parRetreat.parish as parish, 
                      services.service, roles.role, talks.talk 
                      FROM retreats 
                      LEFT JOIN retreatroasters ON retreats.id = retreatroasters.retreatId
                      LEFT JOIN parishes AS parRetreat ON retreats.parishId = parRetreat.id
                      LEFT JOIN parishes AS parish1 ON retreatroasters.parishId = parish1.id
                      LEFT JOIN services ON retreatroasters.serviceId = services.id
                      LEFT JOIN roles ON retreatroasters.roleId = roles.id
                      LEFT JOIN talks ON retreatroasters.talkId = talks.id 
                      LEFT JOIN couples ON retreatroasters.coupleId = couples.id  
                      WHERE retreats.id NOT IN (0) AND (retreats.deleteStatus='' OR retreats.deleteStatus IS NULL) AND retreatroasters.coupleId = ${req.body.couple_Id} 
                      GROUP BY retreats.id`;
        let [countResult, _] = await db.sequelize.query(countQuery);
        const totalCount = countResult[0].totalRecords;
        let [responseData1, __] = await db.sequelize.query(query);

        return res.status(200).send({
          success: true,
          totalRecords: totalCount,
          data: responseData1,
        });
      } else {
        return res.status(200).send({
          success: false,
          msg: "Invalid request. Couple Id required.",
        });
      }
    } catch (error) {
      console.error(error);
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async addLogReport(req, res) {
    try {
      if (req.body.action === "Delete") {
        const allusers = await userSchema.findAll({
          where: {
            deleteAccess: 1,
          },
          raw: true,
        });
        let date = new Date().toLocaleString();
        if (allusers) {
          allusers.map((item) => {
            let replData = DELETE_MESSAGE.replace(
              /#Name#/g,
              `${item.firstName}` + ` ${item.lastName}`
            )
              .replace(/#User#/g, req.body.byWhom)
              .replace(/#date-time#/g, date)
              .replace(/#deletedId#/g, req.body.description);
            Email.sendEmail(
              item.email,
              "LoveStrong Delete Notification",
              replData
            );
          });
        }
      }
      let newreport = new logReportSchema(req.body);
      let succ = await newreport.save();
      if (succ) {
        return res.status(200).send({
          success: true,
        });
      } else {
        return res.status(200).send({
          msg: `Something went wrong. Please try again`,
          error: true,
          success: false,
        });
      }
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async getAllLogReport(req, res) {
    try {
      let { searchKeyword, sortBy, pageNo, size } = req.body;
      let query = { skip: 0, limit: 0 };
      let sort1 = "ASC";
      let sortColumn = "logreports.id";
      let searchColumn = "";
      if (pageNo || size) {
        pageNo = parseInt(pageNo);
        size = parseInt(size);
        if (pageNo < 0 || pageNo === 0) {
          response = {
            error: true,
            msg: "Invalid page number, should start with 1",
          };
          return res.status(200).send(response);
        }
        query.skip = size * (pageNo - 1);
        query.limit = size;
      }
      if (sortBy && sortBy.sortDirection == 1) {
        sort1 = "ASC";
      } else {
        sort1 = "DESC";
      }
      if (sortBy && sortBy.sortColumn && sortBy.sortDirection) {
        if (sortBy.sortColumn === "By Whom") {
          sortColumn = "logreports.byWhom";
        } else if (sortBy.sortColumn === "Page Link") {
          sortColumn = "logreports.pagelink";
        } else if (sortBy.sortColumn === "Description") {
          sortColumn = "logreports.description";
        } else if (sortBy.sortColumn === "Date/Time") {
          sortColumn = "logreports.createdAt";
        }
      }
      if (searchKeyword && searchKeyword != "") {
        searchColumn = `logreports.byWhom LIKE "%${searchKeyword}%" OR
        logreports.pagelink LIKE "%${searchKeyword}%" OR
        logreports.description LIKE "%${searchKeyword}%" OR
        logreports.createdAt LIKE "%${searchKeyword}%"`;
      }
      let select = `SELECT logreports.*  FROM logreports`;
      let where =
        searchKeyword && searchKeyword != "" ? ` WHERE ${searchColumn}` : ``;
      let groupBy = ` GROUP BY logreports.id ORDER BY ${sortColumn} ${sort1}`;
      let limitOffset = req.body.export
        ? ``
        : ` LIMIT ${query.limit}
        OFFSET ${query.skip}`;
      let queryRecords = select + where + groupBy + limitOffset;
      let responseData1 = await db.sequelize
        .query(queryRecords)
        .then(([results, metadata]) => results);
      let records = `SELECT COUNT(logreports.id) AS totalRecords FROM logreports `;
      let countRecords = records;
      let totalRecords = await db.sequelize
        .query(countRecords)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        data: responseData1,
        totalRecords: totalRecords && totalRecords[0].totalRecords,
      });
    } catch (error) {
      return res.send({
        error: true,
        msg: "Something went wrong please try again.",
      });
    }
  }

  async getAllAdmins(req, res) {
    try {
      let query = `SELECT users.userName,users.email,users.deleteAccess,users.id
      FROM users
      WHERE users.userRole = 'ADMIN';`;
      let allAdmins = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Admin fetched.",
        data: allAdmins,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async updateAdmins(req, res) {
    try {
      const updatedPromises = req.body.map(async (admin) => {
        const updated = await userSchema.update(
          { deleteAccess: admin.deleteAccess },
          { where: { id: admin.id } }
        );
        return updated;
      });
      const updated = await Promise.all(updatedPromises);
      return res.status(200).json({
        success: true,
        msg: "Records Updated",
        data: updated,
      });
    } catch (err) {
      console.error("Error updating records", err);
      return res.status(500).json({
        success: false,
        msg: "Internal Server Error",
        error: err.message,
      });
    }
  }

  async updateNewCoupleRegister(req, res) {
    let {
      id,
      hisFirstName,
      hisLastName,
      hisEmail,
      hisMobile,
      herFirstName,
      herLastName,
      herEmail,
      herMobile,
      city,
      state,
      notes,
      parishId,
      zip,
      address,
      allergies,
      anniversary_date,
      under_age_35,
      emergency_name1,
      emergency_relationship1,
      emergency_phone1,
      emergency_name2,
      emergency_relationship2,
      emergency_phone2,
      hear_us,
      referral_from_a_friend_or_family_member,
      attendeeType,
      retreatId,
      primaryKey,
      imageUrl,
      // marriageImageUrl,
      coupleId,
    } = JSON.parse(`${req.body.fromData}`);
    try {
      if (!(hisFirstName || hisLastName || herFirstName || herLastName)) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Please add at least one name.",
        });
      }
      if (!hisEmail && !herEmail) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Please add at least one email ID.",
        });
      }
      // if (hisEmail === herEmail) {
      //   return res.status(200).json({
      //     success: false,
      //     error: true,
      //     msg: "His Email and Her Email should be different.",
      //   });
      // }
      let jsonObj = JSON.parse(req.body.fromData);
      delete jsonObj.attendeeType;
      delete jsonObj.retreatId;
      delete jsonObj.id;
      if (jsonObj.anniversary_date === "") {
        jsonObj.anniversary_date = null;
      }
      if (jsonObj.hear_us) {
        jsonObj.hear_us = JSON.stringify(jsonObj.hear_us);
      }
      let foundRetreat = await retreatSchema.findOne({
        where: { id: retreatId },
        raw: true,
      });
      const schedule = foundRetreat.schedule;
      if (schedule.length > 0) {
        const parsedSchedule = JSON.parse(schedule);
        const dateFrom = new Date(parsedSchedule[0].date);
        const dateTo = new Date(parsedSchedule[parsedSchedule.length - 1].date);
        foundRetreat.dateFrom = dateFrom;
        foundRetreat.dateTo = dateTo;
      } else {
        foundRetreat.dateFrom = null;
        foundRetreat.dateTo = null;
      }
      var ret =
        `${foundRetreat.title}` +
        ` (${
          moment(foundRetreat && foundRetreat.dateFrom)
            .tz("America/New_York")
            .format("MMM DD") +
          " - " +
          moment(foundRetreat.dateTo).tz("America/New_York").format("MMM DD") +
          ", " +
          moment(foundRetreat && foundRetreat.dateFrom)
            .tz("America/New_York")
            .format("YYYY")
        })`;
      let select = `SELECT retreatroasters.id,couples.hisLastName,couples.hisFirstName,couples.herFirstName,couples.herLastName,roles.role,couples.hisEmail,couples.herEmail,couples.hisMobile,couples.herMobile,retreatroasters.roleId,retreatroasters.serviceId FROM retreatroasters
        LEFT JOIN couples ON retreatroasters.coupleId = couples.id 
        LEFT JOIN roles ON retreatroasters.roleId = roles.id
        INNER JOIN retreats on retreatroasters.retreatId = retreats.id WHERE retreatroasters.retreatId = ${retreatId} AND `;
      let addLead = `roles.role = "Lead"`;
      let addCoLead = `roles.role = "Co-Lead"`;
      let queryRecords = select + addLead;
      let queryRecords1 = select + addCoLead;
      let responseData = await db.sequelize
        .query(queryRecords)
        .then(([results, metadata]) => results);
      let responseData1 = await db.sequelize
        .query(queryRecords1)
        .then(([results, metadata]) => results);

      let userDataToUpdate = {
        hisFirstName: hisFirstName,
        hisLastName: hisLastName,
        hisEmail: hisEmail,
        hisMobile: hisMobile,
        herFirstName: herFirstName,
        herLastName: herLastName,
        herEmail: herEmail,
        herMobile: herMobile,
        city: city,
        state: state,
        zip: zip,
        notes: notes,
        parishId: parishId && parishId !== "" ? parishId : null,
        address: address,
        allergies: allergies,
        anniversary_date: anniversary_date === "" ? null : anniversary_date,
        under_age_35: under_age_35,
        emergency_name1: emergency_name1,
        emergency_relationship1: emergency_relationship1,
        emergency_phone1: emergency_phone1,
        emergency_name2: emergency_name2,
        emergency_relationship2: emergency_relationship2,
        emergency_phone2: emergency_phone2,
        hear_us: JSON.stringify(hear_us),
        referral_from_a_friend_or_family_member:
          referral_from_a_friend_or_family_member,
      };
      let imageSavedCouple;
      let coupleDetail = await coupleSchema.findOne({
        where: { id: coupleId },
        raw: true,
      });
      if (req.files && req.files.file) {
        if (coupleDetail) {
          if (coupleDetail.imageUrl) {
            const profileImagePath = path.join(
              PROJECT_DIR,
              "profileImage",
              path.basename(coupleDetail.imageUrl)
            );
            if (fs.existsSync(profileImagePath)) {
              fs.unlinkSync(profileImagePath);
            }
          }
        }
        imageSavedCouple = await this.saveImageForCouple(req.files, coupleId);
      } else {
        if (imageUrl === "") {
          if (coupleDetail) {
            if (coupleDetail.imageUrl) {
              const profileImagePath = path.join(
                PROJECT_DIR,
                "profileImage",
                path.basename(coupleDetail.imageUrl)
              );
              if (fs.existsSync(profileImagePath)) {
                fs.unlinkSync(profileImagePath);
              }
            }
          }
          let removeImage = await coupleSchema.update(
            { imageUrl: "" },
            { where: { id: coupleId } }
          );
        } else {
          let uploadImage = await coupleSchema.update(
            { imageUrl: req.body.file },
            { where: { id: coupleId } }
          );
        }
      }
      // if (req.files && req.files.marriage_file) {
      //   imageSavedCouple = await this.saveImageForCouple(req.files, coupleId);
      // } else {
      //   if (marriageImageUrl === "") {
      //     let removeImage = await coupleSchema.update(
      //       { marriageImageUrl: "" },
      //       { where: { id: coupleId } }
      //     );
      //   } else {
      //     let uploadImage = await coupleSchema.update(
      //       { marriageImageUrl: req.body.marriage_file },
      //       { where: { id: coupleId } }
      //     );
      //   }
      // }
      let updateRoaster = await retreatRoastSchema.update(
        { attendeeType: attendeeType, stage: "VERIFIED" },
        {
          where: {
            [Op.and]: {
              coupleId: coupleId,
              retreatId: retreatId,
            },
          },
        }
      );
      let update = await coupleSchema.update(userDataToUpdate, {
        where: { id: coupleId },
      });
      let findCouple = await coupleSchema.findAll({
        where: { id: coupleId },
        raw: true,
      });
      let adminObj = [
        {
          coupleId: findCouple && findCouple[0] && findCouple[0].id,
          firstName: findCouple && findCouple[0] && findCouple[0].hisFirstName,
          lastName: findCouple && findCouple[0] && findCouple[0].hisLastName,
          mobile: findCouple && findCouple[0] && findCouple[0].hisMobile,
          userName: findCouple && findCouple[0] && findCouple[0].hisFirstName,
          imageUpload: findCouple && findCouple[0] && findCouple[0].imageUrl,
        },

        {
          coupleId: findCouple && findCouple[0] && findCouple[0].id,
          userName: findCouple && findCouple[0] && findCouple[0].herFirstName,
          firstName: findCouple && findCouple[0] && findCouple[0].herFirstName,
          lastName: findCouple && findCouple[0] && findCouple[0].herLastName,
          mobile: findCouple && findCouple[0] && findCouple[0].herMobile,
          imageUpload: findCouple && findCouple[0] && findCouple[0].imageUrl,
        },
      ];
      if (
        findCouple &&
        findCouple[0].hisEmail &&
        findCouple[0].hisEmail !== "" &&
        findCouple[0].hisEmail !== null &&
        findCouple[0].hisEmail !== undefined
      ) {
        let upDate = await userSchema.update(adminObj[0], {
          where: { email: findCouple[0].hisEmail },
        });
      }
      if (
        findCouple &&
        findCouple[0].herEmail &&
        findCouple[0].herEmail !== "" &&
        findCouple[0].herEmail !== null &&
        findCouple[0].herEmail !== undefined
      ) {
        let upDate1 = await userSchema.update(adminObj[1], {
          where: { email: findCouple[0].herEmail },
        });
      }
      return res.send({
        success: true,
        data: findCouple[0],
        msg: `Couple updated successfully`,
      });
    } catch (error) {
      console.log("errrr-->", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async couplesForCheck(req, res) {
    try {
      const allCouples = await coupleSchema.findAll();
      return res.status(200).send({
        success: true,
        msg: "All Couples",
        data: allCouples,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async saveCoupleImage(req, res) {
    try {
      if (req.files) {
        let coupleDetail = await coupleSchema.findOne({
          where: { id: req.body.coupleId },
          raw: true,
        });
        let file;
        let fileUrl;
        file = req.files.file;
        const now = new Date();
        const currentDate = now.toISOString().split("T")[0];
        const fileExtension = file.name.substring(file.name.lastIndexOf("."));
        const fileName = `${coupleDetail.hisLastName}, ${coupleDetail.hisFirstName} & ${coupleDetail.herFirstName}_${currentDate}${fileExtension}`;
        fileUrl = PROJECT_DIR + "/profileImage/" + fileName;
        let imgUrl =
          process.env.SERVERADDRESS + "/public/profileImage/" + fileName;
        let result = await coupleSchema.update(
          { imageUrl: imgUrl },
          { where: { id: req.body.coupleId } }
        );
        await userSchema.update(
          { imageUpload: imgUrl },
          {
            where: {
              [Op.or]: [{ coupleId: req.body.coupleId }],
            },
          }
        );
        if (result) {
          file.mv(fileUrl, async function (err) {
            if (err) {
              return false;
            }
            return true;
          });
        }
        return res.status(200).send({
          success: true,
          msg: "Couple image uploaded successfully.",
        });
      } else {
        return res.status(200).send({
          msg: `Something went wrong. Please try again.`,
          error: true,
          success: false,
        });
      }
    } catch (error) {
      console.log("error", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async removeCoupleImage(req, res) {
    try {
      const coupleDetail = await coupleSchema.findOne({
        where: { id: req.body.id },
        raw: true,
      });

      if (coupleDetail && coupleDetail.imageUrl) {
        const profileImagePath = path.join(
          PROJECT_DIR,
          "profileImage",
          path.basename(coupleDetail.imageUrl)
        );
        // Delete file if it exists
        if (fs.existsSync(profileImagePath)) {
          fs.unlinkSync(profileImagePath);
        }
      }

      // Update DB and clear the URL
      let result = await coupleSchema.update(
        { imageUrl: "" },
        { where: { id: req.body.id } }
      );

      if (result) {
        return res.status(200).send({
          success: true,
          msg: "Couple image removed successfully.",
        });
      } else {
        return res.status(200).json({
          success: false,
          msg: "No record updated.",
        });
      }
    } catch (error) {
      console.log("error", error);
      return res.status(200).json({
        success: false,
        msg: error.message || error,
      });
    }
  }

  async geAdminsAndSubAdmins(req, res) {
    try {
      // Query to fetch all admins
      let queryAdmins = `SELECT users.userName,users.firstName,users.lastName,users.password, users.email, users.id,users.isDisabled FROM users WHERE users.userRole = 'ADMIN';`;
      let getAllAdmins = await db.sequelize
        .query(queryAdmins)
        .then(([results, metadata]) => results);

      // Query to fetch all subadmins
      let querySubAdmins = `SELECT users.userName,users.firstName,users.lastName,users.password, users.email,users.isDisabled, users.id FROM users WHERE users.userRole = 'SUBADMIN';`;
      let getAllSubAdmins = await db.sequelize
        .query(querySubAdmins)
        .then(([results, metadata]) => results);

      return res.status(200).send({
        success: true,
        msg: "All Admins and SubAdmins fetched.",
        admins: getAllAdmins,
        subAdmins: getAllSubAdmins,
      });
    } catch (error) {
      return res.status(500).json({
        success: false,
        msg: error.message,
      });
    }
  }

  async updateUserRole(req, res) {
    try {
      const { role, email } = req.body;
      // Fetch the user by email
      const getUser = await userSchema.findOne({ where: { email: email } });
      if (getUser && getUser.userRole === role) {
        return res.send({
          success: false,
          msg: `This User is already ${role}.`,
        });
      } else {
        if (getUser) {
          // Update the role if the user exists
          const updateRole = await userSchema.update(
            { userRole: role === "ADMIN" ? "ADMIN" : "SUBADMIN" },
            { where: { id: getUser.id } }
          );
        } else {
          // Fetch the couple by email if user not found
          const getCouple = await coupleSchema.findOne({
            where: {
              [Op.or]: [{ hisEmail: email }, { herEmail: email }],
            },
          });
          if (getCouple) {
            const randomPass = Math.random().toString(36).slice(-8);
            const passwordForCouple = "p" + randomPass.slice(1);
            let adminObj = null;
            // Create the admin object
            if (getCouple.hisEmail === email) {
              adminObj = {
                userName: getCouple.hisFirstName,
                email: getCouple.hisEmail,
                password: passwordForCouple,
                accountStatus: "ACTIVE",
                userRole: role === "ADMIN" ? "ADMIN" : "SUBADMIN",
                coupleId: getCouple.id,
                emailVerified: 1,

                firstName: getCouple.hisFirstName ? getCouple.hisFirstName : "",
                lastName: getCouple.hisLastName ? getCouple.hisLastName : "",
                mobile: getCouple.hisMobile ? getCouple.hisMobile : "",
                imageUpload: getCouple.imageUrl,
              };
            } else {
              adminObj = {
                userName: getCouple.herFirstName,
                email: getCouple.herEmail,
                password: passwordForCouple,
                accountStatus: "ACTIVE",
                userRole: role === "ADMIN" ? "ADMIN" : "SUBADMIN",
                coupleId: getCouple.id,
                emailVerified: 1,
                firstName: getCouple.herFirstName ? getCouple.herFirstName : "",
                lastName: getCouple.herLastName ? getCouple.herLastName : "",
                mobile: getCouple.herMobile ? getCouple.herMobile : "",
                imageUpload: getCouple.imageUrl,
              };
            }
            // Save the new user
            if (adminObj !== null) {
              const newUser = await userSchema.create(adminObj);
            }
          }
        }
        return res.send({
          success: true,
          msg: `Role updated.`,
        });
      }
    } catch (error) {
      console.error("Error updating user role:", error);
      return res.status(500).send({
        error: true,
        msg: "Something went wrong, please try again.",
      });
    }
  }

  async removeUserRole(req, res) {
    try {
      const { removeId } = req.body;

      // Update the user's role
      const updateRole = await userSchema.update(
        { userRole: "COUPLE" },
        { where: { id: removeId } }
      );

      if (updateRole[0] === 0) {
        return res.status(404).send({
          success: false,
          msg: "User not found",
        });
      }

      return res.status(200).send({
        success: true,
        msg: "Role Updated",
      });
    } catch (err) {
      console.error("Error updating user role:", err);
      return res.status(500).json({
        success: false,
        msg: "An error occurred while updating the user role.",
      });
    }
  }

  async changeAdminAccess(req, res) {
    try {
      const { id, isDisabled } = req.body;

      // Validate inputs
      if (typeof id !== "number" || ![0, 1].includes(isDisabled)) {
        return res.status(400).send({
          success: false,
          msg: "Invalid input data",
        });
      }

      // Toggle isDisabled status
      const newIsDisabledStatus = isDisabled === 1 ? 0 : 1;

      // Update the user's role
      const updateRole = await userSchema.update(
        { isDisabled: newIsDisabledStatus },
        { where: { id: id } }
      );

      // Check if the user was found and updated
      if (updateRole[0] === 0) {
        return res.status(404).send({
          success: false,
          msg: "User not found",
        });
      }

      return res.status(200).send({
        success: true,
        msg: "Access Updated",
      });
    } catch (err) {
      console.error("Error updating user role:", err);
      return res.status(500).json({
        success: false,
        msg: "An error occurred while updating the user role.",
      });
    }
  }

  async deleteCoupleFromRoaster(req, res) {
    let { id, coupleId, retreatId } = req.body;
    try {
      if (coupleId) {
        let deleteCoupleFromRoast = await retreatRoastSchema.findAll({
          where: {
            [Op.and]: {
              coupleId: coupleId,
              retreatId: retreatId,
            },
          },
          raw: true,
        });

        if (deleteCoupleFromRoast.length > 1) {
          // Fetch couple details before deletion (for image paths)
          const coupleDetail = await coupleSchema.findOne({
            where: { id: coupleId },
            raw: true,
          });
          if (coupleDetail) {
            // Delete profile image if exists
            if (coupleDetail.imageUrl) {
              const profileImagePath = path.join(
                PROJECT_DIR,
                "profileImage",
                path.basename(coupleDetail.imageUrl)
              );
              if (fs.existsSync(profileImagePath)) {
                fs.unlinkSync(profileImagePath);
              }
            }
          }
          // Delete related DB records
          await userSchema.destroy({ where: { coupleId: coupleId } });
          await coupleSchema.destroy({ where: { id: coupleId } });
        } else {
          // Just remove from roast table, keep couple + images
          await retreatRoastSchema.destroy({
            where: {
              [Op.and]: {
                coupleId: coupleId,
                retreatId: retreatId,
              },
            },
          });
        }

        return res.status(200).send({
          success: true,
          msg: "Couple deleted successfully.",
        });
      } else {
        return res.status(200).json({
          success: false,
          msg: "Error in Primary Key.",
        });
      }
    } catch (error) {
      console.log("error:", error);
      return res.status(200).json({
        success: false,
        msg: error.message || error,
      });
    }
  }

  async sendLoginDetail(req, res) {
    const { myData, myRole } = req.body;
    if (!myData) {
      return res.status(200).send({ success: false, msg: "ID is required." });
    }

    try {
      let subAdmins;

      if (myRole === "Committee Member") {
        subAdmins = await userSchema.findOne({
          where: { id: myData.userId },
        });
      } else {
        subAdmins = await userSchema.findOne({
          where: { id: myData.id },
        });
      }

      if (!subAdmins) {
        return res.status(200).send({
          success: false,
          msg: "Role not found.",
        });
      }

      const replData = SENDLOGINDETAILTOSUBADMIN.replace(
        /#firstName#/g,
        subAdmins.firstName || ""
      )
        .replace(/#lastName#/g, subAdmins.lastName || "")
        .replace(/#role#/g, myRole || "")
        .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)
        .replace(/#email#/g, subAdmins.email || "Nil")
        .replace(/#password#/g, subAdmins.password || "Nil");

      if (!subAdmins.email) {
        return res.status(200).send({
          success: false,
          msg: "Email is missing.",
        });
      }

      Email.sendEmail(
        subAdmins.email,
        "Login Details - LOVESTRONG Marriage",
        replData
      );

      return res.status(200).send({
        success: true,
        msg: "Mail sent successfully.",
      });
    } catch (error) {
      console.error("Error sending login details:", error);
      return res.status(200).json({
        success: false,
        msg: "An error occurred while sending the email.",
      });
    }
  }
}

module.exports = new AdminController();
