const dotenv = require("dotenv");
dotenv.config();
const nodemailer = require("nodemailer");
var transporter = nodemailer.createTransport({
  service: "gmail",
  auth: {
    user: process.env.MAIL_USER,
    pass: process.env.MAIL_PASSWORD,
  },
});

exports.sendEmail = function (to, subject, html) {
  var mailOptions = {
    from: process.env.MAIL_USER,
    to: to,
    subject: subject,
    html: html,
  };

  transporter.sendMail(mailOptions, function (error, info) {
    if (error) {
      console.log(
        `Email sent timestamp --> [${new Date().toLocaleString("en-US", {
          timeZoneName: "short",
        })}]\n` +
          `Email sent to --> [${to}]\n` +
          `Error ----->` +
          error
      );
    } else {
      console.log(
        `Email sent timestamp --> [${new Date().toLocaleString("en-US", {
          timeZoneName: "short",
        })}]\n` +
          `Email sent to --> [${to}]\n` +
          info.response
      );
    }
  });
};

// const sendGridMail = require('@sendgrid/mail');
// sendGridMail.setApiKey(process.env.SENDGRID_API_KEY);

// function getMessage(toEmail, subject,template) {
//   console.log("toEmail, subject,template" , toEmail, subject,template);
//   const body = 'This is a test email using SendGrid from Node.js';
//   return {
//     to:toEmail,
//     from:"love@lovestrongmarriage.com",
//     subject: subject,
//     // text: body,
//     html: template,
//   };
// }

// exports.sendEmail = async (toEmail, subject, template) =>  {
//   try {
//     let data = await sendGridMail.send(getMessage(toEmail, subject, template));
//     console.log("data",data);
//     console.log('Email sent successfully1111');
//     return true;
//   } catch (error) {
//     console.error('Error sending test email');
//     console.error(error);
//     if (error.response) {
//       console.error(error.response.body)
//     }
//   }
// }
