const Router = require("express").Router;
const router = new Router();
const auth = require("./AuthRoutes");
const adminRoutes = require("./AdminRoutes");
const serviceRoutes = require("./ServiceRoutes");
const talksRoutes = require("./TalksRoutes");
const rolesRoutes = require("./RolesRoutes");
const sendEmailRoutes = require("./SendEmailRoutes");
const retreatRoutes = require("./RetreatRoutes");
const perishRoutes = require("./PerishRoutes");
const retreatRoastRoutes = require("./retreatRoasterRoutes");
const quickReportRoutes = require("./QuickReportRoutes");
const directoryRoutes = require("./DirectoryRoutes");
const ProgramRoutes = require("./ProgramRoutes");
const RetreatBackUpRoutes = require("./RetreatBackUpRoutes");
const CommitteeRoutes = require("./CommitteeRoutes");
const parishCategoryRoutes = require("./ParishCategoriesRoutes");
const helpRoutes = require("./HelpRoutes");

const middleware = require("../middleware/middleware");

router.route("/").get((req, res) => {
  res.json({ message: "LoveStrong API" });
});

router.use("/api/auth", auth);
router.use("/api/admin", middleware, adminRoutes);
router.use("/api/service", middleware, serviceRoutes);
router.use("/api/talks", middleware, talksRoutes);
router.use("/api/roles", middleware, rolesRoutes);
router.use("/api/email", middleware, sendEmailRoutes);
router.use("/api/retreat", middleware, retreatRoutes);
router.use("/api/retreatRoast", middleware, retreatRoastRoutes);
router.use("/api/perish", middleware, perishRoutes);
router.use("/api/quickReport", middleware, quickReportRoutes);
router.use("/api/directory", middleware, directoryRoutes);
router.use("/api/program", middleware, ProgramRoutes);
router.use("/api/committee", middleware, CommitteeRoutes);
router.use("/api/parish-categories", middleware, parishCategoryRoutes);
router.use("/api/help", middleware, helpRoutes);
router.use("/api/retreat-backup", middleware, RetreatBackUpRoutes);

module.exports = router;
