module.exports = (sequelize, Sequelize) => {
  const RetreatSchema = sequelize.define("retreat", {
    title: {
      type: Sequelize.STRING,
    },
    parishId: {
      type: Sequelize.INTEGER,
      references: {
        model: "parishes",
        key: "id",
      },
    },
    language: {
      type: Sequelize.STRING,
    },
    location: {
      type: Sequelize.STRING,
    },
    image1: {
      type: Sequelize.STRING(1234),
    },
    image2: {
      type: Sequelize.STRING(1234),
    },

    heading: {
      type: Sequelize.STRING,
    },
    mission_statement: {
      type: Sequelize.TEXT,
    },
    description: {
      type: Sequelize.TEXT,
    },
    schedule: {
      type: Sequelize.TEXT,
    },
    dateFrom: {
      type: Sequelize.DATE,
    },
    dateTo: {
      type: Sequelize.DATE,
    },
    deleteStatus: {
      type: Sequelize.STRING,
    },
    mail_msg: {
      type: Sequelize.TEXT,
    },
    accessIds: {
      type: Sequelize.TEXT,
    },
    disabledIds: {
      type: Sequelize.TEXT,
    },
    contact_name: {
      type: Sequelize.STRING,
    },
    contact_email: {
      type: Sequelize.STRING,
    },
    contact_mobile: {
      type: Sequelize.STRING,
    },
    programFile: {
      type: Sequelize.STRING(255),
    },
    directoryFile: {
      type: Sequelize.STRING(255),
    },
    freeze: {
      type: Sequelize.ENUM("FREEZE", "UNFREEZE"),
      defaultValue: "UNFREEZE",
    },
    confirmation: {
      type: Sequelize.TEXT,
    },
    status: {
      type: Sequelize.ENUM("ACTIVE", "INACTIVE"),
      defaultValue: "ACTIVE",
    },
    inactiveReason: {
      type: Sequelize.TEXT,
      allowNull: true,
    },
    retreatCloseStatus: {
      type: Sequelize.BOOLEAN,
      defaultValue: false,
    },
  });

  return RetreatSchema;
};
