var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import { getHours, getMinutes, getSeconds } from '@wojtekmaj/date-utils';
import Input from './Input.js';
import { safeMin, safeMax } from '../shared/utils.js';
export default function SecondInput(_a) {
    var hour = _a.hour, maxTime = _a.maxTime, minTime = _a.minTime, minute = _a.minute, _b = _a.showLeadingZeros, showLeadingZeros = _b === void 0 ? true : _b, otherProps = __rest(_a, ["hour", "maxTime", "minTime", "minute", "showLeadingZeros"]);
    function isSameMinute(date) {
        return hour === getHours(date).toString() && minute === getMinutes(date).toString();
    }
    var maxSecond = safeMin(59, maxTime && isSameMinute(maxTime) && getSeconds(maxTime));
    var minSecond = safeMax(0, minTime && isSameMinute(minTime) && getSeconds(minTime));
    return (React.createElement(Input, __assign({ max: maxSecond, min: minSecond, name: "second", showLeadingZeros: showLeadingZeros }, otherProps)));
}
