const jwt = require("jsonwebtoken");
const Users = require("../database/dbConnection");

const verifyToken = async (req, res, next) => {
  if (
    req.headers.authorization &&
    req.headers.authorization.split(" ")[0] === "Bearer"
  ) {
    try {
      token = req.headers.authorization.split(" ")[1];
      if (token) {
        jwt.verify(token, process.env.jwtAccessTokenSecret, (err, valid) => {
          if (err) {
            res.status(201).send("Please not provided valid token.");
          } else {
            next();
          }
        });
      } else {
        return res.send({
          error: true,
          msg: "Please not provided valid token.",
        });
      }
    } catch (error) {
      return res.send({
        error: true,
        msg: "Session expired, Please login again",
      });
    }
  } else {
    res.status(200).send({
      error: true,
      msg: "Access Token is not provided.",
    });
  }
};

module.exports = verifyToken;
