require("dotenv").config();
const http = require("http");
const express = require("express");
const cors = require("cors");
const routes = require("./src/routers/router.js");
const db = require("./src/database/dbConnection");
const session = require("express-session");
const bodyParser = require("body-parser");
const app = express();
const server = http.createServer(app);
const Users = require("./src/database/dbConnection");
const userSchema = Users.user;
const coupleSchema = Users.couple;
const { Op } = require("sequelize");
const fileUpload = require("express-fileupload");
const path = require("path");
const getRetreatMetaData =
  require("./src/controllers/RetreatController").getRetreatMetaData;
const fs = require("fs");
const cron = require("node-cron");
// // const { google } = require("googleapis");
const scheduleCommitteeRetreatReminder = require("./src/cronJobs/committeeRetreatReminderCron");
const autoConfirmPicturesAndCloseRetreats = require("./src/cronJobs/autoConfirmPicturesAndCloseRetreats");

const scheduleWebsiteUptimeCheck = require("./src/cronJobs/healthCheck.js");

app.use(fileUpload());

app.use(express.static(path.join(__dirname, "../frontend/build")));

app.use(
  bodyParser.json({
    limit: "500mb",
  })
);

app.use(
  bodyParser.urlencoded({
    limit: "500mb",
    parameterLimit: 1000000,
    extended: true,
  })
);

app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));
app.use(cors());
app.use("/", routes);
app.use(
  session({
    cookie: {
      maxAge: 60 * 60 * 100000,
      expires: new Date(Date.now() + 60 * 60 * 100000),
    },
    secret: "####$$%%LoVeStRoNg!!!...",
    resave: false,
    saveUninitialized: false,
  })
);

app.get("/*", async (req, res, next) => {
  if (req.url.startsWith("/public/")) {
    let reqfilename = req.url.replace("/public/", "");
    reqfilename = decodeURI(reqfilename);
    res.sendFile(path.join(__dirname, "public", reqfilename));
  } else {
    /*************Add Dynamic Meta*************/
    let retreatData = {};
    if (req.url.startsWith("/registration-retreat/")) {
      const retreatId = req.url.split("/")[2];
      if (retreatId) {
        retreatData = await getRetreatMetaData(retreatId);
      }
    }

    const indexHtmlPath = path.join(
      __dirname,
      "../frontend/build",
      "index.html"
    );
    let indexHtml = await fs.promises.readFile(indexHtmlPath, "utf-8");

    // Replace meta tags with dynamic values
    indexHtml = indexHtml
      .replace(
        /<title>(.*?)<\/title>/,
        `<title>${retreatData?.title || "Lovestrong Marriage"}</title>`
      )
      .replace(
        /<meta name="description" content="(.*?)">/,
        `<meta name="description" content="${
          retreatData?.description || "Welcome to Lovestrong Marriage"
        }">`
      )
      .replace(
        /<meta property="og:image" content="(.*?)">/,
        `<meta property="og:image" content="${
          retreatData?.imageUrl ||
          "https://lovestrong.koolderbyacademy.com/logo.png"
        }">`
      );

    res.send(indexHtml);
  }
});

// Chrome Extension Create Image Link
app.post("/api/image/screenshot", async function (req, res) {
  // console.log("111111111111");
  if (!req.files || Object.keys(req.files).length === 0) {
    return res.status(200).send("No files were uploaded.");
  }
  let file;
  let fileUrl;
  file = req.files.image;
  let fileName = file.name;
  // for production
  fileUrl =
    `${process.cwd()}/../../76east/images/extensions-screenshot/` + fileName;

  console.log("fileUrl---->", fileUrl);

  // for local testing
  // fileUrl = `${process.cwd()}/extensions-screenshot/` + fileName;

  if (fileUrl && fileUrl !== "") {
    file.mv(fileUrl, async function (err) {
      if (err) {
        return res.status(500).send(err);
      }
      return res.send({
        success: true,
        msg: "File uploaded!",
        data: `https://76east.com/images/extensions-screenshot/${fileName}`,
      });
    });
  }
});

// Chrome Extension Create Video  Link
// app.post("/api/image/recording", async function (req, res) {
//   // console.log("111111111111");
//   if (!req.files || Object.keys(req.files).length === 0) {
//     return res.status(200).send("No files were uploaded.");
//   }
//   let file;
//   let fileUrl;
//   file = req.files.video;
//   let fileName = file.name;
//   // for production
//   fileUrl =
//     `${process.cwd()}/../../76east/images/extensions-screenshot/` + fileName;

//   console.log("fileUrl---->", fileUrl);

//   // for local testing
//   // fileUrl = `${process.cwd()}/extensions-screenshot/` + fileName;

//   if (fileUrl && fileUrl !== "") {
//     file.mv(fileUrl, async function (err) {
//       if (err) {
//         return res.status(500).send(err);
//       }
//       return res.send({
//         success: true,
//         msg: "File uploaded!",
//         data: `https://76east.com/images/extensions-screenshot/${fileName}`,
//       });
//     });
//   }
// });

// Google Drive API setup
// const KEY_FILE_PATH = "credentials.json"; // 🔹 Service Account JSON file path
// const SCOPES = ["https://www.googleapis.com/auth/drive.file"];
// const PARENT_FOLDER_ID = "1rgzGrw0EZlwgyUEduEKWq2EcvEgxB9yL"; // 🔹 Google Drive Folder ID

// const auth = new google.auth.GoogleAuth({
//   keyFile: KEY_FILE_PATH,
//   scopes: SCOPES,
// });

// const drive = google.drive({ version: "v3", auth });

// // API for uploading video to Google Drive
// // Chrome Extension Create Video  Link
// app.post("/api/image/recording", async function (req, res) {
//   try {
//     if (!req.files || Object.keys(req.files).length === 0) {
//       return res.status(400).send("No files were uploaded.");
//     }

//     let file = req.files.video;
//     let fileName = file.name;
//     let tempPath = `./${fileName}`;

//     // Save file temporarily
//     await file.mv(tempPath);

//     // Upload file to Google Drive
//     const fileMetadata = {
//       name: fileName,
//       parents: [PARENT_FOLDER_ID], // 🔹 Folder ID where file will be saved
//     };
//     const media = {
//       mimeType: file.mimetype,
//       body: fs.createReadStream(tempPath),
//     };

//     const response = await drive.files.create({
//       requestBody: fileMetadata,
//       media: media,
//       fields: "id",
//     });

//     // Delete local file after upload
//     fs.unlinkSync(tempPath);

//     // Generate Public URL
//     const fileId = response.data.id;
//     await drive.permissions.create({
//       fileId: fileId,
//       requestBody: {
//         role: "reader",
//         type: "anyone",
//       },
//     });

//     const fileUrl = `https://drive.google.com/file/d/${fileId}/view`;

//     return res.send({
//       success: true,
//       msg: "Video uploaded to Google Drive!",
//       data: fileUrl,
//     });
//   } catch (error) {
//     console.error("Error:", error);
//     return res.status(500).send("Internal Server Error");
//   }
// });

// file & image uplaod
app.post("/api/upload", async function (req, res) {
  // console.log('req.files.file: ',req.files,'userId', req.body.userId);

  if (!req.files || Object.keys(req.files).length === 0) {
    return res.status(200).send("No files were uploaded.");
  }
  let coupleDetail = await coupleSchema.findOne(
    {
      where: {
        [Op.or]: [
          { hisEmail: result1[0].email },
          { herEmail: result1[0].email },
        ],
      },
    }
  );
  let file;
  let fileUrl;
  file = req.files.file;
  let id = req.body.userId;
  // let fileName = new Date().getTime()+"-"+file.name;
        const now = new Date();
        const currentDate = now.toISOString().split('T')[0]; 
        const fileExtension = file.name.substring(file.name.lastIndexOf('.'));
        const fileName = `${coupleDetail.hisLastName}, ${coupleDetail.hisFirstName} & ${coupleDetail.herFirstName}_${currentDate}${fileExtension}`;
  fileUrl = __dirname + "/public/profileImage/" + fileName;
  // console.log('upload images url..', fileUrl);
  let imgUrl = process.env.SERVERADDRESS + "/public/profileImage/" + fileName;
  // console.log('imgUrl:', imgUrl);
  let result = await userSchema.update(
    { imageUpload: imgUrl },
    { where: { id } }
  );
  let result1 = await userSchema.findAll({ where: { id }, raw: true });
  let coupleUpdate = await coupleSchema.update(
    {
      imageUrl: result1[0].imageUpload,
    },
    {
      where: {
        [Op.or]: [
          { hisEmail: result1[0].email },
          { herEmail: result1[0].email },
        ],
      },
    }
  );
  if (result) {
    file.mv(fileUrl, async function (err) {
      if (err) {
        return res.status(500).send(err);
      }
      return res.send({
        success: true,
        msg: "File uploaded!",
        data: result1[0],
      });
    });
  }
});

cron.schedule("0 0 * * *", async () => {
  try {
    const query =
      "DELETE FROM logreports WHERE createdAt < NOW() - INTERVAL 4 MONTH;";
    let responseData = await db.sequelize
      .query(query)
      .then(([results, metadata]) => results);
    if (responseData) {
      console.log(`Deleted records older than 4 months`);
    } else {
      console.error("Error deleting old records:", err);
    }
  } catch (error) {
    console.error("Error executing cron job:", error.message);
  }
});

scheduleCommitteeRetreatReminder();
autoConfirmPicturesAndCloseRetreats();
scheduleWebsiteUptimeCheck();

const start = async () => {
  try {
    db.sequelize.sync({ alter: true });
    server.listen(process.env.PORT || process.env.SERVERPORT, () => {
      console.log(
        "Server is listeninig on: ",
        process.env.PORT || process.env.SERVERPORT
      );
    });
  } catch (error) {
    console.log(error);
  }
};

start();
