const cron = require("node-cron");
const https = require("https");
const Email = require("../helper/sendEmail");

const scheduleWebsiteUptimeCheck = () => {
  // "* * * * *"  for every one minute//
  cron.schedule("*/10 * * * *", () => {
    const hostsToCheck = [
      "lovestrong.koolderbyacademy.com",
      "lovestrongmarriage.com",
    ];

    const recipients = [
      "manpreet02701@gmail.com",
      "gurvinder1902@gmail.com",
      "vishuprajapati15@gmail.com",
      "vandanachadha@gmail.com",
    ];

    hostsToCheck.forEach((host) => {
      const options = {
        hostname: host,
        port: 443,
        path: "/",
        method: "GET",
        timeout: 10000,
      };

      const req = https.request(options, (res) => {
        console.log(`[${host}] res.statusCode:`, res.statusCode);

        if (res.statusCode !== 200) {
          const subject = `🚨 Website Down: ${host} (Status ${res.statusCode})`;
          const message = `Your site (${host}) is down. Please check your site.\n\nStatus Code: ${res.statusCode}`;

          recipients.forEach((email) => {
            Email.sendEmail(email, subject, message);
          });
        }
      });

      req.on("error", (error) => {
        const subject = `🚨 Website Unreachable: ${host}`;
        const message = `Your website (${host}) is unreachable.\n\nError: ${error.message}`;

        recipients.forEach((email) => {
          Email.sendEmail(email, subject, message);
        });
      });

      req.end();
    });
  });
};

module.exports = scheduleWebsiteUptimeCheck;
