/// <reference types="node" />
import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosPromise, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace adsenseplatform_v1alpha {
    export interface Options extends GlobalOptions {
        version: 'v1alpha';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * AdSense Platform API
     *
     *
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const adsenseplatform = google.adsenseplatform('v1alpha');
     * ```
     */
    export class Adsenseplatform {
        context: APIRequestContext;
        accounts: Resource$Accounts;
        platforms: Resource$Platforms;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * Representation of an Account.
     */
    export interface Schema$Account {
        /**
         * Output only. Creation time of the account.
         */
        createTime?: string | null;
        /**
         * Required. An opaque token that uniquely identifies the account among all the platform's accounts. This string may contain at most 64 non-whitespace ASCII characters, but otherwise has no predefined structure. However, it is expected to be a platform-specific identifier for the user creating the account, so that only a single account can be created for any given user. This field must not contain any information that is recognizable as personally identifiable information. e.g. it should not be an email address or login name. Once an account has been created, a second attempt to create an account using the same creation_request_id will result in an ALREADY_EXISTS error.
         */
        creationRequestId?: string | null;
        /**
         * Display name of this account.
         */
        displayName?: string | null;
        /**
         * Output only. Resource name of the account. Format: platforms/pub-[0-9]+/accounts/pub-[0-9]+
         */
        name?: string | null;
        /**
         * Required. Input only. CLDR region code of the country/region of the address. Set this to country code of the child account if known, otherwise to your own country code.
         */
        regionCode?: string | null;
        /**
         * Output only. Approval state of the account.
         */
        state?: string | null;
        /**
         * Required. The IANA TZ timezone code of this account. For more information, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. This field is used for reporting. It is recommended to set it to the same value for all child accounts.
         */
        timeZone?: Schema$TimeZone;
    }
    /**
     * Address data.
     */
    export interface Schema$Address {
        /**
         * First line of address. Max length 64 bytes or 30 characters.
         */
        address1?: string | null;
        /**
         * Second line of address. Max length 64 bytes or 30 characters.
         */
        address2?: string | null;
        /**
         * City. Max length 60 bytes or 30 characters.
         */
        city?: string | null;
        /**
         * Name of the company. Max length 255 bytes or 34 characters.
         */
        company?: string | null;
        /**
         * Contact name of the company. Max length 128 bytes or 34 characters.
         */
        contact?: string | null;
        /**
         * Fax number with international code (i.e. +441234567890).
         */
        fax?: string | null;
        /**
         * Phone number with international code (i.e. +441234567890).
         */
        phone?: string | null;
        /**
         * Country/Region code. The region is specified as a CLDR region code (e.g. "US", "FR").
         */
        regionCode?: string | null;
        /**
         * State. Max length 60 bytes or 30 characters.
         */
        state?: string | null;
        /**
         * Zip/post code. Max length 10 bytes or 10 characters.
         */
        zip?: string | null;
    }
    /**
     * Request definition for the account close rpc.
     */
    export interface Schema$CloseAccountRequest {
    }
    /**
     * Response definition for the account close rpc.
     */
    export interface Schema$CloseAccountResponse {
    }
    /**
     * A representation of a decimal value, such as 2.5. Clients may convert values into language-native decimal formats, such as Java's [BigDecimal](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/math/BigDecimal.html) or Python's [decimal.Decimal](https://docs.python.org/3/library/decimal.html).
     */
    export interface Schema$Decimal {
        /**
         * The decimal value, as a string. The string representation consists of an optional sign, `+` (`U+002B`) or `-` (`U+002D`), followed by a sequence of zero or more decimal digits ("the integer"), optionally followed by a fraction, optionally followed by an exponent. An empty string **should** be interpreted as `0`. The fraction consists of a decimal point followed by zero or more decimal digits. The string must contain at least one digit in either the integer or the fraction. The number formed by the sign, the integer and the fraction is referred to as the significand. The exponent consists of the character `e` (`U+0065`) or `E` (`U+0045`) followed by one or more decimal digits. Services **should** normalize decimal values before storing them by: - Removing an explicitly-provided `+` sign (`+2.5` -\> `2.5`). - Replacing a zero-length integer value with `0` (`.5` -\> `0.5`). - Coercing the exponent character to upper-case, with explicit sign (`2.5e8` -\> `2.5E+8`). - Removing an explicitly-provided zero exponent (`2.5E0` -\> `2.5`). Services **may** perform additional normalization based on its own needs and the internal decimal implementation selected, such as shifting the decimal point and exponent value together (example: `2.5E-1` <-\> `0.25`). Additionally, services **may** preserve trailing zeroes in the fraction to indicate increased precision, but are not required to do so. Note that only the `.` character is supported to divide the integer and the fraction; `,` **should not** be supported regardless of locale. Additionally, thousand separators **should not** be supported. If a service does support them, values **must** be normalized. The ENBF grammar is: DecimalString = '' | [Sign] Significand [Exponent]; Sign = '+' | '-'; Significand = Digits '.' | [Digits] '.' Digits; Exponent = ('e' | 'E') [Sign] Digits; Digits = { '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' \}; Services **should** clearly document the range of supported values, the maximum supported precision (total number of digits), and, if applicable, the scale (number of digits after the decimal point), as well as how it behaves when receiving out-of-bounds values. Services **may** choose to accept values passed as input even when the value has a higher precision or scale than the service supports, and **should** round the value to fit the supported scale. Alternatively, the service **may** error with `400 Bad Request` (`INVALID_ARGUMENT` in gRPC) if precision would be lost. Services **should** error with `400 Bad Request` (`INVALID_ARGUMENT` in gRPC) if the service receives a value outside of the supported range.
         */
        value?: string | null;
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); \}
     */
    export interface Schema$Empty {
    }
    /**
     * A platform sub-account event to record spam signals.
     */
    export interface Schema$Event {
        /**
         * Required. Information associated with the event.
         */
        eventInfo?: Schema$EventInfo;
        /**
         * Required. Event timestamp.
         */
        eventTime?: string | null;
        /**
         * Required. Event type.
         */
        eventType?: string | null;
    }
    /**
     * Private information for partner recorded events (PII).
     */
    export interface Schema$EventInfo {
        /**
         * The billing address of the publisher associated with this event, if available.
         */
        billingAddress?: Schema$Address;
        /**
         * Required. The email address that is associated with the publisher when performing the event.
         */
        email?: string | null;
    }
    /**
     * Response definition for the list accounts rpc.
     */
    export interface Schema$ListAccountsResponse {
        /**
         * The Accounts returned in the list response. Represented by a partial view of the Account resource, populating `name` and `creation_request_id`.
         */
        accounts?: Schema$Account[];
        /**
         * Continuation token used to page through accounts. To retrieve the next page of the results, set the next request's "page_token" value to this.
         */
        nextPageToken?: string | null;
    }
    /**
     * Response definition for the list platform child sites rpc.
     */
    export interface Schema$ListPlatformChildSitesResponse {
        /**
         * Continuation token used to page through platforms. To retrieve the next page of the results, set the next request's "page_token" value to this.
         */
        nextPageToken?: string | null;
        /**
         * The platform child sites returned in this list response.
         */
        platformChildSites?: Schema$PlatformChildSite[];
    }
    /**
     * Response definition for the platform groups list rpc.
     */
    export interface Schema$ListPlatformGroupsResponse {
        /**
         * Continuation token used to page through platforms. To retrieve the next page of the results, set the next request's "page_token" value to this.
         */
        nextPageToken?: string | null;
        /**
         * The platform groups returned in this list response.
         */
        platformGroups?: Schema$PlatformGroup[];
    }
    /**
     * Response definition for the platform list rpc.
     */
    export interface Schema$ListPlatformsResponse {
        /**
         * Continuation token used to page through platforms. To retrieve the next page of the results, set the next request's "page_token" value to this.
         */
        nextPageToken?: string | null;
        /**
         * The platforms returned in this list response.
         */
        platforms?: Schema$Platform[];
    }
    /**
     * Response definition for the site list rpc.
     */
    export interface Schema$ListSitesResponse {
        /**
         * Continuation token used to page through sites. To retrieve the next page of the results, set the next request's "page_token" value to this.
         */
        nextPageToken?: string | null;
        /**
         * The sites returned in this list response.
         */
        sites?: Schema$Site[];
    }
    /**
     * Response definition for the lookup account rpc.
     */
    export interface Schema$LookupAccountResponse {
        /**
         * The name of the Account Format: platforms/{platform\}/accounts/{account_id\}
         */
        name?: string | null;
    }
    /**
     * Representation of a Transparent Platform.
     */
    export interface Schema$Platform {
        /**
         * Default platform group for the platform.
         */
        defaultPlatformGroup?: string | null;
        /**
         * Output only. Description of the platform.
         */
        description?: string | null;
        /**
         * Identifier. Resource name of a platform. Format: accounts/{account\}/platforms/{platform\}
         */
        name?: string | null;
    }
    /**
     * Representation of a Transparent Platform Child Site.
     */
    export interface Schema$PlatformChildSite {
        /**
         * Output only. Domain URL of the Platform Child Site. Part of the PlatformChildSite name.
         */
        domain?: string | null;
        /**
         * Identifier. Format: accounts/{account\}/platforms/{platform\}/childAccounts/{child_account\}/sites/{platform_child_site\}
         */
        name?: string | null;
        /**
         * Resource name of the Platform Group of the Platform Child Site.
         */
        platformGroup?: string | null;
    }
    /**
     * Representation of a Transparent Platform Group.
     */
    export interface Schema$PlatformGroup {
        /**
         * Output only. Description of the PlatformGroup.
         */
        description?: string | null;
        /**
         * Identifier. Format: accounts/{account\}/platforms/{platform\}/groups/{platform_group\}
         */
        name?: string | null;
        /**
         * The revenue share of the PlatformGroup, in millipercent (e.g. 15000 = 15%).
         */
        revshareMillipercent?: Schema$Decimal;
    }
    /**
     * Response definition for the site request review rpc.
     */
    export interface Schema$RequestSiteReviewResponse {
    }
    /**
     * Representation of a Site.
     */
    export interface Schema$Site {
        /**
         * Domain/sub-domain of the site. Must be a valid domain complying with [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt) and formatted as punycode [RFC 3492](https://www.ietf.org/rfc/rfc3492.txt) in case the domain contains unicode characters.
         */
        domain?: string | null;
        /**
         * Output only. Resource name of a site. Format: platforms/{platform\}/accounts/{account\}/sites/{site\}
         */
        name?: string | null;
        /**
         * Output only. State of a site.
         */
        state?: string | null;
    }
    /**
     * Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
     */
    export interface Schema$TimeZone {
        /**
         * IANA Time Zone Database time zone. For example "America/New_York".
         */
        id?: string | null;
        /**
         * Optional. IANA Time Zone Database version number. For example "2019a".
         */
        version?: string | null;
    }
    export class Resource$Accounts {
        context: APIRequestContext;
        platforms: Resource$Accounts$Platforms;
        constructor(context: APIRequestContext);
    }
    export class Resource$Accounts$Platforms {
        context: APIRequestContext;
        childAccounts: Resource$Accounts$Platforms$Childaccounts;
        groups: Resource$Accounts$Platforms$Groups;
        constructor(context: APIRequestContext);
        /**
         * Gets a platform.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Accounts$Platforms$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Accounts$Platforms$Get, options?: MethodOptions): GaxiosPromise<Schema$Platform>;
        get(params: Params$Resource$Accounts$Platforms$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Accounts$Platforms$Get, options: MethodOptions | BodyResponseCallback<Schema$Platform>, callback: BodyResponseCallback<Schema$Platform>): void;
        get(params: Params$Resource$Accounts$Platforms$Get, callback: BodyResponseCallback<Schema$Platform>): void;
        get(callback: BodyResponseCallback<Schema$Platform>): void;
        /**
         * Lists platforms for a specified account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Accounts$Platforms$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Accounts$Platforms$List, options?: MethodOptions): GaxiosPromise<Schema$ListPlatformsResponse>;
        list(params: Params$Resource$Accounts$Platforms$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Accounts$Platforms$List, options: MethodOptions | BodyResponseCallback<Schema$ListPlatformsResponse>, callback: BodyResponseCallback<Schema$ListPlatformsResponse>): void;
        list(params: Params$Resource$Accounts$Platforms$List, callback: BodyResponseCallback<Schema$ListPlatformsResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListPlatformsResponse>): void;
    }
    export interface Params$Resource$Accounts$Platforms$Get extends StandardParameters {
        /**
         * Required. The name of the platform to retrieve. Format: accounts/{account\}/platforms/{platform\}
         */
        name?: string;
    }
    export interface Params$Resource$Accounts$Platforms$List extends StandardParameters {
        /**
         * Optional. The maximum number of platforms to include in the response, used for paging. If unspecified, at most 10000 platforms will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
         */
        pageSize?: number;
        /**
         * Optional. A page token, received from a previous `ListPlatforms` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListPlatforms` must match the call that provided the page token.
         */
        pageToken?: string;
        /**
         * Required. The account which owns the platforms. Format: accounts/{account\}
         */
        parent?: string;
    }
    export class Resource$Accounts$Platforms$Childaccounts {
        context: APIRequestContext;
        sites: Resource$Accounts$Platforms$Childaccounts$Sites;
        constructor(context: APIRequestContext);
    }
    export class Resource$Accounts$Platforms$Childaccounts$Sites {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Lists Platform Child Sites for a specified Platform Child Account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Accounts$Platforms$Childaccounts$Sites$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Accounts$Platforms$Childaccounts$Sites$List, options?: MethodOptions): GaxiosPromise<Schema$ListPlatformChildSitesResponse>;
        list(params: Params$Resource$Accounts$Platforms$Childaccounts$Sites$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Accounts$Platforms$Childaccounts$Sites$List, options: MethodOptions | BodyResponseCallback<Schema$ListPlatformChildSitesResponse>, callback: BodyResponseCallback<Schema$ListPlatformChildSitesResponse>): void;
        list(params: Params$Resource$Accounts$Platforms$Childaccounts$Sites$List, callback: BodyResponseCallback<Schema$ListPlatformChildSitesResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListPlatformChildSitesResponse>): void;
        /**
         * Update a Platform Child Site.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Accounts$Platforms$Childaccounts$Sites$Patch, options: StreamMethodOptions): GaxiosPromise<Readable>;
        patch(params?: Params$Resource$Accounts$Platforms$Childaccounts$Sites$Patch, options?: MethodOptions): GaxiosPromise<Schema$PlatformChildSite>;
        patch(params: Params$Resource$Accounts$Platforms$Childaccounts$Sites$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Accounts$Platforms$Childaccounts$Sites$Patch, options: MethodOptions | BodyResponseCallback<Schema$PlatformChildSite>, callback: BodyResponseCallback<Schema$PlatformChildSite>): void;
        patch(params: Params$Resource$Accounts$Platforms$Childaccounts$Sites$Patch, callback: BodyResponseCallback<Schema$PlatformChildSite>): void;
        patch(callback: BodyResponseCallback<Schema$PlatformChildSite>): void;
    }
    export interface Params$Resource$Accounts$Platforms$Childaccounts$Sites$List extends StandardParameters {
        /**
         * Optional. The maximum number of children to include in the response, used for paging. If unspecified, at most 10000 platforms will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
         */
        pageSize?: number;
        /**
         * Optional. A page token, received from a previous `ListPlatformChildren` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListPlatformChildren` must match the call that provided the page token.
         */
        pageToken?: string;
        /**
         * Required. The name of the child account under the given platform which owns the platform child sites. Format: accounts/{account\}/platforms/{platform\}/childAccounts/{child_account\}
         */
        parent?: string;
    }
    export interface Params$Resource$Accounts$Platforms$Childaccounts$Sites$Patch extends StandardParameters {
        /**
         * Identifier. Format: accounts/{account\}/platforms/{platform\}/childAccounts/{child_account\}/sites/{platform_child_site\}
         */
        name?: string;
        /**
         * Optional. The list of fields to update - currently only supports updating the `platform_group` field.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$PlatformChildSite;
    }
    export class Resource$Accounts$Platforms$Groups {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Lists Platform Groups for a specified Platform.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Accounts$Platforms$Groups$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Accounts$Platforms$Groups$List, options?: MethodOptions): GaxiosPromise<Schema$ListPlatformGroupsResponse>;
        list(params: Params$Resource$Accounts$Platforms$Groups$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Accounts$Platforms$Groups$List, options: MethodOptions | BodyResponseCallback<Schema$ListPlatformGroupsResponse>, callback: BodyResponseCallback<Schema$ListPlatformGroupsResponse>): void;
        list(params: Params$Resource$Accounts$Platforms$Groups$List, callback: BodyResponseCallback<Schema$ListPlatformGroupsResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListPlatformGroupsResponse>): void;
    }
    export interface Params$Resource$Accounts$Platforms$Groups$List extends StandardParameters {
        /**
         * Optional. The maximum number of groups to include in the response, used for paging. If unspecified, at most 10000 groups will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
         */
        pageSize?: number;
        /**
         * Optional. A page token, received from a previous `ListPlatformGroups` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListPlatformGroups` must match the call that provided the page token.
         */
        pageToken?: string;
        /**
         * Required. The name of the platform to retrieve. Format: accounts/{account\}/platforms/{platform\}
         */
        parent?: string;
    }
    export class Resource$Platforms {
        context: APIRequestContext;
        accounts: Resource$Platforms$Accounts;
        constructor(context: APIRequestContext);
    }
    export class Resource$Platforms$Accounts {
        context: APIRequestContext;
        events: Resource$Platforms$Accounts$Events;
        sites: Resource$Platforms$Accounts$Sites;
        constructor(context: APIRequestContext);
        /**
         * Closes a sub-account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        close(params: Params$Resource$Platforms$Accounts$Close, options: StreamMethodOptions): GaxiosPromise<Readable>;
        close(params?: Params$Resource$Platforms$Accounts$Close, options?: MethodOptions): GaxiosPromise<Schema$CloseAccountResponse>;
        close(params: Params$Resource$Platforms$Accounts$Close, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        close(params: Params$Resource$Platforms$Accounts$Close, options: MethodOptions | BodyResponseCallback<Schema$CloseAccountResponse>, callback: BodyResponseCallback<Schema$CloseAccountResponse>): void;
        close(params: Params$Resource$Platforms$Accounts$Close, callback: BodyResponseCallback<Schema$CloseAccountResponse>): void;
        close(callback: BodyResponseCallback<Schema$CloseAccountResponse>): void;
        /**
         * Creates a sub-account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Platforms$Accounts$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Platforms$Accounts$Create, options?: MethodOptions): GaxiosPromise<Schema$Account>;
        create(params: Params$Resource$Platforms$Accounts$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Platforms$Accounts$Create, options: MethodOptions | BodyResponseCallback<Schema$Account>, callback: BodyResponseCallback<Schema$Account>): void;
        create(params: Params$Resource$Platforms$Accounts$Create, callback: BodyResponseCallback<Schema$Account>): void;
        create(callback: BodyResponseCallback<Schema$Account>): void;
        /**
         * Gets information about the selected sub-account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Platforms$Accounts$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Platforms$Accounts$Get, options?: MethodOptions): GaxiosPromise<Schema$Account>;
        get(params: Params$Resource$Platforms$Accounts$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Platforms$Accounts$Get, options: MethodOptions | BodyResponseCallback<Schema$Account>, callback: BodyResponseCallback<Schema$Account>): void;
        get(params: Params$Resource$Platforms$Accounts$Get, callback: BodyResponseCallback<Schema$Account>): void;
        get(callback: BodyResponseCallback<Schema$Account>): void;
        /**
         * Lists a partial view of sub-accounts for a specific parent account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Platforms$Accounts$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Platforms$Accounts$List, options?: MethodOptions): GaxiosPromise<Schema$ListAccountsResponse>;
        list(params: Params$Resource$Platforms$Accounts$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Platforms$Accounts$List, options: MethodOptions | BodyResponseCallback<Schema$ListAccountsResponse>, callback: BodyResponseCallback<Schema$ListAccountsResponse>): void;
        list(params: Params$Resource$Platforms$Accounts$List, callback: BodyResponseCallback<Schema$ListAccountsResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListAccountsResponse>): void;
        /**
         * Looks up information about a sub-account for a specified creation_request_id. If no account exists for the given creation_request_id, returns 404.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        lookup(params: Params$Resource$Platforms$Accounts$Lookup, options: StreamMethodOptions): GaxiosPromise<Readable>;
        lookup(params?: Params$Resource$Platforms$Accounts$Lookup, options?: MethodOptions): GaxiosPromise<Schema$LookupAccountResponse>;
        lookup(params: Params$Resource$Platforms$Accounts$Lookup, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        lookup(params: Params$Resource$Platforms$Accounts$Lookup, options: MethodOptions | BodyResponseCallback<Schema$LookupAccountResponse>, callback: BodyResponseCallback<Schema$LookupAccountResponse>): void;
        lookup(params: Params$Resource$Platforms$Accounts$Lookup, callback: BodyResponseCallback<Schema$LookupAccountResponse>): void;
        lookup(callback: BodyResponseCallback<Schema$LookupAccountResponse>): void;
    }
    export interface Params$Resource$Platforms$Accounts$Close extends StandardParameters {
        /**
         * Required. Account to close. Format: platforms/{platform\}/accounts/{account_id\}
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$CloseAccountRequest;
    }
    export interface Params$Resource$Platforms$Accounts$Create extends StandardParameters {
        /**
         * Required. Platform to create an account for. Format: platforms/{platform\}
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Account;
    }
    export interface Params$Resource$Platforms$Accounts$Get extends StandardParameters {
        /**
         * Required. Account to get information about. Format: platforms/{platform\}/accounts/{account_id\}
         */
        name?: string;
    }
    export interface Params$Resource$Platforms$Accounts$List extends StandardParameters {
        /**
         * Optional. The maximum number of accounts to include in the response, used for paging. If unspecified, at most 10000 accounts will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
         */
        pageSize?: number;
        /**
         * Optional. A page token, received from a previous `ListAccounts` call. Provide this to retrieve the subsequent page.
         */
        pageToken?: string;
        /**
         * Required. Platform who parents the accounts. Format: platforms/{platform\}
         */
        parent?: string;
    }
    export interface Params$Resource$Platforms$Accounts$Lookup extends StandardParameters {
        /**
         * Optional. The creation_request_id provided when calling createAccount.
         */
        creationRequestId?: string;
        /**
         * Required. Platform who parents the account. Format: platforms/{platform\}
         */
        parent?: string;
    }
    export class Resource$Platforms$Accounts$Events {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates an account event.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Platforms$Accounts$Events$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Platforms$Accounts$Events$Create, options?: MethodOptions): GaxiosPromise<Schema$Event>;
        create(params: Params$Resource$Platforms$Accounts$Events$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Platforms$Accounts$Events$Create, options: MethodOptions | BodyResponseCallback<Schema$Event>, callback: BodyResponseCallback<Schema$Event>): void;
        create(params: Params$Resource$Platforms$Accounts$Events$Create, callback: BodyResponseCallback<Schema$Event>): void;
        create(callback: BodyResponseCallback<Schema$Event>): void;
    }
    export interface Params$Resource$Platforms$Accounts$Events$Create extends StandardParameters {
        /**
         * Required. Account to log events about. Format: platforms/{platform\}/accounts/{account\}
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Event;
    }
    export class Resource$Platforms$Accounts$Sites {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a site for a specified account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Platforms$Accounts$Sites$Create, options: StreamMethodOptions): GaxiosPromise<Readable>;
        create(params?: Params$Resource$Platforms$Accounts$Sites$Create, options?: MethodOptions): GaxiosPromise<Schema$Site>;
        create(params: Params$Resource$Platforms$Accounts$Sites$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Platforms$Accounts$Sites$Create, options: MethodOptions | BodyResponseCallback<Schema$Site>, callback: BodyResponseCallback<Schema$Site>): void;
        create(params: Params$Resource$Platforms$Accounts$Sites$Create, callback: BodyResponseCallback<Schema$Site>): void;
        create(callback: BodyResponseCallback<Schema$Site>): void;
        /**
         * Deletes a site from a specified account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Platforms$Accounts$Sites$Delete, options: StreamMethodOptions): GaxiosPromise<Readable>;
        delete(params?: Params$Resource$Platforms$Accounts$Sites$Delete, options?: MethodOptions): GaxiosPromise<Schema$Empty>;
        delete(params: Params$Resource$Platforms$Accounts$Sites$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Platforms$Accounts$Sites$Delete, options: MethodOptions | BodyResponseCallback<Schema$Empty>, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(params: Params$Resource$Platforms$Accounts$Sites$Delete, callback: BodyResponseCallback<Schema$Empty>): void;
        delete(callback: BodyResponseCallback<Schema$Empty>): void;
        /**
         * Gets a site from a specified sub-account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Platforms$Accounts$Sites$Get, options: StreamMethodOptions): GaxiosPromise<Readable>;
        get(params?: Params$Resource$Platforms$Accounts$Sites$Get, options?: MethodOptions): GaxiosPromise<Schema$Site>;
        get(params: Params$Resource$Platforms$Accounts$Sites$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Platforms$Accounts$Sites$Get, options: MethodOptions | BodyResponseCallback<Schema$Site>, callback: BodyResponseCallback<Schema$Site>): void;
        get(params: Params$Resource$Platforms$Accounts$Sites$Get, callback: BodyResponseCallback<Schema$Site>): void;
        get(callback: BodyResponseCallback<Schema$Site>): void;
        /**
         * Lists sites for a specific account.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Platforms$Accounts$Sites$List, options: StreamMethodOptions): GaxiosPromise<Readable>;
        list(params?: Params$Resource$Platforms$Accounts$Sites$List, options?: MethodOptions): GaxiosPromise<Schema$ListSitesResponse>;
        list(params: Params$Resource$Platforms$Accounts$Sites$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Platforms$Accounts$Sites$List, options: MethodOptions | BodyResponseCallback<Schema$ListSitesResponse>, callback: BodyResponseCallback<Schema$ListSitesResponse>): void;
        list(params: Params$Resource$Platforms$Accounts$Sites$List, callback: BodyResponseCallback<Schema$ListSitesResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListSitesResponse>): void;
        /**
         * Requests the review of a site. The site should be in REQUIRES_REVIEW or NEEDS_ATTENTION state. Note: Make sure you place an [ad tag](https://developers.google.com/adsense/platforms/direct/ad-tags) on your site before requesting a review.
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        requestReview(params: Params$Resource$Platforms$Accounts$Sites$Requestreview, options: StreamMethodOptions): GaxiosPromise<Readable>;
        requestReview(params?: Params$Resource$Platforms$Accounts$Sites$Requestreview, options?: MethodOptions): GaxiosPromise<Schema$RequestSiteReviewResponse>;
        requestReview(params: Params$Resource$Platforms$Accounts$Sites$Requestreview, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        requestReview(params: Params$Resource$Platforms$Accounts$Sites$Requestreview, options: MethodOptions | BodyResponseCallback<Schema$RequestSiteReviewResponse>, callback: BodyResponseCallback<Schema$RequestSiteReviewResponse>): void;
        requestReview(params: Params$Resource$Platforms$Accounts$Sites$Requestreview, callback: BodyResponseCallback<Schema$RequestSiteReviewResponse>): void;
        requestReview(callback: BodyResponseCallback<Schema$RequestSiteReviewResponse>): void;
    }
    export interface Params$Resource$Platforms$Accounts$Sites$Create extends StandardParameters {
        /**
         * Required. Account to create site. Format: platforms/{platform\}/accounts/{account_id\}
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Site;
    }
    export interface Params$Resource$Platforms$Accounts$Sites$Delete extends StandardParameters {
        /**
         * Required. The name of the site to delete. Format: platforms/{platform\}/accounts/{account\}/sites/{site\}
         */
        name?: string;
    }
    export interface Params$Resource$Platforms$Accounts$Sites$Get extends StandardParameters {
        /**
         * Required. The name of the site to retrieve. Format: platforms/{platform\}/accounts/{account\}/sites/{site\}
         */
        name?: string;
    }
    export interface Params$Resource$Platforms$Accounts$Sites$List extends StandardParameters {
        /**
         * The maximum number of sites to include in the response, used for paging. If unspecified, at most 10000 sites will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
         */
        pageSize?: number;
        /**
         * A page token, received from a previous `ListSites` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListSites` must match the call that provided the page token.
         */
        pageToken?: string;
        /**
         * Required. The account which owns the sites. Format: platforms/{platform\}/accounts/{account\}
         */
        parent?: string;
    }
    export interface Params$Resource$Platforms$Accounts$Sites$Requestreview extends StandardParameters {
        /**
         * Required. The name of the site to submit for review. Format: platforms/{platform\}/accounts/{account\}/sites/{site\}
         */
        name?: string;
    }
    export {};
}
