import { useState } from "react";
import { toast } from "react-toastify";
import RetreatApi from "../api/retreatApi";
import Select from "react-select";
import { Modal, Button, Row, Col } from "react-bootstrap";
import RetreatRoasterApi from "../api/retreatRoasterApi";
import DeleteModel from "../components/DeleteModel";

function CreateRetreatTeam({
  show,
  allCoupleData,
  rolesDataList,
  roles,
  ediUserIdClicked,
  handleClose,
  getRolesOfRetreats,
  setEditIndex,
  editIndex,
}) {
  let retreatRoasterApi = new RetreatRoasterApi();
  const [roleSelect, setRoleSelect] = useState([]);
  const [roleGreenTick, setRoleGreenTick] = useState(false);
  const [coupleSelectForRole, setCoupleSelectForRole] = useState([]);
  const [removeCoupleModal, setRemoveCoupleModal] = useState("");

  const handleSelectOption = (val, selection) => {
    if (selection === "forRole") {
      setRoleSelect(val);
    } else if (selection === "coupleForRole") {
      setCoupleSelectForRole(val);
    }
  };

  const handleSelectSubmit = async () => {
    if (ediUserIdClicked) {
      let submitData = {
        roleId: roleSelect.value,
        coupleId: coupleSelectForRole.value,
        retreatId: ediUserIdClicked,
      };
      setRoleGreenTick(true);
      await retreatRoasterApi
        .createLeads(submitData)
        .then((res) => {
          if (res.success) {
            getRolesOfRetreats(ediUserIdClicked);
            toast.success(res.msg);
            setRoleSelect([]);
            setCoupleSelectForRole([]);
            setTimeout(() => {
              setRoleGreenTick(false);
            }, 2000);
          } else {
            toast.error(res.msg);
            setRoleGreenTick(false);
          }
        })
        .catch((error) => {
          toast.error(error);
        });
    } else {
      setRoleSelect([]);
      setCoupleSelectForRole([]);
      toast.error("Please enter the required fields.");
    }
  };

  const renderCoupleNames = (couple) => {
    if (!couple) return null;
    const his = couple.hisFirstName || "";
    const her = couple.herFirstName || "";
    const lastName = couple.hisLastName || "";
    const name = `${his}${her ? " & " : ""}${her} ${lastName}`.trim();
    return name || null;
  };

  const leadCouple = renderCoupleNames(roles?.leadCouple);
  const coLeadCouple = renderCoupleNames(roles?.coLeadCouple);
  const mentorCouple = renderCoupleNames(roles?.mentor);
  const spiritualDirector = renderCoupleNames(roles?.spiritualDirector);
  const spiritualMentor = renderCoupleNames(roles?.spiritualMentor);

  const customSelectStyles = {
    control: (provided) => ({
      ...provided,
      minHeight: "50px",
      fontSize: "16px",
      borderRadius: "10px",
    }),
    menu: (provided) => ({
      ...provided,
      fontSize: "16px",
    }),
    option: (provided, state) => ({
      ...provided,
      fontSize: "16px",
      backgroundColor: state.isSelected
        ? "#007bff"
        : state.isFocused
        ? "#f1f1f1"
        : "white",
      color: state.isSelected ? "white" : "black",
    }),
  };

  const handlerRemoveShow = (i) => {
    setEditIndex(i);
    setRemoveCoupleModal(true);
  };
  const handleRemoveClose = () => {
    setRemoveCoupleModal(false);
  };

  const removeCoupleFromRetreat = () => {
    retreatRoasterApi
      .removeCoupleFromRetreat({
        coupleId: editIndex.coupleId,
        retreatId: ediUserIdClicked,
      })
      .then((res) => {
        toast.success(res.msg);
        getRolesOfRetreats(ediUserIdClicked);
        handleRemoveClose();
        setEditIndex("");
        setRemoveCoupleModal(false);
      })
      .catch((error) => {
        console.error(error);
        toast.error("An error occurred while uploading the image.");
      });
  };

  return (
    <Modal
      show={show}
      onHide={handleClose}
      backdrop="static"
      keyboard={false}
      size="lg"
      className="custom-backdrop customSubAdminModal"
    >
      <Modal.Header closeButton>
        <Modal.Title className="fw-bold">Add Retreat Team</Modal.Title>
      </Modal.Header>

      <Modal.Body>
        <Row className="align-items-center g-3">
          <Col md={5}>
            <Select
              styles={customSelectStyles}
              id="couple"
              name="couple"
              options={allCoupleData}
              value={coupleSelectForRole}
              onChange={(val) => {
                handleSelectOption(val, "coupleForRole");
              }}
              isSearchable
              placeholder="Select Couple"
            />
          </Col>
          <Col md={5}>
            <Select
              styles={customSelectStyles}
              id="roles"
              name="roles"
              options={rolesDataList}
              value={roleSelect}
              onChange={(val) => {
                handleSelectOption(val, "forRole");
              }}
              isSearchable
              placeholder="Select Role"
            />
          </Col>
          {roleGreenTick ? (
            <Col md={2} className="text-center">
              <i
                type="button"
                className="mdi mdi-check btn-icon-prepend mt-0 mb-3 plus-icon-role"
              ></i>
            </Col>
          ) : (
            <Col md={2} className="text-center" title="Add Retreat Team">
              {" "}
              <i
                type="button"
                onClick={() => {
                  handleSelectSubmit();
                }}
                className="mdi mdi-plus-circle btn-icon-prepend mt-0 mb-3 plus-icon-role"
              ></i>
            </Col>
          )}
        </Row>

        <hr className="my-4" />

        <div className="selected-couples mt-3">
          {leadCouple && (
            <div className="d-flex justify-content-between align-items-center border rounded p-2 mb-2">
              <span>
                <strong>Lead Couple:</strong> {leadCouple}
              </span>
              <i
                className="mdi mdi-delete-forever text-danger fs-4"
                onClick={() => handlerRemoveShow(roles && roles.leadCouple)}
                title="Remove Couple"
                style={{ cursor: "pointer" }}
              ></i>
            </div>
          )}
          {coLeadCouple && (
            <div className="d-flex justify-content-between align-items-center border rounded p-2 mb-2">
              <span>
                <strong>Co-Lead Couple:</strong> {coLeadCouple}
              </span>
              <i
                className="mdi mdi-delete-forever text-danger fs-4"
                onClick={() => handlerRemoveShow(roles && roles.coLeadCouple)}
                title="Remove Couple"
                style={{ cursor: "pointer" }}
              ></i>
            </div>
          )}
          {mentorCouple && (
            <div className="d-flex justify-content-between align-items-center border rounded p-2 mb-2">
              <span>
                <strong>Mentor Couple:</strong> {mentorCouple}
              </span>
              <i
                className="mdi mdi-delete-forever text-danger fs-4"
                onClick={() => handlerRemoveShow(roles && roles.mentor)}
                title="Remove Couple"
                style={{ cursor: "pointer" }}
              ></i>
            </div>
          )}
          {spiritualMentor && (
            <div className="d-flex justify-content-between align-items-center border rounded p-2 mb-2">
              <span>
                <strong>Spiritual Mentor:</strong> {spiritualMentor}
              </span>
              <i
                className="mdi mdi-delete-forever text-danger fs-4"
                onClick={() =>
                  handlerRemoveShow(roles && roles.spiritualMentor)
                }
                title="Remove Couple"
                style={{ cursor: "pointer" }}
              ></i>
            </div>
          )}
          {/* ✅ Newly Added Roles */}
          {spiritualDirector && (
            <div className="d-flex justify-content-between align-items-center border rounded p-2 mb-2">
              <span>
                <strong>Spiritual Director:</strong> {spiritualDirector}
              </span>
              <i
                className="mdi mdi-delete-forever text-danger fs-4"
                onClick={() =>
                  handlerRemoveShow(roles && roles.spiritualDirector)
                }
                title="Remove Couple"
                style={{ cursor: "pointer" }}
              ></i>
            </div>
          )}
        </div>
      </Modal.Body>

      <Modal.Footer>
        <Button variant="secondary" onClick={handleClose} className="px-4">
          Close
        </Button>
      </Modal.Footer>
      {removeCoupleModal ? (
        <DeleteModel
          show={removeCoupleModal}
          content={
            <>
              <h5 className="mt-4 fw-bold">Retreat Team</h5>
              <div className="p-3 border rounded-3 bg-light shadow-sm">
                {/* His Details */}
                {editIndex && (
                  <>
                    <div className="mb-2">
                      <span className="fw-bold">Role:</span>{" "}
                      {editIndex && (
                        <span className="text-muted"> {editIndex.role}</span>
                      )}
                    </div>
                    <div className="mb-2">
                      <span className="fw-bold">Couple:</span>{" "}
                      {`${
                        editIndex && editIndex.hisFirstName
                          ? editIndex.hisFirstName
                          : ""
                      }` +
                        `${editIndex && editIndex.herFirstName ? " & " : ""}` +
                        `${
                          editIndex && editIndex.herFirstName
                            ? editIndex.herFirstName
                            : ""
                        }` +
                        " " +
                        `${
                          editIndex && editIndex.hisLastName
                            ? editIndex.hisLastName
                            : ""
                        }`}
                    </div>
                  </>
                )}
              </div>
            </>
          }
          handleClose={handleRemoveClose}
          DeleteData={removeCoupleFromRetreat}
        ></DeleteModel>
      ) : null}
    </Modal>
  );
}

export default CreateRetreatTeam;
