import React, { useState, useEffect } from "react";
import { Modal, Button, Form } from "react-bootstrap";
import { toast } from "react-toastify";
import DirectoryApi from "../api/directoryApi";

const SocialLinksModal = ({ show, onClose, directory, setDirectory }) => {
  const directoryApi = new DirectoryApi();

  const [links, setLinks] = useState({
    facebook: "",
    twitter: "",
    pinterest: "",
    instagram: "",
  });
  console.log("directory--=--->", directory);

  // Prefill modal with existing links when it opens
  useEffect(() => {
    if (directory?.socialLinks) {
      let parsedLinks = {};

      try {
        parsedLinks =
          typeof directory.socialLinks === "string"
            ? JSON.parse(directory.socialLinks)
            : directory.socialLinks;
      } catch (e) {
        console.error("Invalid JSON in socialLinks:", directory.socialLinks);
      }

      setLinks({
        facebook: parsedLinks.facebook || "",
        twitter: parsedLinks.twitter || "",
        pinterest: parsedLinks.pinterest || "",
        instagram: parsedLinks.instagram || "",
      });
    }
  }, [directory]);

  const handleChange = (e) => {
    const { name, value } = e.target;
    setLinks({ ...links, [name]: value });
  };

  const handleSubmit = (e) => {
    e.preventDefault();
    try {
      const payload = {
        directoryId: directory?.id,
        socialLinks: links,
      };

      directoryApi
        .uploadLinks(payload)
        .then((res) => {
          toast.success("Social links saved successfully!");
          // update parent state
          setDirectory((prev) => ({
            ...prev,
            socialLinks: links,
          }));
          onClose();
        })
        .catch((error) => {
          console.error(error);
          toast.error("An error occurred while saving links.");
        });
    } catch (error) {
      console.error(error);
      toast.error("An error occurred.");
    }
  };

  return (
    <Modal show={show} onHide={onClose} centered className="custom-backdrop">
      <Modal.Header closeButton>
        <Modal.Title>Social Links</Modal.Title>
      </Modal.Header>

      <Form onSubmit={handleSubmit}>
        <Modal.Body>
          <Form.Group className="mb-3">
            <Form.Label>Facebook URL</Form.Label>
            <Form.Control
              type="url"
              placeholder="Enter Facebook URL"
              name="facebook"
              value={links.facebook}
              onChange={handleChange}
            />
          </Form.Group>

          <Form.Group className="mb-3">
            <Form.Label>Twitter URL</Form.Label>
            <Form.Control
              type="url"
              placeholder="Enter Twitter URL"
              name="twitter"
              value={links.twitter}
              onChange={handleChange}
            />
          </Form.Group>

          <Form.Group className="mb-3">
            <Form.Label>Pinterest URL</Form.Label>
            <Form.Control
              type="url"
              placeholder="Enter Pinterest URL"
              name="pinterest"
              value={links.pinterest}
              onChange={handleChange}
            />
          </Form.Group>

          <Form.Group className="mb-3">
            <Form.Label>Instagram URL</Form.Label>
            <Form.Control
              type="url"
              placeholder="Enter Instagram URL"
              name="instagram"
              value={links.instagram}
              onChange={handleChange}
            />
          </Form.Group>
        </Modal.Body>

        <Modal.Footer>
          <Button variant="secondary" onClick={onClose}>
            Cancel
          </Button>
          <Button type="submit" variant="primary">
            Save Links
          </Button>
        </Modal.Footer>
      </Form>
    </Modal>
  );
};

export default SocialLinksModal;
