# ej2-popups

The popup components such as dialog and tooltip are used to display information in a popup to users. The dialog component provides modal/non-modal (modeless), built-in buttons, positioning, animation, draggable, and template features and helps to create alert, prompt, and confirmation dialogs easily. The tooltip component is used to display a popup that contains some information or message when you hover, click, focus, or touch an element. The information displayed in the tooltip can include simple text, images, hyperlinks, or custom templates.

![Popup](https://ej2.syncfusion.com/products/images/popup/readme.png)

> This is a commercial product and requires a paid license for possession or use. Syncfusion’s licensed software, including this component, is subject to the terms and conditions of Syncfusion's EULA (https://www.syncfusion.com/eula/es/?utm_source=npm&utm_campaign=popup). To acquire a license, you can purchase one at https://www.syncfusion.com/sales/products or start a free 30-day trial here (https://www.syncfusion.com/account/manage-trials/start-trials/?utm_source=npm&utm_campaign=popup).

> A free community license (https://www.syncfusion.com/products/communitylicense/?utm_source=npm&utm_campaign=popup) is also available for companies and individuals whose organizations have less than $1 million USD in annual gross revenue and five or fewer developers.

## Setup

To install popup components and its dependent packages, use the following command

```sh
npm install @syncfusion/ej2-popups
```

## Components Included

Following list of components are available in the package

## Dialog

*   [Getting Started](https://ej2.syncfusion.com/documentation/dialog/getting-started/?utm_source=npm&utm_campaign=dialog)
*   [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=dialog#/material/dialog/default.html)
*   [Product Page](https://www.syncfusion.com/javascript-ui-controls/modal-dialog/?utm_source=npm&utm_campaign=dialog)

## Tooltip

*   [Getting Started](https://ej2.syncfusion.com/documentation/tooltip/getting-started/?utm_source=npm&utm_campaign=tooltip)
*   [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=tooltip#/material/tooltip/default.html)
*   [Product Page](https://www.syncfusion.com/javascript-ui-controls/tooltip/?utm_source=npm&utm_campaign=tooltip)

## Supported Frameworks

These components are available in following list of:

1.	[Angular](https://github.com/syncfusion/ej2-angular-ui-components/?utm_source=npm&utm_campaign=popup)
2.	[React](https://github.com/syncfusion/ej2-react-ui-components/?utm_source=npm&utm_campaign=popup)
3.	[Vue](https://github.com/syncfusion/ej2-vue-ui-components/?utm_source=npm&utm_campaign=popup)
4.	[ASP.NET Core](https://www.syncfusion.com/aspnet-core-ui-controls/?utm_source=npm&utm_campaign=popup)
5.	[ASP.NET MVC](https://www.syncfusion.com/aspnet-mvc-ui-controls/?utm_source=npm&utm_campaign=popup)
6.	[JavaScript (ES5)](https://www.syncfusion.com/javascript-ui-controls/?utm_source=npm&utm_campaign=popup)

## Use-case samples / Showcase samples

*	Expanse Tracker ([Source](https://github.com/syncfusion/ej2-showcase-ts-expensetracker), [Live Demo](https://ej2.syncfusion.com/showcase/typescript/expensetracker/#/dashboard))
*	Story Estimator ([Source](https://github.com/syncfusion/ej2-showcase-aspnetcore-story-estimator), [Live Demo](https://aspdotnetcore.syncfusion.com/showcase/aspnetcore/story-estimator/#/dashboard))
*	Diagram Builder ([Source](https://github.com/syncfusion/ej2-showcase-ng-diagrambuilder), [Live Demo](https://ej2.syncfusion.com/showcase/angular/diagrambuilder/))
*	IT Asset Management ([Live Demo](https://ej2.syncfusion.com/showcase/vue/assetmanagement/#/))
*	Webmail ([Source](https://github.com/syncfusion/ej2-showcase-ts-webmail), [Live Demo](https://ej2.syncfusion.com/showcase/typescript/webmail/#/home))
*	Loan Calculator ([Source](https://github.com/syncfusion/ej2-showcase-ts-loancalculator), [Live Demo](https://ej2.syncfusion.com/showcase/typescript/loancalculator/#/default))

## Key Features

## Dialog
*	[Modal](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=dialog/#/material/dialog/modal-dialog.html) - Displays the important information to users.
*	[Positioning](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=dialog#/material/dialog/position.html) - Supports to customize its display position.
*	[Animation](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=dialog#/material/dialog/animation.html) - Offers to set animation effects on open and close the dialog.
*	[Template](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=dialog#/material/dialog/template.html) - Provides an option to customize its header and footer.
*	[Built-in buttons](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=dialog#/material/dialog/default.html) - Provides a built-in support to add buttons to its properties.

## Tooltip

*	[Positions](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=tooltip#/material/tooltip/default.html) - Allows you to display the tooltip in 12 different positions.
*	[Animation](https://ej2.syncfusion.com/products/typescript/tooltip/animation/?utm_source=npm&utm_campaign=tooltip) - Supports animation effects while showing/hiding the tooltip.
*	[Content](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=tooltip/#/material/tooltip/ajax-content.html) - Assigns with static text, template, or loaded dynamically via AJAX.
*	[Opening modes](https://ej2.syncfusion.com/products/typescript/tooltip/show-hide/?utm_source=npm&utm_campaign=tooltip) - Supports four opening modes such as hover, click, focus, and custom.
*	[Smart positioning](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=tooltip/#/material/tooltip/smart-position.html) - Supports auto tip positioning.
*	[Mouse trail](https://ej2.syncfusion.com/products/typescript/tooltip/customization/?utm_source=npm&utm_campaign=tooltip) - Moves along with mouse pointer using the mouse trailing option.
*	[Sticky mode](https://ej2.syncfusion.com/products/typescript/tooltip/show-hide/?utm_source=npm&utm_campaign=tooltip) - Opens in sticky mode, and allows you to close/hide the Tooltip manually.

## Support

Product support is available for through following mediums:

*	Creating incident in Syncfusion [Direct-trac](https://www.syncfusion.com/support/directtrac/incidents/?utm_source=npm&utm_campaign=popup) support system or [Community forum](https://www.syncfusion.com/forums/essential-js2/?utm_source=npm&utm_campaign=popup).
*	New [GitHub issue](https://github.com/syncfusion/ej2-javascript-ui-controls/issues/new).
*	Ask your query in Stack Overflow with tag `syncfusion` and `ej2`.

## License

Check the license detail [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/license).

## Changelog

Check the changelog [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/controls/popups/CHANGELOG.md/?utm_source=npm&utm_campaign=dialog).


© Copyright 2023 Syncfusion, Inc. All Rights Reserved. The Syncfusion Essential Studio license and copyright applies to this distribution.
