import React from 'react';
import { Styled } from '../constructors/constructWithOptions';
import css from '../constructors/css';
import withTheme from '../hoc/withTheme';
import useTheme from '../hooks/useTheme';
import ThemeProvider, { ThemeConsumer, ThemeContext } from '../models/ThemeProvider';
import { NativeTarget } from '../types';
import isStyledComponent from '../utils/isStyledComponent';
declare const styled: (<Target extends NativeTarget>(tag: Target) => {
    <Props extends {} = {}, Statics = unknown>(initialStyles: import("../types").Styles<(Target extends import("../types").KnownTarget ? React.ComponentProps<Target> : unknown) & Props>, ...interpolations: import("../types").Interpolation<import("../types").ExecutionContext & (Target extends import("../types").KnownTarget ? React.ComponentProps<Target> : unknown) & Props>[]): import("../types").IStyledComponent<"native", Target, (Target extends import("../types").KnownTarget ? React.ComponentProps<Target> : unknown) & Props> & Statics;
    attrs(attrs: import("../types").Attrs<import("../types").ExtensibleObject & (Target extends import("../types").KnownTarget ? React.ComponentProps<Target> : unknown)>): any;
    withConfig(config: import("../types").StyledOptions<"native", Target extends import("../types").KnownTarget ? React.ComponentProps<Target> : unknown>): any;
}) & {
    ActivityIndicator: Styled<"native", typeof import("react-native").ActivityIndicator, import("react-native").ActivityIndicatorProps, {}, unknown>;
    Button: Styled<"native", typeof import("react-native").Button, import("react-native").ButtonProps, {}, unknown>;
    DatePickerIOS: Styled<"native", typeof import("react-native").DatePickerIOS, import("react-native").DatePickerIOSProps, {}, unknown>;
    DrawerLayoutAndroid: Styled<"native", typeof import("react-native").DrawerLayoutAndroid, import("react-native").DrawerLayoutAndroidProps, {}, unknown>;
    FlatList: Styled<"native", typeof import("react-native").FlatList, import("react-native").FlatListProps<unknown>, {}, unknown>;
    Image: Styled<"native", typeof import("react-native").Image, import("react-native").ImageProps, {}, unknown>;
    ImageBackground: Styled<"native", typeof import("react-native").ImageBackground, import("react-native").ImageBackgroundProps, {}, unknown>;
    KeyboardAvoidingView: Styled<"native", typeof import("react-native").KeyboardAvoidingView, import("react-native").KeyboardAvoidingViewProps, {}, unknown>;
    Modal: Styled<"native", typeof import("react-native").Modal, import("react-native").ModalProps, {}, unknown>;
    Pressable: Styled<"native", import("react").ForwardRefExoticComponent<import("react-native").PressableProps & import("react").RefAttributes<import("react-native").View>>, import("react-native").PressableProps & import("react").RefAttributes<import("react-native").View>, {}, unknown>;
    ProgressBarAndroid: Styled<"native", typeof import("react-native").ProgressBarAndroid, import("react-native").ProgressBarAndroidProps, {}, unknown>;
    ProgressViewIOS: Styled<"native", typeof import("react-native").ProgressViewIOS, import("react-native").ProgressViewIOSProps, {}, unknown>;
    RefreshControl: Styled<"native", typeof import("react-native").RefreshControl, import("react-native").RefreshControlProps, {}, unknown>;
    SafeAreaView: Styled<"native", typeof import("react-native").SafeAreaView, import("react-native").ViewProps, {}, unknown>;
    ScrollView: Styled<"native", typeof import("react-native").ScrollView, import("react-native").ScrollViewProps, {}, unknown>;
    SectionList: Styled<"native", typeof import("react-native").SectionList, import("react-native").SectionListProps<unknown, unknown>, {}, unknown>;
    Slider: Styled<"native", typeof import("react-native").Slider, import("react-native").SliderProps, {}, unknown>;
    Switch: Styled<"native", typeof import("react-native").Switch, import("react-native").SwitchProps, {}, unknown>;
    Text: Styled<"native", typeof import("react-native").Text, import("react-native").TextProps, {}, unknown>;
    TextInput: Styled<"native", typeof import("react-native").TextInput, import("react-native").TextInputProps, {}, unknown>;
    TouchableHighlight: Styled<"native", typeof import("react-native").TouchableHighlight, import("react-native").TouchableHighlightProps, {}, unknown>;
    TouchableOpacity: Styled<"native", typeof import("react-native").TouchableOpacity, import("react-native").TouchableOpacityProps, {}, unknown>;
    View: Styled<"native", typeof import("react-native").View, import("react-native").ViewProps, {}, unknown>;
    VirtualizedList: Styled<"native", typeof import("react-native").VirtualizedList, import("react-native").VirtualizedListProps<unknown>, {}, unknown>;
};
export { IStyledComponent, IStyledComponentFactory, IStyledStatics, NativeTarget, StyledOptions, } from '../types';
export { css, isStyledComponent, ThemeProvider, ThemeConsumer, ThemeContext, withTheme, useTheme };
export default styled;
