const cron = require("node-cron");
const db = require("../database/dbConnection");
const committeeMemberSchema = db.committeeMember;
const retreatSchema = db.retreat;
const { COMMITTEEALERT } = require("../helper/emailTemplate");
const Email = require("../helper/sendEmail");
const moment = require("moment-timezone");
// const retreatRoastSchema = db.retreatRoaster;
// const coupleSchema = db.couple;
const userSchema = db.user;
// const scheduleCommitteeRetreatReminder = () => {
//   cron.schedule("* * * * *", async () => {
//  try {
//     // Step 1: Get all roaster records sorted by coupleId + createdAt descending
//     const allRoasters = await retreatRoastSchema.findAll({
//       attributes: ['coupleId', 'imageUrl', 'createdAt'],
//       order: [['coupleId', 'ASC'], ['createdAt', 'DESC']],
//     });

//     // Step 2: Pick latest non-null imageUrl for each couple
//     const latestValidImages = new Map();

//     for (const record of allRoasters) {
//       const { coupleId, imageUrl } = record;

//       // If already have a valid image for this couple, skip
//       if (latestValidImages.has(coupleId)) continue;

//       // If this record has a valid image, store it
//       if (imageUrl) {
//         latestValidImages.set(coupleId, imageUrl);
//       }
//     }

//     // Step 3: Update couple table only for couples with a valid imageUrl from roaster
//     for (const [coupleId, imageUrl] of latestValidImages) {
//       await coupleSchema.update(
//         { imageUrl },
//         { where: { id: coupleId } }
//       );
//     }

//     console.log('✅ Couples updated with latest imageUrl from retreatroaster (only valid images).');
//   } catch (error) {
//     console.error('❌ Error migrating image URLs:', error);
//   }
//   });
// };

const scheduleCommitteeRetreatReminder = () => {
  // (*/10 * * * *) -----Every 10 minutes

  // (0 0 * * 0) -----Ever sunday

  // (*/2 * * * *) -----every 2 minutes,

  cron.schedule("0 0 * * 0", async () => {
    try {
      const committeeMembers = await committeeMemberSchema.findAll();
      for (const cm of committeeMembers) {
        const user = await userSchema.findOne({ where: { id: cm.userId } });
        if (!user) continue;
        const retreatsArray = JSON.parse(cm.retreats || "[]");
        const activeRetreatIds = retreatsArray
          .filter((r) => !r.disabled)
          .map((r) => r.retreatId);
        if (activeRetreatIds.length === 0) continue;
        const retreats = await retreatSchema.findAll({
          where: {
            id: activeRetreatIds,
            dateFrom: { [db.Sequelize.Op.gt]: new Date() },
            status: "ACTIVE",
            freeze: "UNFREEZE",
            retreatCloseStatus: false,
          },
        });

        for (const retreat of retreats) {
          let confirmationArray = [];
          try {
            confirmationArray = JSON.parse(retreat.confirmation || "[]");
          } catch (err) {
            console.error("Invalid confirmation JSON:", err.message);
            continue;
          }

          const hasPendingItems = confirmationArray.some(
            (item) =>
              item.Directory === false ||
              item.roasterData === false ||
              item.Program === false ||
              item.pictures === false
          );
          if (!hasPendingItems) continue;

          let formattedDate = "";
          if (retreat.dateFrom && retreat.dateTo) {
            formattedDate = moment(retreat.dateFrom).isSame(
              retreat.dateTo,
              "day"
            )
              ? `(${moment(retreat.dateFrom)
                  .tz("America/New_York")
                  .format("MMM-DD-YYYY")})`
              : `(${moment(retreat.dateFrom)
                  .tz("America/New_York")
                  .format("MMM DD")} - ${moment(retreat.dateTo)
                  .tz("America/New_York")
                  .format("MMM DD")}, ${moment(retreat.dateFrom)
                  .tz("America/New_York")
                  .format("YYYY")})`;
          }

          const replData = COMMITTEEALERT.replace(
            /#firstName#/g,
            user.firstName || ""
          )
            .replace(/#lastName#/g, user.lastName || "")
            .replace(/#retreat#/g, retreat.title)
            .replace(/#date#/g, formattedDate)
            .replace(/#link#/g, `${process.env.SERVERADDRESS}/login`);

          console.log(
            `Send email to ${user.email} for Retreat: ${retreat.title}`
          );
          Email.sendEmail(user.email, "Retreat review", replData);
        }
      }
    } catch (error) {
      console.error("Error in committee retreat reminder cron:", error.message);
    }
  });
};

module.exports = scheduleCommitteeRetreatReminder;
