const db = require("../database/dbConnection");
const Talks = require("../database/dbConnection");
const { Op } = require("sequelize");
const talksSchema = Talks.talk;

class TalksController {
  async addTalk(req, res) {
    const STOP_WORDS = [
      "of",
      "and",
      "the",
      "is",
      "a",
      "an",
      "in",
      "to",
      "for",
      "with",
      "by",
    ];

    try {
      const { talk, forceSave } = req.body;

      // Check for an exact match (case-insensitive)
      let exactMatch = await talksSchema.findOne({
        where: { talk: { [Op.like]: talk } },
      });

      if (exactMatch) {
        return res.status(200).send({
          success: false,
          msg: "This talk already exists with an exact match.",
        });
      }

      // Proceed to fuzzy search if forceSave is not true
      if (!forceSave) {
        const talkWords = talk
          .toLowerCase()
          .split(" ")
          .filter((word) => !STOP_WORDS.includes(word))
          .map((word) => `%${word}%`);

        if (talkWords.length > 0) {
          let matchingTalks = await talksSchema.findAll({
            where: {
              [Op.or]: talkWords.map((word) => ({
                talk: { [Op.like]: word },
              })),
            },
          });

          if (matchingTalks.length) {
            return res.status(200).send({
              success: true,
              msg: "Potential matches found. Please review before proceeding.",
              matches: matchingTalks,
            });
          }
        }
      }

      // Save the new talk if no matches or forceSave is true
      let newTalk = new talksSchema(req.body);
      let succ = await newTalk.save();

      if (succ) {
        return res.status(200).send({
          success: true,
          msg: "New Talk is created.",
          data: succ,
        });
      } else {
        return res.status(500).send({
          success: false,
          msg: "Something went wrong. Please try again.",
        });
      }
    } catch (error) {
      return res.status(500).json({
        success: false,
        msg: "An error occurred while processing the request.",
        error: error.message,
      });
    }
  }

  async getAllTalkSearch(req, res) {
    try {
      let query = `SELECT talks.id as talkId,talks.talk,talks.createdAt,talks.updatedAt
      FROM talks
      LEFT JOIN retreatroasters ON retreatroasters.talkId = talks.id
      WHERE retreatroasters.talkId IS NOT NULL GROUP BY talks.id`;
      let allRoles = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Perish fetched",
        data: allRoles,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async getAllTalklist(req, res) {
    try {
      let select = `SELECT
                talks.id as talkId,
                retreatroasters.id,
                retreatroasters.createdAt,
                couples.hisLastName,
                couples.hisFirstName,
                couples.herFirstName,
                couples.herLastName,
                retreatroasters.createdAt as latestTalk,
                talks.talk,
                talks.createdAt as talkCreated, COUNT(retreatroasters.id) AS roasters_count 
                FROM talks
                LEFT JOIN retreatroasters ON retreatroasters.talkId = talks.id 
                LEFT JOIN couples ON retreatroasters.coupleId = couples.id
                GROUP BY talks.id ORDER BY 
                talks.createdAt DESC;`;
      let allTalks = await db.sequelize
        .query(select)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Talks",
        data: allTalks,
      });
    } catch (error) {
      console.log("error", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async updateTalk(req, res) {
    try {
      let updated = await talksSchema.update(req.body, {
        where: { id: req.params.talk_id },
      });
      return res.status(200).send({
        success: true,
        msg: "Record Updated",
        data: updated,
      });
    } catch (err) {
      return res.status(200).json({
        success: false,
        msg: err,
      });
    }
  }

  async getTalk(req, res) {
    try {
      const talk = await talksSchema.findById(req.params.talk_id);
      return res.status(200).send({
        success: true,
        msg: "talk",
        data: talk,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async deleteTalk(req, res) {
    try {
      let delete_talk = await talksSchema.destroy({
        where: { id: req.params.talk_id },
      });
      return res.status(200).send({
        success: true,
        msg: "Record Deleted",
        data: delete_talk,
      });
    } catch (err) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async searchTalk(req, res) {
    try {
      let result = await talksSchema.findAll({
        where: {
          talk: {
            [Op.like]: `%${req.params.key}%`,
          },
        },
        raw: true,
      });
      const updatedResult = result.map(({ id, createdAt, ...rest }) => ({
        talkId: id,
        talkCreated: createdAt,
        ...rest,
      }));
      return res.status(200).send({
        success: true,
        msg: "",
        data: updatedResult,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }
}
module.exports = new TalksController();
