const db = require("../database/dbConnection");
const Roles = require("../database/dbConnection");
const { Op } = require("sequelize");
const RolesSchema = Roles.roles;
class RolesController {
  
  async addRole(req, res) {
    const STOP_WORDS = ["of", "and", "the", "is", "a", "an", "in", "to", "for", "with", "by"];
  
    try {
      const { role, forceSave } = req.body;
  
      // Check for an exact match (case-insensitive)
      let exactMatch = await RolesSchema.findOne({
        where: { role: { [Op.like]: role } },
      });
  
      if (exactMatch) {
        return res.status(200).send({
          success: false,
          msg: "This role already exists with an exact match.",
        });
      }
  
      // Proceed to fuzzy search if forceSave is not true
      if (!forceSave) {
        // Split the input into individual words and filter out stop words
        const roleWords = role
          .toLowerCase()
          .split(" ")
          .filter((word) => !STOP_WORDS.includes(word))
          .map((word) => `%${word}%`);
  
        if (roleWords.length > 0) {
          // Perform fuzzy search by checking each significant word
          let matchingRoles = await RolesSchema.findAll({
            where: {
              [Op.or]: roleWords.map((word) => ({
                role: { [Op.like]: word },
              })),
            },
          });
  
          if (matchingRoles.length) {
            return res.status(200).send({
              success: true,
              msg: "Potential matches found. Please review before proceeding.",
              matches: matchingRoles,
            });
          }
        }
      }
  
      // If no matches or forceSave is true, save the new role
      let newRole = new RolesSchema(req.body);
      let succ = await newRole.save();
  
      if (succ) {
        return res.status(200).send({
          success: true,
          msg: "New Role is created.",
          data: succ,
        });
      } else {
        return res.status(500).send({
          success: false,
          msg: "Something went wrong. Please try again.",
        });
      }
    } catch (error) {
      return res.status(500).json({
        success: false,
        msg: "An error occurred while processing the request.",
        error: error.message,
      });
    }
  } 

  async getAllRoleSearch(req, res) {
    try {
      let query = `SELECT roles.*
      FROM roles
      LEFT JOIN retreatroasters ON retreatroasters.roleId = roles.id
      WHERE retreatroasters.roleId IS NOT NULL GROUP BY roles.id ORDER BY roles.id ASC`;
      let allRoles = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Roles",
        data: allRoles,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async getAllRolelist(req, res) {
    try {
      let query = `SELECT roles.*, COUNT(retreatroasters.id) AS roasters_count 
      FROM roles 
      LEFT JOIN retreatroasters ON retreatroasters.roleId = roles.id 
      GROUP BY roles.id 
      ORDER BY roles.id ASC;
      `;
      let allRoles = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Roles",
        data: allRoles,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async updateRole(req, res) {
    try {
      let updated = await RolesSchema.update(req.body, {
        where: { id: req.params.role_id },
      });
      return res.status(200).send({
        success: true,
        msg: "Record Updated",
        data: updated,
      });
    } catch (err) {
      return res.status(200).json({
        success: false,
        msg: err,
      });
    }
  }

  async getRole(req, res) {
    try {
      const Role = await RolesSchema.findByPK(req.params.role_id);
      return res.status(200).send({
        success: true,
        msg: "Role",
        data: Role,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async deleteRole(req, res) {
    try {
      let delete_Role = await RolesSchema.destroy({
        where: { id: req.params.role_id },
      });
      return res.status(200).send({
        success: true,
        msg: "Record Deleted",
        data: delete_Role,
      });
    } catch (err) {
      console.log("error: ", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async searchRole(req, res) {
    try {
      let result = await RolesSchema.findAll({
        where: {
          role: {
            [Op.like]: `%${req.params.key}%`,
          },
        },
        raw: true,
      });
      return res.status(200).send({
        success: true,
        msg: "",
        data: result,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }
}
module.exports = new RolesController();
