const db = require("../database/dbConnection");
const { Op } = require("sequelize");

class QuickRetreatController {
  async searchCounts(req, res) {
    try {
      let { retreatId, dateFrom, dateTo } = req.body;
      let SELECT = `SELECT`;
      let COUNTRETREAT = ` COUNT(IF(retreatroasters.attendeeType = 'Team', retreatroasters.retreatId, NULL)) AS teamed,
      COUNT(IF(retreatroasters.attendeeType != 'Team', retreatroasters.retreatId, NULL)) AS neverteamed,
      COUNT(retreatroasters.talkId NOT IN(0)) as talked,
      COUNT(IF(retreatroasters.talkId IS NULL OR retreatroasters.talkId = '', retreatroasters.retreatId, NULL)) as neverTalked,
      COUNT(retreatroasters.serviceId NOT IN(0)) as serviced,
      COUNT(IF(retreatroasters.serviceId IS NULL OR retreatroasters.serviceId = '', retreatroasters.retreatId, NULL)) as neverServiced,
      COUNT(IF(couples.accountStatus = 'ACTIVE', retreatroasters.coupleId, NULL)) as activeCouple,
      COUNT(IF(couples.accountStatus = 'DIVORCED', retreatroasters.coupleId, NULL) ) as divorcedCouple,
      COUNT(IF(couples.accountStatus = 'DECEASED', retreatroasters.coupleId, NULL) ) as deceasedCouple `;
      let FROMRETREAT = `FROM retreats `;
      let JOIN = `LEFT JOIN retreatroasters ON retreats.id = retreatroasters.retreatId
      LEFT JOIN parishes ON retreatroasters.parishId = parishes.id
      LEFT JOIN services ON retreatroasters.serviceId = services.id
      LEFT JOIN roles ON retreatroasters.roleId = roles.id
      LEFT JOIN talks ON retreatroasters.talkId = talks.id 
      LEFT JOIN couples ON retreatroasters.coupleId = couples.id`;
      let WHERE = "";
      let GROUPBY = ` GROUP BY retreats.id`;
      if (retreatId && retreatId > 0) {
        WHERE += ` WHERE retreats.id = '${retreatId}'`;
      }
      if (dateFrom && dateTo) {
        if (WHERE) {
          WHERE += ` AND retreats.dateFrom >= '${dateFrom}'`;
          WHERE += ` AND retreats.dateTo <= '${dateTo}'`;
        } else {
          WHERE += ` WHERE retreats.dateFrom >= '${dateFrom}'`;
          WHERE += ` AND retreats.dateTo <= '${dateTo}'`;
        }
      }
      let queryRetreat =
        SELECT + COUNTRETREAT + FROMRETREAT + JOIN + WHERE + GROUPBY;
      let outerSelectquery =
        `SELECT
      sum(teamed) as teamed,
      sum(neverteamed) as neverteamed,
      sum(talked) as talked,
      sum(neverTalked) as neverTalked,
      sum(serviced) as serviced,
      sum(neverServiced) as neverServiced,
      sum(activeCouple) as activeCouple,
      sum(divorcedCouple) as divorcedCouple,
      SUM(deceasedCouple) as deceasedCouple
    FROM
      (` +
        queryRetreat +
        `) AS allTeamedCount;`;
      let responseDataCount = await db.sequelize
        .query(outerSelectquery)
        .then(([results]) => results);
      res.send({
        success: true,
        retreats: responseDataCount[0],
      });
    } catch (error) {
      console.log("error:", error);
      return res.status(200).json({
        success: false,
        msg: error.toString(),
      });
    }
  }
}

module.exports = new QuickRetreatController();
