const jwt = require("jsonwebtoken");
const db = require("../database/dbConnection");
const bcrypt = require("bcrypt-nodejs");
const Users = require("../database/dbConnection");
const { Op, Sequelize } = require("sequelize");
const coupleSchema = db.couple;
const retreatSchema = db.retreat;
const tempRetreatSchema = db.tempRetreat;
const retreatRoastSchema = db.retreatRoaster;
const RolesSchema = db.roles;
const perishSchema = db.parish;
const { PROJECT_DIR } = require("../../config");
const userSchema = Users.user;
const teamInterestSchema = db.teamInterest;
const committeeMemberSchema = db.committeeMember;
const moment = require("moment-timezone");
const Email = require("../helper/sendEmail");
const {
  FORGOTPASSWORD,
  NEWCOUPLEMAILVERIFY,
  RETREATMAILMESSAGE,
  NOTIFICATIONFORRETREATREGIS,
  SENDLOGINDETAILBYADMIN,
  CREATENEWRETREAT,
} = require("../helper/emailTemplate");
const { mquery } = require("mongoose");
class AuthController {
  async login(req, res) {
    var { username, password } = req.body;
    try {
      let user1 = await userSchema.findOne({
        where: {
          [Op.or]: {
            userName: username,
            email: username,
          },
        },
        raw: true,
      });
      let checkPassword = await userSchema.findOne({
        where: {
          [Op.and]: {
            password: password,
            email: username,
          },
        },
        raw: true,
      });
      if (user1 && checkPassword && user1.accountStatus == "INACTIVE")
        return res.status(200).json({
          msg: "Your account has been deactivated/ deleted. Please contact Lovestrong Admin.",
          status: false,
        });
      else if (!user1 && checkPassword)
        return res.status(200).json({
          msg: "Your mail does not exist.Please register.",
          status: false,
        });
      else if (user1 && !checkPassword)
        return res.status(200).json({
          msg: "Incorrect password ! Please try again!",
          status: false,
        });
      else if (!user1 && !checkPassword)
        return res.status(200).json({
          msg: "Username/Password does not exist",
          status: false,
        });
      else if (user1 && checkPassword && user1.accountStatus == "ACTIVE") {
        let token = await this.setAccessToken(user1);
        let updateData = await userSchema.findOne({
          where: { email: user1.email },
          raw: true,
        });
        let findCouple = await coupleSchema.findOne({
          where: {
            [Op.or]: {
              hisEmail: user1.email,
              herEmail: user1.email,
            },
          },
          raw: true,
        });
        if (findCouple) {
          updateData.imageUpload = findCouple.imageUrl;
        }

        let query = `
  SELECT id, accessIds 
  FROM retreats 
  WHERE JSON_CONTAINS(accessIds, '{"userId": ${updateData.id}}', '$')
`;
        let myRetreats = await db.sequelize
          .query(query)
          .then(([results]) => results);

        if (myRetreats.length > 0) {
          // Check if user is disabled in ANY retreat
          let hasDisabled = myRetreats.some((retreat) => {
            try {
              let accessIds = JSON.parse(retreat.accessIds || "[]");
              let userAccess = accessIds.find(
                (u) => u.userId === updateData.id
              );
              return userAccess && userAccess.isDisabled === true;
            } catch (e) {
              console.error("Error parsing accessIds", e);
              return false;
            }
          });

          updateData.access = !hasDisabled; // true if ANY retreat has isDisabled:true
        } else {
          updateData.access = true;
        }

        let findCommittieeMember = await committeeMemberSchema.findOne({
          where: {
            userId: updateData.id,
          },
          raw: true,
        });

        if (findCommittieeMember) {
          updateData.committeeMember = true;
        } else {
          updateData.committeeMember = false;
        }
        updateData.jwtToken = token;
        delete updateData.password;
        delete updateData.emailVerified;
        delete updateData.otp;
        delete updateData.emailVerifyCode;
        delete updateData.createdAt;
        delete updateData.updatedAt;
        return res.status(200).send({
          success: true,
          data: updateData,
          msg: "Login successful...",
        });
      }
    } catch (error) {
      console.log("error-->", error);
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async setAccessToken(user) {
    const accessToken = jwt.sign(
      {
        id: user._id,
        userName: user.username,
        userRole: user.userRole,
      },
      process.env.jwtAccessTokenSecret,
      {
        expiresIn: "100h",
        algorithm: "HS256",
      }
    );
    return accessToken;
  }

  async OtpSend(req, res) {
    try {
      let otpCode = Math.floor(Math.random() * 1000000 + 1);

      // Update OTP in the database
      let update = await userSchema.update(
        { otp: otpCode },
        { where: { email: req.body.email }, raw: true }
      );

      // Fetch user data
      let findData = await userSchema.findAll({
        where: { email: req.body.email },
        raw: true,
      });

      const ResponseType = {};

      // Check if user data exists
      if (findData && findData.length > 0) {
        let user = findData[0];
        let replData = FORGOTPASSWORD.replace(
          /#firstName#/g,
          user.userName ? user.userName : ""
        )
          .replace(/#email#/g, user.email ? user.email : "")
          .replace(/#otp#/g, user.otp);

        // Send email
        Email.sendEmail(user.email, "OTP", replData);

        ResponseType.success = true;
        ResponseType.msg = "OTP sent successfully. Check Your Email.";
      } else {
        ResponseType.error = true;
        ResponseType.msg = "Email ID does not exist.";
      }

      res.status(200).json(ResponseType);
    } catch (error) {
      console.error("Error in OtpSend:", error);
      res.status(500).json({
        error: true,
        msg: "Something went wrong. Please try again later.",
      });
    }
  }

  async changePassword(req, res) {
    try {
      const { email, otp, newpassword } = req.body;
      if (newpassword && email && otp) {
        let data = await userSchema.findAll({
          where: { email: email },
          raw: true,
        });
        if (data) {
          let user = await userSchema.update(
            { password: newpassword, otp: 0 },
            { where: { [Op.and]: { email: email, otp: otp } }, raw: true }
          );
          let checkOTP = await userSchema.findOne({
            where: { email: email },
            raw: true,
          });
          if (checkOTP.otp === 0) {
            return res.status(200).send({
              success: true,
              msg: "Password Changed Successfully.",
            });
          } else {
            res.status(200).send({
              success: false,
              msg: "Invalid OTP.",
            });
          }
        } else {
          return res.status(200).send({
            success: false,
            msg: "Invalid Email.",
          });
        }
      } else {
        return req.statu(200).send({
          error: false,
          msg: "All fields are required",
        });
      }
    } catch (error) {
      console.error("Error in changePassword:", error);
      res.status(500).json({
        error: true,
        msg: "Something went wrong. Please try again later.",
      });
    }
  }

  async emailVerify(req, res) {
    try {
      if (req.body.code) {
        let v1 = await userSchema.update(
          { emailVerifyCode: "" },
          { where: { emailVerifyCode: req.body.code } }
        );
        if (v1[0] === 1) {
          return res.send({
            success: true,
            msg: "Email verification is done",
          });
        } else {
          return res.send({
            error: true,
            msg: "This Email is already verified.",
          });
        }
      } else {
        return res.send({
          error: true,
          msg: "Please provide valid link",
        });
      }
    } catch (error) {
      console.error("Error in emailVerify:", error);
      res.status(500).json({
        error: true,
        msg: "Something went wrong. Please try again later.",
      });
    }
  }

  async getProfileData(req, res) {
    try {
      let { id } = req.body;
      let data = await userSchema.findAll({ where: { id: id }, raw: true });
      return res.status(200).send({
        success: true,
        data: data[0],
        msg: "User details fetched successfully.",
      });
    } catch (error) {
      return res.status(200).send({
        error: true,
        msg: "Something went wrong.",
      });
    }
  }

  async EditProfile(req, res) {
    try {
      if (req.body.id) {
        // Find User information
        let findUser = await userSchema.findOne({
          where: { id: req.body.id },
          raw: true,
        });
        // Update Couple information
        await coupleSchema.update(
          { hisEmail: req.body.email },
          { where: { hisEmail: findUser.email } }
        );
        await coupleSchema.update(
          { herEmail: req.body.email },
          { where: { herEmail: findUser.email } }
        );

        // Update user information
        await userSchema.update(req.body, { where: { id: req.body.id } });

        // Fetch and return updated user data
        let updatedUser = await userSchema.findOne({
          where: { id: req.body.id },
          raw: true,
        });

        return res.status(200).send({
          success: true,
          data: updatedUser,
          msg: "User updated successfully.",
        });
      } else {
        return res.status(400).send({
          error: true,
          msg: "Invalid request. Missing user ID.",
        });
      }
    } catch (error) {
      console.error("Error:", error);
      return res.status(500).send({
        error: true,
        msg: "Something went wrong.",
      });
    }
  }

  async passwordChangeAfterLogin(req, res) {
    try {
      let { oldPassword, newPassword } = req.body.pass;
      let { id } = req.body.userData;
      if (oldPassword && newPassword && id) {
        let user = await userSchema.update(
          { password: newPassword },
          { where: { id } }
        );
        if (user) {
          return res.status(200).send({
            success: true,
            msg: "Password updated successfully.",
          });
        } else {
          return {
            success: true,
            msg: "Something went wrong please try again later.",
          };
        }
      } else {
        return res.send({
          error: true,
          msg: "All fields are required.",
        });
      }
    } catch {
      return res.status(200).send({
        error: true,
        msg: "Something went wrong.",
      });
    }
  }

  async getAllPerishlist(req, res) {
    try {
      //       let query = `SELECT
      //   p.*,
      //   (SELECT COUNT(*) FROM retreats r WHERE r.parishId = p.id AND (r.deleteStatus='' OR r.deleteStatus IS NULL)) AS Retreats_count,
      //   (SELECT COUNT(*) FROM couples c WHERE c.parishId = p.id) AS couples_count
      // FROM
      //   parishes p;
      // `;

      let query = `
      SELECT 
        p.*,
        pc.name AS parishCategoryName,
        (SELECT COUNT(*) FROM retreats r WHERE r.parishId = p.id AND (r.deleteStatus='' OR r.deleteStatus IS NULL)) AS Retreats_count,
        (SELECT COUNT(*) FROM couples c WHERE c.parishId = p.id) AS couples_count
      FROM 
        parishes p
      LEFT JOIN parishCategories pc ON p.parishCategoryId = pc.id`;
      let allParishes = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      return res.status(200).send({
        success: true,
        msg: "All Perish fetched.",
        data: allParishes,
      });
    } catch (error) {
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async getParishByCategory(req, res) {
    try {
      const categoryId = req.params.categoryId;

      let query = `
      SELECT 
        p.*, 
        pc.id AS parishCategoryId,
        pc.name AS parishCategoryName
      FROM 
        parishes p
      LEFT JOIN parishCategories pc 
        ON p.parishCategoryId = pc.id
      WHERE 
        p.parishCategoryId = :categoryId
      ORDER BY p.createdAt DESC
    `;

      let parishes = await db.sequelize.query(query, {
        replacements: { categoryId },
        type: db.Sequelize.QueryTypes.SELECT,
      });

      return res.status(200).send({
        success: true,
        msg: "Parishes fetched for category",
        data: parishes,
      });
    } catch (error) {
      return res.status(500).send({
        success: false,
        msg: error.message,
      });
    }
  }

  async checkPKCouple(req, res) {
    try {
      let primaryKeyMax = await coupleSchema.max("primaryKey");
      return res.send({
        success: true,
        data: primaryKeyMax,
        msg: "Primary key checked.",
      });
    } catch (error) {
      return res.send({
        success: false,
        msg: "Something went wrong.",
      });
    }
  }

  async getAllIncommingRetreats(req, res) {
    try {
      const currentDate = new Date().toISOString().split("T")[0];
      let query = `SELECT retreats.*,parishes.parish AS parishName,parishes.imageUrl AS parishImageUrl,parishes.link AS parishLink,programs.status AS programStatus,directories.status AS directoryStatus FROM retreats
      LEFT JOIN programs ON programs.retreatId = retreats.id
       LEFT JOIN parishes ON parishes.id = retreats.parishId
      LEFT JOIN directories ON directories.retreatId = retreats.id
      WHERE (retreats.deleteStatus='' OR retreats.deleteStatus IS NULL) ORDER BY dateFrom DESC`;
      let allRetreats = await db.sequelize
        .query(query)
        .then(([results, metadata]) => results);
      const parsedData = allRetreats.map((item) => {
        const { confirmation, schedule, ...rest } = item;
        const parsedSchedule = schedule ? JSON.parse(schedule) : [];
        const parsedConfirmations = confirmation
          ? JSON.parse(confirmation)
          : [];
        return {
          ...rest,
          confirmation: parsedConfirmations,
          schedule: parsedSchedule.map((entry) => ({
            date: new Date(entry.date),
            from: entry.from,
            to: entry.to,
          })),
        };
      });
      return res.status(200).send({
        success: true,
        msg: "All Incomming Retreats",
        data: parsedData,
      });
    } catch (error) {
      return res.status(500).json({
        success: false,
        msg: "Error fetching new retreats",
        error: error.message,
      });
    }
  }

  // only show currentDate retreats
  // async getAllIncommingRetreats(req, res) {
  //   try {
  //     const currentDate = new Date().toISOString().split("T")[0];
  //     let query = `SELECT retreats.*,programs.status AS programStatus,directories.status AS directoryStatus FROM retreats
  //     LEFT JOIN programs ON programs.retreatId = retreats.id
  //     LEFT JOIN directories ON directories.retreatId = retreats.id
  //     WHERE dateFrom >= '${currentDate}' AND (retreats.deleteStatus='' OR retreats.deleteStatus IS NULL) ORDER BY dateFrom DESC`;
  //     let allRetreats = await db.sequelize
  //       .query(query)
  //       .then(([results, metadata]) => results);
  //     const parsedData = allRetreats.map((item) => {
  //       const { schedule, ...rest } = item;
  //       const parsedSchedule = schedule ? JSON.parse(schedule) : [];
  //       return {
  //         ...rest,
  //         schedule: parsedSchedule.map((entry) => ({
  //           date: new Date(entry.date),
  //           from: entry.from,
  //           to: entry.to,
  //         })),
  //       };
  //     });
  //     return res.status(200).send({
  //       success: true,
  //       msg: "All Incomming Retreats",
  //       data: parsedData,
  //     });
  //   } catch (error) {
  //     return res.status(500).json({
  //       success: false,
  //       msg: "Error fetching new retreats",
  //       error: error.message,
  //     });
  //   }
  // }

  async getRolesOfRetreats(req, res) {
    try {
      let query = `SELECT roles.role,couples.id AS coupleId,couples.hisMobile,couples.herMobile,couples.hisLastName, couples.imageUrl,couples.hisFirstName,couples.herFirstName, couples.herLastName FROM retreatroasters LEFT JOIN couples ON retreatroasters.coupleId = couples.id LEFT JOIN roles ON retreatroasters.roleId = roles.id INNER JOIN retreats on retreatroasters.retreatId = retreats.id WHERE retreatroasters.retreatId = ${req.body.id};`;
      const [allRoaster, metadata] = await db.sequelize.query(query);
      let myRolesRoasters = {
        mentor: null,
        leadCouple: null,
        // shadowLeadCouple: null,
        coLeadCouple: null,
        spiritualDirector: null,
        spiritualMentor: null,
      };
      allRoaster.forEach((roaster) => {
        if (roaster.role === "Mentor") {
          myRolesRoasters.mentor = roaster;
        } else if (roaster.role === "Lead") {
          myRolesRoasters.leadCouple = roaster;
        } else if (roaster.role === "Co-Lead") {
          myRolesRoasters.coLeadCouple = roaster;
          // } else if (roaster.role === "Shadow Lead") {
          //   myRolesRoasters.shadowLeadCouple = roaster;
        } else if (roaster.role === "Spiritual Director") {
          myRolesRoasters.spiritualDirector = roaster;
        } else if (roaster.role === "Spiritual Mentor") {
          myRolesRoasters.spiritualMentor = roaster;
        }
      });
      return res.status(200).send({
        success: true,
        msg: "All rosters",
        data: myRolesRoasters,
      });
    } catch (error) {
      console.error("Error fetching new retreats:", error);
      return res.status(500).json({
        success: false,
        msg: "Error fetching new retreats",
        error: error.message,
      });
    }
  }

  // async registerCoupleForRetrteat(req, res) {
  //   let {
  //     hisFirstName,
  //     hisLastName,
  //     hisEmail,
  //     hisMobile,
  //     herFirstName,
  //     herLastName,
  //     herEmail,
  //     herMobile,
  //     city,
  //     state,
  //     notes,
  //     parishId,
  //     zip,
  //     address,
  //     allergies,
  //     anniversary_date,
  //     under_age_35,
  //     emergency_name1,
  //     emergency_relationship1,
  //     emergency_phone1,
  //     emergency_name2,
  //     emergency_relationship2,
  //     emergency_phone2,
  //     hear_us,
  //     referral_from_a_friend_or_family_member,
  //     attendeeType,
  //     retreatId,
  //   } = JSON.parse(`${req.body.fromData}`);
  //   try {
  //     const normalizedHisMobile = hisMobile && hisMobile.replace(/\D/g, "");
  //     const normalizedHerMobile = herMobile && herMobile.replace(/\D/g, "");
  //     if (!(hisFirstName || hisLastName || herFirstName || herLastName)) {
  //       return res.status(200).json({
  //         success: false,
  //         error: true,
  //         msg: "Please add at least one name.",
  //       });
  //     }
  //     if (!attendeeType || attendeeType === "" || attendeeType === null) {
  //       return res.status(200).json({
  //         success: false,
  //         error: true,
  //         msg: "Please select either a Retreatant or a Team Couple.",
  //       });
  //     }
  //     if (!hisEmail && !herEmail) {
  //       return res.status(200).json({
  //         success: false,
  //         error: true,
  //         msg: "Please add at least one email ID.",
  //       });
  //     }
  //     let query;
  //     let query1;
  //     if (hisEmail && !herEmail) {
  //       query = `SELECT retreatroasters.* FROM retreatroasters LEFT JOIN couples ON retreatroasters.coupleId = couples.id
  //   WHERE retreatroasters.retreatId = ${retreatId}
  //   AND couples.hisEmail = "${hisEmail}"`;
  //     }

  //     if (!hisEmail && herEmail) {
  //       query = `SELECT retreatroasters.* FROM retreatroasters LEFT JOIN couples ON retreatroasters.coupleId = couples.id
  //  WHERE retreatroasters.retreatId = ${retreatId}
  //  AND couples.herEmail = "${herEmail}"`;
  //     }

  //     if (hisEmail && herEmail) {
  //       query = `SELECT retreatroasters.* FROM retreatroasters LEFT JOIN couples ON retreatroasters.coupleId = couples.id
  //   WHERE retreatroasters.retreatId = ${retreatId}
  //   AND (couples.hisEmail = "${hisEmail}" OR couples.herEmail = "${herEmail}")`;
  //     }

  //     let responseData = await db.sequelize
  //       .query(query)
  //       .then(([results, metadata]) => results);

  //     if (responseData && responseData.length) {
  //       return res.status(200).send({
  //         success: false,
  //         msg: "You are already registered for this Retreat with this Email id.",
  //       });
  //     } else {
  //       let jsonObj = JSON.parse(req.body.fromData);
  //       ["hisEmail", "herEmail", "hisMobile", "herMobile"].forEach((field) => {
  //         if (jsonObj[field] === "") {
  //           jsonObj[field] = null;
  //         }
  //       });
  //       if (jsonObj.anniversary_date === "") {
  //         jsonObj.anniversary_date = null;
  //       }
  //       if (jsonObj.hear_us) {
  //         jsonObj.hear_us = JSON.stringify(jsonObj.hear_us);
  //       }
  //       let checkInMainCouple = false;
  //       let check_in_main_hisEmail = "";
  //       let check_in_main_herEmail = "";
  //       let check_in_main_hisMobile = "";
  //       let check_in_main_herMobile = "";
  //       let check_duplicate_hisEmail = "";
  //       let check_duplicate_herEmail = "";
  //       let check_duplicate_hisMobile = "";
  //       let check_duplicate_herMobile = "";
  //       // Find Couple--------------------
  //       if (
  //         hisEmail &&
  //         hisEmail !== "" &&
  //         hisEmail !== null &&
  //         hisEmail !== undefined
  //       ) {
  //         check_in_main_hisEmail = await coupleSchema.findAll({
  //           where: { hisEmail: hisEmail },
  //           raw: true,
  //         });

  //         check_duplicate_hisEmail = await coupleSchema.findOne({
  //           where: { herEmail: hisEmail },
  //           raw: true,
  //         });

  //         if (
  //           (check_in_main_hisEmail &&
  //             check_in_main_hisEmail.length &&
  //             check_in_main_hisEmail !== "") ||
  //           check_duplicate_hisEmail
  //         ) {
  //           // console.log("---------TRUE ---- check_duplicate_hisEmail");

  //           let checkMobile = await coupleSchema.findOne({
  //             where: {
  //               id: {
  //                 [Op.ne]:
  //                   check_in_main_hisEmail[0].id || check_duplicate_hisEmail.id,
  //               }, // ✅ Exclude the current user
  //               [Op.or]: [
  //                 {
  //                   [Op.and]: [
  //                     { hisMobile: { [Op.ne]: null } },
  //                     { hisMobile: { [Op.ne]: "" } },
  //                     Sequelize.literal(
  //                       `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
  //                     ),
  //                   ],
  //                 },
  //                 {
  //                   [Op.and]: [
  //                     { hisMobile: { [Op.ne]: null } },
  //                     { hisMobile: { [Op.ne]: "" } },
  //                     Sequelize.literal(
  //                       `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
  //                     ),
  //                   ],
  //                 },
  //                 {
  //                   [Op.and]: [
  //                     { herMobile: { [Op.ne]: null } },
  //                     { herMobile: { [Op.ne]: "" } },
  //                     Sequelize.literal(
  //                       `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
  //                     ),
  //                   ],
  //                 },
  //                 {
  //                   [Op.and]: [
  //                     { herMobile: { [Op.ne]: null } },
  //                     { herMobile: { [Op.ne]: "" } },
  //                     Sequelize.literal(
  //                       `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
  //                     ),
  //                   ],
  //                 },
  //               ],
  //             },
  //           });
  //         if (checkMobile) {
  //           return res.status(200).json({
  //             success: false,
  //             error: true,
  //             msg: "This Mobile is already used.",
  //           });
  //         }
  //           checkInMainCouple = true;
  //         }
  //       }

  //       if (
  //         herEmail &&
  //         herEmail !== "" &&
  //         herEmail !== null &&
  //         herEmail !== undefined
  //       ) {
  //         check_in_main_herEmail = await coupleSchema.findAll({
  //           where: { herEmail: herEmail },
  //           raw: true,
  //         });

  //         check_duplicate_herEmail = await coupleSchema.findOne({
  //           where: { hisEmail: herEmail },
  //           raw: true,
  //         });
  //         // console.log(
  //         //   "check_duplicate_herEmail--------------->>>>",
  //         //   check_duplicate_herEmail
  //         // );
  //         if (
  //           (check_in_main_herEmail &&
  //             check_in_main_herEmail.length &&
  //             check_in_main_herEmail !== "") ||
  //           check_duplicate_herEmail
  //         ) {
  //           // console.log("===========TRUE------->>>>", check_duplicate_herEmail);
  //                       let checkMobile = await coupleSchema.findOne({
  //             where: {
  //               id: {
  //                 [Op.ne]:
  //                   check_in_main_herEmail[0].id || check_duplicate_herEmail.id,
  //               }, // ✅ Exclude the current user
  //               [Op.or]: [
  //                 {
  //                   [Op.and]: [
  //                     { hisMobile: { [Op.ne]: null } },
  //                     { hisMobile: { [Op.ne]: "" } },
  //                     Sequelize.literal(
  //                       `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
  //                     ),
  //                   ],
  //                 },
  //                 {
  //                   [Op.and]: [
  //                     { hisMobile: { [Op.ne]: null } },
  //                     { hisMobile: { [Op.ne]: "" } },
  //                     Sequelize.literal(
  //                       `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
  //                     ),
  //                   ],
  //                 },
  //                 {
  //                   [Op.and]: [
  //                     { herMobile: { [Op.ne]: null } },
  //                     { herMobile: { [Op.ne]: "" } },
  //                     Sequelize.literal(
  //                       `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
  //                     ),
  //                   ],
  //                 },
  //                 {
  //                   [Op.and]: [
  //                     { herMobile: { [Op.ne]: null } },
  //                     { herMobile: { [Op.ne]: "" } },
  //                     Sequelize.literal(
  //                       `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
  //                     ),
  //                   ],
  //                 },
  //               ],
  //             },
  //           });
  //         if (checkMobile) {
  //           return res.status(200).json({
  //             success: false,
  //             error: true,
  //             msg: "This Mobile is already used.",
  //           });
  //         }
  //           checkInMainCouple = true;
  //         }
  //       }
  //       let getRetreatData = await retreatSchema.findOne({
  //         where: { id: retreatId },
  //         raw: true,
  //       });
  //       let accessIds = JSON.parse(getRetreatData.accessIds || "[]");
  //       if (!checkInMainCouple) {
  //         let checkMobile = await coupleSchema.findOne({
  //           where: {
  //             [Op.or]: [
  //               {
  //                 [Op.and]: [
  //                   { hisMobile: { [Op.ne]: null } },
  //                   { hisMobile: { [Op.ne]: "" } },
  //                   Sequelize.literal(
  //                     `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
  //                   ),
  //                 ],
  //               },
  //               {
  //                 [Op.and]: [
  //                   { hisMobile: { [Op.ne]: null } },
  //                   { hisMobile: { [Op.ne]: "" } },
  //                   Sequelize.literal(
  //                     `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
  //                   ),
  //                 ],
  //               },
  //               {
  //                 [Op.and]: [
  //                   { herMobile: { [Op.ne]: null } },
  //                   { herMobile: { [Op.ne]: "" } },
  //                   Sequelize.literal(
  //                     `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHisMobile}'`
  //                   ),
  //                 ],
  //               },
  //               {
  //                 [Op.and]: [
  //                   { herMobile: { [Op.ne]: null } },
  //                   { herMobile: { [Op.ne]: "" } },
  //                   Sequelize.literal(
  //                     `REPLACE(REPLACE(REPLACE(REPLACE(herMobile, '-', ''), '(', ''), ')', ''), ' ', '') = '${normalizedHerMobile}'`
  //                   ),
  //                 ],
  //               },
  //             ],
  //           },
  //         });
  //         if (checkMobile) {
  //           return res.status(200).json({
  //             success: false,
  //             error: true,
  //             msg: "This Mobile is already used.",
  //           });
  //         }
  //         // If couple is not exist in the DB
  //         let primaryKeyMax = await coupleSchema.max("primaryKey");
  //         jsonObj.primaryKey = primaryKeyMax + 1;
  //         let newUser = new coupleSchema(jsonObj);
  //         let succ = await newUser.save();
  //         let paswordForCouple1;
  //         let paswordForCouple2;
  //         if (hisEmail && hisEmail !== "" && hisEmail !== undefined) {
  //           let randompass1 = Math.random().toString(36).slice(-8);
  //           paswordForCouple1 =
  //             randompass1.slice(0, 0) + "p" + randompass1.slice(1);
  //         }
  //         if (herEmail && herEmail !== "" && herEmail !== undefined) {
  //           let randompass2 = Math.random().toString(36).slice(-8);
  //           paswordForCouple2 =
  //             randompass2.slice(0, 0) + "p" + randompass2.slice(1);
  //         }
  //         //Create Retreat Roster
  //         let userDataToUpdate = {
  //           attendeeType: attendeeType,
  //           coupleId: succ && succ.id,
  //           retreatId: retreatId,
  //           stage: "VERIFIED",
  //         };
  //         let newRoaster = new retreatRoastSchema(userDataToUpdate);
  //         let succ1 = await newRoaster.save();
  //         let imageSavedCouple;
  //         if (req.files) {
  //           imageSavedCouple = await this.saveImageForCouple(
  //             req.files,
  //             succ.id
  //           );
  //         }
  //         let coupleValues = await coupleSchema.findOne({
  //           where: {
  //             id: succ.id,
  //           },
  //           raw: true,
  //         });

  //         let adminObj = [
  //           {
  //             userName: coupleValues && coupleValues.hisFirstName,
  //             email: coupleValues && coupleValues.hisEmail,
  //             password: paswordForCouple1 ? paswordForCouple1 : null,
  //             accountStatus: "ACTIVE",
  //             userRole: "COUPLE",
  //             coupleId: coupleValues && coupleValues.id,
  //             firstName: coupleValues.hisFirstName
  //               ? coupleValues.hisFirstName
  //               : "",
  //             lastName: coupleValues.hisLastName
  //               ? coupleValues.hisLastName
  //               : "",
  //             mobile: coupleValues.hisMobile ? coupleValues.hisMobile : "",
  //             imageUpload: coupleValues.imageUrl,
  //           },
  //           {
  //             userName: coupleValues && coupleValues.herFirstName,
  //             email: coupleValues && coupleValues.herEmail,
  //             password: paswordForCouple2 ? paswordForCouple2 : null,
  //             accountStatus: "ACTIVE",
  //             userRole: "COUPLE",
  //             coupleId: coupleValues && coupleValues.id,
  //             firstName: coupleValues.herFirstName
  //               ? coupleValues.herFirstName
  //               : "",
  //             lastName: coupleValues.herLastName
  //               ? coupleValues.herLastName
  //               : "",
  //             mobile: coupleValues.herMobile ? coupleValues.herMobile : "",
  //             imageUpload: coupleValues.imageUrl,
  //           },
  //         ];

  //         let userObj = [
  //           {
  //             userName: coupleValues && coupleValues.hisFirstName,
  //             accountStatus: "ACTIVE",
  //             coupleId: coupleValues && coupleValues.id,
  //             firstName: coupleValues.hisFirstName
  //               ? coupleValues.hisFirstName
  //               : "",
  //             lastName: coupleValues.hisLastName
  //               ? coupleValues.hisLastName
  //               : "",
  //             mobile: coupleValues.hisMobile ? coupleValues.hisMobile : "",
  //             imageUpload: coupleValues.imageUrl,
  //           },
  //           {
  //             userName: coupleValues && coupleValues.herFirstName,
  //             accountStatus: "ACTIVE",
  //             coupleId: coupleValues && coupleValues.id,
  //             firstName: coupleValues.herFirstName
  //               ? coupleValues.herFirstName
  //               : "",
  //             lastName: coupleValues.herLastName
  //               ? coupleValues.herLastName
  //               : "",
  //             mobile: coupleValues.herMobile ? coupleValues.herMobile : "",
  //             imageUpload: coupleValues.imageUrl,
  //           },
  //         ];
  //         if (
  //           succ &&
  //           succ.hisEmail &&
  //           succ.hisEmail !== "" &&
  //           succ.hisEmail !== undefined
  //         ) {
  //           let userValues = await userSchema.findOne({
  //             where: {
  //               email: succ.hisEmail,
  //             },
  //             raw: true,
  //           });
  //           if (userValues) {
  //             let updateUser = await userSchema.update(userObj[0], {
  //               where: { id: userValues.id },
  //             });
  //           } else {
  //             let newUser = new userSchema(adminObj[0]);
  //             let succUser1 = await newUser.save();
  //           }

  //           // let replData = SENDLOGINDETAILBYADMIN.replace(
  //           //   /#firstName#/g,
  //           //   succ.hisFirstName ? succ.hisFirstName : ""
  //           // )
  //           //   .replace(/#lastName#/g, succ.hisLastName ? succ.hisLastName : "")
  //           //   .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)
  //           //   .replace(/#email#/g, hisEmail)
  //           //   .replace(/#password#/g, paswordForCouple1);
  //           // Email.sendEmail(
  //           //   succ.hisEmail,
  //           //   "Couple Detail for Login- LOVESTRONG Marriage",
  //           //   replData
  //           // );

  //           let replData1 = RETREATMAILMESSAGE.replace(
  //             /#firstName#/g,
  //             succ.hisFirstName ? succ.hisFirstName : ""
  //           )
  //             .replace(/#lastName#/g, succ.hisLastName ? succ.hisLastName : "")
  //             .replace(
  //               /#mail_message#/g,
  //               getRetreatData.mail_msg
  //                 ? getRetreatData.mail_msg
  //                 : "<h3>Welcome to LOVESTRONG Marriage!</h3>"
  //             );

  //           Email.sendEmail(
  //             succ.hisEmail,
  //             `Thank you for Retreat Registration - ${getRetreatData.title}`,
  //             replData1
  //           );
  //         }
  //         if (
  //           succ &&
  //           succ.herEmail &&
  //           succ.herEmail !== "" &&
  //           succ.herEmail !== undefined
  //         ) {
  //           let userHerValues = await userSchema.findOne({
  //             where: {
  //               email: succ.herEmail,
  //             },
  //             raw: true,
  //           });
  //           // console.log("userHerValues------->>", userHerValues);
  //           if (userHerValues) {
  //             // console.log("1111111111111111 her update");
  //             let updateUser = await userSchema.update(userObj[1], {
  //               where: { id: userHerValues.id },
  //             });
  //           } else {
  //             // console.log("222222 her create");

  //             let newUser = new userSchema(adminObj[1]);
  //             let succUser2 = await newUser.save();
  //           }
  //           // let replData = SENDLOGINDETAILBYADMIN.replace(
  //           //   /#firstName#/g,
  //           //   succ.herFirstName ? succ.herFirstName : ""
  //           // )
  //           //   .replace(/#lastName#/g, succ.herLastName ? succ.herLastName : "")
  //           //   .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)

  //           //   .replace(/#email#/g, herEmail)
  //           //   .replace(/#password#/g, paswordForCouple2);
  //           // Email.sendEmail(
  //           //   succ.herEmail,
  //           //   "Couple Detail for Login- LOVESTRONG Marriage",
  //           //   replData
  //           // );
  //           let replData1 = RETREATMAILMESSAGE.replace(
  //             /#firstName#/g,
  //             succ.herFirstName ? succ.herFirstName : ""
  //           )
  //             .replace(/#lastName#/g, succ.herLastName ? succ.herLastName : "")
  //             .replace(
  //               /#mail_message#/g,
  //               getRetreatData.mail_msg
  //                 ? getRetreatData.mail_msg
  //                 : "<h3>Welcome to LOVESTRONG Marriage!</h3>"
  //             );

  //           Email.sendEmail(
  //             succ.herEmail,
  //             `Thank you for Retreat Registration - ${getRetreatData.title}`,
  //             replData1
  //           );
  //         }
  //         //Send mail to Retreat Sub-Admins
  //         for (let item of accessIds) {
  //           let myUser = await userSchema.findOne({
  //             where: { id: item },
  //           });
  //           if (myUser) {
  //             if (myUser.email) {
  //               let replData = NOTIFICATIONFORRETREATREGIS.replace(
  //                 /#userName#/g,
  //                 myUser.userName || ""
  //               )
  //                 .replace(/#retreatTitle#/g, getRetreatData.title || "")
  //                 .replace(
  //                   /#coupleName#/g,
  //                   `${succ.hisLastName ? succ.hisLastName : ""}` +
  //                     ` (${succ.hisFirstName ? succ.hisFirstName : ""}` +
  //                     ` - ${succ.herFirstName ? succ.herFirstName : ""})`
  //                 )
  //                 .replace(/#type#/g, attendeeType)
  //                 .replace(
  //                   /#link#/g,
  //                   `${process.env.SERVERADDRESS}/retreat-registrations`
  //                 );
  //               Email.sendEmail(
  //                 myUser.email,
  //                 "Notification for New Retreat Registration",
  //                 replData
  //               );
  //             }
  //           }
  //         }
  //       } else {
  //         // If couple is exist in the DB
  //         let userDataToUpdate1 = {
  //           hisFirstName: hisFirstName,
  //           hisLastName: hisLastName,
  //           hisEmail: hisEmail !== "" ? hisEmail : null,
  //           hisMobile: hisMobile !== "" ? hisMobile : null,
  //           herFirstName: herFirstName,
  //           herLastName: herLastName,
  //           herEmail: herEmail !== "" ? herEmail : null,
  //           herMobile: herMobile !== "" ? herMobile : null,
  //           city: city,
  //           state: state,
  //           zip: zip,
  //           notes: notes,
  //           parishId: parishId && parishId !== "" ? parishId : null,
  //           address: address,
  //           allergies: allergies,
  //           anniversary_date: anniversary_date === "" ? null : anniversary_date,
  //           under_age_35: under_age_35,
  //           emergency_name1: emergency_name1,
  //           emergency_relationship1: emergency_relationship1,
  //           emergency_phone1: emergency_phone1,
  //           emergency_name2: emergency_name2,
  //           emergency_relationship2: emergency_relationship2,
  //           emergency_phone2: emergency_phone2,
  //           hear_us: JSON.stringify(hear_us),
  //           referral_from_a_friend_or_family_member:
  //             referral_from_a_friend_or_family_member,
  //         };
  //         //Update Couple and find couple Detail
  //         let findCouple = "";
  //         if (
  //           check_in_main_hisEmail &&
  //           check_in_main_hisEmail.length &&
  //           check_in_main_hisEmail !== ""
  //         ) {
  //           userDataToUpdate1.imageUrl = check_in_main_hisEmail[0].imageUrl;
  //           let update = await coupleSchema.update(userDataToUpdate1, {
  //             where: { id: check_in_main_hisEmail[0].id },
  //           });

  //           findCouple = await coupleSchema.findAll({
  //             where: { id: check_in_main_hisEmail[0].id },
  //             raw: true,
  //           });
  //         }
  //         if (
  //           check_in_main_herEmail &&
  //           check_in_main_herEmail.length &&
  //           check_in_main_herEmail !== ""
  //         ) {
  //           userDataToUpdate1.imageUrl = check_in_main_herEmail[0].imageUrl;
  //           let update = await coupleSchema.update(userDataToUpdate1, {
  //             where: { id: check_in_main_herEmail[0].id },
  //           });

  //           findCouple = await coupleSchema.findAll({
  //             where: { id: check_in_main_herEmail[0].id },
  //             raw: true,
  //           });
  //         }

  //         if (check_duplicate_hisEmail) {
  //           // console.log("uPDATE_________check_duplicate_hisEmail");
  //           userDataToUpdate1.imageUrl = check_duplicate_hisEmail.imageUrl;

  //           let update = await coupleSchema.update(userDataToUpdate1, {
  //             where: { id: check_duplicate_hisEmail.id },
  //           });

  //           findCouple = await coupleSchema.findAll({
  //             where: { id: check_duplicate_hisEmail.id },
  //             raw: true,
  //           });
  //           // console.log("findCouple__________check_duplicate_hisEmail");
  //         }

  //         if (check_duplicate_herEmail) {
  //           // console.log("uPDATE_________check_duplicate_herEmail");
  //           userDataToUpdate1.imageUrl = check_duplicate_herEmail.imageUrl;

  //           let update = await coupleSchema.update(userDataToUpdate1, {
  //             where: { id: check_duplicate_herEmail.id },
  //           });

  //           findCouple = await coupleSchema.findAll({
  //             where: { id: check_duplicate_herEmail.id },
  //             raw: true,
  //           });
  //           // console.log("findCouple__________check_duplicate_herEmail");
  //         }

  //         if (findCouple && findCouple.length) {
  //           //Create new Retreat Roster
  //           let userDataToUpdate = {
  //             attendeeType: attendeeType,
  //             coupleId: findCouple[0].id,
  //             retreatId: retreatId,
  //             stage: "VERIFIED",
  //           };
  //           let newRoaster = new retreatRoastSchema(userDataToUpdate);
  //           let succ1 = await newRoaster.save();
  //           let imageSavedCouple1;
  //           if (req.files) {
  //             imageSavedCouple1 = await this.saveImageForCouple(
  //               req.files,
  //               findCouple[0].id
  //             );
  //           }

  //           let adminObj = [
  //             {
  //               coupleId: findCouple[0].id,
  //               userName: findCouple[0].hisFirstName,
  //               firstName: findCouple[0].hisFirstName
  //                 ? findCouple[0].hisFirstName
  //                 : "",
  //               lastName: findCouple[0].hisLastName
  //                 ? findCouple[0].hisLastName
  //                 : "",
  //               mobile: findCouple[0].hisMobile ? findCouple[0].hisMobile : "",
  //               imageUpload: findCouple[0].imageUrl,
  //             },

  //             {
  //               coupleId: findCouple[0].id,
  //               userName: findCouple[0].herFirstName,
  //               firstName: findCouple[0].herFirstName
  //                 ? findCouple[0].herFirstName
  //                 : "",
  //               lastName: findCouple[0].herLastName
  //                 ? findCouple[0].herLastName
  //                 : "",
  //               mobile: findCouple[0].herMobile ? findCouple[0].herMobile : "",
  //               imageUpload: findCouple[0].imageUrl,
  //             },
  //           ];
  //           //Update User Detail and Send Thankyou Mail.
  //           if (
  //             findCouple &&
  //             findCouple[0].hisEmail &&
  //             findCouple[0].hisEmail !== "" &&
  //             findCouple[0].hisEmail !== null
  //           ) {
  //             let upDate = await userSchema.update(adminObj[0], {
  //               where: { email: findCouple[0].hisEmail },
  //             });
  //             let userValues = await userSchema.findOne({
  //               where: { email: findCouple[0].hisEmail },
  //               raw: true,
  //             });
  //             if (
  //               userValues &&
  //               userValues.email &&
  //               userValues.email !== "" &&
  //               userValues.email !== undefined
  //             ) {
  //               let replData = RETREATMAILMESSAGE.replace(
  //                 /#firstName#/g,
  //                 userValues.firstName ? userValues.firstName : ""
  //               )
  //                 .replace(
  //                   /#lastName#/g,
  //                   userValues.lastName ? userValues.lastName : ""
  //                 )
  //                 .replace(
  //                   /#mail_message#/g,
  //                   getRetreatData.mail_msg
  //                     ? getRetreatData.mail_msg
  //                     : "<h3>Welcome to LOVESTRONG Marriage!</h3>"
  //                 );

  //               Email.sendEmail(
  //                 userValues.email,
  //                 `Thank you for Retreat Registration - ${getRetreatData.title}`,
  //                 replData
  //               );
  //             }
  //           }
  //           if (
  //             findCouple &&
  //             findCouple[0].herEmail &&
  //             findCouple[0].herEmail !== "" &&
  //             findCouple[0].herEmail !== null
  //           ) {
  //             let upDate1 = await userSchema.update(adminObj[1], {
  //               where: { email: findCouple[0].herEmail },
  //             });
  //             let userValues1 = await userSchema.findOne({
  //               where: { email: findCouple[0].herEmail },
  //               raw: true,
  //             });
  //             if (
  //               userValues1 &&
  //               userValues1.email &&
  //               userValues1.email !== "" &&
  //               userValues1.email !== undefined
  //             ) {
  //               let replData = RETREATMAILMESSAGE.replace(
  //                 /#firstName#/g,
  //                 userValues1.firstName ? userValues1.firstName : ""
  //               )
  //                 .replace(
  //                   /#lastName#/g,
  //                   userValues1.lastName ? userValues1.lastName : ""
  //                 )
  //                 .replace(
  //                   /#mail_message#/g,
  //                   getRetreatData.mail_msg
  //                     ? getRetreatData.mail_msg
  //                     : "<h3>Welcome to LOVESTRONG Marriage!</h3>"
  //                 );

  //               Email.sendEmail(
  //                 userValues1.email,
  //                 `Thank you for Retreat Registration - ${getRetreatData.title}`,
  //                 replData
  //               );
  //             }
  //           }
  //           //Send mail to Retreat Sub-Admin
  //           for (let item of accessIds) {
  //             let myUser = await userSchema.findOne({
  //               where: { id: item },
  //             });
  //             if (myUser) {
  //               if (myUser.email) {
  //                 let replData = NOTIFICATIONFORRETREATREGIS.replace(
  //                   /#userName#/g,
  //                   myUser.userName || ""
  //                 )
  //                   .replace(/#retreatTitle#/g, getRetreatData.title || "")
  //                   .replace(
  //                     /#coupleName#/g,
  //                     `${
  //                       findCouple[0].hisLastName
  //                         ? findCouple[0].hisLastName
  //                         : ""
  //                     }` +
  //                       ` (${
  //                         findCouple[0].hisFirstName
  //                           ? findCouple[0].hisFirstName
  //                           : ""
  //                       }` +
  //                       ` - ${
  //                         findCouple[0].herFirstName
  //                           ? findCouple[0].herFirstName
  //                           : ""
  //                       })`
  //                   )
  //                   .replace(
  //                     /#link#/g,
  //                     `${process.env.SERVERADDRESS}/retreat-registrations`
  //                   )
  //                   .replace(/#type#/g, attendeeType);
  //                 Email.sendEmail(
  //                   myUser.email,
  //                   "Notification for New Retreat Registration",
  //                   replData
  //                 );
  //               }
  //             }
  //           }
  //         }
  //       }
  //       return res.status(200).send({
  //         success: true,
  //         msg: "Thank you for Retreat Rgistration!",
  //         data: jsonObj,
  //         checkInMainCouple: checkInMainCouple,
  //       });
  //     }
  //   } catch (error) {
  //     console.log(
  //       `registerCoupleForRetrteat [${new Date().toLocaleString("en-US", {
  //         timeZoneName: "short",
  //       })}] error -->`,
  //       error
  //     );
  //     return res.status(200).json({
  //       success: false,
  //       msg: error,
  //     });
  //   }
  // }

  async registerCoupleForRetrteat(req, res) {
    try {
      let {
        hisFirstName,
        hisLastName,
        hisEmail,
        hisMobile,
        herFirstName,
        herLastName,
        herEmail,
        herMobile,
        city,
        state,
        notes,
        parishId,
        zip,
        address,
        allergies,
        anniversary_date,
        under_age_35,
        emergency_name1,
        emergency_relationship1,
        emergency_phone1,
        emergency_name2,
        emergency_relationship2,
        emergency_phone2,
        hear_us,
        referral_from_a_friend_or_family_member,
        attendeeType,
        retreatId,
      } = JSON.parse(req.body.fromData);

      const normalizedHisMobile = hisMobile
        ? hisMobile.replace(/\D/g, "")
        : null;
      const normalizedHerMobile = herMobile
        ? herMobile.replace(/\D/g, "")
        : null;
      if (!attendeeType) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Please select either a Retreatant or a Team Couple.",
        });
      }
      if (!(hisFirstName || hisLastName || herFirstName || herLastName)) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Please add at least one name.",
        });
      }

      if (!hisEmail && !herEmail) {
        return res.status(200).json({
          success: false,
          error: true,
          msg: "Please add at least one email ID.",
        });
      }

      let rosterQuery = `SELECT retreatroasters.* FROM retreatroasters LEFT JOIN couples ON retreatroasters.coupleId = couples.id WHERE retreatroasters.retreatId = ${retreatId}`;
      if (hisEmail && herEmail) {
        rosterQuery += ` AND (couples.hisEmail = "${hisEmail}" OR couples.herEmail = "${herEmail}")`;
      } else if (hisEmail) {
        rosterQuery += ` AND couples.hisEmail = "${hisEmail}"`;
      } else if (herEmail) {
        rosterQuery += ` AND couples.herEmail = "${herEmail}"`;
      }

      let rosterResult = await db.sequelize
        .query(rosterQuery)
        .then(([results]) => results);
      if (rosterResult && rosterResult.length) {
        return res.status(200).send({
          success: false,
          msg: "You are already registered for this Retreat with this Email id.",
        });
      }

      let jsonObj = JSON.parse(req.body.fromData);
      ["hisEmail", "herEmail", "hisMobile", "herMobile"].forEach((f) => {
        if (jsonObj[f] === "") jsonObj[f] = null;
      });
      if (jsonObj.anniversary_date === "") jsonObj.anniversary_date = null;
      if (jsonObj.hear_us) jsonObj.hear_us = JSON.stringify(jsonObj.hear_us);

      let checkInMainCouple = false;
      let coupleMatch = null;
      if (hisEmail) {
        let existingHis = await coupleSchema.findAll({
          where: { hisEmail },
          raw: true,
        });
        let duplicateHis = await coupleSchema.findOne({
          where: { herEmail: hisEmail },
          raw: true,
        });
        if ((existingHis && existingHis.length) || duplicateHis) {
          coupleMatch = existingHis.length ? existingHis[0] : duplicateHis;
          checkInMainCouple = true;
        }
      }
      // Check by herEmail if not found yet
      if (!coupleMatch && herEmail) {
        let existingHer = await coupleSchema.findAll({
          where: { herEmail },
          raw: true,
        });
        let duplicateHer = await coupleSchema.findOne({
          where: { hisEmail: herEmail },
          raw: true,
        });
        if ((existingHer && existingHer.length) || duplicateHer) {
          coupleMatch = existingHer.length ? existingHer[0] : duplicateHer;
          checkInMainCouple = true;
        }
      }

      // ✅ If couple found, exclude them from mobile duplication check
      let excludeId = coupleMatch ? coupleMatch.id : null;

      // ✅ Mobile duplicate check
      let mobileDupWhere = {
        ...(excludeId && { id: { [Op.ne]: excludeId } }),
        [Op.or]: [
          Sequelize.literal(
            `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile,'-',''),'(',''),')',''),' ','')='${normalizedHisMobile}'`
          ),
          Sequelize.literal(
            `REPLACE(REPLACE(REPLACE(REPLACE(herMobile,'-',''),'(',''),')',''),' ','')='${normalizedHisMobile}'`
          ),
          Sequelize.literal(
            `REPLACE(REPLACE(REPLACE(REPLACE(hisMobile,'-',''),'(',''),')',''),' ','')='${normalizedHerMobile}'`
          ),
          Sequelize.literal(
            `REPLACE(REPLACE(REPLACE(REPLACE(herMobile,'-',''),'(',''),')',''),' ','')='${normalizedHerMobile}'`
          ),
        ],
      };

      if (normalizedHisMobile || normalizedHerMobile) {
        let mobileDuplicate = await coupleSchema.findOne({
          where: mobileDupWhere,
        });
        if (mobileDuplicate) {
          return res.status(200).json({
            success: false,
            error: true,
            msg: "This Mobile is already used.",
          });
        }
      }

      let retreatData = await retreatSchema.findOne({
        where: { id: retreatId },
        raw: true,
      });
      let accessIds = JSON.parse(retreatData.accessIds || "[]");

      let coupleId = null;

      if (!checkInMainCouple) {
        // ✅ New couple
        let primaryKeyMax = await coupleSchema.max("primaryKey");
        jsonObj.primaryKey = primaryKeyMax + 1;
        let newCouple = await coupleSchema.create(jsonObj);
        coupleId = newCouple.id;

        // Add retreat roster
        await retreatRoastSchema.create({
          attendeeType,
          coupleId,
          retreatId,
          stage: "VERIFIED",
        });

        // Handle images
        if (req.files) await this.saveImageForCouple(req.files, coupleId);
      } else {
        // ✅ Existing couple -> update details
        let updateData = {
          hisFirstName,
          hisLastName,
          hisEmail: hisEmail || null,
          hisMobile: hisMobile || null,
          herFirstName,
          herLastName,
          herEmail: herEmail || null,
          herMobile: herMobile || null,
          city,
          state,
          zip,
          notes,
          parishId: parishId || null,
          address,
          allergies,
          anniversary_date: anniversary_date || null,
          under_age_35,
          emergency_name1,
          emergency_relationship1,
          emergency_phone1,
          emergency_name2,
          emergency_relationship2,
          emergency_phone2,
          hear_us: JSON.stringify(hear_us),
          referral_from_a_friend_or_family_member,
        };

        await coupleSchema.update(updateData, {
          where: { id: coupleMatch.id },
        });
        coupleId = coupleMatch.id;

        // Add retreat roster
        await retreatRoastSchema.create({
          attendeeType,
          coupleId,
          retreatId,
          stage: "VERIFIED",
        });

        if (req.files) await this.saveImageForCouple(req.files, coupleId);
      }

      // ✅ Fetch updated couple
      let coupleData = await coupleSchema.findOne({
        where: { id: coupleId },
        raw: true,
      });

      // ✅ Create/update users & send mails
      let userPairs = [
        {
          email: coupleData.hisEmail,
          firstName: coupleData.hisFirstName,
          lastName: coupleData.hisLastName,
          mobile: coupleData.hisMobile,
        },
        {
          email: coupleData.herEmail,
          firstName: coupleData.herFirstName,
          lastName: coupleData.herLastName,
          mobile: coupleData.herMobile,
        },
      ];

      for (let user of userPairs) {
        if (user.email) {
          let existingUser = await userSchema.findOne({
            where: { email: user.email },
            raw: true,
          });
          let userData = {
            userName: user.firstName,
            email: user.email,
            accountStatus: "ACTIVE",
            userRole: "COUPLE",
            coupleId,
            firstName: user.firstName || "",
            lastName: user.lastName || "",
            mobile: user.mobile || "",
            imageUpload: coupleData.imageUrl,
          };
          if (existingUser) {
            await userSchema.update(userData, {
              where: { id: existingUser.id },
            });

            let replData = SENDLOGINDETAILBYADMIN.replace(
              /#firstName#/g,
              user.firstName ? user.firstName : ""
            )
              .replace(/#lastName#/g, user.lastName ? user.lastName : "")
              .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)

              .replace(/#email#/g, user.email)
              .replace(/#password#/g, existingUser.password);
            Email.sendEmail(
              user.email,
              "Couple Detail for Login- LOVESTRONG Marriage",
              replData
            );
          } else {
            let randompass1 = Math.random().toString(36).slice(-8);
            let paswordForCouple =
              randompass1.slice(0, 0) + "p" + randompass1.slice(1);
            userData.password = paswordForCouple;
            await userSchema.create(userData);
            let replData = SENDLOGINDETAILBYADMIN.replace(
              /#firstName#/g,
              user.firstName ? user.firstName : ""
            )
              .replace(/#lastName#/g, user.lastName ? user.lastName : "")
              .replace(/#url#/g, `${process.env.SERVERADDRESS}/login`)

              .replace(/#email#/g, user.email)
              .replace(/#password#/g, paswordForCouple);
            Email.sendEmail(
              user.email,
              "Couple Detail for Login- LOVESTRONG Marriage",
              replData
            );
          }

          // Send thank you mail
          let mailBody = RETREATMAILMESSAGE.replace(
            /#firstName#/g,
            user.firstName || ""
          )
            .replace(/#lastName#/g, user.lastName || "")
            .replace(
              /#mail_message#/g,
              retreatData.mail_msg || "<h3>Welcome to LOVESTRONG Marriage!</h3>"
            );

          Email.sendEmail(
            user.email,
            `Thank you for Retreat Registration - ${retreatData.title}`,
            mailBody
          );
        }
      }

      // ✅ Send mail to retreat's Lead and Co-Lead couples
      let leadCoupleRole = await RolesSchema.findOne({
        where: { role: "Lead" },
        raw: true,
      });
      let coLeadCoupleRole = await RolesSchema.findOne({
        where: { role: "Co-Lead" },
        raw: true,
      });

      // Get all retreat roster entries for Lead and Co-Lead
      let roasterData = await retreatRoastSchema.findAll({
        where: {
          retreatId: retreatId,
          roleId: [leadCoupleRole.id, coLeadCoupleRole.id],
        },
        raw: true,
      });

      // Get all couple records for these roles
      let roleCoupleIds = roasterData.map((r) => r.coupleId);

      let allRoleCouples = await coupleSchema.findAll({
        where: { id: roleCoupleIds },
        raw: true,
      });
      let parishData = "";
      if (retreatData.parishId) {
        parishData = await perishSchema.findOne({
          where: { id: retreatData.parishId },
          raw: true,
        });
      }

      let retreatTitle = "";
      if (parishData?.parish) {
        retreatTitle += parishData.parish;
      }
      if (retreatData.language) {
        retreatTitle += ` (${retreatData.language[0].toUpperCase()}${retreatData.language.slice(
          1
        )})`;
      }
      if (retreatData.location) {
        retreatTitle += ` ${retreatData.location[0].toUpperCase()}${retreatData.location.slice(
          1
        )}`;
      }

      for (let item of allRoleCouples) {
        let myUsers = await userSchema.findAll({
          where: { coupleId: item.id },
          raw: true,
        });

        for (let userItem of myUsers) {
          if (userItem.email) {
            let replData = NOTIFICATIONFORRETREATREGIS.replace(
              /#userName#/g,
              userItem.userName || ""
            )
              .replace(/#retreatTitle#/g, retreatTitle || "")
              .replace(
                /#coupleName#/g,
                `${coupleData.hisLastName || ""} (${
                  coupleData.hisFirstName || ""
                } - ${coupleData.herFirstName || ""})`
              )
              .replace(
                /#link#/g,
                `${process.env.SERVERADDRESS}/retreat-registrations`
              )
              .replace(/#type#/g, attendeeType || "Retreatant");

            Email.sendEmail(
              userItem.email,
              "Notification for New Retreat Registration",
              replData
            );
          }
        }
      }

      // ✅ Notify Sub-Admins
      for (let access of accessIds) {
        // Skip if disabled
        if (access.isDisabled) continue;

        let subAdmin = await userSchema.findOne({
          where: { id: access.userId }, // use userId instead of raw id
          raw: true,
        });

        if (subAdmin?.email) {
          let notifyBody = NOTIFICATIONFORRETREATREGIS.replace(
            /#userName#/g,
            subAdmin.userName || ""
          )
            .replace(/#retreatTitle#/g, retreatTitle || "")
            .replace(
              /#coupleName#/g,
              `${coupleData.hisLastName || ""} (${
                coupleData.hisFirstName || ""
              } - ${coupleData.herFirstName || ""})`
            )
            .replace(
              /#link#/g,
              `${process.env.SERVERADDRESS}/retreat-registrations`
            )
            .replace(/#type#/g, attendeeType)
            .replace(
              /#helpLink#/g,
              `${process.env.SERVERADDRESS}/create-ticket`
            );

          await Email.sendEmail(
            subAdmin.email,
            "Notification for New Retreat Registration",
            notifyBody
          );
        }
      }
      return res.status(200).send({
        success: true,
        msg: "Thank you for Retreat Registration!",
        data: jsonObj,
      });
    } catch (error) {
      console.error("registerCoupleForRetrteat error:", error);
      return res.status(200).json({ success: false, msg: error.message });
    }
  }

  async saveImageForCouple(files, coupleId) {
    try {
      let updateData = {};
      let coupleDetail = await coupleSchema.findOne({
        where: { id: coupleId },
        raw: true,
      });
      if (coupleDetail) {
        if (coupleDetail.imageUrl) {
          const profileImagePath = path.join(
            PROJECT_DIR,
            "profileImage",
            path.basename(coupleDetail.imageUrl)
          );
          if (fs.existsSync(profileImagePath)) {
            fs.unlinkSync(profileImagePath);
          }
        }
      }
      if (files.file) {
        const file = files.file;
        const now = new Date();
        const currentDate = now.toISOString().split("T")[0];
        const fileExtension = file.name.substring(file.name.lastIndexOf("."));
        const fileName = `${coupleDetail.hisLastName}, ${coupleDetail.hisFirstName} & ${coupleDetail.herFirstName}_${currentDate}${fileExtension}`;
        const fileUrl = PROJECT_DIR + "/profileImage/" + fileName;
        const imgUrl =
          process.env.SERVERADDRESS + "/public/profileImage/" + fileName;
        updateData.imageUrl = imgUrl;
        file.mv(fileUrl, async function (err) {
          if (err) {
            return false;
          }
        });
      }

      if (
        coupleDetail[0].imageUrl === "" ||
        coupleDetail[0].imageUrl === null
      ) {
        if (Object.keys(updateData).length > 0) {
          await coupleSchema.update(updateData, { where: { id: coupleId } });
        }
      }
    } catch (error) {
      return error;
    }
  }

  async createTempRetreat(req, res) {
    // console.log(
    //   "process.env.CAPTCHESECRETKEY}-->",
    //   process.env.CAPTCHESECRETKEY
    // );
    try {
      let {
        parishId,
        language,
        location,
        schedule,
        heading,
        mission_statement,
        description,
        mail_msg,
        contact_name,
        contact_email,
        contact_mobile,
        retreat_team,
        token,
        subAdmins,
      } = JSON.parse(`${req.body.fromData}`);
      // console.log("token--->>", token);
      // const respo = await fetch(
      //   `https://www.google.com/recaptcha/api/siteverify?secret=${process.env.CAPTCHESECRETKEY}&response=${token}`,
      //   {
      //     method: "POST",
      //   }
      // );
      // console.log("respo---->>", respo);
      // const data = await respo.json(); // Parse the response to JSON
      // console.log("respo---->>", data);
      // if (data.success) {
      //   console.log("CAPTCHA verification successful");
      // } else {
      //   return res.status(200).json({
      //     success: false,
      //     msg: "CAPTCHA verification failed",
      //   });
      // }
      let schedule1 = schedule.filter((item) => item && item.date);
      if (schedule1 && schedule1.length) {
        let dateFrom;
        let dateTo;
        if (schedule1.length > 0) {
          dateFrom = new Date(schedule1[0].date);
          dateTo = new Date(schedule1[schedule1.length - 1].date);
        } else {
          dateFrom = null;
          dateTo = null;
        }
        let parishCheck = await perishSchema.findOne({
          where: { id: parishId },
        });
        let saveObj = {
          title: `${parishCheck.parish} (${
            language.charAt(0).toUpperCase() + language.slice(1).toLowerCase()
          }) ${location}`,
          parishId: parishId,
          language: language,
          location: location,
          schedule: JSON.stringify(schedule1),
          heading: heading,
          mission_statement: mission_statement,
          description: description,
          mail_msg: mail_msg,
          contact_name: contact_name,
          contact_email: contact_email,
          contact_mobile: contact_mobile,
          retreat_team: JSON.stringify(retreat_team),
          dateFrom: dateFrom,
          dateTo: dateTo,
          subAdmins: JSON.stringify(subAdmins),
        };

        let checkRetreat = await tempRetreatSchema.findOne({
          where: { title: saveObj.title },
          raw: true,
        });
        if (checkRetreat) {
          return res.status(200).send({
            success: false,
            msg: "Retreat already exists.",
          });
        }
        let newRetreat = new tempRetreatSchema(saveObj);
        let succ = await newRetreat.save();
        if (req.files) {
          let imageSavedCouple = await this.saveImagesForRetreat(
            req.files,
            succ.id
          );
        }
        try {
          let update = await tempRetreatSchema.update(
            { mission_statement: mission_statement },
            {
              where: { language: language },
            }
          );
          let queryAdmins = `SELECT users.userName,users.firstName,users.lastName,users.password, users.email, users.id,users.isDisabled FROM users WHERE users.userRole = 'ADMIN' AND users.isDisabled = 0 AND users.accountStatus = "ACTIVE" AND users.email ="jimmieflores@gmail.com";`;
          let getAllAdmins = await db.sequelize
            .query(queryAdmins)
            .then(([results, metadata]) => results);
          for (let item of getAllAdmins) {
            if (item.email) {
              let replData = CREATENEWRETREAT.replace(
                /#retreatTitle#/g,
                succ.title || ""
              )
                .replace(/#parish#/g, parishCheck.parish || "")

                .replace(
                  /#language#/g,
                  succ.language.charAt(0).toUpperCase() || ""
                )

                .replace(/#location#/g, succ.location || "")

                .replace(
                  /#retreatDates#/g,
                  moment(dateFrom).isSame(dateTo, "day")
                    ? `(${moment(dateFrom)
                        .tz("America/New_York")
                        .format("MMM-DD-YYYY")})`
                    : `(${moment(dateFrom)
                        .tz("America/New_York")
                        .format("MMM DD")} - ${moment(dateTo)
                        .tz("America/New_York")
                        .format("MMM DD")}, ${moment(dateFrom)
                        .tz("America/New_York")
                        .format("YYYY")})` || ""
                )
                .replace(/#retreatTheme#/g, succ.heading || "")

                .replace(/#contact_name#/g, succ.contact_name || "")
                .replace(/#contact_email#/g, succ.contact_email || "")
                .replace(/#contact_mobile#/g, succ.contact_mobile || "");

              Email.sendEmail(item.email, "New Retreat Registration", replData);
            }
          }
        } catch (error) {
          console.error("Error updating records:", error);
        }
        if (succ) {
          return res.status(200).send({
            success: true,
            msg: "Retreat added successfully.",
            data: succ,
          });
        } else {
          return res.status(200).send({
            msg: `Something went wrong. Please try again.`,
            error: true,
            success: false,
          });
        }
      } else {
        return res.status(200).json({
          success: false,
          msg: "Atleast one Date is required.",
        });
      }
    } catch (error) {
      console.log(
        `createTempRetreat [${new Date().toLocaleString("en-US", {
          timeZoneName: "short",
        })}] error -->`,
        error
      );
      return res.status(200).json({
        success: false,
        msg: error,
      });
    }
  }

  async saveImagesForRetreat(files, retreatId) {
    try {
      if (files && files.file1) {
        let file1 = files.file1;
        let fileName1 = file1.name;
        let fileUrl1 = `${PROJECT_DIR}/retreatImage/${fileName1}`;
        let imgUrl1 = `${process.env.SERVERADDRESS}/public/retreatImage/${fileName1}`;
        // Update the retreat schema with image URL
        await tempRetreatSchema.update(
          { image1: imgUrl1 },
          { where: { id: retreatId } }
        );
        // Move file1 asynchronously
        const moveFile1 = new Promise((resolve, reject) => {
          file1.mv(fileUrl1, (err) => {
            if (err) {
              reject(err);
            } else {
              resolve();
            }
          });
        });
        // Wait for file movement to complete
        await moveFile1;
      }
      // Return true if everything is successful
      return true;
    } catch (error) {
      console.error("Error saving images:", error);
      throw error;
    }
  }

  async getMissionStatement(req, res) {
    try {
      let foundMissionStatement = await retreatSchema.findOne({});
      return res.status(200).send({
        success: true,
        msg: "Mision Statement",
        data: foundMissionStatement,
      });
    } catch (error) {
      return res.status(500).json({
        success: false,
        msg: "Error fetching new retreats",
        error: error.message,
      });
    }
  }

  async checkMailInDb(req, res) {
    try {
      const { email, prevAttendeeType } = req.body;
      const record = await coupleSchema.findOne({
        where: {
          [Op.or]: [{ hisEmail: email }, { herEmail: email }],
        },
      });
      if (record) {
        return res.status(200).json({
          success: true,
          message: "Found mail.",
          data: record,
          prevAttendeeType: prevAttendeeType,
        });
      }
      return res.status(200).json({
        success: false,
        message: "No record found for this email.",
        prevAttendeeType: prevAttendeeType,
      });
    } catch (error) {
      console.error("Error checking email:", error);
      return res.status(200).json({
        success: false,
        message: "Server error while checking email.",
        error: error.message,
        prevAttendeeType: prevAttendeeType,
      });
    }
  }

  async allCouples(req, res) {
    try {
      let all_couple = await coupleSchema.findAll();
      return res.status(200).send({
        success: true,
        msg: "All Couples",
        data: all_couple,
      });
    } catch (err) {
      return res.status(200).json({
        success: false,
        msg: err,
      });
    }
  }

  async outerUsers(req, res) {
    try {
      let all_outer_users = await userSchema.findAll({
        where: { coupleId: null },
      });
      return res.status(200).send({
        success: true,
        msg: "All outer Users",
        data: all_outer_users,
      });
    } catch (err) {
      return res.status(200).json({
        success: false,
        msg: err,
      });
    }
  }

  async submitTeamInterest(req, res) {
    try {
      const { name, email, mobile, selectedRetreats, interestType } = req.body;

      // ✅ Basic validation
      if (
        !name ||
        !email ||
        !mobile ||
        !selectedRetreats ||
        selectedRetreats.length === 0
      ) {
        return res.status(400).json({
          success: false,
          msg: "All fields are required, and at least one retreat must be selected",
        });
      }

      // ✅ Check if user already submitted for these retreats
      let existingUser = await teamInterestSchema.findOne({ where: { email } });

      if (existingUser) {
        // Merge retreats: keep old + new unique
        let oldRetreats = existingUser.retreatIds || [];
        let newRetreats = [...new Set([...oldRetreats, ...selectedRetreats])];

        await existingUser.update({ retreatIds: newRetreats });

        return res.status(200).json({
          success: true,
          msg: "Interest updated successfully",
          data: existingUser,
        });
      }

      // ✅ If not exist → create new record
      const newMember = await teamInterestSchema.create({
        name,
        email,
        mobile,
        interestType,
        retreatIds: selectedRetreats,
      });

      // ✅ Get Leads & Co-Leads for selected retreats
      let roles = await RolesSchema.findAll({
        where: { role: { [Op.in]: ["Lead", "Co-Lead"] } },
        attributes: ["id", "role"],
      });

      if (roles.length > 0) {
        const roleIds = roles.map((r) => r.id);

        // ✅ Raw SQL (direct array because we use QueryTypes.SELECT)
        const results = await db.sequelize.query(
          `
        SELECT 
          rr.retreatId,
          rr.coupleId,
          r.role,
          c.hisFirstName,
          c.hisLastName,
          c.herFirstName,
          c.herLastName,
          c.hisEmail,
          c.herEmail
        FROM retreatroasters rr
        INNER JOIN roles r ON rr.roleId = r.id
        INNER JOIN couples c ON rr.coupleId = c.id
        WHERE rr.retreatId IN (:retreatIds) 
          AND rr.roleId IN (:roleIds)
        `,
          {
            replacements: { retreatIds: selectedRetreats, roleIds },
            type: Sequelize.QueryTypes.SELECT, // returns array directly
          }
        );

        // ✅ Send email to all leads/co-leads
        for (let lead of results) {
          let fullName = `${lead.hisFirstName || ""} ${
            lead.hisLastName || ""
          } & ${lead.herFirstName || ""} ${lead.herLastName || ""}`;
          let recipients = [lead.hisEmail, lead.herEmail].filter(Boolean);

          if (recipients.length > 0) {
            await Email.sendEmail(
              recipients,
              `New Team Interest for Retreat ${lead.retreatId}`,
              `
              Hello ${fullName},<br><br>
              ${name} (${email}, ${mobile}) has shown interest for 
              <b>${interestType}</b> in retreat <b>${lead.retreatId}</b>.<br><br>
              Regards,<br>
              LoveStrong Team
            `
            );
          }
        }
      }

      // ✅ Thank you email to user
      await Email.sendEmail(
        email,
        "Thank you for your interest!",
        `Dear ${name},<br><br>
      We’ve received your request to join as a team member for retreat(s): ${selectedRetreats.join(
        ", "
      )}.<br><br>
      Regards,<br>
      LoveStrong Team`
      );

      return res.status(200).json({
        success: true,
        msg: "Team interest submitted successfully",
        data: newMember,
      });
    } catch (err) {
      console.error("Error submitting team interest:", err);
      return res.status(500).json({
        success: false,
        msg: "Server error while submitting interest",
        error: err.message,
      });
    }
  }
}

module.exports = new AuthController();
