const controller = require("../controllers/AdminController");
const Router = require("express").Router;
const router = new Router();

// Couples
router
  .route("/createCouple")
  .post((...args) => controller.createCouple(...args));

router
  .route("/getAllCouplesList")
  .post((...args) => controller.getAllCouplesList(...args));

router
  .route("/getAllCouplesSearch")
  .post((...args) => controller.getAllCouplesSearch(...args));

router
  .route("/getMissingData")
  .get((...args) => controller.getMissingData(...args));

router.route("/editCouple").post((...args) => controller.editCouple(...args));

router
  .route("/getCouplesDetail")
  .post((...args) => controller.getCouplesDetail(...args));

router
  .route("/deleteCouple")
  .post((...args) => controller.deleteCouple(...args));

router.route("/search/:key").get((...args) => controller.searchKey(...args));

router
  .route("/makeCoupleAsSubAdmin")
  .post((...args) => controller.makeCoupleAsSubAdmin(...args));

router
  .route("/changeStatus")
  .post((...args) => controller.changeStatus(...args));

router
  .route("/saveCoupleExcel")
  .post((...args) => controller.saveCoupleExcel(...args));

router
  .route("/getStateCity")
  .post((...args) => controller.getStateCity(...args));

router
  .route("/participatedInRetreats")
  .post((...args) => controller.participatedInRetreats(...args));

router
  .route("/addlogreport")
  .post((...args) => controller.addLogReport(...args));

router
  .route("/getalllogreport")
  .post((...args) => controller.getAllLogReport(...args));

router
  .route("/getAllAdmins")
  .get((...args) => controller.getAllAdmins(...args));

router
  .route("/updateAdmins")
  .post((...args) => controller.updateAdmins(...args));

router
  .route("/retreatRegisteredCouples")
  .post((...args) => controller.retreatRegisteredCouples(...args));

router
  .route("/updateNewCoupleRegister")
  .post((...args) => controller.updateNewCoupleRegister(...args));

router
  .route("/couplesForCheck")
  .get((...args) => controller.couplesForCheck(...args));

router
  .route("/participatedInRetreats")
  .post((...args) => controller.participatedInRetreats(...args));

router
  .route("/saveCoupleImage")
  .post((...args) => controller.saveCoupleImage(...args));

router
  .route("/removeCoupleImage")
  .post((...args) => controller.removeCoupleImage(...args));

router
  .route("/geAdminsAndSubAdmins")
  .get((...args) => controller.geAdminsAndSubAdmins(...args));

router
  .route("/updateUserRole")
  .post((...args) => controller.updateUserRole(...args));

router
  .route("/removeUserRole")
  .post((...args) => controller.removeUserRole(...args));

router
  .route("/changeAdminAccess")
  .post((...args) => controller.changeAdminAccess(...args));

router
  .route("/deleteCoupleFromRoaster")
  .post((...args) => controller.deleteCoupleFromRoaster(...args));

router
  .route("/send-login-detail")
  .post((...args) => controller.sendLoginDetail(...args));

module.exports = router;
