# ej2-inputs

A package of Essential JS 2 Input textbox components. It comes with a collection of form components which is useful to get different input values from the users such as text, numbers, patterns, color and file inputs.

![ej2-inputs](https://ej2.syncfusion.com/products/images/input/readme.gif)

> This is a commercial product and requires a paid license for possession or use. Syncfusion’s licensed software, including this component, is subject to the terms and conditions of Syncfusion's EULA (https://www.syncfusion.com/eula/es/). To acquire a license, you can purchase one at https://www.syncfusion.com/sales/products or start a free 30-day trial here (https://www.syncfusion.com/account/manage-trials/start-trials).

> A free community license (https://www.syncfusion.com/products/communitylicense) is also available for companies and individuals whose organizations have less than $1 million USD in annual gross revenue and five or fewer developers.

## Setup

To install Input and its dependent packages, use the following command

```sh
npm install @syncfusion/ej2-inputs
```

## Components included

Following list of components are available in the package.

* **ColorPicker** - Color picker is a user interface that is used to select and adjust color values.
  * [Getting Started](https://ej2.syncfusion.com/documentation/color-picker/getting-started?lang=typescript&utm_source=npm&utm_campaign=color-picker)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=color-picker#/material/color-picker/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/color-picker)

* **FormValidator** - The FormValidator is used to validate the form elements before submitting to the server.
  * [Getting Started](https://ej2.syncfusion.com/documentation/form-validator?lang=typescript&utm_source=npm&utm_campaign=formvalidator)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=formvalidator#/material/form-validator/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/form-validator/?utm_source=npm&utm_campaign=form-validator)

* **TextBox** - The text box component is an extended version of the HTML input control which is used to edit or display text input on a form.
  * [Getting Started](https://ej2.syncfusion.com/documentation/textbox/getting-started?lang=typescript&utm_source=npm&utm_campaign=textbox)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=textbox#/material/textbox/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/text-box/?utm_source=npm&utm_campaign=text-box)

* **MaskedTextBox** - MaskedTextBox allows the user to enter the valid input only based on the provided mask.
  * [Getting Started](https://ej2.syncfusion.com/documentation/maskedtextbox/getting-started?lang=typescript&utm_source=npm&utm_campaign=maskedtextbox)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=maskedtextbox#/material/maskedtextbox/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/maskedtextbox/?utm_source=npm&utm_campaign=maskedtextbox)

* **NumericTextBox** - NumericTextBox is used to get the number inputs from the user. The input values can be incremented or decremented by a predefined step value.
  * [Getting Started](https://ej2.syncfusion.com/documentation/numerictextbox/getting-started?lang=typescript&utm_source=npm&utm_campaign=numerictextbox)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=numerictextbox#/material/numerictextbox/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/numerictextbox/?utm_source=npm&utm_campaign=numerictextbox)

* **Signature** - The Signature control allows user to draw smooth signatures as vector outline of strokes using variable width bezier curve interpolation. It allows to save signature as image.
  * [Getting Started](https://ej2.syncfusion.com/documentation/signature/getting-started?lang=typescript&utm_source=npm&utm_campaign=signature)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=signature#/material/signature/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/signature/?utm_source=npm&utm_campaign=signature)

* **Slider** - The slider component allows you to select a value or range of values between the min and max range.
  * [Getting Started](https://ej2.syncfusion.com/documentation/slider/getting-started?lang=typescript&utm_source=npm&utm_campaign=slider)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/slider/?utm_source=npm&utm_campaign=slider)

* **Uploader** - The [JavaScript File Upload](https://www.syncfusion.com/javascript-ui-controls/js-file-upload?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm) component is an extended version of the HTML5 upload control which is used to upload images, documents, and other files to a server.
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/js-file-upload?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm)
  * [Getting Started](https://ej2.syncfusion.com/documentation/uploader/getting-started?l?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=uploader#/material/uploader/default.html?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm)

## Supported frameworks

Input component is also offered in following list of frameworks.

1. [Angular](https://github.com/syncfusion/ej2-angular-ui-components/tree/master/components/inputs/?utm_source=npm&utm_campaign=input)
2. [React](https://github.com/syncfusion/ej2-react-ui-components/tree/master/components/inputs/?utm_source=npm&utm_campaign=input)
3. [VueJS](https://github.com/syncfusion/ej2-vue-ui-components/tree/master/components/inputs/?utm_source=npm&utm_campaign=input)
4. [ASP.NET Core](https://www.syncfusion.com/aspnet-core-ui-controls/numeric-textbox/?utm_source=npm&utm_campaign=input)
5. [ASP.NET MVC](https://www.syncfusion.com/aspnet-mvc-ui-controls/input-mask/?utm_source=npm&utm_campaign=input)
6. [JavaScript (ES5)](https://www.syncfusion.com/javascript-ui-controls/range-slider/?utm_source=npm&utm_campaign=input)

## Showcase samples

* Expanse Tracker ([Source](https://github.com/syncfusion/ej2-sample-ts-expensetracker), [Live Demo]( https://ej2.syncfusion.com/showcase/typescript/expensetracker/?utm_source=npm&utm_campaign=numerictextbox#/expense))
* Loan Calculator ([Source](https://github.com/syncfusion/ej2-sample-ts-loancalculator), [Live Demo]( https://ej2.syncfusion.com/showcase/typescript/loancalculator/?utm_source=npm&utm_campaign=slider))
* Cloud Pricing ([Live Demo](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/azure-pricing.html))

## Key Features

### 1. ColorPicker
- [**Color specification**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=color-picker#/material/color-picker/default.html) - Supports `Red Green Blue`, `Hue Saturation Value` and `Hex` codes.
- [**Mode**](https://ej2.syncfusion.com/documentation/color-picker/mode-and-value#mode-and-value) - Supports `Picker` and `Palette` mode.
- [**Inline**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=color-picker#/material/color-picker/inline.html) - Supports inline type rendering of color picker.
- [**Custom palettes**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=color-picker#/material/color-picker/custom.html) - Allows you to customize palettes and supports multiple palette groups rendering.
- [**Opacity**](https://ej2.syncfusion.com/documentation/color-picker/mode-and-value#color-value) - Allows to set and change the `opacity` of the selected color.
- [**Accessibility**](https://ej2.syncfusion.com/documentation/color-picker/accessibility#accessibility) - Built-in accessibility features to access color picker using the keyboard, screen readers, or other assistive technology devices.

### 2. TextBox
- [**Floating Label**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=textbox#/material/textbox/default.html) – floats the placeholder text while focus.
- [**Input Group**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=textbox#/material/textbox/default.html) – group the icons, buttons along with textbox.
- [**Validation States**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=textbox#/material/textbox/default.html) – provides styles for success, error, and warning states.
- [**Multiline**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=textbox#/material/textbox/default.html) – handles multiline input with placeholder text

### 3. MaskedTextBox
- [**Custom Characters**](https://ej2.syncfusion.com/demos/?lang=typescript&utm_source=npm&utm_campaign=maskedtextbox/#/material/maskedtextbox/custom-mask.html) - allows you to use your own characters as the mask elements.
- [**Regular Expression**](https://ej2.syncfusion.com/documentation/maskedtextbox/mask-configuration#regular-expression?lang=typescript&utm_source=npm&utm_campaign=maskedtextbox#regular-expression) - can be used as a mask element for each character of the MaskedTextBox.
- [**Accessibility**](https://ej2.syncfusion.com/documentation/maskedtextbox/accessibility?lang=typescript&utm_source=npm&utm_campaign=maskedtextbox) - provides built-in accessibility support which helps to access all the MaskedTextBox component features through keyboard, on-screen readers, or other assistive technology devices.

### 4. NumericTextBox
- [**Range Validation**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=numerictextbox/#/material/numerictextbox/range-validation.html) - allows to set the minimum and maximum range of values in the NumericTextBox.
- [**Number Formats**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=numerictextbox/#/material/numerictextbox/custom-format.html) - supports the number display formatting with MSDN standard and custom number formats.
- [**Precision Of Numbers**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=numerictextbox/#/material/numerictextbox/restrict-decimals.html) - allows to restrict the number precision when enters the value.
- [**Keyboard Interaction**](https://ej2.syncfusion.com/documentation/numerictextbox/accessibility#keyboard-interaction/?lang=typescript&utm_source=npm&utm_campaign=numerictextbox#keyboard-interaction) - allows users to interact with the NumericTextBox using the keyboard.
- [**Accessibility**](https://ej2.syncfusion.com/documentation/numerictextbox/accessibility/?lang=typescript&utm_source=npm&utm_campaign=numerictextbox) - provides built-in accessibility support which helps to access all the NumericTextBox component features through keyboard, on-screen readers or other assistive technology devices.
- [**Internationalization**](https://ej2.syncfusion.com/documentation/numerictextbox/globalization#internationalization/?lang=typescript&utm_source=npm&utm_campaign=numerictextbox) - library provides support for formatting and parsing number using the official Unicode CLDR JSON data.
- [**Localization**](https://ej2.syncfusion.com/documentation/numerictextbox/globalization#internationalization/?lang=typescript&utm_source=npm&utm_campaign=numerictextbox#localization) - Supports to localize spin up and down buttons title for the tooltip to different cultures.

### 5. Signature
- [**Customization**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/signature/default.html) - Support various customization options like background color, background image, stroke color, stroke width, save with background, undo, redo, clear, readonly, and disabled.
- [**Save**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/signature/default.html) - Support to save the signature as image like PNG, JPEG, and SVG.
- [**Load**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/signature/default.html)
- Support to load the signature as base64 url of the image.
- [**Draw**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/signature/default.html)
- Support to draw the text with the different font family and font size.

### 6. Slider
- [**Types**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/default.html) - Provided three types of Slider.
- [**Orientation**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/orientation.html) - Displays the Slider in horizontal or vertical direction.
- [**Buttons**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/tooltip.html) - Provided built-in support to render the buttons in both edges of the Slider.
- [**Tooltip**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/tooltip.html) - Displays a tooltip to show the currently selected value.
- [**Ticks**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/ticks.html) - Displays a scale with small and big ticks.
- [**Format**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/format.html) - Customize the slider values into various format.
- [**Limits**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/limits.html) - Slider thumb movement restriction enabled with interval dragging in range-slider.
- [**Accessibility**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/default.html) - Built-in compliance with the [WAI-ARIA](http://www.w3.org/WAI/PF/aria-practices/) specifications.
- [**Keyboard Interaction**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=slider#/material/slider/api.html) - The Slider can be intractable through the keyboard.

### 7. Upload
- [**Chunk Upload**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm#/material/uploader/chunk-upload.html) – used to upload large files as chunks
- [**Drag-and-drop**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm/#/material/uploader/custom-drop-area.html) – drag the files and drop into component to upload them.
- [**Template**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm/#/material/uploader/custom-file-list.html) – the file list and buttons can be customize using template
- [**Validation**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm/#/material/uploader/file-validation.html) – validate extension and size of upload file
- [**Auto Upload**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm#/material/uploader/default.html) – Process the file to upload without interaction.
- [**Preload Files**](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_medium=listing&utm_campaign=javascript-file-upload-npm/#/material/uploader/preload-files.html) – View and manipulate previously uploaded files

## Support

Product support is available for through following mediums.

* Creating incident in Syncfusion [Direct-trac](https://www.syncfusion.com/support/directtrac/incidents/?utm_source=npm&utm_campaign=input) support system or [Community forum](https://www.syncfusion.com/forums/essential-js2/?utm_source=npm&utm_campaign=input).
* New [GitHub issue](https://github.com/syncfusion/ej2-javascript-ui-controls/issues/new).
* Ask your query in Stack Overflow with tag `syncfusion`, `ej2`.

## License

Check the license detail [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/license/?utm_source=npm&utm_campaign=input).

## Changelog

Check the changelog [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/controls/inputs/CHANGELOG.md/?utm_source=npm&utm_campaign=input)


© Copyright 2023 Syncfusion, Inc. All Rights Reserved. The Syncfusion Essential Studio license and copyright applies to this distribution.